/*
 * Decompiled with CFR 0.152.
 */
package mainPackage;

import applicationPackage.CollisionHandler;
import applicationPackage.EnviromentGenerator;
import applicationPackage.GameController;
import applicationPackage.LevelCreator;
import com.jarbull.jbf.JBAction;
import com.jarbull.jbf.JBGameCanvas;
import com.jarbull.jbf.JBManager;
import com.jarbull.jbf.util.KeyCodeAdapter;
import domainPackage.Location;
import domainPackage.UserPlane;
import java.io.IOException;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Layer;
import javax.microedition.lcdui.game.Sprite;
import javax.microedition.lcdui.game.TiledLayer;
import mainPackage.LevelCompleteCanvas;
import mainPackage.SoundCheckScreen;
import mainPackage.WingsofWar;
import mainPackage.WingsofWarProcessor;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class WingsofWarCanvas
extends JBGameCanvas
implements Runnable {
    public static boolean startScreen;
    public static boolean bossDead;
    public static boolean sameLevel;
    public static int planeState;
    public static int currentLevel;
    public static long clearLayersTime;
    public static long createLayersTime;
    public static LevelCreator levelCreator;
    public static WingsofWar mainMidlet;
    public Sprite backGroundSprite;
    private int a;
    private final Image[] a;
    private final Image[] b;
    private WingsofWarProcessor a;
    private Location a;
    private TiledLayer a;
    private TiledLayer b;
    private Graphics a;

    public WingsofWarCanvas(WingsofWar wingsofWar) {
        int n2;
        this.setFullScreenMode(true);
        mainMidlet = wingsofWar;
        levelCreator = new LevelCreator();
        this.a = 50;
        currentLevel = 0;
        planeState = 0;
        bossDead = false;
        sameLevel = false;
        startScreen = false;
        this.a = new Image[10];
        for (n2 = 9; n2 >= 0; --n2) {
            this.a[n2] = JBManager.getInstance().getTextImage(Integer.toString(n2), "font-oyun");
        }
        this.b = new Image[10];
        for (n2 = 9; n2 >= 0; --n2) {
            this.b[n2] = JBManager.getInstance().getTextImage(Integer.toString(n2), "font-score");
        }
        this.a = this.getGraphics();
        this.initializeProcessor();
        KeyCodeAdapter.getInstance().setCanvas((Canvas)this);
    }

    public void paintBackGround(Graphics graphics) {
        EnviromentGenerator.getInstance().managerBackGround.paint(graphics, 0, 20);
        EnviromentGenerator.getInstance().managerGroundParticle.paint(graphics, 0, 20);
    }

    public void paintGroundEnemy(Graphics object) {
        try {
            this.renderGroundEnemy((Graphics)object);
            return;
        }
        catch (IOException iOException) {
            object = iOException;
            iOException.printStackTrace();
            return;
        }
    }

    public void paintCloudFirstLayer(Graphics graphics) {
        for (int i2 = GameController.getInstance().cloudListFirstLayer.getNoItems() - 1; i2 >= 0; --i2) {
            GameController.getInstance().cloudListFirstLayer.retrieveCloud(i2).getUnitSprite().paint(graphics);
        }
    }

    public void paintPlayerShadow(Graphics graphics) {
        GameController.getInstance().userShadow.getUnitSprite().paint(graphics);
    }

    public void paintAirEnemy(Graphics object) {
        try {
            this.renderAirEnemy((Graphics)object);
            return;
        }
        catch (IOException iOException) {
            object = iOException;
            iOException.printStackTrace();
            return;
        }
    }

    public void paintFire(Graphics graphics) {
        GameController.getInstance().managerEnemyFire.paint(graphics, 0, 20);
        GameController.getInstance().managerUserFire.paint(graphics, 0, 20);
        if (CollisionHandler.getExplosionSprite() != null) {
            CollisionHandler.getExplosionSprite().paint(graphics);
        }
        if (CollisionHandler.getExplosionBossSprite() != null) {
            CollisionHandler.getExplosionBossSprite().paint(graphics);
        }
        if (CollisionHandler.getExplosionUserSprite() != null) {
            CollisionHandler.getExplosionUserSprite().paint(graphics);
        }
    }

    public void paintPlayer(Graphics object) {
        try {
            this.renderPlayer((Graphics)object);
            return;
        }
        catch (IOException iOException) {
            object = iOException;
            iOException.printStackTrace();
            return;
        }
    }

    public void paintCloudSecondLayer(Graphics graphics) {
        for (int i2 = GameController.getInstance().cloudListSecondLayer.getNoItems() - 1; i2 >= 0; --i2) {
            GameController.getInstance().cloudListSecondLayer.retrieveCloud(i2).getUnitSprite().paint(graphics);
        }
    }

    public void paintScreen(Graphics object) {
        try {
            object.drawImage(GameController.getInstance().barImage1, 0, 0, 0);
            this.renderGamePlayBars();
            return;
        }
        catch (IOException iOException) {
            object = iOException;
            iOException.printStackTrace();
            return;
        }
    }

    public void paintAll() {
        this.paintBackGround(this.a);
        this.paintGroundEnemy(this.a);
        this.paintCloudFirstLayer(this.a);
        this.paintPlayerShadow(this.a);
        this.paintAirEnemy(this.a);
        this.paintFire(this.a);
        this.paintPlayer(this.a);
        this.paintCloudSecondLayer(this.a);
        this.paintScreen(this.a);
    }

    public void renderGamePlayBars() {
        CollisionHandler.getInstance().getHitPointBar().paint(this.a);
        CollisionHandler.getInstance().getHealthBar().paint(this.a);
        CollisionHandler.getInstance().getBonusBar().paint(this.a);
        String string = Integer.toString(CollisionHandler.getInstance().scorePoint);
        int n2 = 32;
        for (int i2 = 0; i2 < string.length(); ++i2) {
            int n3 = Integer.parseInt(string.substring(i2, i2 + 1));
            this.a.drawImage(this.b[n3], n2, 2, 20);
            n2 += this.b[n3].getWidth();
        }
    }

    public void renderPlayer(Graphics graphics) {
        if (UserPlane.getInstance() != null) {
            UserPlane.getInstance().getUnitSprite().paint(graphics);
            UserPlane.getInstance().userPlaneFireEffect1.paint(graphics);
            UserPlane.getInstance().userPlaneFireEffect2.paint(graphics);
        }
    }

    public void renderGroundEnemy(Graphics graphics) {
        GameController.getInstance().managerGroundPlane.paint(graphics, 0, 20);
        GameController.getInstance().managerBonusPlane.paint(graphics, 0, 20);
    }

    public void renderAirEnemy(Graphics graphics) {
        GameController.getInstance().managerBossPlane.paint(graphics, 0, 20);
        GameController.getInstance().managerEnemyPlane.paint(graphics, 0, 20);
    }

    public void adjustGamePlayBars() {
        CollisionHandler.getInstance().hitPointBar.setLocation(100, 12);
        CollisionHandler.getInstance().hitPointBar.setSize(26, 4);
        CollisionHandler.getInstance().hitPointBar.setVisible(true);
        CollisionHandler.getInstance().healthBar.setLocation(80, 12);
        CollisionHandler.getInstance().bonusBar.setLocation(102, 5);
    }

    public void checkKeys(int n2) {
        this.a.a = this.getKeyStates();
    }

    public void keyPressed(int n2) {
        this.a.b = KeyCodeAdapter.getInstance().adoptKeyCode(n2);
    }

    public void createLayers() {
        long l2 = System.currentTimeMillis();
        this.a = EnviromentGenerator.getInstance().createBackGroundBoard();
        this.b = EnviromentGenerator.getInstance().createGroundParticleBoard(EnviromentGenerator.getInstance().createGroundParticleMap(EnviromentGenerator.getInstance().groundLayerIndex, LevelCreator.getCurrentLevel()));
        if (EnviromentGenerator.getInstance().managerBackGround == null && EnviromentGenerator.getInstance().managerGroundParticle == null) {
            EnviromentGenerator.getInstance().createBackGroundManagers();
        }
        EnviromentGenerator.getInstance().managerBackGround.append((Layer)this.a);
        EnviromentGenerator.getInstance().managerGroundParticle.append((Layer)this.b);
        this.adjustGamePlayBars();
        createLayersTime = System.currentTimeMillis() - l2;
    }

    public void clearLayers() {
        int n2;
        long l2 = System.currentTimeMillis();
        if (EnviromentGenerator.getInstance().managerBackGround != null && EnviromentGenerator.getInstance().managerGroundParticle != null) {
            for (n2 = EnviromentGenerator.getInstance().managerBackGround.getSize() - 1; n2 >= 0; --n2) {
                EnviromentGenerator.getInstance().managerBackGround.remove(EnviromentGenerator.getInstance().managerBackGround.getLayerAt(n2));
            }
            for (n2 = EnviromentGenerator.getInstance().managerGroundParticle.getSize() - 1; n2 >= 0; --n2) {
                EnviromentGenerator.getInstance().managerGroundParticle.remove(EnviromentGenerator.getInstance().managerGroundParticle.getLayerAt(n2));
            }
        }
        for (n2 = GameController.getInstance().managerBossPlane.getSize() - 1; n2 >= 0; --n2) {
            GameController.getInstance().managerBossPlane.remove(GameController.getInstance().managerBossPlane.getLayerAt(n2));
        }
        for (n2 = GameController.getInstance().managerEnemyPlane.getSize() - 1; n2 >= 0; --n2) {
            GameController.getInstance().managerEnemyPlane.remove(GameController.getInstance().managerEnemyPlane.getLayerAt(n2));
        }
        for (n2 = GameController.getInstance().managerGroundPlane.getSize() - 1; n2 >= 0; --n2) {
            GameController.getInstance().managerGroundPlane.remove(GameController.getInstance().managerGroundPlane.getLayerAt(n2));
        }
        for (n2 = GameController.getInstance().managerBonusPlane.getSize() - 1; n2 >= 0; --n2) {
            GameController.getInstance().managerBonusPlane.remove(GameController.getInstance().managerBonusPlane.getLayerAt(n2));
        }
        for (n2 = GameController.getInstance().managerEnemyFire.getSize() - 1; n2 >= 0; --n2) {
            GameController.getInstance().managerEnemyFire.remove(GameController.getInstance().managerEnemyFire.getLayerAt(n2));
        }
        for (n2 = GameController.getInstance().managerUserFire.getSize() - 1; n2 >= 0; --n2) {
            GameController.getInstance().managerUserFire.remove(GameController.getInstance().managerUserFire.getLayerAt(n2));
        }
        for (n2 = GameController.getInstance().enemyPlaneList.getNoItems() - 1; n2 >= 0; --n2) {
            GameController.getInstance().enemyPlaneList.retrieveEnemyPlane(n2).getTimer().cancel();
            GameController.getInstance().enemyPlaneList.deleteEnemyPlaneByIndex(n2);
        }
        for (n2 = GameController.getInstance().groundUnitList.getNoItems() - 1; n2 >= 0; --n2) {
            GameController.getInstance().groundUnitList.retrieveGroundUnit(n2).getTimer().cancel();
            GameController.getInstance().groundUnitList.deleteGroundUnitIndex(n2);
        }
        for (n2 = GameController.getInstance().bossPlaneList.getNoItems() - 1; n2 >= 0; --n2) {
            GameController.getInstance().bossPlaneList.retrieveBossUnit(n2).getTimer().cancel();
            GameController.getInstance().bossPlaneList.deleteBossIndex(n2);
        }
        for (n2 = GameController.getInstance().bonusList.getNoItems() - 1; n2 >= 0; --n2) {
            GameController.getInstance().bonusList.deleteBonusByIndex(n2);
        }
        for (n2 = GameController.getInstance().UserFireList.getNoItems() - 1; n2 >= 0; --n2) {
            GameController.getInstance().UserFireList.deleteFireIndex(n2);
        }
        for (n2 = GameController.getInstance().EnemyFireList.getNoItems() - 1; n2 >= 0; --n2) {
            GameController.getInstance().EnemyFireList.deleteFireIndex(n2);
        }
        for (n2 = GameController.getInstance().cloudListFirstLayer.getNoItems() - 1; n2 >= 0; --n2) {
            GameController.getInstance().cloudListFirstLayer.deleteCloudByIndex(n2);
        }
        for (n2 = GameController.getInstance().cloudListSecondLayer.getNoItems() - 1; n2 >= 0; --n2) {
            GameController.getInstance().cloudListSecondLayer.deleteCloudByIndex(n2);
        }
        EnviromentGenerator.getInstance().groundLayerIndex = 10;
        EnviromentGenerator.getInstance().groundUnitLayerIndex = 10;
        CollisionHandler.getInstance().clearAnimationTimers();
        UserPlane.getInstance().setDefense(100);
        UserPlane.getInstance().setHealth(UserPlane.getInstance().getHealth());
        CollisionHandler.getInstance().getHitPointBar().setValue(100);
        CollisionHandler.getInstance().getHealthBar().setValue(UserPlane.getInstance().getHealth());
        CollisionHandler.getInstance().getBonusBar().setValue(0);
        UserPlane.getInstance().weaponOverHeat = 0;
        this.a = new Location(64 - UserPlane.getInstance().getUnitSprite().getWidth() / 2, 160 - UserPlane.getInstance().getUnitSprite().getHeight(), UserPlane.getInstance().getUnitSprite().getWidth(), UserPlane.getInstance().getUnitSprite().getHeight());
        UserPlane.getInstance().setLocation(this.a, UserPlane.getInstance().getUnitSprite());
        clearLayersTime = System.currentTimeMillis() - l2;
    }

    public void clearManagers() {
        EnviromentGenerator.getInstance().managerBackGround = null;
        EnviromentGenerator.getInstance().managerGroundParticle = null;
        this.a = null;
        this.b = null;
    }

    public void initializeProcessor() {
        if (this.a != null) {
            this.a.killThread = true;
        }
        this.a = new WingsofWarProcessor();
        this.a.start();
    }

    private boolean a() {
        if (CollisionHandler.getInstance().isUserDead() || bossDead && LevelCreator.getCurrentLevel() == 8) {
            JBManager.getInstance().gameSettings.putAndSave("score:mylast", Integer.toString(CollisionHandler.getInstance().scorePoint));
            try {
                if (Integer.parseInt(JBManager.getInstance().gameSettings.get("score:mytop")) < CollisionHandler.getInstance().scorePoint) {
                    JBManager.getInstance().gameSettings.putAndSave("score:mytop", Integer.toString(CollisionHandler.getInstance().scorePoint));
                }
            }
            catch (Exception exception) {
                JBManager.getInstance().gameSettings.putAndSave("score:mytop", Integer.toString(CollisionHandler.getInstance().scorePoint));
            }
            JBManager.getInstance().gameSettings.remove("lastLevel");
            JBManager.getInstance().gameSettings.remove("lastScore");
            mainMidlet.openPauseMenu();
            JBManager.getInstance().addAction(new JBAction(this, "TOP:T0"));
            mainMidlet.d();
            return true;
        }
        return false;
    }

    public void executeGame() {
        while (WingsofWar.isRunning && !bossDead && !CollisionHandler.getInstance().isUserDead() && !WingsofWar.restartApp) {
            long l2 = System.currentTimeMillis();
            if (!WingsofWar.pauseApp) {
                if (UserPlane.getInstance().getDefence() > 0) {
                    this.checkKeys(this.getKeyStates());
                }
                this.paintAll();
                this.flushGraphics();
            }
            try {
                Thread.sleep(Math.max(0L, (long)this.a - System.currentTimeMillis() + l2));
            }
            catch (InterruptedException interruptedException) {
                InterruptedException interruptedException2 = interruptedException;
                interruptedException.printStackTrace();
            }
        }
    }

    public void run() {
        while (WingsofWar.startApp && !this.a()) {
            IOException iOException;
            Runnable runnable;
            if (LevelCreator.getCurrentLevel() == 0 && !CollisionHandler.getInstance().isUserDead()) {
                runnable = null;
                startScreen = true;
                try {
                    runnable = new SoundCheckScreen(mainMidlet);
                }
                catch (IOException iOException2) {
                    iOException = iOException2;
                    iOException2.printStackTrace();
                }
                ((SoundCheckScreen)runnable).show();
                ((SoundCheckScreen)runnable).joinThread();
            }
            LevelCreator.setCurrentLevel(currentLevel);
            this.executeGame();
            if (!bossDead || LevelCreator.getCurrentLevel() == 8) continue;
            runnable = null;
            try {
                runnable = new LevelCompleteCanvas(mainMidlet, true, 0);
            }
            catch (IOException iOException3) {
                iOException = iOException3;
                iOException3.printStackTrace();
            }
            ((LevelCompleteCanvas)runnable).start();
            ((LevelCompleteCanvas)runnable).joinThread();
            ++currentLevel;
        }
    }
}

