/*
 * Decompiled with CFR 0.152.
 */
package com.jarbull.basket.inGame;

import com.jarbull.basket.tools.BallAnimationHandler;
import com.jarbull.basket.tools.ImageHandler;
import com.jarbull.basket.tools.Vector2D;
import java.io.IOException;
import javax.microedition.lcdui.game.Layer;
import javax.microedition.lcdui.game.LayerManager;
import javax.microedition.lcdui.game.Sprite;

public class Ball
extends Sprite {
    private static final Vector2D GRAVITY_V2D = new Vector2D(0.0, 0.4);
    private static final int SPRITE_WIDTH = 20;
    private static final int SPRITE_HEIGHT = 20;
    public double velocityX;
    public double velocityY;
    public double stepX = 0.0;
    public double stepY = 0.0;
    private int previousStepX = 0;
    private int previousStepY = 0;
    public boolean basketOldu;
    public boolean fileyeCarpti;
    BallAnimationHandler ballAnimHandler;
    LayerManager layermanager;

    public Ball(LayerManager layerManager, int x, int y) throws IOException {
        super(ImageHandler.getInstance().getImage("/res/img/basketball.png"), 20, 20);
        this.layermanager = layerManager;
        this.velocityX = 0.0;
        this.velocityY = 0.0;
        layerManager.insert((Layer)this, 1);
        this.setPosition(x, y);
        this.ballAnimHandler = new BallAnimationHandler(this);
        this.ballAnimHandler.start();
    }

    public int getCenterX() {
        return this.getX() + this.getWidth() / 2;
    }

    public int getCenterY() {
        return this.getY() + this.getHeight() / 2;
    }

    public void move() {
        Vector2D oldVelocity2D = new Vector2D(this.velocityX, this.velocityY);
        Vector2D newVelocityV2D = Vector2D.add(oldVelocity2D, GRAVITY_V2D);
        this.velocityX = newVelocityV2D.x;
        this.velocityY = newVelocityV2D.y;
        this.stepX += newVelocityV2D.x;
        this.stepY += newVelocityV2D.y;
        int roundedStepX = (int)this.stepX;
        int roundedStepY = (int)this.stepY;
        if (roundedStepX != 0 || roundedStepY != 0) {
            this.previousStepX = roundedStepX;
            this.previousStepY = roundedStepY;
            this.move(roundedStepX, roundedStepY);
            this.stepX %= 1.0;
            this.stepY %= 1.0;
        }
    }

    public void moveBack() {
        this.move(-this.previousStepX, -this.previousStepY);
    }

    public void reflect(Vector2D normalVector) {
        Vector2D velocityVector = new Vector2D(this.velocityX, this.velocityY);
        double projection = Vector2D.dotProduct(velocityVector, normalVector);
        Vector2D projectionVectorX2 = new Vector2D(normalVector.x * projection * 2.0, normalVector.y * projection * 2.0);
        velocityVector = Vector2D.subtract(velocityVector, projectionVectorX2);
        this.velocityX = velocityVector.x * 0.7;
        this.velocityY = velocityVector.y * 0.7;
    }

    public void kill() {
        this.ballAnimHandler.kill();
    }
}

