/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.Sprite;

class Perls {
    static final int MAX_PERLS = 10;
    static final int ZUMA_MOVE_TIME = 65;
    static final int ZUMA_MOVE_TIME_FAST = 1;
    static final int BIRD_STEALING_TIME = 46;
    static final int BIRD_STEALING_TIME2 = 23;
    static final int VIBRATION_TIME = 30;
    int iPerlWidth = 0;
    int iPerlWidth2 = 0;
    int iPerlHeight = 0;
    int iPerlHeight2 = 0;
    int iTopInit = 0;
    int iTop = 0;
    int iInnerLeft = 0;
    int iLeft = 0;
    int iRight = 0;
    int iLastPerlXPos;
    int iLastPerlYPos;
    int[][] iaPerls = null;
    int iPerlsInLine = 0;
    int iTotalLines = 0;
    int[] iaStackedPerls = null;
    int[] iaTestedPerls = null;
    int[] iaFallingPerls = null;
    int[] iaGroupedPerls = null;
    int[] iaPerlsOnStart = null;
    int[] iaPerlsInGame = null;
    int iActivePerlsCount;
    int iStackedPerlsCount;
    int iZumaPerlsCount;
    int[] iaColumnsShifts = null;
    int iFallOffs = 0;
    boolean bUseWaves;
    boolean bBirdStealing;
    boolean bFloatingStones;
    boolean bDangerousState;
    boolean bArcadeMode;
    boolean bShakePerlsNeeded;
    boolean bNextPerlReady;
    int iPreparedPerl;
    int iNextBonusInXShots;
    int iNextBonus;
    int iLastAddedCol;
    int iBombPerl;
    int iLevelNum;
    int iLevelType;
    boolean bFrozenLevel;
    int iFreezeSpeed;
    int frozenRowLast;
    int frozenColLast;
    int iZumaMoveTime = 65;
    int iZumaMoveTimeBack = 65;
    int iZumaEnd;
    int[] iaZumaPerls = null;
    int iZumaLastMovedIdx;
    int iLastDspX;
    int iPerlsToPop;
    int iPerlsOnStart;
    int iPerlsLeft;
    int iRocksInPlay;
    int iMultiplierTime;
    int iMultiplierVal;
    int iDropDownTimer;
    int iBirdSpeed;
    int iBirdTimer;
    int iBirdDirection = 1;
    int iBirdRow;
    int iBirdCol;
    int iBirdHeight;
    int iBirdHeight4;
    int iBirdWidth;
    int iBirdWidth2;
    int iPlayerRow;
    int iPlayerCol;
    int iPlayerRowLast;
    int iPlayerColLast;
    boolean bFailed;
    boolean bNoScoreForShakenPerls;

    Perls() {
    }

    void init() {
        Debug.trace("Perls.init() - in");
        this.iPerlsInLine = 11;
        this.iTotalLines = 10;
        this.iaColumnsShifts = new int[this.iPerlsInLine];
        this.iaStackedPerls = new int[this.iPerlsInLine * this.iTotalLines];
        this.iaTestedPerls = new int[this.iPerlsInLine * this.iTotalLines];
        this.iaFallingPerls = new int[this.iPerlsInLine * this.iTotalLines];
        this.iaGroupedPerls = new int[this.iPerlsInLine * this.iTotalLines];
        this.iaZumaPerls = new int[this.iPerlsInLine * (this.iTotalLines - 1)];
        this.iaPerlsInGame = new int[7];
        this.iaPerlsOnStart = new int[7];
        this.iaPerls = new int[this.iTotalLines][];
        for (int i = 0; i < this.iTotalLines; ++i) {
            this.iaPerls[i] = new int[this.iPerlsInLine];
            for (int ii = 0; ii < this.iPerlsInLine; ++ii) {
                this.iaPerls[i][ii] = -1979;
            }
        }
        this.reset();
        Debug.trace("Perls.init() - out");
    }

    void reset() {
        if (Resources.sprPerls != null) {
            this.iPerlWidth = Resources.sprPerlsWidth;
            this.iPerlWidth2 = this.iPerlWidth / 2;
            this.iPerlHeight = Resources.sprPerls.getHeight();
            this.iPerlHeight2 = this.iPerlHeight / 2;
            this.iTop = this.iTopInit = Resources.imgScoreFont.getHeight() + 6 + this.iPerlWidth2;
            this.iInnerLeft = (Defines.WIDTH - this.iPerlsInLine * this.iPerlWidth) / 2 + this.iPerlWidth2 / 2;
            this.iLeft = this.iInnerLeft - this.iPerlWidth2;
            this.iRight = this.iInnerLeft + this.iPerlsInLine * this.iPerlWidth;
        }
        for (int i = this.iaColumnsShifts.length - 1; i >= 0; --i) {
            this.iaColumnsShifts[i] = 0;
        }
        Arrays.resetIntsArray(this.iaStackedPerls);
        Arrays.resetIntsArray(this.iaTestedPerls);
        Arrays.resetIntsArray(this.iaFallingPerls);
        Arrays.resetIntsArray(this.iaGroupedPerls);
        Arrays.resetIntsArray(this.iaZumaPerls);
        this.resetPerls();
        this.bShakePerlsNeeded = false;
        this.bNoScoreForShakenPerls = false;
        this.iLastAddedCol = -1;
        this.iPerlsToPop = 0;
        this.iZumaLastMovedIdx = -1;
    }

    void destroy() {
        this.iaColumnsShifts = null;
        this.iaStackedPerls = null;
        this.iaTestedPerls = null;
        this.iaFallingPerls = null;
        this.iaGroupedPerls = null;
        this.iaZumaPerls = null;
        this.iaPerlsInGame = null;
        this.iaPerlsOnStart = null;
        for (int i = 0; i < this.iTotalLines; ++i) {
            this.iaPerls[i] = null;
        }
        this.iaPerls = null;
        Common.garbageCollect();
    }

    void resetPerls() {
        for (int i = 0; i < this.iTotalLines; ++i) {
            for (int ii = 0; ii < this.iPerlsInLine; ++ii) {
                this.iaPerls[i][ii] = -1979;
            }
        }
    }

    void save(DataOutputStream data) {
        boolean len = false;
        try {
            for (int i = 0; i < this.iTotalLines; ++i) {
                for (int ii = 0; ii < this.iPerlsInLine; ++ii) {
                    data.writeInt(this.iaPerls[i][ii]);
                }
            }
            data.writeInt(this.iActivePerlsCount);
            data.writeInt(this.iStackedPerlsCount);
            for (int ii = 0; ii < this.iPerlsInLine; ++ii) {
                data.writeInt(this.iaColumnsShifts[ii]);
            }
            data.writeInt(this.iFallOffs);
            data.writeBoolean(this.bShakePerlsNeeded);
            data.writeBoolean(this.bNextPerlReady);
            data.writeInt(this.iPreparedPerl);
            data.writeInt(this.iNextBonusInXShots);
            data.writeInt(this.iNextBonus);
            data.writeInt(this.iLastAddedCol);
            data.writeInt(this.iBombPerl);
            data.writeInt(this.iLevelNum);
            data.writeInt(this.iPerlsToPop);
            data.writeInt(this.iPerlsOnStart);
            data.writeInt(this.iPerlsLeft);
            data.writeInt(this.iMultiplierTime);
            data.writeInt(this.iMultiplierVal);
            Arrays.saveIntArrayValues(this.iaStackedPerls, data);
            Arrays.saveIntArrayValues(this.iaTestedPerls, data);
            Arrays.saveIntArrayValues(this.iaFallingPerls, data);
            Arrays.saveIntArrayValues(this.iaGroupedPerls, data);
            Arrays.saveIntArrayValues(this.iaPerlsOnStart, data);
            Arrays.saveIntArrayValues(this.iaPerlsInGame, data);
        }
        catch (Throwable ex) {
            Debug.trace(ex.toString());
        }
    }

    void load(DataInputStream data) {
        this.bArcadeMode = true;
        boolean len = false;
        try {
            for (int i = 0; i < this.iTotalLines; ++i) {
                for (int ii = 0; ii < this.iPerlsInLine; ++ii) {
                    this.iaPerls[i][ii] = data.readInt();
                }
            }
            this.iActivePerlsCount = data.readInt();
            this.iStackedPerlsCount = data.readInt();
            for (int ii = 0; ii < this.iPerlsInLine; ++ii) {
                this.iaColumnsShifts[ii] = data.readInt();
            }
            this.iFallOffs = data.readInt();
            this.bShakePerlsNeeded = data.readBoolean();
            this.bNextPerlReady = data.readBoolean();
            this.iPreparedPerl = data.readInt();
            this.iNextBonusInXShots = data.readInt();
            this.iNextBonus = data.readInt();
            this.iLastAddedCol = data.readInt();
            this.iBombPerl = data.readInt();
            this.iLevelNum = data.readInt();
            this.iPerlsToPop = data.readInt();
            this.iPerlsOnStart = data.readInt();
            this.iPerlsLeft = data.readInt();
            this.iMultiplierTime = data.readInt();
            this.iMultiplierVal = data.readInt();
            Arrays.loadIntArrayValues(this.iaStackedPerls, data);
            Arrays.loadIntArrayValues(this.iaTestedPerls, data);
            Arrays.loadIntArrayValues(this.iaFallingPerls, data);
            Arrays.loadIntArrayValues(this.iaGroupedPerls, data);
            Arrays.loadIntArrayValues(this.iaPerlsOnStart, data);
            Arrays.loadIntArrayValues(this.iaPerlsInGame, data);
        }
        catch (Throwable ex) {
            Debug.trace(ex.toString());
        }
        this.updateDangerousState();
    }

    int activePerls() {
        int cnt = 0;
        for (int i = 0; i < this.iTotalLines; ++i) {
            for (int ii = 0; ii < this.iPerlsInLine; ++ii) {
                int val;
                if (this.iaPerls[i][ii] == -1979 || (val = this.getPerlVal(i, ii)) >= 7) continue;
                ++cnt;
            }
        }
        if (this.bArcadeMode) {
            if (cnt == 0 && !this.bFailed) {
                X.canvas.createCongratLabel(0, 0, Resources.sprLabelBrilliant);
                WholeGame.sounds.playSound(2, 6, 10);
                Level.figState[WholeGame.level.idx_octopus] = 1;
                GameDef.figStateTimer[WholeGame.level.idx_octopus] = 100;
                WholeGame.level.player.incScore(100);
                X.canvas.createScoreLabel(this.iLastPerlXPos, this.iLastPerlYPos, 100);
            }
        } else if (cnt == 0) {
            if (WholeGame.level.statItemToShow(this.iLevelNum) == 0 && !this.bFailed && this.iLevelType != 6) {
                WholeGame.level.testAchievement(9);
            }
        }
        return cnt;
    }

    int getNextBonus() {
        return this.iPerlsInLine * (1 + Common.getRandomUInt(2)) + Common.getRandomUInt(this.iPerlsInLine);
    }

    int getLevelBonus(int val) {
        Debug.trace("getLevelBonus() - in");
        if (this.bArcadeMode) {
            if (Common.getRandomUInt(100) % 3 == 0) {
                return 700 + val;
            }
            if (Common.getRandomUInt(100) % 5 == 0) {
                return 800 + val;
            }
        } else {
            switch (this.iLevelNum) {
                case 5: 
                case 6: 
                case 7: {
                    int tmp = Common.getRandomUInt(100) % 3;
                    if (tmp == 0) {
                        Debug.trace("getLevelBonus() - out1");
                        return 700 + val;
                    }
                    if (tmp != 1) break;
                    Debug.trace("getLevelBonus() - out1");
                    return 800 + val;
                }
                case 8: 
                case 9: {
                    if (Common.getRandomUInt(100) % 2 != 0) break;
                    Debug.trace("getLevelBonus() - out1");
                    return 700 + val;
                }
                case 10: 
                case 11: 
                case 12: 
                case 14: {
                    if (Common.getRandomUInt(100) % 2 == 0) {
                        return 800 + val;
                    }
                }
                case 38: 
                case 39: {
                    return (Common.getRandomUInt(100) % 2 == 0 ? 600 : 800) + val;
                }
                case 44: 
                case 45: {
                    return (Common.getRandomUInt(100) % 2 == 0 ? 600 : 800) + val;
                }
            }
        }
        Debug.trace("getLevelBonus() - out2");
        return 600 + val;
    }

    void loadLevel(int level) {
        Debug.trace("loadLevel() - in");
        try {
            InputStream is = Common._class.getResourceAsStream("/" + level + ".l");
            DataInputStream dis = new DataInputStream(is);
            for (int row = 0; row < this.iTotalLines; ++row) {
                for (int col = 0; col < this.iPerlsInLine; ++col) {
                    int dataChar = dis.readByte();
                    if (dataChar < -1) {
                        dataChar += 255;
                    }
                    if (dataChar == -1) {
                        this.iaPerls[row][col] = -1979;
                        continue;
                    }
                    ++this.iPerlsOnStart;
                    this.iaPerls[row][col] = dataChar == 8 ? dataChar + 300 : (dataChar == 9 ? dataChar + 200 : (dataChar == 10 ? dataChar : dataChar % 10 + dataChar / 10 * 100));
                }
            }
            dis.close();
            dis = null;
            is.close();
            is = null;
            System.gc();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.updatePerlsInGameArray();
        Arrays.resetIntsArray(this.iaPerlsOnStart);
        Arrays.addIntsToArray(this.iaPerlsOnStart, this.iaPerlsInGame);
        Debug.trace("loadLevel() - out");
    }

    void createRandomPerls(int rows, int colors, int bonuses) {
        Debug.trace("createRandomPerls() - in");
        int nextBonus = this.getNextBonus();
        for (int i = 0; i < rows; ++i) {
            for (int ii = 0; ii < this.iPerlsInLine; ++ii) {
                ++this.iPerlsOnStart;
                this.iaPerls[i][ii] = Common.getRandomUInt(colors);
                if (this.iaPerls[i][ii] == 7) {
                    this.iaPerls[i][ii] = 507;
                }
                if (bonuses <= 0) continue;
                if (nextBonus > 0) {
                    --nextBonus;
                    continue;
                }
                --bonuses;
                nextBonus = this.getNextBonus();
                this.iaPerls[i][ii] = this.getLevelBonus(this.iaPerls[i][ii]);
            }
        }
        if (bonuses > 0) {
            this.iNextBonus = this.getNextBonus();
        }
        this.updatePerlsInGameArray();
        Arrays.printIntArray(this.iaPerlsInGame);
        Arrays.resetIntsArray(this.iaPerlsOnStart);
        Arrays.addIntsToArray(this.iaPerlsOnStart, this.iaPerlsInGame);
        Arrays.printIntArray(this.iaPerlsOnStart);
        Debug.trace("createRandomPerls() - out");
    }

    void prepareLevel(int iLevelNum) {
        Debug.trace("Perls.prepareLevel() - in");
        this.iLevelNum = iLevelNum;
        this.iMultiplierVal = 0;
        this.iMultiplierTime = 0;
        this.bArcadeMode = false;
        this.bFailed = false;
        this.bUseWaves = false;
        this.bFloatingStones = false;
        this.bBirdStealing = false;
        this.bFrozenLevel = false;
        this.frozenRowLast = -1;
        this.frozenColLast = -1;
        this.iNextBonus = -1;
        this.iPerlsOnStart = 0;
        this.iPerlsLeft = 0;
        switch (iLevelNum) {
            case 13: 
            case 14: {
                this.iLevelType = 1;
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                this.iLevelType = 1;
                this.loadLevel(iLevelNum);
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                this.iLevelType = 1;
                this.loadLevel(iLevelNum);
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                this.iLevelType = 1;
                this.loadLevel(iLevelNum);
                this.bFloatingStones = true;
                break;
            }
            case 15: {
                this.iLevelType = 1;
                this.createRandomPerls(5, 3, 0);
                this.iNextBonus = (2 + Common.getRandomUInt(2)) * this.iPerlsInLine + Common.getRandomUInt(this.iPerlsInLine);
                break;
            }
            case 16: {
                this.iLevelType = 1;
                this.createRandomPerls(5, 5, 0);
                this.iNextBonus = (2 + Common.getRandomUInt(2)) * this.iPerlsInLine + Common.getRandomUInt(this.iPerlsInLine);
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                this.iLevelType = 1;
                this.createRandomPerls(5, iLevelNum - 11, 0);
                this.iNextBonus = (1 + Common.getRandomUInt(2)) * this.iPerlsInLine + Common.getRandomUInt(this.iPerlsInLine);
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                this.iFreezeSpeed = 3;
                this.bFrozenLevel = true;
                this.iLevelType = 1;
                this.loadLevel(iLevelNum);
                break;
            }
            case 35: 
            case 36: {
                this.iLevelType = 1;
                this.loadLevel(iLevelNum);
                this.bBirdStealing = true;
                this.initBirdStealing();
                break;
            }
            case 37: 
            case 38: 
            case 39: {
                this.iLevelType = 4;
                this.loadLevel(iLevelNum);
                this.initBirdStealing();
                this.iBirdSpeed = 70;
                int firstCol = this.iPerlsInLine - 1;
                this.iBirdCol = 5;
                this.iBirdHeight = Resources.imgBird.getHeight();
                this.iBirdHeight4 = this.iBirdHeight / 4;
                this.iBirdWidth = Resources.imgBird.getWidth();
                this.iBirdWidth2 = this.iBirdWidth / 2;
                break;
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                this.iLevelType = 5;
                this.loadLevel(iLevelNum);
                break;
            }
            case 44: {
                this.iLevelType = 1;
                this.createRandomPerls(6, 5, 5);
                break;
            }
            case 45: {
                this.iLevelType = 1;
                this.createRandomPerls(6, 7, 5);
                break;
            }
            case 46: 
            case 47: 
            case 48: 
            case 49: {
                this.iLevelType = 3;
                this.iZumaEnd = 0;
                int iLastClr = -1;
                int iCnt = 0;
                int iPerls = 60;
                if (iLevelNum == 49) {
                    iPerls = 60;
                }
                for (int i = 0; i < iPerls; ++i) {
                    this.iaZumaPerls[i] = Common.getRandomUInt(iLevelNum - 43);
                    if (iLastClr == this.iaZumaPerls[i]) {
                        if (++iCnt <= 1) continue;
                        do {
                            this.iaZumaPerls[i] = Common.getRandomUInt(iLevelNum - 43);
                        } while (iLastClr == this.iaZumaPerls[i]);
                        iCnt = 0;
                        iLastClr = this.iaZumaPerls[i];
                        continue;
                    }
                    iCnt = 0;
                    iLastClr = this.iaZumaPerls[i];
                }
                this.iZumaPerlsCount = iPerls;
                this.updatePerlsInGameArray();
                this.iLastDspX = -Defines.WIDTH;
                break;
            }
            case 29: {
                this.iLevelType = 6;
                this.iDropDownTimer = 2000;
                break;
            }
            default: {
                Debug.trace("level " + iLevelNum + " -> Perls.prepare() not defined");
            }
        }
        this.setShotsBetweenBonuses();
        this.updateDangerousState();
        this.prepareNextPerl();
        Debug.trace("Perls.prepareLevel() - out");
    }

    void prepareArcade() {
        Debug.trace("Perls.prepareArcade() - in");
        this.iLevelNum = 0;
        this.iMultiplierVal = 0;
        this.iMultiplierTime = 0;
        this.bArcadeMode = true;
        this.bFailed = false;
        this.bUseWaves = false;
        this.bFloatingStones = false;
        this.bBirdStealing = false;
        this.bFrozenLevel = false;
        this.frozenRowLast = -1;
        this.frozenColLast = -1;
        this.iNextBonus = -1;
        this.iPerlsOnStart = 0;
        this.iPerlsLeft = 0;
        this.iLevelType = 1;
        this.createRandomPerls(5, 4, 0);
        this.iNextBonus = (2 + Common.getRandomUInt(2)) * this.iPerlsInLine + Common.getRandomUInt(this.iPerlsInLine);
        this.setShotsBetweenBonuses();
        this.updateDangerousState();
        this.prepareNextPerl();
        Debug.trace("Perls.prepareArcade() - out");
    }

    void initBirdStealing() {
        this.iBirdTimer = 0;
        this.iBirdSpeed = (Common.getRandomUInt(4) + 2) * 65;
        this.iBirdRow = -1;
    }

    void setPerlToSteal() {
        if (this.iBirdRow != -1) {
            return;
        }
        this.iBirdCol = -1;
        int cnt = 0;
        for (int row = 2; row < this.iTotalLines; ++row) {
            for (int col = 0; col < this.iPerlsInLine; ++col) {
                if (this.iaPerls[row][col] == -1979) continue;
                ++cnt;
            }
        }
        int tmpIdx = Common.getRandomUInt(cnt);
        for (int row = 2; row < this.iTotalLines; ++row) {
            for (int col = 0; col < this.iPerlsInLine; ++col) {
                if (this.iaPerls[row][col] == -1979 || --tmpIdx > 0) continue;
                this.iBirdRow = row;
                this.iBirdCol = col;
                return;
            }
        }
    }

    int getBottom() {
        return this.iTopInit + this.iTotalLines * this.iPerlHeight;
    }

    void resetPerlAdd() {
        this.iLastAddedCol = -1;
    }

    void addPerlOnTop(int col) {
        if (col < 0) {
            return;
        }
        if (col > this.iPerlsInLine - 1) {
            return;
        }
        if (this.iLastAddedCol == col) {
            return;
        }
        this.iaColumnsShifts[col] = this.iPerlHeight2;
        this.shiftColDown(col);
        this.iaPerls[0][col] = Arrays.intInArray(this.iaPerlsOnStart, Common.getRandomUInt(Arrays.intsInArray(this.iaPerlsOnStart)));
        if (this.iNextBonus != -1) {
            if (this.iNextBonus > 0) {
                --this.iNextBonus;
            } else {
                this.iNextBonus = this.getNextBonus();
                this.iaPerls[0][col] = this.getLevelBonus(this.iaPerls[0][col]);
            }
        }
        Arrays.printIntArray(this.iaPerlsOnStart);
        ++this.iPerlsOnStart;
        this.iLastAddedCol = col;
        WholeGame.particles.createBubbles(this.iInnerLeft + col * this.iPerlWidth + this.iPerlWidth2, this.iTop);
        this.updateDangerousState();
    }

    boolean canAddPerl(int row, int col) {
        if (row > this.iTotalLines - 1) {
            this.bFailed = true;
            return true;
        }
        if (row > 0) {
            int trow = row - 1;
            if (this.iaPerls[row - 1][col] != -1979) {
                return true;
            }
            if (row % 2 == 0 ? col > 0 && this.iaPerls[row - 1][col - 1] != -1979 : col < this.iPerlsInLine - 2 && this.iaPerls[row - 1][col + 1] != -1979) {
                return true;
            }
        }
        return false;
    }

    void addPerl(int row, int col, int type) {
        if (row > this.iTotalLines - 1) {
            this.bFailed = true;
            return;
        }
        if (this.iaPerls[row][col] != -1979) {
            return;
        }
        if (type == 9) {
            type += 200;
        }
        this.iaPerls[row][col] = type;
        ++this.iPerlsOnStart;
        WholeGame.particles.createBubbles(this.iInnerLeft + col * this.iPerlWidth + this.iPerlWidth2, this.iTop + row * this.iPerlHeight + this.iPerlHeight2);
        this.updateDangerousState();
    }

    int getLastRowForAdd() {
        for (int i = this.iTotalLines - 1; i >= 0; --i) {
            for (int ii = 0; ii < this.iPerlsInLine; ++ii) {
                if (this.iaPerls[i][ii] == -1979) continue;
                return i;
            }
        }
        return -1;
    }

    int getColForAdd(int row) {
        int cnt = this.getPerlsInRow(row);
        cnt -= Common.getRandomUInt(cnt);
        for (int i = 0; i < this.iPerlsInLine; ++i) {
            if (this.iaPerls[row][i] == -1979 || --cnt != 0) continue;
            return i;
        }
        return -1;
    }

    int getPerlsInRow(int row) {
        int cnt = 0;
        for (int i = 0; i < this.iPerlsInLine; ++i) {
            if (this.iaPerls[row][i] == -1979) continue;
            ++cnt;
        }
        return cnt;
    }

    int getPerlsInCol(int col) {
        Debug.trace("getPerlsInCol() - in");
        int cnt = 0;
        for (int i = 0; i < this.iTotalLines; ++i) {
            if (this.iaPerls[i][col] == -1979) continue;
            ++cnt;
        }
        Debug.trace("getPerlsInCol() - out " + cnt);
        return cnt;
    }

    void shiftColDown(int col) {
        if (this.iaPerls[this.iTotalLines - 1][col] != -1979) {
            this.bFailed = true;
        }
        for (int i = this.iTotalLines - 1; i >= 1; --i) {
            this.iaPerls[i][col] = this.iaPerls[i - 1][col];
            if (this.iStackedPerlsCount <= 0) continue;
            for (int ii = 0; ii < this.iStackedPerlsCount; ++ii) {
                int row;
                int val = this.iaStackedPerls[ii] % 1000;
                int _col = val % this.iPerlsInLine;
                if (_col != col || (row = val / this.iPerlsInLine) != i - 1) continue;
                int n = ii;
                this.iaStackedPerls[n] = this.iaStackedPerls[n] - val;
                int n2 = ii;
                this.iaStackedPerls[n2] = this.iaStackedPerls[n2] + ((row + 1) * this.iPerlsInLine + _col);
            }
        }
        this.updateDangerousState();
    }

    boolean shiftColsLeft() {
        Debug.trace("shiftColsLeft() - in");
        for (int i = 1; i < this.iPerlsInLine; ++i) {
            for (int ii = this.iTotalLines - 1; ii >= 0; --ii) {
                this.iaPerls[ii][i - 1] = this.iaPerls[ii][i];
                this.iaPerls[ii][i] = -1979;
            }
        }
        Debug.trace("shiftColsLeft() - out");
        return this.getPerlsInCol(0) == 0;
    }

    boolean shiftColsRight() {
        Debug.trace("shiftColsRight() - in");
        for (int i = this.iPerlsInLine - 2; i >= 0; --i) {
            for (int ii = this.iTotalLines - 1; ii >= 0; --ii) {
                Debug.trace("" + i + " , " + ii);
                this.iaPerls[ii][i + 1] = this.iaPerls[ii][i];
                this.iaPerls[ii][i] = -1979;
            }
        }
        Debug.trace("shiftColsRight() - out");
        return this.getPerlsInCol(this.iPerlsInLine - 1) == 0;
    }

    void updateDangerousState() {
        if (this.iLevelType == 3) {
            this.bDangerousState = this.iaZumaPerls[this.iaZumaPerls.length - 1 - this.iPerlsInLine] != -1979;
            this.bFailed = this.bFailed || this.iaZumaPerls[this.iaZumaPerls.length - 1] != -1979;
            return;
        }
        if (this.iLevelType == 5) {
            int iBottom = this.iTopInit + this.iPerlHeight * this.iTotalLines;
            int iLastRow = this.getLastRowForAdd();
            int iActual = this.iTop + this.iPerlHeight * (iLastRow + 1);
            int iDH = iBottom - iActual;
            this.bDangerousState = iDH < 2 * Resources.sprPerlsWidth;
            this.bFailed = this.bFailed || iDH <= 0;
            return;
        }
        for (int i = this.iPerlsInLine - 1; i >= 0; --i) {
            if (this.iaPerls[this.iTotalLines - 2][i] == -1979) continue;
            this.bDangerousState = true;
            return;
        }
        this.bDangerousState = false;
    }

    void updatePerlsInGameArray() {
        int i;
        Debug.trace("updatePerlsInGameArray() - in");
        this.iRocksInPlay = 0;
        this.iPerlsLeft = 0;
        Arrays.resetIntsArray(this.iaPerlsInGame);
        if (this.iLevelType == 1 || this.iLevelType == 4 || this.iLevelType == 5) {
            for (i = this.iTotalLines - 1; i >= 0; --i) {
                for (int ii = 0; ii < this.iPerlsInLine; ++ii) {
                    int val = this.getPerlVal(i, ii);
                    if (val == -1979) continue;
                    if (val < 7) {
                        ++this.iPerlsLeft;
                        if (Arrays.arrayContainsInt(this.iaPerlsInGame, val)) continue;
                        Arrays.addIntToArray(this.iaPerlsInGame, val);
                        continue;
                    }
                    if (val != 8 && val != 9) continue;
                    ++this.iRocksInPlay;
                }
            }
        }
        if (this.iLevelType == 3) {
            for (i = this.iaZumaPerls.length - 1; i >= 0; --i) {
                int val = this.iaZumaPerls[i];
                if (val == -1979 || val >= 7 || Arrays.arrayContainsInt(this.iaPerlsInGame, val)) continue;
                Arrays.addIntToArray(this.iaPerlsInGame, val);
            }
        }
        this.iActivePerlsCount = this.activePerls();
        Debug.trace("iaPerlsInGame contains " + Arrays.intsInArray(this.iaPerlsInGame));
        Debug.trace("updatePerlsInGameArray() - out");
    }

    int getBonusPerlType() {
        int tmp = 0;
        if (this.bArcadeMode) {
            tmp = Common.getRandomUInt(200);
            if (WholeGame.level.iLevelNum > 5 && tmp % 3 == 0) {
                return 14;
            }
            return 11;
        }
        switch (this.iLevelNum) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return -1979;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                return -1979;
            }
            case 80: {
                tmp = Common.getRandomUInt(300);
                switch (tmp /= 100) {
                    case 1: {
                        return 14;
                    }
                    case 2: {
                        return -1979;
                    }
                }
                return 11;
            }
            case 11: 
            case 12: 
            case 13: {
                return Common.getRandomUInt(100) % 2 == 0 ? 11 : -1979;
            }
            case 31: {
                return Common.getRandomUInt(100) % 2 == 0 ? 15 : -1979;
            }
            case 32: {
                tmp = Common.getRandomUInt(300);
                switch (tmp /= 100) {
                    case 1: {
                        return 15;
                    }
                    case 2: {
                        return 14;
                    }
                }
                return 11;
            }
            case 37: 
            case 38: 
            case 39: {
                return Common.getRandomUInt(100) % 2 == 0 ? 11 : 14;
            }
            case 44: 
            case 45: {
                return Common.getRandomUInt(100) % 2 == 0 ? 11 : 14;
            }
        }
        Debug.trace("level " + this.iLevelNum + " -> Perls.getBonusPerlType() not defined");
        return -1979;
    }

    void setShotsBetweenBonuses() {
        this.iNextBonusInXShots = Common.getRandomUInt(4) + 6;
    }

    void changeSwitchPerls() {
        if (this.iLevelType != 3) {
            for (int row = 0; row < this.iTotalLines; ++row) {
                for (int col = 0; col < this.iPerlsInLine; ++col) {
                    int pval = this.iaPerls[row][col];
                    if (pval < 500 || pval >= 600) continue;
                    this.iaPerls[row][col] = 500 + Arrays.intInArray(this.iaPerlsInGame, Common.getRandomUInt(Arrays.intsInArray(this.iaPerlsInGame)));
                    WholeGame.particles.createBubbles(this.iInnerLeft + this.getDspX(col) + col * this.iPerlWidth, this.iTop + this.getDspY(col) + row * this.iPerlHeight + this.iPerlHeight2);
                    WholeGame.particles.createBubbles(this.iInnerLeft + this.getDspX(col) + col * this.iPerlWidth, this.iTop + this.getDspY(col) + row * this.iPerlHeight + this.iPerlHeight2);
                }
            }
        }
    }

    void updatePreparedPerl() {
        if (Arrays.intsInArray(this.iaPerlsInGame) == 0) {
            return;
        }
        if (this.iPreparedPerl > 6) {
            return;
        }
        if (!Arrays.arrayContainsInt(this.iaPerlsInGame, this.iPreparedPerl)) {
            this.iPreparedPerl = Arrays.intInArray(this.iaPerlsInGame, Common.getRandomUInt(Arrays.intsInArray(this.iaPerlsInGame)));
        }
        if (WholeGame.level.player.perlType == -1979) {
            return;
        }
        if (WholeGame.level.player.perlSpd != 0) {
            return;
        }
        if (WholeGame.level.player.perlType > 6) {
            return;
        }
        if (!Arrays.arrayContainsInt(this.iaPerlsInGame, WholeGame.level.player.perlType)) {
            WholeGame.level.player.perlType = Arrays.intInArray(this.iaPerlsInGame, Common.getRandomUInt(Arrays.intsInArray(this.iaPerlsInGame)));
        }
    }

    void prepareNextPerl() {
        Debug.trace("Perls.prepareNextPerl() - in");
        this.updatePerlsInGameArray();
        if (this.iRocksInPlay > 0 && this.iRocksInPlay >= this.iPerlsLeft / 2) {
            this.iPreparedPerl = 14;
            this.bNextPerlReady = true;
            return;
        }
        if (Arrays.intsInArray(this.iaPerlsInGame) == 0) {
            this.iPreparedPerl = Common.getRandomUInt(7);
            this.bNextPerlReady = true;
            return;
        }
        this.iPreparedPerl = Arrays.intInArray(this.iaPerlsInGame, Common.getRandomUInt(Arrays.intsInArray(this.iaPerlsInGame)));
        Debug.trace("iPreparedPerl = " + this.iPreparedPerl);
        if (this.iNextBonusInXShots > 0) {
            --this.iNextBonusInXShots;
        } else {
            this.setShotsBetweenBonuses();
            int bonusPerl = this.getBonusPerlType();
            Debug.trace("bonusPerl = " + bonusPerl);
            if (bonusPerl != -1979) {
                this.iPreparedPerl = bonusPerl;
            }
        }
        this.bNextPerlReady = true;
        this.changeSwitchPerls();
        Debug.trace("Perls.prepareNextPerl() - out");
    }

    int getMultiplierTime() {
        int tmp = 10 - (this.iMultiplierVal < 10 ? this.iMultiplierVal : 10);
        return 2500 + GameDef.barValue(tmp, 10, 2500);
    }

    void incMultiplier() {
        this.iMultiplierTime = this.getMultiplierTime();
        ++this.iMultiplierVal;
        if (this.iMultiplierVal == 15) {
            WholeGame.level.testAchievement(1);
        }
    }

    boolean placePerl(int row, int col, int rowNext, int colNext, int type) {
        Debug.trace("placePerl " + row + ", " + col + ", " + rowNext + ", " + colNext);
        this.iBombPerl = -1979;
        if (this.bFrozenLevel) {
            this.unfrozePerls(this.iaStackedPerls, rowNext, colNext, type, type == 15 ? 4 : 3);
            Arrays.resetIntsArray(this.iaStackedPerls);
            this.iStackedPerlsCount = 0;
            if (type == 15) {
                return false;
            }
        }
        Arrays.resetIntsArray(this.iaStackedPerls);
        this.iaPerls[row][col] = type;
        this.updateDangerousState();
        if (type == 11) {
            WholeGame.particles.createBubbles(this.iInnerLeft + col * this.iPerlWidth + this.iPerlWidth2, this.iTop + row * this.iPerlHeight + this.iPerlHeight2);
            this.markPerlsRainbow(this.iaStackedPerls, row, col);
        } else if (type == 14) {
            this.iBombPerl = row * this.iPerlsInLine + col;
            this.explodePerls(this.iaStackedPerls, row, col, 4);
        } else {
            this.markPerls(this.iaStackedPerls, row, col);
        }
        this.iStackedPerlsCount = Arrays.intsInArray(this.iaStackedPerls);
        Debug.trace("iStackedPerlsCount = " + this.iStackedPerlsCount);
        if (this.iStackedPerlsCount < 3 && type != 14) {
            if (type == 11) {
                this.iaPerls[row][col] = this.getPerlVal(rowNext, colNext);
            }
            this.iStackedPerlsCount = 0;
            Arrays.resetIntsArray(this.iaStackedPerls);
            this.bNextPerlReady = true;
        } else {
            int i;
            if (this.iStackedPerlsCount >= 25) {
                WholeGame.level.testAchievement(8);
            } else if (this.iStackedPerlsCount >= 10) {
                WholeGame.level.testAchievement(7);
            }
            if (WholeGame.level.player.playerBounces == 2) {
                WholeGame.level.testAchievement(4);
            }
            if (WholeGame.level.player.playerBounces > 2) {
                WholeGame.level.testAchievement(5);
            }
            boolean bPointer = false;
            boolean bBomb = false;
            boolean bStop = false;
            int iBombRow = 0;
            int iBombCol = 0;
            for (i = this.iStackedPerlsCount - 1; i >= 0; --i) {
                if (this.iaStackedPerls[i] == -1979) continue;
                int v = this.val2perlAbs(this.iaStackedPerls[i]);
                bPointer = bPointer || v >= 600 && v < 700;
                bBomb = bBomb || v >= 700 && v < 800;
                bStop = bStop || v >= 800 && v < 900;
                iBombRow = this.iaStackedPerls[i] / this.iPerlsInLine;
                iBombCol = this.iaStackedPerls[i] % this.iPerlsInLine;
            }
            if (bBomb) {
                Arrays.resetIntsArray(this.iaTestedPerls);
                this.explodePerls(this.iaTestedPerls, iBombRow, iBombCol, 4);
                Arrays.addUniqueIntsToArray(this.iaStackedPerls, this.iaTestedPerls);
                this.iStackedPerlsCount = Arrays.intsInArray(this.iaStackedPerls);
            }
            if (bPointer) {
                WholeGame.level.player.playerPointer += 10;
            }
            if (bStop) {
                WholeGame.level.iTimeToActionDelay = 15000;
            }
            for (i = this.iStackedPerlsCount - 1; i >= 0; --i) {
                if (this.iaStackedPerls[i] == -1979) continue;
                this.iaStackedPerls[i] = this.iaStackedPerls[i] + 1000;
            }
            this.iPerlsToPop = this.iStackedPerlsCount;
            this.incMultiplier();
            if (this.iMultiplierVal == 3) {
                X.canvas.createCongratLabel(0, 0, Resources.sprLabelNice);
                WholeGame.sounds.playSound(2, 4, 10);
                Level.figState[WholeGame.level.idx_octopus] = 1;
                GameDef.figStateTimer[WholeGame.level.idx_octopus] = 100;
            }
            if (this.iMultiplierVal == 6) {
                X.canvas.createCongratLabel(0, 0, Resources.sprLabelPerfect);
                WholeGame.sounds.playSound(2, 5, 10);
                Level.figState[WholeGame.level.idx_octopus] = 1;
                GameDef.figStateTimer[WholeGame.level.idx_octopus] = 100;
            }
            if (this.iMultiplierVal == 10) {
                X.canvas.createCongratLabel(0, 0, Resources.sprLabelBrilliant);
                WholeGame.sounds.playSound(2, 6, 10);
                Level.figState[WholeGame.level.idx_octopus] = 1;
                GameDef.figStateTimer[WholeGame.level.idx_octopus] = 100;
            }
        }
        return true;
    }

    int getDspX(int tmp) {
        if (this.iLevelType != 1 && this.iLevelType != 5) {
            if (this.iLevelType == 4) {
                return GameDef.barValue(this.iBirdTimer, this.iBirdSpeed, this.iPerlWidth) * this.iBirdDirection;
            }
            if (this.iLevelType == 3) {
                return tmp * -1 * this.iPerlWidth2 + GameDef.barValue(65 - this.iZumaMoveTime, 65, this.iPerlWidth) * tmp;
            }
        }
        return 0;
    }

    int getDspY(int tmp) {
        if (this.iLevelType == 1 || this.iLevelType == 5) {
            return -this.iaColumnsShifts[tmp];
        }
        return 0;
    }

    void damageRock(int row, int col, int dspx) {
        int val = this.iaPerls[row][col];
        this.iaPerls[row][col] = val -= 100;
        WholeGame.particles.createExplosion(col * this.iPerlWidth + (dspx >> 4), row * this.iPerlWidth + this.iTop, val % 100 == 8 ? Resources.sprPcsRock : Resources.sprPcsShell);
        if (val < 100) {
            this.iaPerls[row][col] = -1979;
            --this.iRocksInPlay;
            this.bShakePerlsNeeded = true;
            --WholeGame.level.iArcadePerlsLeft;
            WholeGame.level.bRefreshStatusPerls = true;
        }
        WholeGame.particles.createBubbles(WholeGame.level.player.perlXPx, WholeGame.level.player.perlYPx);
    }

    boolean testPerl(int perlX, int perlY, int perlSpdX, int perlSpdY, int perlType) {
        this.bNextPerlReady = false;
        if (this.iLevelType == 1 || this.iLevelType == 5 || this.iLevelType == 4) {
            int iPlayerColNext;
            int len = this.iaPerls.length;
            int dspy = this.iTop << 4;
            this.iPlayerRow = (perlY - dspy) / this.iPerlHeight >> 4;
            int iPlayerRowNext = (perlY + perlSpdY - dspy) / this.iPerlHeight >> 4;
            if (this.iPlayerRow > this.iTotalLines - 1) {
                Debug.trace("  >> iPlayerRow = " + this.iPlayerRow + " => " + iPlayerRowNext);
                if (iPlayerRowNext < this.iTotalLines) {
                    Debug.trace(" iPlayerRowNext = " + iPlayerRowNext + " -> " + this.iTotalLines);
                    int dspx = this.iInnerLeft + this.getDspX(iPlayerRowNext) - (iPlayerRowNext % 2 == 0 ? this.iPerlWidth2 : 0) << 4;
                    int iPlayerColNext2 = (perlX + perlSpdX - dspx) / this.iPerlWidth >> 4;
                    if (iPlayerColNext2 >= 0 && iPlayerColNext2 < this.iPerlsInLine && this.iaPerls[iPlayerRowNext][iPlayerColNext2] != -1979) {
                        this.bFailed = true;
                        WholeGame.particles.createBubbles(WholeGame.level.player.perlXPx, WholeGame.level.player.perlYPx);
                    }
                }
                this.iPlayerRowLast = this.iPlayerRow;
                return false;
            }
            if (iPlayerRowNext >= this.iTotalLines) {
                this.iPlayerRowLast = this.iPlayerRow;
                return false;
            }
            boolean bOnAnchor = false;
            if (this.iLevelType != 5) {
                if (this.iPlayerRow < 0) {
                    return false;
                }
            } else if (this.iPlayerRow < 0) {
                this.iPlayerRow = 0;
                bOnAnchor = true;
            }
            boolean ang = false;
            int dspx = this.iInnerLeft + this.getDspX(this.iPlayerRow) - (this.iPlayerRow % 2 == 0 ? this.iPerlWidth2 : 0) << 4;
            this.iPlayerCol = (perlX - dspx) / this.iPerlWidth >> 4;
            if (this.iPlayerCol < 0) {
                return false;
            }
            if (this.iPlayerCol > this.iPerlsInLine - 1) {
                return false;
            }
            perlX += perlSpdX;
            perlY += perlSpdY;
            if (this.iLevelType != 5) {
                if (iPlayerRowNext < 0) {
                    return false;
                }
            } else if (iPlayerRowNext < 0) {
                iPlayerRowNext = 0;
                bOnAnchor = true;
            }
            if ((iPlayerColNext = (perlX - (dspx = this.iInnerLeft + this.getDspX(iPlayerRowNext) - (iPlayerRowNext % 2 == 0 ? this.iPerlWidth2 : 0) << 4)) / this.iPerlWidth >> 4) < 0) {
                return false;
            }
            if (iPlayerColNext > this.iPerlsInLine - 1) {
                return false;
            }
            int iNextPerlVal = this.iaPerls[iPlayerRowNext][iPlayerColNext];
            if (!bOnAnchor) {
                if (iNextPerlVal >= 100 && iNextPerlVal < 500 && perlType != 14) {
                    this.damageRock(iPlayerRowNext, iPlayerColNext, dspx);
                    if (perlType != 15) {
                        this.bNextPerlReady = true;
                        return true;
                    }
                }
                if (iNextPerlVal != -1979) {
                    if (this.iPlayerRow > this.iTotalLines - 1) {
                        this.bFailed = true;
                        WholeGame.particles.createBubbles(WholeGame.level.player.perlXPx, WholeGame.level.player.perlYPx);
                        return true;
                    }
                    if (this.iaPerls[this.iPlayerRow][this.iPlayerCol] != -1979 && perlType != 15 && this.iaPerls[this.iPlayerRow][this.iPlayerCol] == 10) {
                        iPlayerRowNext = (perlY + perlSpdY - dspy) / this.iPerlHeight >> 4;
                        iPlayerColNext = (perlX + perlSpdX - dspx) / this.iPerlWidth >> 4;
                        if (this.iPlayerRow == iPlayerRowNext) {
                            WholeGame.level.player.perlSpdY *= -1;
                            WholeGame.particles.createExplosion(WholeGame.level.player.perlXPx, WholeGame.level.player.perlYPx, Resources.sprStars);
                        }
                        return false;
                    }
                    if (iNextPerlVal == 10) {
                        boolean leftDir;
                        iPlayerRowNext = (perlY + perlSpdY - dspy) / this.iPerlHeight >> 4;
                        iPlayerColNext = (perlX + perlSpdX - dspx) / this.iPerlWidth >> 4;
                        boolean bl = leftDir = perlSpdX >= 0;
                        if (leftDir) {
                            if (this.iPlayerCol == iPlayerColNext + 1) {
                                WholeGame.level.player.perlSpdX *= -1;
                                WholeGame.particles.createExplosion(WholeGame.level.player.perlXPx, WholeGame.level.player.perlYPx, Resources.sprStars);
                            }
                        } else if (this.iPlayerCol == iPlayerColNext - 1) {
                            WholeGame.level.player.perlSpdX *= -1;
                            WholeGame.particles.createExplosion(WholeGame.level.player.perlXPx, WholeGame.level.player.perlYPx, Resources.sprStars);
                        }
                        WholeGame.level.player.perlSpdY *= -1;
                        return false;
                    }
                    if (this.iaPerls[this.iPlayerRow][this.iPlayerCol] != -1979) {
                        this.iPlayerRow = this.iPlayerRowLast;
                        this.iPlayerCol = this.iPlayerColLast;
                        if (this.iPlayerRow > this.iTotalLines - 1) {
                            this.bFailed = true;
                            WholeGame.particles.createBubbles(WholeGame.level.player.perlXPx, WholeGame.level.player.perlYPx);
                            return false;
                        }
                    }
                    return this.placePerl(this.iPlayerRow, this.iPlayerCol, iPlayerRowNext, iPlayerColNext, perlType);
                }
                this.iPlayerRowLast = this.iPlayerRow;
                this.iPlayerColLast = this.iPlayerCol;
                return false;
            }
            return this.placePerl(this.iPlayerRow, this.iPlayerCol, iPlayerRowNext, iPlayerColNext, perlType);
        }
        if (this.iLevelType == 3) {
            int len = this.iaZumaPerls.length;
            int ypos = this.iTop;
            int xpos = this.iInnerLeft;
            int mark = 1;
            int gap = this.iPerlWidth + 2;
            if (GameDef._HEIGHT <= 130) {
                gap = this.iPerlWidth - 1;
            } else if (GameDef._HEIGHT <= 160) {
                gap = this.iPerlWidth;
            }
            int gap2 = gap / 2;
            int ztime2 = 32;
            for (int i = 0; i < len; ++i) {
                int dspy = 0;
                if (i % this.iPerlsInLine == this.iPerlsInLine - 1 && mark == 1) {
                    dspy = gap2 - GameDef.barValue(this.iZumaMoveTime, 65, gap2);
                }
                if (i % this.iPerlsInLine == 0 && mark == 1) {
                    dspy = -GameDef.barValue(this.iZumaMoveTime, 65, gap2);
                }
                if (i % this.iPerlsInLine == this.iPerlsInLine - 1 && mark == -1) {
                    dspy = gap2 - GameDef.barValue(this.iZumaMoveTime, 65, gap2);
                }
                if (i % this.iPerlsInLine == 0 && mark == -1) {
                    dspy = -GameDef.barValue(this.iZumaMoveTime, 65, gap2);
                }
                if (i > 0 && i % this.iPerlsInLine == 0) {
                    ypos += gap;
                    xpos += this.iPerlWidth * (mark *= -1);
                }
                if (this.iaZumaPerls[i] == -1979) {
                    xpos += this.iPerlWidth * mark;
                    continue;
                }
                int dspx = this.getDspX(mark);
                if (mark == -1) {
                    dspx += this.iPerlWidth;
                }
                int dx = Math.abs((xpos + dspx << 4) - (perlX + perlSpdX));
                int dy = Math.abs((ypos + dspy << 4) - (perlY + perlSpdY));
                xpos += this.iPerlWidth * mark;
                if (dx > this.iPerlWidth << 4 || dy > this.iPerlWidth << 4) continue;
                WholeGame.particles.createBubbles(WholeGame.level.player.perlXPx, WholeGame.level.player.perlYPx);
                this.movePerlsZuma(i);
                this.iaZumaPerls[i] = perlType;
                ++this.iZumaPerlsCount;
                --this.iZumaEnd;
                this.iMultiplierVal = 0;
                this.makeZumaPopping(i);
                return true;
            }
        }
        if (this.iLevelType == 6) {
            int iX = perlX >> 4;
            int iY = perlY >> 4;
            for (int i = this.iPerlsInLine - 1; i >= 0; --i) {
                int dy;
                int dx;
                if (this.iaPerls[0][i] == -1979 || (dx = Math.abs(this.iaPerls[1][i] - iX)) > this.iPerlWidth || (dy = Math.abs((this.iaPerls[2][i] >> 2) - iY)) > this.iPerlHeight) continue;
                this.incMultiplier();
                WholeGame.particles.createBubbles(this.iaPerls[1][i] + this.iPerlWidth2, (this.iaPerls[2][i] >> 2) + this.iPerlHeight2);
                WholeGame.particles.createBubbles(this.iaPerls[1][i] + this.iPerlWidth2, (this.iaPerls[2][i] >> 2) + this.iPerlHeight2);
                int iBase = 10;
                if (this.iaPerls[0][i] == perlType) {
                    iBase = 50;
                    X.canvas.createCongratLabel(0, 0, Resources.sprLabelNice);
                }
                int score = this.iMultiplierVal > 1 ? this.iMultiplierVal * iBase : (iBase *= WholeGame.level.player.playerBounces > 0 ? WholeGame.level.player.playerBounces + 1 : 1);
                WholeGame.level.player.incScore(this.iMultiplierVal * iBase);
                if (this.iMultiplierVal > 1) {
                    X.canvas.createScoreLabel(this.iaPerls[1][i] + this.iPerlWidth2, (this.iaPerls[2][i] >> 2) + this.iPerlHeight2, this.iMultiplierVal, iBase);
                } else {
                    X.canvas.createScoreLabel(this.iaPerls[1][i] + this.iPerlWidth2, (this.iaPerls[2][i] >> 2) + this.iPerlHeight2, iBase);
                }
                this.iaPerls[0][i] = -1979;
                WholeGame.level.incPoppedBubbles(1);
                WholeGame.vibrate(30);
                WholeGame.sounds.playSound_Pop();
                this.bNextPerlReady = true;
                return true;
            }
        }
        return false;
    }

    void makeZumaPopping(int idx) {
        Arrays.resetIntsArray(this.iaStackedPerls);
        this.markPerlsZuma(this.iaStackedPerls, idx);
        this.iStackedPerlsCount = Arrays.intsInArray(this.iaStackedPerls);
        if (this.iStackedPerlsCount < 3) {
            this.iStackedPerlsCount = 0;
            Arrays.resetIntsArray(this.iaStackedPerls);
            this.bNextPerlReady = true;
        } else {
            ++this.iMultiplierVal;
            for (int ii = this.iStackedPerlsCount - 1; ii >= 0; --ii) {
                if (this.iaStackedPerls[ii] == -1979) continue;
                this.iaStackedPerls[ii] = this.iaStackedPerls[ii] + 1000;
            }
            this.iPerlsToPop = this.iStackedPerlsCount;
            this.bNextPerlReady = true;
        }
    }

    void shakePerls() {
        int i;
        Arrays.resetIntsArray(this.iaTestedPerls);
        for (int i2 = 0; i2 < this.iTotalLines; ++i2) {
            for (int ii = 0; ii < this.iPerlsInLine; ++ii) {
                if (this.iaPerls[i2][ii] == -1979) continue;
                Arrays.addIntToArray(this.iaTestedPerls, i2 * this.iPerlsInLine + ii);
            }
        }
        this.iFallOffs = 0;
        Arrays.resetIntsArray(this.iaFallingPerls);
        do {
            int len2 = this.iaTestedPerls.length;
            for (i = 0; i < len2; ++i) {
                if (this.iaTestedPerls[i] == -1979) continue;
                Arrays.resetIntsArray(this.iaGroupedPerls);
                this.groupPerls(this.iaTestedPerls[i]);
                this.makeFallingPerls();
            }
        } while (Arrays.intsInArray(this.iaTestedPerls) > 0);
        if (Arrays.intsInArray(this.iaFallingPerls) > 0) {
            int len = Arrays.intsInArray(this.iaFallingPerls);
            if (len >= 20) {
                WholeGame.level.testAchievement(3);
            } else if (len >= 10) {
                WholeGame.level.testAchievement(2);
            }
            for (i = 0; i < len; ++i) {
                int val = Arrays.intInArray(this.iaFallingPerls, i);
                int row = val / this.iPerlsInLine;
                int col = val % this.iPerlsInLine;
                this.iaPerls[row][col] = -1979;
            }
            this.updateDangerousState();
        }
        this.bShakePerlsNeeded = false;
        this.bNextPerlReady = true;
    }

    void groupPerls(int val) {
        int tx;
        int val2;
        int ty;
        int tx2;
        int val22;
        Arrays.addUniqueIntToArray(this.iaGroupedPerls, val);
        Arrays.removeIntFromArray(this.iaTestedPerls, val);
        int x = val % this.iPerlsInLine;
        int y = val / this.iPerlsInLine;
        if (x > 0 && Arrays.arrayContainsInt(this.iaTestedPerls, val22 = y * this.iPerlsInLine + (tx2 = x - 1))) {
            this.groupPerls(val22);
        }
        if (x < this.iPerlsInLine - 1 && Arrays.arrayContainsInt(this.iaTestedPerls, val22 = y * this.iPerlsInLine + (tx2 = x + 1))) {
            this.groupPerls(val22);
        }
        if (y > 0) {
            ty = y - 1;
            if (y % 2 == 0) {
                if (x > 0 && Arrays.arrayContainsInt(this.iaTestedPerls, val2 = ty * this.iPerlsInLine + (tx = x - 1))) {
                    this.groupPerls(val2);
                }
            } else if (x < this.iPerlsInLine - 2 && Arrays.arrayContainsInt(this.iaTestedPerls, val2 = ty * this.iPerlsInLine + (tx = x + 1))) {
                this.groupPerls(val2);
            }
        }
        if (y < this.iTotalLines - 1) {
            ty = y + 1;
            if (y % 2 == 0) {
                if (x > 0 && Arrays.arrayContainsInt(this.iaTestedPerls, val2 = ty * this.iPerlsInLine + (tx = x - 1))) {
                    this.groupPerls(val2);
                }
            } else if (x < this.iPerlsInLine - 2 && Arrays.arrayContainsInt(this.iaTestedPerls, val2 = ty * this.iPerlsInLine + (tx = x + 1))) {
                this.groupPerls(val2);
            }
            if (Arrays.arrayContainsInt(this.iaTestedPerls, val22 = ty * this.iPerlsInLine + x)) {
                this.groupPerls(val22);
            }
        }
    }

    void groupPerlsZuma(int val) {
        int tx;
        int val2;
        int val22;
        Arrays.addUniqueIntToArray(this.iaGroupedPerls, val);
        Arrays.removeIntFromArray(this.iaTestedPerls, val);
        int x = val % this.iPerlsInLine;
        int y = val / this.iPerlsInLine;
        if (x == 0) {
            if (y % 2 == 0) {
                if (y > 0 && Arrays.arrayContainsInt(this.iaTestedPerls, val22 = (y - 1) * this.iPerlsInLine + 0)) {
                    this.groupPerlsZuma(val22);
                }
            } else if (y < this.iTotalLines - 1 && Arrays.arrayContainsInt(this.iaTestedPerls, val22 = (y + 1) * this.iPerlsInLine + 0)) {
                this.groupPerlsZuma(val22);
            }
        }
        if (x == this.iPerlsInLine - 1) {
            if (y % 2 == 0) {
                if (y < this.iTotalLines - 1 && Arrays.arrayContainsInt(this.iaTestedPerls, val22 = (y + 1) * this.iPerlsInLine + 0)) {
                    this.groupPerlsZuma(val22);
                }
            } else if (y > 0 && Arrays.arrayContainsInt(this.iaTestedPerls, val22 = (y - 1) * this.iPerlsInLine + 0)) {
                this.groupPerlsZuma(val22);
            }
        }
        if (x > 0 && Arrays.arrayContainsInt(this.iaTestedPerls, val2 = y * this.iPerlsInLine + (tx = x - 1))) {
            this.groupPerls(val2);
        }
        if (x < this.iPerlsInLine - 1 && Arrays.arrayContainsInt(this.iaTestedPerls, val2 = y * this.iPerlsInLine + (tx = x + 1))) {
            this.groupPerls(val2);
        }
    }

    int val2perl(int val) {
        return this.getPerlVal(val / this.iPerlsInLine, val % this.iPerlsInLine);
    }

    int val2perlAbs(int val) {
        return this.iaPerls[val / this.iPerlsInLine][val % this.iPerlsInLine];
    }

    boolean isOnPlatform(int row, int col) {
        if (!this.bFloatingStones) {
            return false;
        }
        if (row < this.iTotalLines - 1) {
            if (this.getPerlVal(row + 1, col) >= 7) {
                return true;
            }
            if (row % 2 == 0 ? col > 0 && this.getPerlVal(row + 1, col - 1) >= 7 : col < this.iPerlsInLine - 1 && this.getPerlVal(row + 1, col + 1) >= 7) {
                return true;
            }
        }
        return false;
    }

    void makeFallingPerls() {
        int val;
        int i;
        int len = Arrays.intsInArray(this.iaGroupedPerls);
        boolean bAttached = false;
        boolean bOnPlatform = false;
        boolean bIsPlatform = this.val2perl(Arrays.intInArray(this.iaGroupedPerls, 0)) >= 7 && this.bFloatingStones;
        for (i = 0; i < len && !bAttached && !bOnPlatform; ++i) {
            val = Arrays.intInArray(this.iaGroupedPerls, i);
            if (val < this.iPerlsInLine) {
                bAttached = true;
            }
            if (bIsPlatform && this.val2perl(Arrays.intInArray(this.iaGroupedPerls, 0)) < 7) {
                bIsPlatform = false;
            }
            bOnPlatform = bOnPlatform || this.isOnPlatform(val / this.iPerlsInLine, val % this.iPerlsInLine);
        }
        if (!bAttached && !bOnPlatform || bIsPlatform && !bAttached) {
            for (i = 0; i < len; ++i) {
                val = Arrays.intInArray(this.iaGroupedPerls, i);
                Arrays.addIntToArray(this.iaFallingPerls, val);
            }
        }
        Arrays.resetIntsArray(this.iaGroupedPerls);
    }

    boolean markedPerl(int[] perlBuffer, int row, int col) {
        return Arrays.arrayContainsInt(perlBuffer, row * this.iPerlsInLine + col);
    }

    boolean markedPerl(int[] perlBuffer, int idx) {
        return Arrays.arrayContainsInt(perlBuffer, idx);
    }

    int getPerlVal(int val) {
        int RetVal = val;
        if (RetVal >= 100 && RetVal <= 900) {
            return RetVal % 100;
        }
        if (RetVal >= 1000) {
            return RetVal / 1000 - 1;
        }
        return RetVal;
    }

    int getPerlVal(int row, int col) {
        return this.getPerlVal(this.iaPerls[row][col]);
    }

    void markPerls(int[] perlBuffer, int row, int col) {
        int perlVal = this.getPerlVal(row, col);
        if (perlVal == -1979) {
            return;
        }
        Arrays.addUniqueIntToArray(perlBuffer, row * this.iPerlsInLine + col);
        if (row > 0) {
            if (this.getPerlVal(row - 1, col) == perlVal && !this.markedPerl(perlBuffer, row - 1, col)) {
                this.markPerls(perlBuffer, row - 1, col);
            }
            if (row % 2 == 0) {
                if (col > 0 && this.getPerlVal(row - 1, col - 1) == perlVal && !this.markedPerl(perlBuffer, row - 1, col - 1)) {
                    this.markPerls(perlBuffer, row - 1, col - 1);
                }
            } else if (col < this.iPerlsInLine - 1 && this.getPerlVal(row - 1, col + 1) == perlVal && !this.markedPerl(perlBuffer, row - 1, col + 1)) {
                this.markPerls(perlBuffer, row - 1, col + 1);
            }
        }
        if (row < this.iTotalLines - 1) {
            if (this.getPerlVal(row + 1, col) == perlVal && !this.markedPerl(perlBuffer, row + 1, col)) {
                this.markPerls(perlBuffer, row + 1, col);
            }
            if (row % 2 == 0) {
                if (col > 0 && this.getPerlVal(row + 1, col - 1) == perlVal && !this.markedPerl(perlBuffer, row + 1, col - 1)) {
                    this.markPerls(perlBuffer, row + 1, col - 1);
                }
            } else if (col < this.iPerlsInLine - 1 && this.getPerlVal(row + 1, col + 1) == perlVal && !this.markedPerl(perlBuffer, row + 1, col + 1)) {
                this.markPerls(perlBuffer, row + 1, col + 1);
            }
        }
        if (col > 0 && this.getPerlVal(row, col - 1) == perlVal && !this.markedPerl(perlBuffer, row, col - 1)) {
            this.markPerls(perlBuffer, row, col - 1);
        }
        if (col < this.iPerlsInLine - 1 && this.getPerlVal(row, col + 1) == perlVal && !this.markedPerl(perlBuffer, row, col + 1)) {
            this.markPerls(perlBuffer, row, col + 1);
        }
    }

    void markPerlsRainbow(int[] perlBuffer, int row, int col) {
        Arrays.resetIntsArray(this.iaTestedPerls);
        if (row > 0) {
            this.iaPerls[row][col] = this.getPerlVal(row - 1, col);
            if (!this.markedPerl(this.iaStackedPerls, row - 1, col)) {
                this.markPerls(this.iaTestedPerls, row - 1, col);
                if (Arrays.intsInArray(this.iaTestedPerls) >= 3) {
                    Arrays.addIntsToArray(perlBuffer, this.iaTestedPerls);
                }
                Arrays.resetIntsArray(this.iaTestedPerls);
            }
            if (row % 2 == 0) {
                if (col > 0) {
                    this.iaPerls[row][col] = this.getPerlVal(row - 1, col - 1);
                    if (!this.markedPerl(perlBuffer, row - 1, col - 1)) {
                        this.markPerls(this.iaTestedPerls, row - 1, col - 1);
                        if (Arrays.intsInArray(this.iaTestedPerls) >= 3) {
                            Arrays.addIntsToArray(perlBuffer, this.iaTestedPerls);
                        }
                        Arrays.resetIntsArray(this.iaTestedPerls);
                    }
                }
            } else if (col < this.iPerlsInLine - 1) {
                this.iaPerls[row][col] = this.getPerlVal(row - 1, col + 1);
                if (!this.markedPerl(perlBuffer, row - 1, col + 1)) {
                    this.markPerls(this.iaTestedPerls, row - 1, col + 1);
                    if (Arrays.intsInArray(this.iaTestedPerls) >= 3) {
                        Arrays.addIntsToArray(perlBuffer, this.iaTestedPerls);
                    }
                    Arrays.resetIntsArray(this.iaTestedPerls);
                }
            }
        }
        if (row < this.iTotalLines - 1) {
            this.iaPerls[row][col] = this.getPerlVal(row + 1, col);
            if (!this.markedPerl(perlBuffer, row + 1, col)) {
                this.markPerls(this.iaTestedPerls, row + 1, col);
                if (Arrays.intsInArray(this.iaTestedPerls) >= 3) {
                    Arrays.addIntsToArray(perlBuffer, this.iaTestedPerls);
                }
                Arrays.resetIntsArray(this.iaTestedPerls);
            }
            if (row % 2 == 0) {
                if (col > 0) {
                    this.iaPerls[row][col] = this.getPerlVal(row + 1, col - 1);
                    if (!this.markedPerl(perlBuffer, row + 1, col - 1)) {
                        this.markPerls(this.iaTestedPerls, row + 1, col - 1);
                        if (Arrays.intsInArray(this.iaTestedPerls) >= 3) {
                            Arrays.addIntsToArray(perlBuffer, this.iaTestedPerls);
                        }
                        Arrays.resetIntsArray(this.iaTestedPerls);
                    }
                }
            } else if (col < this.iPerlsInLine - 1) {
                this.iaPerls[row][col] = this.getPerlVal(row + 1, col + 1);
                if (!this.markedPerl(perlBuffer, row + 1, col + 1)) {
                    this.markPerls(this.iaTestedPerls, row + 1, col + 1);
                    if (Arrays.intsInArray(this.iaTestedPerls) >= 3) {
                        Arrays.addIntsToArray(perlBuffer, this.iaTestedPerls);
                    }
                    Arrays.resetIntsArray(this.iaTestedPerls);
                }
            }
        }
        if (col > 0) {
            this.iaPerls[row][col] = this.getPerlVal(row, col - 1);
            if (!this.markedPerl(perlBuffer, row, col - 1)) {
                this.markPerls(this.iaTestedPerls, row, col - 1);
                if (Arrays.intsInArray(this.iaTestedPerls) >= 3) {
                    Arrays.addIntsToArray(perlBuffer, this.iaTestedPerls);
                }
                Arrays.resetIntsArray(this.iaTestedPerls);
            }
        }
        if (col < this.iPerlsInLine - 1) {
            this.iaPerls[row][col] = this.getPerlVal(row, col + 1);
            if (!this.markedPerl(perlBuffer, row, col + 1)) {
                this.markPerls(this.iaTestedPerls, row, col + 1);
                if (Arrays.intsInArray(this.iaTestedPerls) >= 3) {
                    Arrays.addIntsToArray(perlBuffer, this.iaTestedPerls);
                }
                Arrays.resetIntsArray(this.iaTestedPerls);
            }
        }
    }

    void explodePerls(int[] perlBuffer, int row, int col, int lev) {
        if (lev == 0) {
            return;
        }
        if (this.iaPerls[row][col] == -1979) {
            return;
        }
        int iVal = row * this.iPerlsInLine + col;
        Debug.trace("explodePerls [" + row + "][" + col + "] = " + this.iaPerls[row][col]);
        Arrays.addUniqueIntToArray(perlBuffer, iVal);
        int iPerlVal = this.iaPerls[row][col];
        if (iPerlVal >= 700 && iPerlVal < 800) {
            if (this.iBombPerl != -1979 && this.iBombPerl != iVal) {
                WholeGame.level.testAchievement(0);
            }
            lev = 4;
        }
        if (row > 0) {
            if (!this.markedPerl(perlBuffer, row - 1, col)) {
                this.explodePerls(perlBuffer, row - 1, col, lev - 1);
            }
            if (row % 2 == 0) {
                if (col > 0 && !this.markedPerl(perlBuffer, row - 1, col - 1)) {
                    this.explodePerls(perlBuffer, row - 1, col - 1, lev - 1);
                }
            } else if (col < this.iPerlsInLine - 1 && !this.markedPerl(perlBuffer, row - 1, col + 1)) {
                this.explodePerls(perlBuffer, row - 1, col + 1, lev - 1);
            }
        }
        if (row < this.iTotalLines - 1) {
            if (!this.markedPerl(perlBuffer, row + 1, col)) {
                this.explodePerls(perlBuffer, row + 1, col, lev - 1);
            }
            if (row % 2 == 0) {
                if (col > 0 && !this.markedPerl(perlBuffer, row + 1, col - 1)) {
                    this.explodePerls(perlBuffer, row + 1, col - 1, lev - 1);
                }
            } else if (col < this.iPerlsInLine - 1 && !this.markedPerl(perlBuffer, row + 1, col + 1)) {
                this.explodePerls(perlBuffer, row + 1, col + 1, lev - 1);
            }
        }
        if (col > 0 && !this.markedPerl(perlBuffer, row, col - 1)) {
            this.explodePerls(perlBuffer, row, col - 1, lev - 1);
        }
        if (col < this.iPerlsInLine - 1 && !this.markedPerl(perlBuffer, row, col + 1)) {
            this.explodePerls(perlBuffer, row, col + 1, lev - 1);
        }
        this.updateDangerousState();
    }

    void explodeColorMatch(int row, int col) {
        int colour = this.getPerlVal(row, col);
        for (int i = 0; i < this.iTotalLines; ++i) {
            for (int ii = 0; ii < this.iPerlsInLine; ++ii) {
                if (this.getPerlVal(i, ii) != colour) continue;
                Arrays.addIntToArray(this.iaStackedPerls, i * this.iPerlsInLine + ii);
            }
        }
    }

    void unfrozePerls(int[] perlBuffer, int row, int col, int perlType, int lev) {
        if (perlType == 15 && this.frozenRowLast == row && this.frozenColLast == col) {
            return;
        }
        if (lev == 0) {
            return;
        }
        if (this.iaPerls[row][col] >= 1000) {
            int freezeFact = this.iaPerls[row][col] % 1000;
            int iDec = 300;
            if (lev >= 1) {
                iDec += 300;
            }
            if (lev >= 2) {
                iDec += 300;
            }
            if ((freezeFact -= iDec) < 0) {
                freezeFact = 0;
            }
            this.iaPerls[row][col] = this.iaPerls[row][col] / 1000 * 1000 + freezeFact;
        } else if (this.iaPerls[row][col] >= 100 && this.iaPerls[row][col] < 500 && perlType == 15) {
            int dspx = this.getDspX(col);
            this.damageRock(row, col, dspx);
        }
        if (this.iaPerls[row][col] != -1979) {
            Arrays.addUniqueIntToArray(perlBuffer, row * this.iPerlsInLine + col);
        }
        if (row > 1) {
            if (!this.markedPerl(perlBuffer, row - 1, col)) {
                this.unfrozePerls(perlBuffer, row - 1, col, perlType, lev - 1);
            }
            if (row % 2 == 0) {
                if (col > 1 && !this.markedPerl(perlBuffer, row - 1, col - 1)) {
                    this.unfrozePerls(perlBuffer, row - 1, col - 1, perlType, lev - 1);
                }
            } else if (col < this.iPerlsInLine - 2 && !this.markedPerl(perlBuffer, row - 1, col + 1)) {
                this.unfrozePerls(perlBuffer, row - 1, col + 1, perlType, lev - 1);
            }
        }
        if (row < this.iTotalLines - 2) {
            if (!this.markedPerl(perlBuffer, row + 1, col)) {
                this.unfrozePerls(perlBuffer, row + 1, col, perlType, lev - 1);
            }
            if (row % 2 == 0) {
                if (col > 1 && !this.markedPerl(perlBuffer, row + 1, col - 1)) {
                    this.unfrozePerls(perlBuffer, row + 1, col - 1, perlType, lev - 1);
                }
            } else if (col < this.iPerlsInLine - 2 && !this.markedPerl(perlBuffer, row + 1, col + 1)) {
                this.unfrozePerls(perlBuffer, row + 1, col + 1, perlType, lev - 1);
            }
        }
        if (col > 0 && !this.markedPerl(perlBuffer, row, col - 1)) {
            this.unfrozePerls(perlBuffer, row, col - 1, perlType, lev - 1);
        }
        if (col < this.iPerlsInLine - 1 && !this.markedPerl(perlBuffer, row, col + 1)) {
            this.unfrozePerls(perlBuffer, row, col + 1, perlType, lev - 1);
        }
        this.frozenRowLast = row;
        this.frozenColLast = col;
    }

    void markPerlsZuma(int[] perlBuffer, int idx) {
        int perlVal = this.iaZumaPerls[idx];
        if (perlVal == -1979) {
            return;
        }
        Arrays.addUniqueIntToArray(perlBuffer, idx);
        if (idx > 0 && this.iaZumaPerls[idx - 1] == perlVal && !this.markedPerl(perlBuffer, idx - 1)) {
            this.markPerlsZuma(perlBuffer, idx - 1);
        }
        if (idx < this.iaZumaPerls.length - 2 && this.iaZumaPerls[idx + 1] == perlVal && !this.markedPerl(perlBuffer, idx + 1)) {
            this.markPerlsZuma(perlBuffer, idx + 1);
        }
    }

    void freezePerls() {
        int freezeFact = 0;
        for (int i = 0; i < this.iTotalLines; ++i) {
            for (int ii = 0; ii < this.iPerlsInLine; ++ii) {
                if (this.iaPerls[i][ii] == -1979) continue;
                if (this.iaPerls[i][ii] >= 1000) {
                    freezeFact = this.iaPerls[i][ii] % 1000;
                    if (freezeFact >= 900) continue;
                    int iInc = this.iFreezeSpeed;
                    if (freezeFact + this.iFreezeSpeed > 900) {
                        iInc = 900 - freezeFact;
                    }
                    this.iaPerls[i][ii] = this.iaPerls[i][ii] + iInc;
                    continue;
                }
                if (this.iaPerls[i][ii] >= 7) continue;
                this.iaPerls[i][ii] = (this.iaPerls[i][ii] + 1) * 1000;
            }
        }
    }

    int perlsBelow(int row, int col) {
        int cnt = 0;
        for (int i = row; i < this.iTotalLines; ++i) {
            if (this.iaPerls[row][col] == -1979) continue;
            ++cnt;
        }
        return cnt;
    }

    void movePerlsZuma(int idx) {
        if (Arrays.intsInArray(this.iaStackedPerls) > 0) {
            return;
        }
        for (int i = this.iaZumaPerls.length - 2; i >= idx; --i) {
            this.iaZumaPerls[i + 1] = this.iaZumaPerls[i];
            this.iaZumaPerls[i] = -1979;
        }
        ++this.iZumaEnd;
    }

    void movePerlsZumaBack(int idx) {
        if (Arrays.intsInArray(this.iaStackedPerls) > 0) {
            return;
        }
        int len = this.iaZumaPerls.length;
        for (int i = idx; i < len - 1; ++i) {
            this.iaZumaPerls[i] = this.iaZumaPerls[i + 1];
            this.iaZumaPerls[i + 1] = -1979;
        }
    }

    boolean removeZumaHoles() {
        if (Arrays.intsInArray(this.iaStackedPerls) > 0) {
            return false;
        }
        int cnt = 0;
        for (int i = this.iaZumaPerls.length - 1; i >= 0; --i) {
            if (this.iaZumaPerls[i] == -1979) continue;
            ++cnt;
        }
        boolean bMoved = false;
        boolean bStart = false;
        int len = this.iaZumaPerls.length;
        for (int i = 0; i < len - 1; ++i) {
            if (this.iaZumaPerls[i] != -1979) {
                if (!bStart) {
                    bStart = true;
                }
                --cnt;
                continue;
            }
            if (!bStart || cnt <= 0) continue;
            this.movePerlsZumaBack(i);
            this.iZumaLastMovedIdx = i;
            bMoved = true;
            Debug.trace("removeZumaHoles() - out(true) " + this.iZumaLastMovedIdx + " -> " + cnt);
            return true;
        }
        if (!bMoved && this.iZumaLastMovedIdx != -1) {
            this.makeZumaPopping(this.iZumaLastMovedIdx);
            this.iZumaLastMovedIdx = -1;
        }
        return false;
    }

    int activeDropdownPerls() {
        int cnt = 0;
        for (int i = this.iPerlsInLine - 1; i >= 0; --i) {
            if (this.iaPerls[0][i] == -1979) continue;
            ++cnt;
        }
        return cnt;
    }

    void createDropdownPerl() {
        if (this.activeDropdownPerls() == this.iPerlsInLine) {
            return;
        }
        for (int i = this.iPerlsInLine - 1; i >= 0; --i) {
            if (this.iaPerls[0][i] != -1979) continue;
            this.iaPerls[0][i] = Common.getRandomUInt(7);
            this.iaPerls[1][i] = this.iInnerLeft + Common.getRandomUInt(GameDef._WIDTH - 2 * this.iInnerLeft);
            this.iaPerls[2][i] = -(this.iTop + (1 + Common.getRandomUInt(3)) * this.iPerlHeight) << 2;
            this.iaPerls[3][i] = 4 + Common.getRandomUInt(3);
            return;
        }
    }

    void update() {
        if (this.iLevelType == 1 || this.iLevelType == 5 || this.iLevelType == 4 || this.iLevelType == 6) {
            if (this.bFailed) {
                boolean bDrop = true;
                for (int i = this.iPerlsInLine - 1; i >= 0 && bDrop; --i) {
                    if (this.iaColumnsShifts[i] == 0) continue;
                    bDrop = false;
                }
                if (bDrop) {
                    this.dropAllPerls();
                }
            }
            if (this.iMultiplierTime > 0) {
                this.iMultiplierTime -= 30;
                if (this.iMultiplierTime <= 0) {
                    this.iMultiplierTime = 0;
                    this.iMultiplierVal = 0;
                }
            }
            if (this.iStackedPerlsCount > 0) {
                this.bShakePerlsNeeded = true;
            }
            if (this.bShakePerlsNeeded && this.iStackedPerlsCount == 0) {
                this.shakePerls();
            }
            if (this.bBirdStealing) {
                if (this.iBirdTimer < this.iBirdSpeed) {
                    ++this.iBirdTimer;
                } else {
                    if (this.iPerlsLeft < this.iPerlsOnStart / 3) {
                        return;
                    }
                    this.initBirdStealing();
                }
            }
            if (this.iLevelType == 4) {
                if (this.iBirdTimer < this.iBirdSpeed) {
                    ++this.iBirdTimer;
                } else {
                    this.iBirdTimer = 0;
                    if (this.iBirdDirection < 0) {
                        --this.iBirdCol;
                        if (!this.shiftColsLeft()) {
                            this.iBirdDirection = 1;
                        }
                    } else {
                        ++this.iBirdCol;
                        if (!this.shiftColsRight()) {
                            this.iBirdDirection = -1;
                        }
                    }
                }
            }
        }
        if (this.iLevelType == 3) {
            if (this.bFailed) {
                if (this.iZumaMoveTime > 0) {
                    --this.iZumaMoveTime;
                    return;
                }
                this.iZumaMoveTime = 1;
                this.movePerlsZuma(0);
                return;
            }
            if (this.removeZumaHoles()) {
                return;
            }
            if (this.iaZumaPerls[this.iZumaEnd] == -1979) {
                this.movePerlsZumaBack(this.iZumaEnd);
            } else {
                if (this.iZumaMoveTime > 0) {
                    --this.iZumaMoveTime;
                    return;
                }
                this.iZumaMoveTime = 65;
                this.movePerlsZuma(0);
            }
            this.updateDangerousState();
        }
        if (this.iLevelType == 6) {
            if (this.iDropDownTimer > 0) {
                this.iDropDownTimer -= 30;
            } else {
                this.iDropDownTimer = 2000;
                this.createDropdownPerl();
            }
            for (int i = this.iPerlsInLine - 1; i >= 0; --i) {
                if (this.iaPerls[0][i] == -1979) continue;
                int[] nArray = this.iaPerls[2];
                int n = i;
                nArray[n] = nArray[n] + this.iaPerls[3][i];
                int iBottom = GameDef._HEIGHT - Resources.sprStar1Height - this.iPerlHeight;
                if (this.iaPerls[2][i] >> 2 <= iBottom) continue;
                this.iaPerls[0][i] = -1979;
                WholeGame.particles.createBubbles(this.iaPerls[1][i] + this.iPerlWidth2, (this.iaPerls[2][i] >> 2) + this.iPerlWidth2);
                WholeGame.particles.createBubbles(this.iaPerls[1][i] + this.iPerlWidth2, (this.iaPerls[2][i] >> 2) + this.iPerlWidth2);
            }
        }
        if (this.bFrozenLevel) {
            this.freezePerls();
        }
    }

    int getScoreBase(int cnt, boolean bFalling) {
        int iRetVal = 1;
        if (bFalling) {
            iRetVal *= 2;
        }
        if (cnt > 6) {
            iRetVal *= 2;
        }
        if (this.iMultiplierTime > 0) {
            iRetVal *= this.iMultiplierVal;
        }
        return iRetVal;
    }

    int getScoreBase(int cnt) {
        return this.getScoreBase(cnt, false);
    }

    void dropAllPerls() {
        int len = this.iaPerls.length;
        int ypos = this.iTop;
        for (int row = 0; row < len; ++row) {
            int dspx = this.getDspX(row);
            int xpos = this.iInnerLeft;
            xpos -= row % 2 == 0 ? this.iPerlWidth2 : 0;
            for (int col = 0; col < this.iPerlsInLine; ++col) {
                int perlVal = this.iaPerls[row][col];
                if (perlVal == -1979) continue;
                int tmpx = Common.getRandomInt(4) * 4;
                int pidx = WholeGame.particles.createParticle(xpos, ypos, tmpx, -((Common.getRandomUInt(4) + 2) * 5), 0, Common.getRandomUInt(4) + 2, 0, 0);
                if (pidx != -1) {
                    WholeGame.particles.partSprite[pidx] = Resources.sprPerls;
                    WholeGame.particles.partFrame[pidx] = this.getPerlVal(row, col);
                    WholeGame.particles.partLife[pidx] = 30 + Common.getRandomUInt(4) * 10;
                }
                this.iaPerls[row][col] = -1979;
                --WholeGame.level.iArcadePerlsLeft;
                WholeGame.level.bRefreshStatusPerls = true;
                xpos += this.iPerlWidth;
            }
            ypos += this.iPerlHeight;
        }
        this.bDangerousState = false;
    }

    void paintClassicLevel(Graphics g) {
        int val;
        Sprite spr = Resources.sprPerls;
        int ypos = this.iTop;
        int iStatusTop = Resources.iStatusHeight + 1;
        g.setClip(0, iStatusTop += 2, GameDef._WIDTH, GameDef._HEIGHT - iStatusTop);
        for (int row = 0; row < this.iTotalLines; ++row) {
            int dspx = this.getDspX(row);
            int xpos = this.iInnerLeft;
            xpos -= row % 2 == 0 ? this.iPerlWidth2 : 0;
            for (int col = 0; col < this.iPerlsInLine; ++col) {
                boolean bStop;
                int perlVal = this.iaPerls[row][col];
                int dspy = this.getDspY(col);
                if (this.iaColumnsShifts[col] > 0) {
                    int n = col;
                    this.iaColumnsShifts[n] = this.iaColumnsShifts[n] - 1;
                }
                if (perlVal == -1979) {
                    xpos += this.iPerlWidth;
                    continue;
                }
                boolean bFrozen = perlVal >= 1000;
                int freezeFact = 0;
                if (bFrozen) {
                    freezeFact = perlVal % 1000;
                    perlVal = perlVal / 1000 - 1;
                }
                boolean bRock = perlVal >= 100 && perlVal < 500;
                boolean bSwitch = perlVal >= 500 && perlVal < 600;
                boolean bPointer = perlVal >= 600 && perlVal < 700;
                boolean bBomb = perlVal >= 700 && perlVal < 800;
                boolean bl = bStop = perlVal >= 800 && perlVal < 900;
                if (bRock) {
                    int frm = perlVal / 100 - 1;
                    spr = (perlVal %= 100) == 8 ? Resources.sprRock : Resources.sprShell;
                    perlVal = frm;
                }
                if (bSwitch) {
                    perlVal -= 500;
                }
                if (bPointer) {
                    perlVal -= 600;
                }
                if (bBomb) {
                    perlVal -= 700;
                }
                if (bStop) {
                    perlVal -= 800;
                }
                spr.setPosition(xpos + dspx, ypos + dspy);
                spr.setFrame(perlVal);
                spr.paint(g);
                if (bFrozen && freezeFact > 300) {
                    Sprite sprF = Resources.sprFrozen;
                    sprF.setPosition(xpos + dspx, ypos + dspy);
                    sprF.setFrame(GameDef.barValue(freezeFact - 300, 600, 4));
                    sprF.paint(g);
                }
                if (bRock) {
                    spr = Resources.sprPerls;
                }
                if (bSwitch) {
                    Sprite sprS = Resources.sprSwitch;
                    sprS.setPosition(xpos + dspx, ypos + dspy);
                    sprS.setFrame(Math.abs((int)(WholeGame.lRunCounter % 12L) / 4));
                    sprS.paint(g);
                }
                if (bBomb) {
                    spr.setPosition(xpos + dspx, ypos + dspy);
                    spr.setFrame(14);
                    spr.paint(g);
                }
                if (bPointer) {
                    Sprite sprP = Resources.sprPtr;
                    sprP.setPosition(xpos + dspx, ypos + dspy);
                    sprP.setFrame(Math.abs((int)(WholeGame.lRunCounter % 12L) / 4));
                    sprP.paint(g);
                }
                if (bStop) {
                    spr.setPosition(xpos + dspx, ypos + dspy);
                    spr.setFrame(12);
                    spr.paint(g);
                }
                xpos += this.iPerlWidth;
            }
            ypos += this.iPerlHeight;
        }
        int iLoops = 3;
        for (int i = 0; i < iLoops; ++i) {
            if (this.iStackedPerlsCount <= 0) continue;
            spr = Resources.sprExplosion;
            int v = Arrays.intInArray(this.iaStackedPerls, 0);
            val = v % 500;
            int frm = v / 500;
            int row = val / this.iPerlsInLine;
            int col = val % this.iPerlsInLine;
            int xpos = col * this.iPerlWidth + this.iPerlWidth2;
            ypos = row * this.iPerlHeight + this.iTop;
            if (frm == 0) {
                if (this.iaPerls[row][col] != -1979) {
                    this.iaPerls[row][col] = -1979;
                    WholeGame.level.incPoppedBubbles(1);
                    WholeGame.vibrate(30);
                    --WholeGame.level.iArcadePerlsLeft;
                    WholeGame.level.bRefreshStatusPerls = true;
                    WholeGame.sounds.playSound_Pop();
                }
                WholeGame.particles.createPerlExplosion(xpos, ypos);
                Arrays.removeIntFromArray(this.iaStackedPerls, v);
                Debug.trace("POP " + this.iStackedPerlsCount);
                --this.iStackedPerlsCount;
                if (this.iStackedPerlsCount != 0) continue;
                int scoreBase = this.getScoreBase(this.iPerlsToPop);
                WholeGame.level.player.incScore(this.iPerlsToPop * (scoreBase *= WholeGame.level.player.playerBounces > 0 ? WholeGame.level.player.playerBounces + 1 : 1));
                WholeGame.level.incTimeToAction(this.iPerlsToPop * 200);
                this.iLastPerlXPos = xpos;
                this.iLastPerlYPos = ypos;
                this.updatePerlsInGameArray();
                X.canvas.createScoreLabel(xpos, ypos, this.iPerlsToPop, scoreBase);
                this.updateDangerousState();
                this.updatePreparedPerl();
                continue;
            }
            spr.setPosition(xpos - Resources.sprExplosionWidth / 2, ypos - Resources.sprExplosionHeight / 2);
            spr.setFrame(frm - 1);
            spr.paint(g);
            Arrays.changeIntInArray(this.iaStackedPerls, 0, --frm * 500 + val);
        }
        int len = Arrays.intsInArray(this.iaFallingPerls);
        spr = Resources.sprPerls;
        spr.setFrame(16);
        if (len > 0) {
            spr.setFrame(16);
            for (int i = 0; i < len; ++i) {
                val = Arrays.intInArray(this.iaFallingPerls, i);
                int row = val / this.iPerlsInLine;
                int col = val % this.iPerlsInLine;
                ypos = this.iTop + row * this.iPerlHeight;
                int xpos = this.iInnerLeft - (row % 2 == 0 ? this.iPerlWidth2 : 0) + col * this.iPerlWidth;
                int dspx = this.getDspX(row);
                int dspy = 0;
                spr.setPosition(xpos + dspx, ypos + dspy + this.iFallOffs);
                spr.paint(g);
                if (this.iFallOffs != 15) continue;
                WholeGame.particles.createPerlExplosion(xpos + dspx, ypos + dspy);
                if (i != len - 1 || this.bNoScoreForShakenPerls) continue;
                int scoreBase = this.getScoreBase(len, true);
                WholeGame.level.player.incScore(len * scoreBase);
                X.canvas.createScoreLabel(xpos, ypos, len, scoreBase);
            }
            if (this.iFallOffs < 15) {
                ++this.iFallOffs;
            } else {
                this.bNoScoreForShakenPerls = false;
                Arrays.resetIntsArray(this.iaFallingPerls);
                this.updatePerlsInGameArray();
            }
        }
        if (this.bDangerousState && !this.bFailed) {
            int iLineY = this.iTopInit + this.iPerlHeight * this.iTotalLines;
            if (WholeGame.lRunCounter % 2L == 0L) {
                for (int i = 0; i < GameDef._WIDTH; i += Resources.sprPerlsWidth) {
                    WholeGame.particles.createBubble(i, iLineY);
                }
            }
            if (WholeGame.lRunCounter % 4L == 0L) {
                g.setColor(0xFFFFFF);
                g.fillRect(0, iLineY, GameDef._WIDTH, 1);
            }
        }
    }

    void paintZumaLevel(Graphics g) {
        Sprite spr = Resources.sprPerls;
        int len = this.iaZumaPerls.length;
        int ypos = this.iTop;
        int xpos = this.iInnerLeft;
        int mark = 1;
        int gap = this.iPerlWidth + 2;
        if (GameDef._HEIGHT <= 130) {
            gap = this.iPerlWidth - 1;
        } else if (GameDef._HEIGHT <= 160) {
            gap = this.iPerlWidth;
        }
        int gap2 = gap / 2;
        int iStatusTop = Resources.iStatusHeight + 1;
        g.setClip(0, iStatusTop += 2, GameDef._WIDTH, GameDef._HEIGHT);
        int ztime2 = 32;
        for (int i = 0; i < len; ++i) {
            int dspy = 0;
            if (i % this.iPerlsInLine == this.iPerlsInLine - 1 && mark == 1) {
                dspy = gap2 - GameDef.barValue(this.iZumaMoveTime, 65, gap2);
            }
            if (i % this.iPerlsInLine == 0 && mark == 1) {
                dspy = -GameDef.barValue(this.iZumaMoveTime, 65, gap2);
            }
            if (i % this.iPerlsInLine == this.iPerlsInLine - 1 && mark == -1) {
                dspy = gap2 - GameDef.barValue(this.iZumaMoveTime, 65, gap2);
            }
            if (i % this.iPerlsInLine == 0 && mark == -1) {
                dspy = -GameDef.barValue(this.iZumaMoveTime, 65, gap2);
            }
            if (i > 0 && i % this.iPerlsInLine == 0) {
                ypos += gap;
                xpos += this.iPerlWidth * (mark *= -1);
            }
            if (this.iaZumaPerls[i] == -1979) {
                xpos += this.iPerlWidth * mark;
                continue;
            }
            int dspx = this.getDspX(mark);
            spr.setPosition(xpos + dspx, ypos + dspy);
            spr.setFrame(this.iaZumaPerls[i]);
            spr.paint(g);
            if (this.iStackedPerlsCount > 0) {
                int v = Arrays.intInArray(this.iaStackedPerls, 0);
                int val = v % 500;
                int frm = v / 500;
                if (val == i) {
                    WholeGame.sounds.playSound_Pop();
                    WholeGame.particles.createPerlExplosion(xpos + dspx, ypos + dspy);
                    Arrays.removeIntFromArray(this.iaStackedPerls, v);
                    --this.iStackedPerlsCount;
                    --this.iZumaPerlsCount;
                    this.iaZumaPerls[i] = -1979;
                    WholeGame.level.incPoppedBubbles(1);
                    WholeGame.vibrate(30);
                    if (this.iStackedPerlsCount == 0) {
                        int scoreBase = this.getScoreBase(this.iPerlsToPop);
                        int iChainMultiplier = this.iMultiplierVal >= 2 ? this.iMultiplierVal : 1;
                        WholeGame.level.player.incScore((scoreBase *= WholeGame.level.player.playerBounces > 0 ? WholeGame.level.player.playerBounces + 1 : 1) * iChainMultiplier * this.iPerlsToPop);
                        X.canvas.createScoreLabel(xpos + dspx, ypos + dspy, this.iPerlsToPop, scoreBase * iChainMultiplier);
                        this.updatePerlsInGameArray();
                    }
                }
                if (this.iStackedPerlsCount == 0) {
                    if (this.iMultiplierVal == 2) {
                        X.canvas.createCongratLabel(xpos + dspx, ypos + dspy, Resources.sprLabelNice);
                        WholeGame.sounds.playSound(2, 4, 10);
                    }
                    if (this.iMultiplierVal == 3) {
                        X.canvas.createCongratLabel(xpos + dspx, ypos + dspy, Resources.sprLabelPerfect);
                    }
                    if (this.iMultiplierVal == 4) {
                        X.canvas.createCongratLabel(xpos + dspx, ypos + dspy, Resources.sprLabelBrilliant);
                    }
                }
            }
            if (i == this.iZumaEnd) {
                Resources.sprCrab.setPosition(xpos + dspx + this.iPerlWidth2 - (mark == 1 ? Resources.sprCrab.getWidth() : 0), ypos + dspy);
                Resources.sprCrab.setFrame(this.iZumaMoveTime % 6 / 3);
                Resources.sprCrab.setTransform(mark == 1 ? 2 : 0);
                Resources.sprCrab.paint(g);
                if (this.iZumaMoveTime % 6 == 0) {
                    WholeGame.particles.createBubbles(xpos + dspx + Resources.sprCrab.getWidth() * (mark == 1 ? -1 : 1), ypos + dspy);
                }
            }
            xpos += this.iPerlWidth * mark;
        }
        if (this.bDangerousState && !this.bFailed) {
            g.setClip(0, 0, GameDef._WIDTH, GameDef._HEIGHT);
            int H = this.iPerlWidth + 2;
            if (GameDef._HEIGHT <= 130) {
                H = this.iPerlWidth - 1;
            } else if (GameDef._HEIGHT <= 160) {
                H = this.iPerlWidth;
            }
            int iLineY = this.iTopInit + H * (this.iTotalLines - 1);
            if (WholeGame.lRunCounter % 2L == 0L) {
                for (int i = 0; i < GameDef._WIDTH; i += Resources.sprPerlsWidth) {
                    WholeGame.particles.createBubble(i, iLineY);
                }
            }
            if (WholeGame.lRunCounter % 4L == 0L) {
                g.setColor(0xFFFFFF);
                g.fillRect(0, iLineY, GameDef._WIDTH, 1);
            }
        }
    }

    void paintAnchor(Graphics g, int ypos) {
        int iStatusTop = Resources.iStatusHeight + 1;
        g.setClip(0, iStatusTop += 2, GameDef._WIDTH, GameDef._HEIGHT);
        int cnt = GameDef._WIDTH / Resources.sprAnchorWidth;
        int iInnerLeft = (GameDef._WIDTH - cnt * Resources.sprAnchorWidth) / 2;
        Sprite spr = Resources.sprAnchor;
        spr.setFrame(0);
        spr.setPosition(iInnerLeft, ypos -= Resources.sprAnchorHeight);
        spr.paint(g);
        spr.setFrame(1);
        int xpos = iInnerLeft + Resources.sprAnchorWidth;
        for (int i = 1; i < cnt - 1; ++i) {
            spr.setPosition(xpos, ypos);
            spr.paint(g);
            xpos += Resources.sprAnchorWidth;
        }
        spr.setFrame(3);
        spr.setPosition(xpos, ypos);
        spr.paint(g);
        xpos = (GameDef._WIDTH - Resources.sprAnchorWidth) / 2;
        spr.setFrame(2);
        spr.setPosition(xpos, ypos);
        spr.paint(g);
        spr.setFrame(4);
        for (int _ypos = ypos - Resources.sprAnchorHeight; _ypos > -Resources.sprAnchorHeight; _ypos -= Resources.sprAnchorHeight) {
            spr.setPosition(xpos, _ypos);
            spr.paint(g);
        }
        g.setClip(0, 0, GameDef._WIDTH, GameDef._HEIGHT);
    }

    void paint(Graphics g) {
        if (this.iLevelType == 3) {
            this.paintZumaLevel(g);
        }
        if (this.iLevelType == 1) {
            int dt;
            this.paintClassicLevel(g);
            if (this.bBirdStealing && (dt = this.iBirdSpeed - this.iBirdTimer) < 46) {
                this.setPerlToSteal();
                if (this.iBirdCol > 0 && this.iBirdRow > 0) {
                    int h = Resources.imgBird.getHeight();
                    int w2 = Resources.imgBird.getWidth() / 2;
                    int ypos = -(GameDef.barValue(Math.abs(dt - 23), 23, h) + (Resources.imgBird.getHeight() - (this.iTop + this.iBirdRow * this.iPerlHeight + this.iPerlHeight2)));
                    g.drawImage(Resources.imgBird, this.iInnerLeft + this.iBirdCol * this.iPerlWidth - w2, ypos, 20);
                    if (dt == 23) {
                        int tmp = Common.getRandomUInt(100) % 3;
                        this.iaPerls[this.iBirdRow][this.iBirdCol] = 308;
                        WholeGame.particles.createBubbles(this.iInnerLeft + this.iBirdCol * this.iPerlWidth + this.iPerlWidth2, this.iTop + this.iBirdRow * this.iPerlHeight + this.iPerlHeight2);
                        WholeGame.particles.createBubbles(this.iInnerLeft + this.iBirdCol * this.iPerlWidth + this.iPerlWidth2, this.iTop + this.iBirdRow * this.iPerlHeight + this.iPerlHeight2);
                    }
                }
            }
        }
        if (this.iLevelType == 4) {
            int iw = Resources.imgPlant.getWidth();
            int ih2 = Resources.imgPlant.getHeight() / 2;
            int iStatusTop = Resources.iStatusHeight + 1;
            g.setClip(0, iStatusTop += 2, GameDef._WIDTH, GameDef._HEIGHT - iStatusTop);
            for (int x = GameDef._WIDTH + iw + (this.iBirdCol * this.iPerlWidth + this.getDspX(0)) % iw; x >= -iw; x -= iw) {
                g.drawImage(Resources.imgPlant, x, this.iTop - ih2, 20);
            }
            this.paintClassicLevel(g);
            g.drawImage(Resources.imgBird, this.iInnerLeft + this.iBirdCol * this.iPerlWidth + this.getDspX(0) - this.iBirdWidth2, -this.iBirdHeight + this.iBirdHeight4, 20);
        }
        if (this.iLevelType == 5) {
            this.paintClassicLevel(g);
            this.paintAnchor(g, this.iTop);
        }
        if (this.iLevelType == 6) {
            int iStatusTop = Resources.iStatusHeight + 1;
            g.setClip(0, iStatusTop += 2, GameDef._WIDTH, GameDef._HEIGHT - iStatusTop);
            Sprite spr = Resources.sprPerls;
            for (int i = this.iPerlsInLine - 1; i >= 0; --i) {
                if (this.iaPerls[0][i] == -1979) continue;
                spr.setPosition(this.iaPerls[1][i], this.iaPerls[2][i] >> 2);
                spr.setFrame(this.iaPerls[0][i]);
                spr.paint(g);
            }
        }
    }
}

