/*
 * Decompiled with CFR 0.152.
 */
class pathfinding {
    static int mapWidthMax = 21;
    static int mapHeightMax = 21;
    int mapWidth;
    int mapHeight;
    int imax = mapWidthMax * mapHeightMax / 8;
    int[] paths = new int[this.imax];
    int paths_count = 1;
    int shortest_path = 0;
    int[] paths_coord = new int[this.imax];
    byte[] parent = new byte[mapWidthMax * mapHeightMax];
    int[] krokyX = new int[200];
    int[] krokyY = new int[200];
    int krokyCount = 0;
    byte direction_up = 1;
    byte direction_down = (byte)64;
    byte direction_left = (byte)4;
    byte direction_right = (byte)16;
    int[] paths_guessed_way = new int[this.imax];
    boolean path_found = false;
    int[] path = new int[this.imax];
    int path_count;
    int path_total_length = 0;
    int manhattan = 1;
    int real = 2;
    int real_diagonalvalue = 20;
    int heuristic = this.manhattan;
    StringBuffer sbPath;
    String sPath = "";
    int iNbOfElements;
    int poziciaX;

    public boolean walkability(int[][] map, int x, int y) {
        boolean walkFree = false;
        if (map[x][y] == 0) {
            walkFree = true;
        }
        if (map[x][y] == 1) {
            walkFree = false;
        }
        return walkFree;
    }

    public pathfinding(int width, int height) {
        this.mapWidth = width;
        this.mapHeight = height;
    }

    public void setParameters(int width, int height) {
        this.mapWidth = width;
        this.mapHeight = height;
    }

    public boolean findPath(int startx, int starty, int targetx, int targety) {
        if (startx < 0 || starty < 0 || startx > this.mapWidth - 1 || starty > this.mapHeight - 1 || targetx < 0 || targety < 0 || targetx > this.mapWidth - 1 || targety > this.mapHeight - 1) {
            return false;
        }
        this.path_found = false;
        for (int i1 = 0; i1 <= this.mapWidth * this.mapHeight - 1; ++i1) {
            this.parent[i1] = -1;
        }
        this.paths_count = 1;
        this.shortest_path = 0;
        this.paths[this.shortest_path] = 0;
        this.paths_coord[this.shortest_path] = this.getIndex(startx, starty);
        this.parent[this.paths_coord[this.shortest_path]] = 0;
        int xoffset = Math.abs(this.getX(this.paths_coord[0]) - targetx);
        int yoffset = Math.abs(this.getY(this.paths_coord[0]) - targety);
        if (this.heuristic == this.manhattan) {
            this.paths_guessed_way[0] = (xoffset + yoffset) * 10;
        }
        if (this.heuristic == this.real) {
            this.paths_guessed_way[0] = xoffset > yoffset ? (xoffset - yoffset) * 10 + yoffset * this.real_diagonalvalue : (yoffset - xoffset) * 10 + xoffset * this.real_diagonalvalue;
        }
        this.paths_guessed_way[0] = this.paths_guessed_way[0] + this.paths[0];
        while (!this.path_found) {
            this.shortest_path = 0;
            for (int i1 = 0; i1 <= this.paths_count - 1; ++i1) {
                if (this.paths_guessed_way[i1] >= this.paths_guessed_way[this.shortest_path]) continue;
                this.shortest_path = i1;
            }
            int i1min = this.getX(this.paths_coord[this.shortest_path]) <= 0 ? 0 : -1;
            int i1max = this.getX(this.paths_coord[this.shortest_path]) >= this.mapWidth - 1 ? 0 : 1;
            int i2min = this.getY(this.paths_coord[this.shortest_path]) <= 0 ? 0 : -1;
            int i2max = this.getY(this.paths_coord[this.shortest_path]) >= this.mapHeight - 1 ? 0 : 1;
            for (int i1 = i1min; i1 <= i1max; ++i1) {
                for (int i2 = i2min; i2 <= i2max; ++i2) {
                    if (Math.abs(i1) == Math.abs(i2)) continue;
                    int thisx = this.getX(this.paths_coord[this.shortest_path]) + i1;
                    int thisy = this.getY(this.paths_coord[this.shortest_path]) + i2;
                    if (i1 == 0 && i2 == 0 || this.getIndex(thisx, thisy) == this.getIndex(startx, starty) || !this.walkability(Game.path, thisx, thisy)) continue;
                    int t_needed = 0;
                    if (i1 != 0) {
                        t_needed += 10;
                    }
                    if (i2 != 0) {
                        t_needed += 10;
                    }
                    if (t_needed == 20) {
                        t_needed = 14;
                    }
                    if (this.parent[this.getIndex(thisx, thisy)] > 0) {
                        int i3;
                        boolean not_on_closed_list = false;
                        for (i3 = 0; i3 <= this.paths_count - 1; ++i3) {
                            if (this.paths_coord[i3] != this.getIndex(thisx, thisy)) continue;
                            not_on_closed_list = true;
                            break;
                        }
                        if (!not_on_closed_list || this.paths[this.shortest_path] + t_needed >= this.paths[i3]) continue;
                        this.paths[i3] = this.paths[this.shortest_path] + t_needed;
                        xoffset = Math.abs(thisx - targetx);
                        yoffset = Math.abs(thisy - targety);
                        if (this.heuristic == this.manhattan) {
                            this.paths_guessed_way[i3] = (xoffset + yoffset) * 10;
                        }
                        if (this.heuristic == this.real) {
                            this.paths_guessed_way[i3] = xoffset > yoffset ? (xoffset - yoffset) * 10 + yoffset * this.real_diagonalvalue : (yoffset - xoffset) * 10 + xoffset * this.real_diagonalvalue;
                        }
                        int n = i3;
                        this.paths_guessed_way[n] = this.paths_guessed_way[n] + this.paths[i3];
                        this.parent[this.paths_coord[i3]] = 0;
                        if (i1 == 1) {
                            int n2 = this.paths_coord[i3];
                            this.parent[n2] = (byte)(this.parent[n2] + this.direction_left);
                        }
                        if (i1 == -1) {
                            int n3 = this.paths_coord[i3];
                            this.parent[n3] = (byte)(this.parent[n3] + this.direction_right);
                        }
                        if (i2 == 1) {
                            int n4 = this.paths_coord[i3];
                            this.parent[n4] = (byte)(this.parent[n4] + this.direction_up);
                        }
                        if (i2 != -1) continue;
                        int n5 = this.paths_coord[i3];
                        this.parent[n5] = (byte)(this.parent[n5] + this.direction_down);
                        continue;
                    }
                    this.paths_coord[this.paths_count] = this.getIndex(thisx, thisy);
                    this.paths[this.paths_count] = this.paths[this.shortest_path] + t_needed;
                    xoffset = Math.abs(thisx - targetx);
                    yoffset = Math.abs(thisy - targety);
                    if (this.heuristic == this.manhattan) {
                        this.paths_guessed_way[this.paths_count] = (xoffset + yoffset) * 10;
                    }
                    if (this.heuristic == this.real) {
                        this.paths_guessed_way[this.paths_count] = xoffset > yoffset ? (xoffset - yoffset) * 10 + yoffset * this.real_diagonalvalue : (yoffset - xoffset) * 10 + xoffset * this.real_diagonalvalue;
                    }
                    int n = this.paths_count;
                    this.paths_guessed_way[n] = this.paths_guessed_way[n] + this.paths[this.paths_count];
                    this.parent[this.paths_coord[this.paths_count]] = 0;
                    if (i1 == 1) {
                        int n6 = this.paths_coord[this.paths_count];
                        this.parent[n6] = (byte)(this.parent[n6] + this.direction_left);
                    }
                    if (i1 == -1) {
                        int n7 = this.paths_coord[this.paths_count];
                        this.parent[n7] = (byte)(this.parent[n7] + this.direction_right);
                    }
                    if (i2 == 1) {
                        int n8 = this.paths_coord[this.paths_count];
                        this.parent[n8] = (byte)(this.parent[n8] + this.direction_up);
                    }
                    if (i2 == -1) {
                        int n9 = this.paths_coord[this.paths_count];
                        this.parent[n9] = (byte)(this.parent[n9] + this.direction_down);
                    }
                    ++this.paths_count;
                }
            }
            if (this.path_found) continue;
            if (this.paths_coord[this.shortest_path] == this.getIndex(targetx, targety)) {
                this.path_found = true;
                this.path_total_length = this.paths[this.shortest_path];
            }
            if (this.paths_count == 1) break;
            for (int i3 = this.shortest_path + 1; i3 <= this.paths_count - 1; ++i3) {
                this.paths[i3 - 1] = this.paths[i3];
                this.paths_coord[i3 - 1] = this.paths_coord[i3];
                this.paths_guessed_way[i3 - 1] = this.paths_guessed_way[i3];
            }
            --this.paths_count;
        }
        if (!this.path_found) {
            return false;
        }
        int fx = targetx;
        int fy = targety;
        int n = 0;
        while (fx != startx || fy != starty) {
            if (this.parent[this.getIndex(fx, fy)] == this.direction_left) {
                this.addPoint(n, fx, fy);
                --fx;
            } else if (this.parent[this.getIndex(fx, fy)] == this.direction_left + this.direction_up) {
                this.addPoint(n, fx, fy);
                --fx;
                --fy;
            } else if (this.parent[this.getIndex(fx, fy)] == this.direction_up) {
                this.addPoint(n, fx, fy);
                --fy;
            } else if (this.parent[this.getIndex(fx, fy)] == this.direction_right + this.direction_up) {
                this.addPoint(n, fx, fy);
                ++fx;
                --fy;
            } else if (this.parent[this.getIndex(fx, fy)] == this.direction_right) {
                this.addPoint(n, fx, fy);
                ++fx;
            } else if (this.parent[this.getIndex(fx, fy)] == this.direction_right + this.direction_down) {
                this.addPoint(n, fx, fy);
                ++fx;
                ++fy;
            } else if (this.parent[this.getIndex(fx, fy)] == this.direction_down) {
                this.addPoint(n, fx, fy);
                ++fy;
            } else if (this.parent[this.getIndex(fx, fy)] == this.direction_left + this.direction_down) {
                this.addPoint(n, fx, fy);
                --fx;
                ++fy;
            }
            ++n;
        }
        for (int i1 = 0; i1 <= n - 1; ++i1) {
            this.path[i1] = this.path[this.imax - n + i1];
        }
        this.path_count = n;
        return true;
    }

    int getIndex(int x, int y) {
        return y * this.mapWidth + x;
    }

    int getX(int index) {
        return index % this.mapWidth;
    }

    int getY(int index) {
        return (index - this.getX(index)) / this.mapWidth;
    }

    void addPoint(int n, int x, int y) {
        ++this.krokyCount;
        this.path[this.imax - n - 1] = this.getIndex(x, y);
        this.krokyX[this.krokyCount] = x;
        this.krokyY[this.krokyCount] = y;
        this.sPath = this.sPath + Integer.toString(x) + "," + Integer.toString(y) + ",";
        ++this.iNbOfElements;
    }
}

