/*
 * Decompiled with CFR 0.152.
 */
package ng.games.pacman.media;

import ng.games.pacman.media.UniversalSound;

public class GameEffects {
    private UniversalSound titleSound;
    private UniversalSound eatDotsSound;
    private UniversalSound bonusSound;
    private UniversalSound levelCompleteSound;
    private UniversalSound playerEatenSound;
    private UniversalSound lastSound = null;
    private boolean isSoundOn = true;
    private static GameEffects instance;
    private boolean titleSoundPlaying = false;

    private GameEffects() {
        try {
            this.titleSound = UniversalSound.load("/title", 1);
            this.eatDotsSound = UniversalSound.load("/eat_dots", 0);
            this.playerEatenSound = UniversalSound.load("/player_is_eaten", 0);
            this.levelCompleteSound = UniversalSound.load("/level_complete", 0);
            this.bonusSound = UniversalSound.load("/bonus", 0);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public boolean isSoundOn() {
        return this.isSoundOn;
    }

    public void setSoundOn(boolean bl) {
        this.isSoundOn = bl;
    }

    public static GameEffects getInstance() {
        if (instance == null) {
            instance = new GameEffects();
        }
        return instance;
    }

    public void playTitleMusic() {
        if (!this.titleSoundPlaying) {
            this.playSound(this.titleSound, true, 3);
            this.titleSoundPlaying = true;
        }
    }

    public void playBonus() {
    }

    public void playEatFood() {
    }

    public void playLevelComplete() {
    }

    public void playPlayerEaten() {
    }

    public void playSound(UniversalSound universalSound, boolean bl, int n) {
        if (universalSound == null) {
            return;
        }
        if (this.isSoundOn) {
            try {
                if (this.lastSound != null && this.lastSound.isPlaying()) {
                    this.lastSound.stop();
                }
                universalSound.play(bl);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void stopTitleMusic() {
        if (this.titleSoundPlaying) {
            try {
                this.titleSound.stop();
                this.titleSoundPlaying = false;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void vibrate() {
    }

    public void destroy() {
        if (this.titleSoundPlaying) {
            try {
                this.titleSound.stop();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.titleSound.deallocate();
            if (this.eatDotsSound != null) {
                this.eatDotsSound.deallocate();
            }
            if (this.playerEatenSound != null) {
                this.playerEatenSound.deallocate();
            }
            if (this.levelCompleteSound != null) {
                this.levelCompleteSound.deallocate();
            }
            if (this.bonusSound != null) {
                this.bonusSound.deallocate();
            }
        }
    }

    private static byte[] parseOTASoundString(String string) {
        string = string.toUpperCase();
        byte[] byArray = new byte[string.length() / 2];
        for (int i = 0; i < string.length(); i += 2) {
            char c = string.charAt(i + 1);
            int n = c >= '0' && c <= '9' ? c - 48 : c - 65 + 10;
            c = string.charAt(i);
            n = c >= '0' && c <= '9' ? (n += (c - 48) * 16) : (n += (c - 65 + 10) * 16);
            byArray[i / 2] = (byte)n;
        }
        return byArray;
    }
}

