/*
 * Decompiled with CFR 0.152.
 */
package com.slg.j2me.lib.gui.layout;

import com.slg.j2me.lib.gfx.ClipRect;
import com.slg.j2me.lib.gui.control.GuiContainer;
import com.slg.j2me.lib.gui.layout.ScreenLayout;
import javax.microedition.lcdui.Graphics;

public class CellLayout
extends ScreenLayout {
    public GuiContainer[][] cellContainers;
    public int[][] cellProportions;
    public int[][] cellLayout;
    public int[] rowProportions;
    public int cellRows;
    ClipRect oldRect;
    ClipRect newRect = new ClipRect(0, 0, 0, 0);

    public CellLayout(int rows, String debugName) {
        super(debugName);
        this.init(rows);
    }

    public CellLayout(int rows) {
        this.init(rows);
    }

    private void init(int rows) {
        this.cellRows = rows;
        this.cellContainers = new GuiContainer[rows][];
        this.cellProportions = new int[rows][];
        this.cellLayout = new int[rows][];
        this.rowProportions = new int[rows];
    }

    public void setRow(int row, int cells, int proportion) {
        if (row < 0 || row >= this.cellRows) {
            System.out.println("Assertion Failure: row>=0 && row<cellRows\nD:\\FLWBF2_CODE\\FLWBF2_F500\\FLWBF2_SonyEricsson_F500i_v0-5-5_SRC/src/master_code/com/slg/j2me/lib\\gui\\layout/CellLayout.java[78]");
            try {
                throw new Exception();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.rowProportions[row] = proportion;
        this.cellProportions[row] = new int[cells];
        for (int i = 0; i < cells; ++i) {
            this.cellProportions[row][i] = 1;
        }
        this.cellLayout[row] = new int[cells];
        this.cellContainers[row] = new GuiContainer[cells];
    }

    public void setRowFlags(int row, int proportion, int layout) {
        if (row < 0 || row >= this.cellRows) {
            System.out.println("Assertion Failure: row>=0 && row<cellRows\nD:\\FLWBF2_CODE\\FLWBF2_F500\\FLWBF2_SonyEricsson_F500i_v0-5-5_SRC/src/master_code/com/slg/j2me/lib\\gui\\layout/CellLayout.java[93]");
            try {
                throw new Exception();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.rowProportions[row] = proportion;
    }

    public void setCell(int row, int cell, GuiContainer container, int proportion, int layout) {
        if (row < 0 || row >= this.cellRows) {
            System.out.println("Assertion Failure: row>=0 && row<cellRows\nD:\\FLWBF2_CODE\\FLWBF2_F500\\FLWBF2_SonyEricsson_F500i_v0-5-5_SRC/src/master_code/com/slg/j2me/lib\\gui\\layout/CellLayout.java[101]");
            try {
                throw new Exception();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (cell < 0 || cell >= this.cellProportions[row].length) {
            System.out.println("Assertion Failure: cell>=0 && cell<cellProportions[row].length\nD:\\FLWBF2_CODE\\FLWBF2_F500\\FLWBF2_SonyEricsson_F500i_v0-5-5_SRC/src/master_code/com/slg/j2me/lib\\gui\\layout/CellLayout.java[102]");
            try {
                throw new Exception();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.cellProportions[row][cell] = proportion;
        this.cellLayout[row][cell] = layout;
        this.cellContainers[row][cell] = container;
    }

    public void setCellFlags(int row, int cell, int proportion, int layout) {
        if (row < 0 || row >= this.cellRows) {
            System.out.println("Assertion Failure: row>=0 && row<cellRows\nD:\\FLWBF2_CODE\\FLWBF2_F500\\FLWBF2_SonyEricsson_F500i_v0-5-5_SRC/src/master_code/com/slg/j2me/lib\\gui\\layout/CellLayout.java[113]");
            try {
                throw new Exception();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (cell < 0 || cell >= this.cellProportions[row].length) {
            System.out.println("Assertion Failure: cell>=0 && cell<cellProportions[row].length\nD:\\FLWBF2_CODE\\FLWBF2_F500\\FLWBF2_SonyEricsson_F500i_v0-5-5_SRC/src/master_code/com/slg/j2me/lib\\gui\\layout/CellLayout.java[114]");
            try {
                throw new Exception();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.cellProportions[row][cell] = proportion;
        this.cellLayout[row][cell] = layout;
    }

    public void open() {
        this.layout();
    }

    public void close() {
        for (int row = 0; row < this.cellRows; ++row) {
            if (this.cellContainers[row] == null) continue;
            for (int i = 0; i < this.cellContainers[row].length; ++i) {
                GuiContainer container = this.cellContainers[row][i];
                if (!(container instanceof ScreenLayout)) continue;
                ScreenLayout layoutcontainer = (ScreenLayout)container;
                layoutcontainer.close();
            }
        }
    }

    public void layout() {
        try {
            int i;
            short max_h;
            int row;
            int totalproportion = 0;
            for (int i2 = 0; i2 < this.cellRows; ++i2) {
                if (this.rowProportions[i2] < 0) continue;
                totalproportion += this.rowProportions[i2];
            }
            if (totalproportion < 0) {
                System.out.println("Assertion Failure: totalproportion>=0\nD:\\FLWBF2_CODE\\FLWBF2_F500\\FLWBF2_SonyEricsson_F500i_v0-5-5_SRC/src/master_code/com/slg/j2me/lib\\gui\\layout/CellLayout.java[161]");
                try {
                    throw new Exception();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            int[] row_y0 = new int[this.cellRows];
            int[] row_h = new int[this.cellRows];
            int sum = 0;
            int fixed_space = 0;
            int variable_space = this.clipRect.h;
            for (row = 0; row < this.cellRows; ++row) {
                max_h = 0;
                if (this.cellContainers[row] != null) {
                    for (i = 0; i < this.cellContainers[row].length; ++i) {
                        if (this.cellContainers[row][i] == null) continue;
                        try {
                            this.cellContainers[row][i].initialise();
                            max_h = max_h > this.cellContainers[row][i].clipRect.h ? max_h : this.cellContainers[row][i].clipRect.h;
                            continue;
                        }
                        catch (Exception e) {
                            System.out.println("exception: " + e);
                        }
                    }
                }
                if (this.rowProportions[row] >= 0) continue;
                fixed_space += max_h;
            }
            if ((variable_space -= fixed_space) == 0 || totalproportion == 0) {
                variable_space = 0;
                this.clipRect.h = (short)fixed_space;
                totalproportion = 1;
            }
            fixed_space = 0;
            for (row = 0; row < this.cellRows; ++row) {
                row_y0[row] = fixed_space + sum * variable_space / totalproportion;
                if (this.rowProportions[row] >= 0) {
                    sum += this.rowProportions[row];
                } else {
                    max_h = 0;
                    if (this.cellContainers[row] != null) {
                        for (i = 0; i < this.cellContainers[row].length; ++i) {
                            if (this.cellContainers[row][i] == null) continue;
                            max_h = max_h > this.cellContainers[row][i].clipRect.h ? max_h : this.cellContainers[row][i].clipRect.h;
                        }
                    }
                    fixed_space += max_h;
                }
                row_h[row] = fixed_space + sum * variable_space / totalproportion - row_y0[row];
            }
            int max_width = 0;
            for (int row2 = 0; row2 < this.cellRows; ++row2) {
                if (this.cellProportions[row2] != null) {
                    totalproportion = 0;
                    fixed_space = 0;
                    sum = 0;
                    variable_space = this.clipRect.w;
                    for (int i3 = 0; i3 < this.cellProportions[row2].length; ++i3) {
                        if (this.cellProportions[row2][i3] >= 0) {
                            totalproportion += this.cellProportions[row2][i3];
                            continue;
                        }
                        fixed_space += this.cellContainers[row2][i3].clipRect.w;
                    }
                    if (totalproportion < 0) {
                        System.out.println("Assertion Failure: totalproportion>=0\nD:\\FLWBF2_CODE\\FLWBF2_F500\\FLWBF2_SonyEricsson_F500i_v0-5-5_SRC/src/master_code/com/slg/j2me/lib\\gui\\layout/CellLayout.java[236]");
                        try {
                            throw new Exception();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    if ((variable_space -= fixed_space) == 0 || totalproportion == 0) {
                        variable_space = 0;
                        max_width = max_width > fixed_space ? max_width : fixed_space;
                        totalproportion = 1;
                    } else {
                        max_width = this.clipRect.w;
                    }
                    try {
                        fixed_space = 0;
                        for (int i4 = 0; i4 < this.cellProportions[row2].length; ++i4) {
                            GuiContainer container = this.cellContainers[row2][i4];
                            if (container != null) {
                                int x0 = sum * variable_space / totalproportion + fixed_space;
                                int y0 = row_y0[row2];
                                if (this.cellProportions[row2][i4] >= 0) {
                                    sum += this.cellProportions[row2][i4];
                                } else {
                                    fixed_space += container.clipRect.w;
                                }
                                int w = sum * variable_space / totalproportion + fixed_space - x0;
                                int h = row_h[row2];
                                if ((this.cellLayout[row2][i4] & 2) != 0) {
                                    if (h - container.clipRect.h > 0) {
                                        container.clipRect.y0 = (short)(y0 + (h - container.clipRect.h) / 2);
                                    } else {
                                        container.clipRect.y0 = (short)y0;
                                        container.clipRect.h = (short)h;
                                    }
                                } else {
                                    container.clipRect.y0 = (short)y0;
                                    container.clipRect.h = (short)h;
                                }
                                if ((this.cellLayout[row2][i4] & 1) != 0) {
                                    container.clipRect.x0 = w - container.clipRect.w > 0 ? (short)(x0 + (w - container.clipRect.w) / 2) : (short)x0;
                                } else {
                                    container.clipRect.x0 = (short)x0;
                                    container.clipRect.w = (short)w;
                                }
                                if (!(container instanceof ScreenLayout)) continue;
                                ScreenLayout layoutcontainer = (ScreenLayout)container;
                                layoutcontainer.layout();
                                continue;
                            }
                            sum += this.cellProportions[row2][i4];
                        }
                        continue;
                    }
                    catch (Exception e) {
                        System.out.println("CellLayout.layout() Exception: " + e);
                        continue;
                    }
                }
                System.out.println("CellLayout.layout() - row #" + row2 + " is not initialised!");
            }
            if (max_width != 0) {
                this.clipRect.w = (short)max_width;
            }
        }
        catch (Exception ex) {
            System.out.println("Exception in CellLayout: " + ex);
            System.out.println("Assertion Failure: false\nD:\\FLWBF2_CODE\\FLWBF2_F500\\FLWBF2_SonyEricsson_F500i_v0-5-5_SRC/src/master_code/com/slg/j2me/lib\\gui\\layout/CellLayout.java[322]");
            try {
                throw new Exception();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void paint(Graphics g) {
        for (int row = 0; row < this.cellRows; ++row) {
            if (this.cellContainers[row] == null || this.rowProportions[row] == 0) continue;
            for (int i = 0; i < this.cellContainers[row].length; ++i) {
                GuiContainer container = this.cellContainers[row][i];
                try {
                    if (container == null) continue;
                    this.oldRect = container.clipRect;
                    this.newRect.x0 = (short)(this.clipRect.x0 + container.clipRect.x0);
                    this.newRect.y0 = (short)(this.clipRect.y0 + container.clipRect.y0);
                    this.newRect.w = (short)((this.newRect.x0 + container.clipRect.w < this.clipRect.x0 + this.clipRect.w ? this.newRect.x0 + container.clipRect.w : this.clipRect.x0 + this.clipRect.w) - this.newRect.x0);
                    this.newRect.h = (short)((this.newRect.y0 + container.clipRect.h < this.clipRect.y0 + this.clipRect.h ? this.newRect.y0 + container.clipRect.h : this.clipRect.y0 + this.clipRect.h) - this.newRect.y0);
                    if (this.newRect.w > 0 && this.newRect.h > 0) {
                        container.clipRect = this.newRect;
                        if (container == null) {
                            System.out.println("Assertion Failure: container != null\nD:\\FLWBF2_CODE\\FLWBF2_F500\\FLWBF2_SonyEricsson_F500i_v0-5-5_SRC/src/master_code/com/slg/j2me/lib\\gui\\layout/CellLayout.java[355]");
                            try {
                                throw new Exception();
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        container.paint(g);
                    }
                    container.clipRect = this.oldRect;
                    continue;
                }
                catch (Exception e) {
                    System.out.println("CellLayout.paint() Exception: " + e);
                    e.printStackTrace();
                }
            }
        }
    }

    public void process() {
        for (int row = 0; row < this.cellRows; ++row) {
            if (this.cellContainers[row] == null) continue;
            for (int i = 0; i < this.cellContainers[row].length; ++i) {
                GuiContainer container = this.cellContainers[row][i];
                if (container == null || !(container instanceof ScreenLayout)) continue;
                ScreenLayout layoutcontainer = (ScreenLayout)container;
                layoutcontainer.process();
            }
        }
    }
}

