/*
 * Decompiled with CFR 0.152.
 */
package com.slg.j2me.lib.sys;

import com.slg.j2me.lib.gfx.BaseScreen;
import com.slg.j2me.lib.gui.layout.ScreenStack;
import com.slg.j2me.lib.snd.SoundBank;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.lcdui.Display;
import javax.microedition.midlet.MIDlet;
import javax.microedition.midlet.MIDletStateChangeException;

public abstract class Application
extends MIDlet
implements Runnable {
    public static Application instance = null;
    public static Display display = null;
    public static boolean loaded = false;
    public static boolean applicationPaused = false;
    public static boolean isLoading = false;
    public static boolean lastDrawnScreenWasLoading = false;
    public static long startingMemory = Runtime.getRuntime().freeMemory();
    public static int appError = 0;
    public static long logoTime;
    public static long timeLastFrame;
    public static int lastFrameTime;
    public static int fp_deltatime;
    Timer iTimer = new Timer();

    public abstract void load();

    public abstract void process();

    public abstract void startApp() throws MIDletStateChangeException;

    public abstract void pauseApp();

    public abstract void doPause();

    public abstract void unPause();

    public abstract void resumeSound();

    public Application() {
        instance = this;
        display = Display.getDisplay((MIDlet)this);
        Application.printMemoryStatus();
    }

    public static void printMemoryStatus() {
        Application.gc();
        long free_memory = Runtime.getRuntime().freeMemory();
        System.out.println("Memory Status: " + (startingMemory - free_memory) + " / " + startingMemory + " [" + free_memory + " free]");
    }

    public static byte[] getResourceFromJar(String file) {
        try {
            ByteArrayOutputStream bo = new ByteArrayOutputStream();
            InputStream is = instance.getClass().getResourceAsStream(file);
            int _byte = 0;
            while ((_byte = is.read()) != -1) {
                bo.write(_byte);
            }
            is.close();
            return bo.toByteArray();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void waitForLogoTimeout() {
        long time = System.currentTimeMillis();
        long time_left = 2500L - (time - logoTime);
        if (time_left > 0L) {
            try {
                System.out.println("waiting " + time_left + " millis");
                Thread.sleep(time_left);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        logoTime = System.currentTimeMillis();
    }

    public static void logError(int code) {
        if (appError == 0) {
            appError = code;
            int colour = 0xFF7F7F;
            switch (code) {
                case 1: {
                    colour = 0xFF0000;
                    break;
                }
                case 2: {
                    colour = 0xFF00FF;
                    break;
                }
                case 3: {
                    colour = 0xFFFF00;
                    break;
                }
                case 4: {
                    colour = 65280;
                }
            }
            ScreenStack.instance.setBackgroundColour(colour);
        }
    }

    protected final void backgroundLoad() {
        try {
            Thread myThread = new Thread(this);
            myThread.start();
        }
        catch (Error e) {
            Application.quit();
        }
    }

    public static void setAppLoading() {
        if (!lastDrawnScreenWasLoading) {
            isLoading = true;
            try {
                Thread.sleep(50L);
            }
            catch (Exception e) {
                // empty catch block
            }
            BaseScreen.forcePaint();
            try {
                Thread.sleep(50L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public final void run() {
        this.load();
        BaseScreen.resetKeys();
        loaded = true;
        timeLastFrame = System.currentTimeMillis();
        this.iTimer.schedule((TimerTask)new MyTimerTask(), 0L, 20L);
    }

    public void processInternal() {
        if (BaseScreen.screensShown > 0 && applicationPaused && !BaseScreen.badScreenSize) {
            this.unPause();
        }
        if (applicationPaused) {
            timeLastFrame = System.currentTimeMillis();
            return;
        }
        if (BaseScreen.screensShown == 0) {
            this.doPause();
            return;
        }
        long time = System.currentTimeMillis();
        if (isLoading) {
            isLoading = false;
            timeLastFrame = time;
        }
        lastFrameTime = (int)(time - timeLastFrame);
        timeLastFrame = time;
        lastFrameTime = lastFrameTime < 10 ? 10 : (lastFrameTime > 100 ? 100 : lastFrameTime);
        fp_deltatime = lastFrameTime * 66;
        if (BaseScreen.pauseDialogShown) {
            lastFrameTime = 0;
            fp_deltatime = 0;
        }
        SoundBank.process();
        BaseScreen.beginInputProcessing();
        try {
            this.process();
        }
        catch (Exception e) {
            System.out.println("\n\n*******************************************************\n" + e + "\n*******************************************************\n\n");
            e.printStackTrace();
        }
        BaseScreen.endInputProcessing();
        BaseScreen.forcePaint();
    }

    public void destroyApp(boolean unconditional) {
        try {
            this.iTimer.cancel();
        }
        catch (Exception e) {
            System.out.println("\n\n*******************************************************\nException in destroyApp() " + e.toString() + "\n*******************************************************\n\n");
            e.printStackTrace();
        }
    }

    public static final void quit() {
        try {
            instance.destroyApp(true);
        }
        catch (Exception e) {
            System.out.println("\n\n*******************************************************\nException in quit() " + e.toString() + "\n*******************************************************\n\n");
            e.printStackTrace();
        }
        instance.notifyDestroyed();
        instance = null;
    }

    public static final void gc() {
        System.gc();
    }

    public static final String formatNumber(int num, int length, char blank) {
        String s = "";
        int i = 1;
        for (int j = 1; j < length; ++j) {
            if (num / i < 10) {
                s = s + blank;
            }
            i *= 10;
        }
        if (num == 0) {
            return s + blank;
        }
        return s + num;
    }

    static {
        timeLastFrame = System.currentTimeMillis();
        lastFrameTime = 20;
        fp_deltatime = 0;
    }

    class MyTimerTask
    extends TimerTask {
        MyTimerTask() {
        }

        public void run() {
            Application.this.processInternal();
        }
    }
}

