/*
 * Decompiled with CFR 0.152.
 */
package DWGameEngine;

import DWGameEngine.GameUtil;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public abstract class GameCore
extends Canvas {
    public static final int GAME_ACT = 5;
    public static final int GAME_CONTROL = 6;
    public static final int GAME_HELP = 4;
    public static final int GAME_LOAD = 1;
    public static final int GAME_LOGO = 0;
    public static final int GAME_MENU = 3;
    public static final int GAME_OPTION = 7;
    public static final int GAME_TITLE = 2;
    public final int IMAGE_NUM;
    public static int LEFT_X;
    public static int LEFT_Y;
    public static final int SUPER_GAME_CONTROL = 2;
    public static final int SUPER_MENU_CONTROL = 1;
    public int keypad = 0;
    private Image logo_img;
    public boolean m_CheckTime = true;
    public static long m_CurrectTime;
    protected int m_DelayTime;
    public static Font m_Font;
    public static int m_FontSizeHeight;
    public static int m_FontSizeWidth;
    public static int m_GameControl;
    public static int m_GameState;
    public static int m_KeyIndex;
    public static boolean[] m_KeyState;
    protected int m_LoadCount;
    private int m_LoadWidth;
    public static int m_OldGameState;
    private runGame m_Run;
    private int m_SleepTime;
    public static Thread m_Thread;

    static {
        m_KeyState = new boolean[14];
        LEFT_X = 0;
        LEFT_Y = 0;
        m_CurrectTime = 0L;
    }

    public GameCore() {
        this.IMAGE_NUM = 11;
        this.setFullScreenMode(true);
        m_Font = Font.getDefaultFont();
        m_FontSizeWidth = m_Font.charWidth('\u6211');
        m_FontSizeHeight = m_Font.getHeight();
        this.m_SleepTime = 40;
        this.m_Run = new runGame(this);
        m_Thread = new Thread(this.m_Run);
        this.init();
        m_Thread.start();
    }

    public static void clearKeyState() {
        m_KeyIndex = -1;
        int i = 0;
        while (i < 14) {
            GameCore.m_KeyState[i] = false;
            ++i;
        }
    }

    private void init() {
        this.m_LoadWidth = 8;
        this.m_LoadCount = -1;
        this.m_DelayTime = 0;
        this.logo_img = GameUtil.createImage("logo.png");
        GameCore.setGameControl(2);
        GameCore.setGameState(0);
        LEFT_X = 0;
        LEFT_Y = 16;
        LEFT_Y = 8;
    }

    public abstract void keyAction();

    public void keyPressed(int key) {
        int getkey = 0;
        this.keypad = 0;
        getkey = this.getGameAction(key);
        this.keypad = key;
        if (this.keypad == -6) {
            m_KeyIndex = 12;
        } else if (this.keypad == -7) {
            m_KeyIndex = 13;
        } else if (this.keypad >= 48 && this.keypad <= 57) {
            m_KeyIndex = this.keypad - 48;
        } else if (this.keypad == 42) {
            m_KeyIndex = 10;
        } else if (this.keypad == 35) {
            m_KeyIndex = 11;
        }
        if (getkey == 1) {
            m_KeyIndex = 2;
        } else if (getkey == 6) {
            m_KeyIndex = 8;
        } else if (getkey == 2) {
            m_KeyIndex = 4;
        } else if (getkey == 5) {
            m_KeyIndex = 6;
        } else if (getkey == 8) {
            m_KeyIndex = 5;
        }
        if (m_KeyIndex != -1) {
            GameCore.m_KeyState[GameCore.m_KeyIndex] = true;
        }
    }

    public void keyReleased(int key) {
        GameCore.clearKeyState();
    }

    public abstract void loadImage();

    public void pause() {
        this.m_Run.stop = 1;
    }

    public void resume() {
        this.m_Run.stop = 0;
    }

    public static void setDelayTime(int time) {
        try {
            Thread.sleep(time);
        }
        catch (Exception exception) {
            return;
        }
    }

    public static void setGameControl(int control) {
        m_GameControl = control;
    }

    public static void setGameState(int st) {
        m_OldGameState = m_GameState;
        m_GameState = st;
    }

    public void update(Graphics g) {
        this.keyAction();
        switch (m_GameState) {
            case 0: {
                g.setColor(255, 255, 255);
                g.fillRect(0, 0, 128, 160);
                GameUtil.drawImage(g, this.logo_img, (128 - this.logo_img.getWidth()) / 2, (128 - this.logo_img.getHeight()) / 2, 0);
                GameCore.setGameState(1);
                break;
            }
            case 1: {
                g.setColor(0);
                GameUtil.drawRect(g, 24, (128 - this.logo_img.getHeight()) / 2 + this.logo_img.getHeight() + 8, 80, 3);
                g.setColor(255, 0, 0);
                GameUtil.fillRect(g, 24, (128 - this.logo_img.getHeight()) / 2 + this.logo_img.getHeight() + 8, this.m_LoadCount * this.m_LoadWidth, 3);
                this.loadImage();
                if (this.m_LoadCount <= 11) break;
                this.logo_img = null;
                System.gc();
                GameCore.setGameState(2);
            }
        }
    }

    class runGame
    implements Runnable {
        Canvas screen;
        int stop = 0;

        public runGame(Canvas c) {
            this.screen = c;
        }

        public void run() {
            while (true) {
                if (this.stop != 0) {
                    continue;
                }
                try {
                    Thread.sleep(GameCore.this.m_SleepTime);
                }
                catch (Exception exception) {
                    return;
                }
                this.screen.repaint(0, 0, 128, 160);
            }
        }
    }
}

