/*
 * Decompiled with CFR 0.152.
 */
package com.zeemote.zc.j2me;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.util.Hashtable;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

final class PropertyStore {
    private static final String LOCAL_RECORD_STORE_NAME = "com.zeemote.zc.lzp";
    private static final String GLOBAL_RECORD_STORE_NAME = "gzp";
    private static final String GLOBAL_STORE_SUITE = "Zeemote Manager";
    private static final String GLOBAL_STORE_VENDOR = "Zeemote, Inc.";
    private static final int FORMAT_VERSION_NUMBER = 1;

    private PropertyStore() {
    }

    static void deleteGlobalProperties() throws IOException {
        try {
            RecordStore.deleteRecordStore((String)GLOBAL_RECORD_STORE_NAME);
            return;
        }
        catch (RecordStoreException recordStoreException) {
            throw new IOException(recordStoreException.getMessage());
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void createGlobalProperties() throws IOException {
        RecordStore recordStore = null;
        try {
            recordStore = PropertyStore.openRecordStore(GLOBAL_RECORD_STORE_NAME, true, 1, true);
            if (recordStore.getNumRecords() <= 0) {
                recordStore.addRecord(new byte[0], 0, 0);
            }
            if (recordStore == null) return;
        }
        catch (RecordStoreException recordStoreException) {
            try {
                throw new IOException(recordStoreException.getMessage());
                catch (SecurityException securityException) {
                    throw new IOException(securityException.getMessage());
                }
            }
            catch (Throwable throwable) {
                if (recordStore == null) throw throwable;
                try {
                    recordStore.closeRecordStore();
                    throw throwable;
                }
                catch (RecordStoreException recordStoreException2) {}
                throw throwable;
            }
        }
        try {
            recordStore.closeRecordStore();
            return;
        }
        catch (RecordStoreException recordStoreException) {
            return;
        }
    }

    static Hashtable readGlobalProperties() throws IOException {
        return PropertyStore.readProperties(false);
    }

    static Hashtable readLocalProperties() throws IOException {
        return PropertyStore.readProperties(true);
    }

    static void storeGlobalProperties(Hashtable hashtable) throws IOException {
        PropertyStore.storeProperties(hashtable, false);
    }

    static void storeLocalProperties(Hashtable hashtable) throws IOException {
        PropertyStore.storeProperties(hashtable, true);
    }

    private static Hashtable readProperties(boolean bl) throws IOException {
        Hashtable hashtable;
        block7: {
            RecordStore recordStore = null;
            try {
                recordStore = bl ? PropertyStore.openLocalRecordStore() : PropertyStore.openGlobalRecordStore();
                hashtable = PropertyStore.readProperties(recordStore);
                if (null == recordStore) break block7;
            }
            catch (Throwable throwable) {
                if (null != recordStore) {
                    try {
                        recordStore.closeRecordStore();
                    }
                    catch (RecordStoreException recordStoreException) {}
                }
                throw throwable;
            }
            try {
                recordStore.closeRecordStore();
            }
            catch (RecordStoreException recordStoreException) {}
        }
        return hashtable;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void storeProperties(Hashtable hashtable, boolean bl) throws IOException {
        RecordStore recordStore = null;
        try {
            recordStore = bl ? PropertyStore.openLocalRecordStore() : PropertyStore.openGlobalRecordStore();
            PropertyStore.storeProperties(hashtable, recordStore);
            if (null == recordStore) return;
        }
        catch (Throwable throwable) {
            if (null == recordStore) throw throwable;
            try {
                recordStore.closeRecordStore();
                throw throwable;
            }
            catch (RecordStoreException recordStoreException) {}
            throw throwable;
        }
        try {
            recordStore.closeRecordStore();
            return;
        }
        catch (RecordStoreException recordStoreException) {
            return;
        }
    }

    private static RecordStore openLocalRecordStore() throws IOException {
        return PropertyStore.openRecordStore(LOCAL_RECORD_STORE_NAME, true, 0, true);
    }

    private static RecordStore openGlobalRecordStore() throws IOException {
        try {
            return RecordStore.openRecordStore((String)GLOBAL_RECORD_STORE_NAME, (String)GLOBAL_STORE_VENDOR, (String)GLOBAL_STORE_SUITE);
        }
        catch (RecordStoreException recordStoreException) {
            throw new IOException(recordStoreException.getMessage());
        }
        catch (SecurityException securityException) {
            throw new IOException(securityException.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Hashtable readProperties(RecordStore object) throws IOException {
        Object object2;
        RecordEnumeration recordEnumeration;
        block15: {
            recordEnumeration = null;
            FilterInputStream filterInputStream = null;
            try {
                recordEnumeration = object.enumerateRecords(null, null, false);
                object = new Hashtable();
                if (recordEnumeration.hasNextElement()) {
                    byte[] byArray = recordEnumeration.nextRecord();
                    object2 = byArray;
                    if (byArray != null && (filterInputStream = new DataInputStream(new ByteArrayInputStream((byte[])object2))).available() > 0) {
                        int n = ((DataInputStream)filterInputStream).readInt();
                        if (n != 1) {
                            throw new IOException();
                        }
                        while (filterInputStream.available() > 0) {
                            String string = ((DataInputStream)filterInputStream).readUTF();
                            String string2 = ((DataInputStream)filterInputStream).readUTF();
                            ((Hashtable)object).put(string, string2);
                        }
                    }
                }
                object2 = object;
                if (null == filterInputStream) break block15;
            }
            catch (RecordStoreException recordStoreException) {
                try {
                    throw new IOException(recordStoreException.getMessage());
                }
                catch (Throwable throwable) {
                    if (null != filterInputStream) {
                        try {
                            filterInputStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (null != recordEnumeration) {
                        recordEnumeration.destroy();
                    }
                    throw throwable;
                }
            }
            try {
                filterInputStream.close();
            }
            catch (IOException iOException) {}
        }
        if (null != recordEnumeration) {
            recordEnumeration.destroy();
        }
        return object2;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void storeProperties(Hashtable hashtable, RecordStore recordStore) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream;
        block15: {
            RecordEnumeration recordEnumeration = null;
            DataOutputStream dataOutputStream = null;
            byteArrayOutputStream = null;
            try {
                byteArrayOutputStream = new ByteArrayOutputStream();
                dataOutputStream = new DataOutputStream(byteArrayOutputStream);
                dataOutputStream.writeInt(1);
                Object object = hashtable.keys();
                while (object.hasMoreElements()) {
                    String string = (String)object.nextElement();
                    String string2 = (String)hashtable.get(string);
                    dataOutputStream.writeUTF(string);
                    dataOutputStream.writeUTF(string2);
                }
                dataOutputStream.flush();
                dataOutputStream.close();
                dataOutputStream = null;
                object = byteArrayOutputStream.toByteArray();
                recordEnumeration = recordStore.enumerateRecords(null, null, false);
                while (recordEnumeration.hasNextElement()) {
                    recordStore.deleteRecord(recordEnumeration.nextRecordId());
                }
                recordStore.addRecord((byte[])object, 0, ((Object)object).length);
                if (null == recordEnumeration) break block15;
            }
            catch (RecordStoreException recordStoreException) {
                try {
                    throw new IOException(recordStoreException.getMessage());
                    catch (SecurityException securityException) {
                        throw new IOException(securityException.getMessage());
                    }
                }
                catch (Throwable throwable) {
                    if (null != recordEnumeration) {
                        recordEnumeration.destroy();
                    }
                    if (null != byteArrayOutputStream) {
                        try {
                            byteArrayOutputStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (null == dataOutputStream) throw throwable;
                    try {
                        dataOutputStream.close();
                        throw throwable;
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
            }
            recordEnumeration.destroy();
        }
        if (null == byteArrayOutputStream) return;
        try {
            byteArrayOutputStream.close();
            return;
        }
        catch (IOException iOException) {}
    }

    private static RecordStore openRecordStore(String string, boolean bl, int n, boolean bl2) throws IOException {
        RecordStore recordStore = null;
        try {
            recordStore = RecordStore.openRecordStore((String)string, (boolean)bl);
            recordStore.setMode(n, bl2);
            return recordStore;
        }
        catch (RecordStoreException recordStoreException) {
            throw new IOException(recordStoreException.getMessage());
        }
        catch (SecurityException securityException) {
            throw new IOException(securityException.getMessage());
        }
    }
}

