/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterInputStream;
import java.io.InputStream;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.rms.InvalidRecordIDException;
import javax.microedition.rms.RecordStore;
import wrapper.WrapperMIDlet;

public class Menu
extends Canvas
implements Runnable,
Constants {
    public static String[] languageCodes;
    public static int languageCount;
    public static boolean multiLang;
    public static Image[] langCaptions;
    public static Image langOK;
    public static boolean textsLoaded;
    public static String communityURL;
    public static String portalURL;
    public static String demoURL;
    public static String visitURL;
    public static String demoMsg;
    public static boolean isGetMoreEnable;
    private static final String emptyString = "";
    boolean isGameSplash = false;
    private static final int LB = 36;
    private static final int RB = 40;
    private Graphics screen;
    private Image[] images = null;
    static boolean demoEnabled;
    static final String defaultDemoText = "Demo is over";
    static String demoText;
    static String portalText;
    public static int lang_sel;
    public static int lang_num;
    public static String[] lang_code;
    public static String[] lang_name;
    private static boolean isLanguagesSelected;
    private static boolean isMultiLanguages;
    public static boolean isDemo;
    private int selectedLanguageIndex = 0;
    private Image splash;
    private Image icon;
    private XFont font = new XFont();
    private String[] names;
    private int type;
    private Throwable t;
    private String msg;
    private static int state;
    private int softkeyHeight;
    private String lsk;
    private String rsk;
    public int screenWidth = 0;
    public int screenHeight = 0;
    private int scrollingPosition = 0;
    private int selected;
    private String[][] text;
    public static String[] texts;
    private String[] portals;
    private int scrollCount = 0;
    private int pressedKey = 0;
    private boolean isPreesedEnter = false;
    private boolean isPaintLock = false;
    public static final String VERSION;

    public Menu() {
        this.setFullScreenMode(true);
    }

    private void setSoftLabel(int key, String label) {
        if (key == -6) {
            this.lsk = label;
        } else if (key == -7) {
            this.rsk = label;
        }
    }

    private void setSoftkeys(String lsk, String rsk) {
        this.setSoftLabel(-6, lsk);
        this.setSoftLabel(-7, rsk);
    }

    public void keyPressed(int keyCode) {
        switch (state) {
            case 3: {
                if (this.isAction(keyCode)) {
                    if (2 == this.selected) {
                        if (null == portalURL) {
                            this.changeState(5);
                        } else {
                            this.changeState(4);
                        }
                    } else if (3 == this.selected) {
                        this.changeState(5);
                    } else {
                        this.changeState(200);
                    }
                    this.repaintNow();
                } else if (this.isLeft(keyCode)) {
                    --this.selected;
                    if (this.selected < 0) {
                        this.selected = this.names.length - 1;
                    }
                    this.scrollingPosition = 0;
                    this.pressedKey = keyCode;
                } else if (this.isRight(keyCode)) {
                    ++this.selected;
                    if (this.selected >= this.names.length) {
                        this.selected = 0;
                    }
                    this.scrollingPosition = 0;
                    this.pressedKey = keyCode;
                }
                if (keyCode != -7) break;
                this.changeState(101);
                break;
            }
            case 2: {
                this.handleSelectLanguage(keyCode);
                this.repaintNow();
                break;
            }
            case 4: {
                if (keyCode == -7) {
                    this.changeState(3);
                    break;
                }
                if (this.isAction(keyCode)) {
                    this.isPreesedEnter = true;
                    break;
                }
                this.handleCursor(keyCode);
                this.repaintNow();
                break;
            }
            case 101: {
                if (keyCode == -7) {
                    this.changeState(3);
                    break;
                }
                if (this.isAction(keyCode)) {
                    this.isPreesedEnter = true;
                    break;
                }
                this.handleCursor(keyCode);
                this.repaintNow();
                break;
            }
            case 5: {
                if (keyCode == -7) {
                    this.changeState(3);
                    break;
                }
                this.handleCursor(keyCode);
                this.repaintNow();
            }
        }
    }

    private boolean isAction(int keyCode) {
        if (keyCode == 53 || keyCode == -6 || keyCode == -5) {
            return true;
        }
        try {
            return this.getGameAction(keyCode) == 8;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean isUp(int keyCode) {
        if (keyCode == 50 || keyCode == -1) {
            return true;
        }
        try {
            return this.getGameAction(keyCode) == 1;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean isDown(int keyCode) {
        if (keyCode == 56 || keyCode == -2) {
            return true;
        }
        try {
            return this.getGameAction(keyCode) == 6;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean isLeft(int keyCode) {
        if (keyCode == 52 || keyCode == -3) {
            return true;
        }
        try {
            if (this.getGameAction(keyCode) == 2) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private boolean isRight(int keyCode) {
        if (keyCode == 54 || keyCode == -4) {
            return true;
        }
        try {
            return this.getGameAction(keyCode) == 5;
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected void executionException(int type, Throwable t) {
        this.type = type;
        this.t = t;
        System.out.println(" t " + t.toString());
        this.repaintNow();
    }

    protected void msg(int type, String msg) {
        this.type = type;
        this.msg = msg;
        System.out.println(" msg " + msg);
        this.repaintNow();
    }

    public void run() {
        this.screenWidth = this.getWidth();
        this.screenHeight = this.getHeight();
        boolean isMenu = true;
        while (state != 100 && isMenu) {
            switch (state) {
                case 0: {
                    try {
                        this.splash = Image.createImage((String)"/disney_logo.png");
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                    this.load();
                    this.font.load(0);
                    this.softkeyHeight = this.font.getHeight() + this.changeScaleValueFromQVGA(6);
                    this.readSettings();
                    if (!isLanguagesSelected) {
                        if (lang_sel < 0) {
                            lang_sel = 0;
                        }
                        this.loadStrings();
                    } else {
                        this.loadStrings();
                    }
                    this.changeState(1);
                    this.repaintNow();
                    break;
                }
                case 1: {
                    this.isGameSplash = false;
                    try {
                        Thread.sleep(3000L);
                    }
                    catch (InterruptedException ie) {
                        // empty catch block
                    }
                    this.isGameSplash = true;
                    this.splash = null;
                    System.gc();
                    try {
                        this.splash = Image.createImage((String)"/splash2.png");
                    }
                    catch (Exception e3) {
                        // empty catch block
                    }
                    this.repaintNow();
                    try {
                        Thread.sleep(3000L);
                    }
                    catch (InterruptedException ie) {
                        // empty catch block
                    }
                    if (1 < lang_num) {
                        isMultiLanguages = true;
                    }
                    if (1 < lang_num && !isLanguagesSelected) {
                        this.changeState(2);
                    } else {
                        this.loadStrings();
                        this.changeState(3);
                        this.repaintNow();
                    }
                    this.splash = null;
                    System.gc();
                    break;
                }
                case 2: {
                    this.repaintNow();
                    try {
                        Thread.yield();
                        Thread.sleep(100L);
                    }
                    catch (Exception e4) {}
                    break;
                }
                case 3: {
                    this.handleMenu();
                    break;
                }
                case 200: {
                    this.free();
                    this.setSoftkeys(null, null);
                    isMenu = false;
                    WrapperMIDlet.getInstance().executeMIDlet(this.selected);
                    this.changeState(300);
                    break;
                }
                case 300: {
                    this.repaintNow();
                    try {
                        Thread.yield();
                        Thread.sleep(100L);
                    }
                    catch (Exception e5) {}
                    break;
                }
                case 5: {
                    this.repaintNow();
                    try {
                        Thread.yield();
                        Thread.sleep(100L);
                    }
                    catch (Exception e6) {}
                    break;
                }
                case 101: {
                    if (this.isPreesedEnter) {
                        this.changeState(100);
                        this.isPreesedEnter = false;
                        break;
                    }
                    this.repaintNow();
                    try {
                        Thread.yield();
                        Thread.sleep(100L);
                    }
                    catch (Exception e7) {}
                    break;
                }
                case 4: {
                    if (this.isPreesedEnter) {
                        MainMIDlet.callUrl(portalURL);
                        this.isPreesedEnter = false;
                        break;
                    }
                    this.repaintNow();
                    try {
                        Thread.yield();
                        Thread.sleep(100L);
                        break;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        if (isMenu) {
            WrapperMIDlet.getInstance().notifyDestroyed();
        }
    }

    private void repaintNow() {
        this.isPaintLock = false;
        this.repaint();
        this.serviceRepaints();
        try {
            Thread.yield();
            Thread.sleep(10L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void changeState(int newState) {
        state = newState;
        switch (state) {
            case 3: {
                this.load();
                this.setSoftkeys(Menu.getMessage(2), Menu.getMessage(3));
                break;
            }
            case 2: {
                this.setSoftkeys("OK", null);
                break;
            }
            case 300: {
                break;
            }
            case 200: {
                break;
            }
            case 101: {
                this.scrollCount = 0;
                this.isPreesedEnter = false;
                this.text = this.font.breakPages(texts[6], this.screenWidth - 20, this.screenHeight - (this.changeScaleValueFromQVGA(24) + 20));
                this.setSoftkeys(Menu.getMessage(2), Menu.getMessage(4));
                break;
            }
            case 4: {
                this.scrollCount = 0;
                this.isPreesedEnter = false;
                this.text = this.font.breakPages(texts[0], this.screenWidth - 20, this.screenHeight - (this.changeScaleValueFromQVGA(24) + 20));
                this.setSoftkeys(Menu.getMessage(7), Menu.getMessage(4));
                break;
            }
            case 5: {
                this.scrollCount = 0;
                String about = XFont.replace(WrapperMIDlet.getInstance().getAppProperty("MIDlet-Version"), Menu.getMessage(10));
                this.text = this.font.breakPages(about, this.screenWidth - 20, this.screenHeight - (this.changeScaleValueFromQVGA(24) + 20));
                this.setSoftkeys(null, Menu.getMessage(4));
            }
        }
        this.repaintNow();
    }

    protected void paint(Graphics g2) {
        if (null == g2 || this.isPaintLock) {
            return;
        }
        this.isPaintLock = true;
        this.screen = g2;
        switch (state) {
            case 0: {
                this.paintLoading(this.screen);
                break;
            }
            case 1: {
                this.paintSplash(this.screen);
                break;
            }
            case 2: {
                this.drawSelectLanguage(this.screen);
                break;
            }
            case 3: {
                this.paintMenu(this.screen);
                break;
            }
            case 200: 
            case 300: {
                this.screen.setColor(0xFFFFFF);
                this.screen.fillRect(0, 0, this.screenWidth, this.screenHeight);
                break;
            }
            case 4: 
            case 5: 
            case 101: {
                int y = this.images[0].getHeight();
                y = state == 5 ? 16 : (y -= this.changeScaleValueFromQVGA(40));
                this.drawTextBox(this.screen, this.text, 10, y, this.screenWidth - 20, this.screenHeight - y - (this.changeScaleValueFromQVGA(24) + 20));
                this.screen.setClip(0, 0, this.screenWidth, this.screenHeight);
                this.paintSoftkeys(this.screen);
            }
        }
        if (0 < this.type) {
            this.screen.setClip(0, 0, this.screenWidth, this.screenHeight);
            this.screen.setColor(0xFFFFFF);
            this.screen.fillRect(0, 0, this.screenWidth, this.screenHeight);
            this.screen.setColor(0xFF0000);
            if (null != this.t) {
                this.screen.drawString(this.t.toString(), 0, 20, 20);
            }
            if (null != this.msg) {
                this.screen.drawString(this.msg, 0, 50, 20);
            }
        }
    }

    private void paintLoading(Graphics g2) {
    }

    private void paintSplash(Graphics g2) {
        if (this.splash != null) {
            if (this.isGameSplash) {
                g2.setColor(0xFFFFFF);
                g2.setColor(2377373);
                g2.fillRect(0, 0, this.screenWidth, this.screenHeight);
                g2.drawImage(this.splash, this.screenWidth / 2, 0, 17);
            } else {
                g2.setColor(2377373);
                g2.fillRect(0, 0, this.screenWidth, this.screenHeight);
                g2.drawImage(this.splash, this.screenWidth / 2, this.screenHeight / 2, 3);
            }
        }
    }

    private int changeScaleValueFromQVGA(int n) {
        return n * 10000 / 187 / 100;
    }

    private int changeScaleValueFromMLes(int n) {
        return n * 10000 / 137 / 100;
    }

    private void paintMenu(Graphics g2) {
        int offsetY = this.changeScaleValueFromMLes(220) - this.screenHeight;
        int IMAGE_BOX_X = 68;
        int IMAGE_BOX_Y = this.changeScaleValueFromMLes(74) - offsetY / 3;
        int TEXT_BOX_Y = IMAGE_BOX_Y + this.images[1].getHeight() + 6;
        g2.setColor(11328503);
        g2.fillRect(0, 0, this.screenWidth, this.screenHeight);
        if (this.selected < 0) {
            this.selected = this.names.length - 1;
        }
        if (this.selected >= this.names.length) {
            this.selected = 0;
        }
        g2.drawImage(this.images[3], this.screenWidth >> 1, 0, 17);
        g2.drawImage(this.images[0], this.screenWidth >> 1, 0, 17);
        int x = 68;
        int y = IMAGE_BOX_Y;
        if (0 == this.selected) {
            this.drawScreenShotWithShadow(g2, this.images[1], x, y);
        } else if (1 == this.selected) {
            this.drawScreenShotWithShadow(g2, this.images[2], x, y);
        } else if (2 == this.selected) {
            if (null == portalURL) {
                this.drawScreenShotWithShadow(g2, this.images[7], x, y);
            } else {
                this.drawScreenShotWithShadow(g2, this.images[6], x, y);
            }
        } else if (3 == this.selected) {
            this.drawScreenShotWithShadow(g2, this.images[7], x, y);
        }
        y = TEXT_BOX_Y;
        this.drawLabelBox(g2, this.names[this.selected], x, y, this.images[1].getWidth() + this.changeScaleValueFromQVGA(40), this.changeScaleValueFromMLes(30));
        g2.setClip(0, 0, this.screenWidth, this.screenHeight);
        this.paintSoftkeys(g2);
    }

    private void handleMenu() {
        this.scrollingPosition += this.changeScaleValueFromMLes(3);
        int tw = this.font.stringWidth(this.names[this.selected]) + this.changeScaleValueFromQVGA(60);
        if (tw < this.scrollingPosition) {
            this.scrollingPosition = 0;
        }
        this.repaintNow();
        try {
            Thread.sleep(100L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void paintSoftkeys(Graphics g2) {
        if (this.lsk != null || this.rsk != null) {
            int fullHeight = this.screenHeight;
            int y = fullHeight - this.changeScaleValueFromQVGA(3);
            if (this.lsk != null) {
                this.drawSoftkeyLabelBox(g2, this.lsk, 0, this.screenHeight, 36);
            }
            if (this.rsk != null) {
                this.drawSoftkeyLabelBox(g2, this.rsk, this.screenWidth, this.screenHeight, 40);
            }
        }
    }

    private void drawScreenShotWithShadow(Graphics g2, Image img, int x, int y) {
        g2.drawImage(img, x, y, 17);
    }

    private void drawLabelBox(Graphics g2, String label, int x, int y, int w, int h2) {
        x -= w >> 1;
        int CURSOR_LEFT_X = this.changeScaleValueFromMLes(15);
        int CURSOR_RIGHT_X = this.changeScaleValueFromMLes(17);
        ++x;
        w -= 3;
        int y2 = y + h2 / 2 + this.changeScaleValueFromQVGA(2);
        int tw = this.font.stringWidth(this.names[this.selected]) + this.changeScaleValueFromQVGA(60);
        this.font.drawString(g2, this.names[this.selected], this.screenWidth / 2, y2, 3);
        y2 = y - (this.images[1].getHeight() >> 1);
        g2.setClip(0, 0, this.screenWidth, this.screenHeight);
        if (this.isLeft(this.pressedKey)) {
            g2.drawImage(this.images[4], x - (CURSOR_LEFT_X + 3), y2, 10);
        } else {
            g2.drawImage(this.images[4], x - CURSOR_LEFT_X, y2, 10);
        }
        if (this.isRight(this.pressedKey)) {
            g2.drawImage(this.images[5], x + w + (CURSOR_RIGHT_X + 3), y2, 6);
        } else {
            g2.drawImage(this.images[5], x + w + CURSOR_RIGHT_X, y2, 6);
        }
        this.pressedKey = 0;
    }

    private void drawSoftkeyLabelBox(Graphics g2, String label, int x, int y, int anchor) {
        this.font.drawString(g2, label, x, y, anchor);
    }

    public DataInputStream initializeImageFromBNDL(String resource) throws Exception {
        DataInputStream in = null;
        in = new DataInputStream(this.getClass().getResourceAsStream(resource));
        in.readInt();
        return in;
    }

    public Image loadImageFromBNDL(DataInputStream in) throws Exception {
        Image img = null;
        int numBytes = in.readInt();
        byte[] b2 = new byte[numBytes];
        in.readFully(b2);
        img = Image.createImage((byte[])b2, (int)0, (int)numBytes);
        b2 = null;
        return img;
    }

    public void skipImageFromBNDL(DataInputStream in) throws Exception {
        int numBytes = in.readInt();
        in.skipBytes(numBytes);
    }

    public void closeImageFromBNDL(DataInputStream in) throws Exception {
        if (null != in) {
            in.close();
        }
        in = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void load() {
        block12: {
            System.gc();
            if (null != this.images) {
                return;
            }
            this.readSettings();
            DataInputStream bndl = null;
            this.images = new Image[8];
            bndl = this.initializeImageFromBNDL("/menu.bin");
            for (int i2 = 0; i2 < this.images.length; ++i2) {
                this.images[i2] = this.loadImageFromBNDL(bndl);
            }
            try {
                this.closeImageFromBNDL(bndl);
            }
            catch (Exception e2) {}
            break block12;
            catch (Exception e3) {
                try {
                    e3.printStackTrace();
                }
                catch (Throwable throwable) {
                    try {
                        this.closeImageFromBNDL(bndl);
                    }
                    catch (Exception e4) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {
                    this.closeImageFromBNDL(bndl);
                }
                catch (Exception exception) {}
            }
        }
    }

    public void free() {
        this.font.unload();
        this.font = null;
        this.splash = null;
        if (null != this.images) {
            for (int i2 = 0; i2 < this.images.length; ++i2) {
                if (null == this.images[i2]) continue;
                this.images[i2] = null;
            }
        }
        System.gc();
        this.images = null;
        System.gc();
        try {
            Thread.sleep(100L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.gc();
    }

    public void startBrowser(String urlName) {
        System.out.println("platformRequest: " + urlName);
        try {
            if (null != urlName) {
                Thread.sleep(100L);
                WrapperMIDlet.getInstance().platformRequest(urlName);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void terminate() {
        this.changeState(100);
    }

    public void loadStrings() {
        try {
            int versionNumberPos;
            int cnt;
            texts = new String[19];
            DataInputStream is = new DataInputStream(this.getClass().getResourceAsStream("text__" + languageCodes[lang_sel] + ".txt"));
            is.readShort();
            for (cnt = 0; cnt < 8; ++cnt) {
                Menu.texts[cnt] = is.readUTF();
            }
            is.readShort();
            while (cnt < 11) {
                Menu.texts[cnt] = is.readUTF();
                ++cnt;
            }
            textsLoaded = true;
            is.close();
            is = null;
            if (texts[10] != null && (versionNumberPos = texts[10].indexOf(37)) >= 0) {
                Menu.texts[10] = texts[10].substring(0, versionNumberPos) + VERSION + texts[10].substring(versionNumberPos + 1);
            }
            if (isGetMoreEnable) {
                demoMsg = texts[1];
                this.names = new String[4];
            } else {
                this.names = new String[3];
            }
            int cc = 0;
            this.names[cc++] = texts[8];
            this.names[cc++] = texts[9];
            if (isGetMoreEnable) {
                this.names[cc++] = texts[1];
            }
            this.names[cc++] = texts[5];
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public static String getPropertyURL(String value) {
        int pos = value.indexOf("jad:");
        if (pos != 0) {
            return value;
        }
        int pos2 = value.indexOf(124);
        String tag = value.substring(pos + "jad:".length(), pos2);
        value = value.substring(pos2 + 1);
        String valJAD = WrapperMIDlet.getInstance().getAppProperty(tag);
        if (valJAD == null) {
            return value;
        }
        if ((value = value + "&url=" + valJAD).length() > 128) {
            return valJAD;
        }
        return value;
    }

    public static String getKeyValue(String str) {
        return str.substring(str.indexOf("=") + 1, str.length());
    }

    private void handleSelectLanguage(int keyCode) {
        if (this.isAction(keyCode)) {
            lang_sel = this.selectedLanguageIndex;
            isLanguagesSelected = true;
            this.font.load(0);
            this.loadStrings();
            this.saveSettings();
            this.changeState(3);
            for (int i2 = 0; i2 < langCaptions.length; ++i2) {
                Menu.langCaptions[i2] = null;
            }
            langOK = null;
        } else if (this.isUp(keyCode)) {
            --this.selectedLanguageIndex;
            if (this.selectedLanguageIndex < 0) {
                this.selectedLanguageIndex = lang_num - 1;
            }
        } else if (this.isDown(keyCode)) {
            ++this.selectedLanguageIndex;
            if (lang_num <= this.selectedLanguageIndex) {
                this.selectedLanguageIndex = 0;
            }
        }
    }

    private void drawSelectLanguage(Graphics g2) {
        g2.setClip(0, 0, this.screenWidth, this.screenHeight);
        g2.setColor(11328503);
        g2.fillRect(0, 0, this.screenWidth, this.screenHeight);
        g2.drawImage(this.images[3], this.screenWidth >> 1, 0, 17);
        int y = this.screenHeight - lang_num * langCaptions[0].getHeight() >> 1;
        for (int i2 = 0; i2 < lang_num; ++i2) {
            if (this.selectedLanguageIndex == i2) {
                g2.drawImage(this.images[5], this.screenWidth / 2 - (langCaptions[i2].getWidth() + 10) / 2, y + langCaptions[i2].getHeight() * i2, 10);
                g2.drawImage(this.images[4], this.screenWidth / 2 + (langCaptions[i2].getWidth() + 10) / 2, y + langCaptions[i2].getHeight() * i2, 6);
            }
            g2.drawImage(langCaptions[i2], this.screenWidth / 2, y + langCaptions[i2].getHeight() * i2, 3);
        }
        g2.drawImage(langOK, 2, this.screenHeight - 2, 36);
    }

    public void saveSettings() {
        try {
            RecordStore rs = RecordStore.openRecordStore((String)"WinterPack", (boolean)true);
            ByteArrayOutputStream ba = new ByteArrayOutputStream();
            DataOutputStream out = new DataOutputStream(ba);
            byte[] buffer = null;
            try {
                out.writeInt(lang_sel);
                out.writeBoolean(isLanguagesSelected);
                buffer = ba.toByteArray();
                rs.setRecord(1, buffer, 0, buffer.length);
            }
            catch (InvalidRecordIDException e2) {
                rs.addRecord(buffer, 0, buffer.length);
            }
            rs.closeRecordStore();
            rs = null;
            out.close();
            out = null;
            ba.close();
            ba = null;
            System.gc();
        }
        catch (Exception e3) {
            e3.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readSettings() {
        boolean isNoData = false;
        try {
            FilterInputStream in = null;
            byte[] buffer = null;
            try {
                RecordStore rs = RecordStore.openRecordStore((String)"WinterPack", (boolean)true);
                try {
                    buffer = rs.getRecord(1);
                    if (buffer == null || buffer.length == 0) {
                        throw new IllegalStateException();
                    }
                }
                catch (Exception e2) {
                    buffer = new byte[1024];
                    isNoData = true;
                }
                rs.closeRecordStore();
                rs = null;
                System.gc();
            }
            catch (Exception e3) {
                // empty catch block
            }
            try {
                in = new DataInputStream(new ByteArrayInputStream(buffer));
                lang_sel = ((DataInputStream)in).readInt();
                isLanguagesSelected = ((DataInputStream)in).readBoolean();
            }
            catch (Exception e4) {
                e4.printStackTrace();
            }
            finally {
                if (null != in) {
                    in.close();
                    in = null;
                }
                System.gc();
            }
        }
        catch (Exception e5) {
            e5.printStackTrace();
        }
    }

    private void handleTextBox() {
    }

    private void drawTextBox(Graphics g2, String[][] text, int x, int y, int w, int h2) {
        g2.setColor(11328503);
        g2.fillRect(0, 0, this.screenWidth, this.screenHeight);
        g2.drawImage(this.images[3], this.screenWidth >> 1, 0, 17);
        for (int i2 = 0; i2 < text[this.scrollCount].length; ++i2) {
            this.font.drawString(g2, text[this.scrollCount][i2], x, y, 20);
            y += this.font.getHeight();
        }
        if (1 < text.length) {
            this.drawCursor(g2, 0 < this.scrollCount, this.scrollCount < text.length - 1);
        }
    }

    private void handleCursor(int keyCode) {
        try {
            if (this.isLeft(keyCode) && 0 < this.scrollCount) {
                --this.scrollCount;
            }
            if (this.isRight(keyCode) && this.scrollCount < this.text.length - 1) {
                ++this.scrollCount;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void drawCursor(Graphics g2, boolean isLeft, boolean isRight) {
        int x = this.screenWidth / 2;
        int y = this.screenHeight - 3;
        if (isLeft) {
            g2.drawImage(this.images[4], x - 10, y, 40);
        }
        if (isRight) {
            g2.drawImage(this.images[5], x + 10, y, 36);
        }
    }

    public static final String getMessage(int id) {
        return texts[id];
    }

    protected boolean readLanguageDefinition() {
        DataInputStream din = new DataInputStream(this.getClass().getResourceAsStream("/lang"));
        try {
            languageCodes = MainMIDlet.readStrings(din);
            languageCount = 0;
            DataInputStream test = null;
            if (languageCodes.length > 1 && !isLanguagesSelected) {
                langCaptions = new Image[languageCodes.length];
                for (int i2 = 0; i2 < languageCodes.length; ++i2) {
                    try {
                        test = new DataInputStream(this.getClass().getResourceAsStream("/lp__" + languageCodes[i2] + emptyString));
                        int cntBytes = ((InputStream)test).available();
                        byte[] buff = new byte[cntBytes];
                        ((InputStream)test).read(buff, 0, cntBytes);
                        Menu.langCaptions[i2] = Image.createImage((byte[])buff, (int)0, (int)cntBytes);
                        buff = null;
                        try {
                            Thread.sleep(50L);
                        }
                        catch (InterruptedException e2) {
                            // empty catch block
                        }
                        ((InputStream)test).close();
                        test = null;
                        continue;
                    }
                    catch (Exception e3) {
                        System.out.println("/lp__" + languageCodes[i2] + " NOT FOUND : " + e3.getMessage());
                        Menu.languageCodes[i2] = null;
                    }
                }
                try {
                    test = new DataInputStream(this.getClass().getResourceAsStream("/lpok"));
                    int cntBytes = ((InputStream)test).available();
                    byte[] buff = new byte[cntBytes];
                    ((InputStream)test).read(buff, 0, cntBytes);
                    langOK = Image.createImage((byte[])buff, (int)0, (int)cntBytes);
                    buff = null;
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException e4) {
                        // empty catch block
                    }
                    ((InputStream)test).close();
                    test = null;
                }
                catch (Exception e5) {
                    e5.printStackTrace();
                }
            }
            for (int i3 = 0; i3 < languageCodes.length; ++i3) {
                try {
                    test = new DataInputStream(this.getClass().getResourceAsStream("/text__" + languageCodes[i3] + ".txt"));
                    ((InputStream)test).close();
                    test = null;
                    System.gc();
                }
                catch (Exception e6) {
                    System.out.println("/text__" + languageCodes[i3] + ".txt NOT FOUND");
                    Menu.languageCodes[i3] = null;
                    continue;
                }
                System.out.println("/text__" + languageCodes[i3] + ".txt FOUND");
                Menu.languageCodes[Menu.languageCount++] = languageCodes[i3];
            }
            multiLang = languageCodes.length > 1;
            try {
                demoURL = null;
                demoMsg = null;
                while (true) {
                    String key;
                    String value;
                    String string = value = (key = din.readUTF()).equals("demo") ? emptyString : din.readUTF();
                    if ("portalURL".equals(key)) {
                        portalURL = MainMIDlet._instance.getPropertyURL(value);
                    }
                    if ("visitURL".equals(key)) {
                        visitURL = MainMIDlet._instance.getPropertyURL(value);
                    }
                    if (("demoURL__" + languageCodes[lang_sel].toLowerCase()).equals(key)) {
                        demoURL = MainMIDlet._instance.getPropertyURL(value);
                    }
                    if ("communityURL".equals(key)) {
                        communityURL = MainMIDlet._instance.getPropertyURL(value);
                    }
                    if (("demoMsg__" + languageCodes[lang_sel].toLowerCase()).equals(key)) {
                        demoMsg = value;
                    }
                    if (!"demo".equals(key)) continue;
                    isDemo = true;
                }
            }
            catch (Exception e7) {
                e7.printStackTrace();
                isGetMoreEnable = portalURL != null;
                isDemo = demoURL != null || isDemo;
                isMultiLanguages = multiLang;
                lang_num = languageCount;
            }
        }
        catch (Exception e8) {
            e8.printStackTrace();
            System.out.println("Error reading language");
        }
        return false;
    }

    public static void quit() {
        state = 100;
    }

    static {
        langCaptions = null;
        langOK = null;
        textsLoaded = false;
        demoEnabled = false;
        lang_sel = 0;
        lang_code = null;
        lang_name = null;
        isLanguagesSelected = false;
        isMultiLanguages = false;
        isDemo = false;
        VERSION = MainMIDlet._instance.getAppProperty("MIDlet-Version");
    }
}

