/*
 * Decompiled with CFR 0.152.
 */
package Application;

import Actions.CAct;
import Application.CCanvas;
import Application.CCanvasCheck;
import Application.CEmbeddedFile;
import Application.CEventLoader;
import Application.CKeyConvert;
import Application.CMIDlet;
import Application.CMusicPlayer;
import Application.CRunFrame;
import Application.CSoundPlayer;
import Application.CSysEventKeyDown;
import Application.CWindowManager;
import Banks.CFontBank;
import Banks.CImageBank;
import Banks.CMusicBank;
import Banks.CSoundBank;
import Conditions.CCnd;
import Expressions.CExp;
import Expressions.CValue;
import Extensions.CExtLoader;
import OI.COIList;
import RunLoop.CRun;
import Services.CArrayList;
import Services.CChunk;
import Services.CFile;
import Services.CRect;
import Services.CServices;
import Sprites.CColMask;
import Transitions.CTransitionData;
import Transitions.CTransitionManager;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class CRunApp {
    public static final short RUNTIME_VERSION = 770;
    public static final short MAX_PLAYER = 4;
    public static final short MAX_KEY = 8;
    public static final short GA_NOHEADING = 2;
    public static final short GA_SPEEDINDEPENDANT = 8;
    public static final short GA_STRETCH = 16;
    public static final short GA_MENUHIDDEN = 128;
    public static final short GA_MENUBAR = 256;
    public static final short GA_MAXIMISE = 512;
    public static final short GA_MIX = 1024;
    public static final short GA_FULLSCREENATSTART = 2048;
    public static final short GANF_SAMPLESOVERFRAMES = 1;
    public static final short GANF_RUNFRAME = 4;
    public static final short GANF_NOTHICKFRAME = 64;
    public static final short GANF_DONOTCENTERFRAME = 128;
    public static final short GANF_DISABLE_CLOSE = 512;
    public static final short GANF_HIDDENATSTART = 1024;
    public static final short GANF_MDI = 16384;
    public static final short GAOF_JAVASWING = 4096;
    public static final short GAOF_JAVAAPPLET = 8192;
    public static final short SL_RESTART = 0;
    public static final short SL_STARTFRAME = 1;
    public static final short SL_FRAMEFADEINLOOP = 2;
    public static final short SL_FRAMELOOP = 3;
    public static final short SL_FRAMEFADEOUTLOOP = 4;
    public static final short SL_ENDFRAME = 5;
    public static final short SL_QUIT = 6;
    public static final int MAX_VK = 64;
    public static final short CTRLTYPE_MOUSE = 0;
    public static final short CTRLTYPE_JOY1 = 1;
    public static final short CTRLTYPE_JOY2 = 2;
    public static final short CTRLTYPE_JOY3 = 3;
    public static final short CTRLTYPE_JOY4 = 4;
    public static final short CTRLTYPE_KEYBOARD = 5;
    public static final short ARF_INGAMELOOP = 4;
    public static final int FILEINFO_DRIVE = 0;
    public static final int FILEINFO_DIR = 1;
    public static final int FILEINFO_TEMPPATH = 2;
    public static final int FILEINFO_PATH = 3;
    public static final int FILEINFO_APPNAME = 4;
    public static final int DISPLAY_WINDOW = 0;
    public static final int DISPLAY_SWING = 1;
    public static final int DISPLAY_FULLSCREEN = 2;
    public static final int DISPLAY_PANEL = 3;
    public static final int DISPLAY_APPLET = 4;
    public static final int AH2OPT_GLOBALREFRESH = 8;
    public static final int ORIENTATION_PORTRAIT = 0;
    public static final int ORIENTATION_LANDSCAPE = 1;
    public Display display;
    public CMIDlet midlet;
    public CCanvas canvas = null;
    public byte[] jarApp = null;
    public int displayType;
    public long[] frameOffsets;
    public int frameMaxIndex = 0;
    public short nGlobalValuesInit;
    public byte[] globalValuesInitTypes;
    public int[] globalValuesInit;
    public short nGlobalStringsInit;
    public String[] globalStringsInit;
    public COIList OIList;
    public CImageBank imageBank;
    public CFontBank fontBank;
    public CSoundBank soundBank;
    public CSoundPlayer soundPlayer;
    public CMusicBank musicBank;
    public CMusicPlayer musicPlayer;
    public int appRunningState;
    public int[] lives;
    public int[] scores;
    public String[] playerNames;
    public CArrayList gValues;
    public CArrayList gStrings;
    public CValue tempGValue;
    public int startFrame = 0;
    public int nextFrame;
    public int currentFrame;
    public CRunFrame frame = null;
    public CFile file = null;
    public long refTime;
    public CRun run = null;
    public boolean redrawBack = true;
    public short gaFlags;
    public short gaNewFlags;
    public short gaMode;
    public short gaOtherFlags;
    public int gaCxWin;
    public int gaCyWin;
    public int gaScoreInit;
    public int gaLivesInit;
    public int gaBorderColour;
    public int gaNbFrames;
    public int gaFrameRate;
    public byte gaMDIWindowMenu;
    public short[] pcCtrlType = new short[4];
    public short[][] pcCtrlKeys = new short[4][8];
    public short[][] controlKeys = new short[4][8];
    public short[] frameHandleToIndex;
    public short frameMaxHandle;
    public int cx;
    public int cy;
    public CWindowManager winMan = null;
    public Image editWin;
    public Graphics g2EditWin;
    public int mouseX;
    public int mouseY;
    public byte[] keyBuffer;
    public int keyGame;
    public short appRunFlags = 0;
    public CArrayList adGO = null;
    public CArrayList sysEvents = null;
    boolean quit = false;
    public CExtLoader extLoader = null;
    public boolean m_bLoading = false;
    public boolean bVisible = false;
    public int debug = 0;
    public int xOffset = 0;
    public int yOffset = 0;
    public String pLoadFilename = null;
    public Image spritesBack = null;
    public CArrayList extensionStorage = null;
    public CEmbeddedFile[] embeddedFiles = null;
    public CTransitionManager transitionManager = null;
    public CEventLoader eventLoader;
    public CArrayList debugList = null;
    public int hdr2Options = 0;
    public int canvasWidth;
    public int canvasHeight;
    public boolean bGoodCanvas = false;
    public boolean bUnicode = false;
    public int specialKeyCode = 0;
    public int screenRotate;
    public CArrayList graphicFonts = null;
    public int oldOrientation;

    public void setApplication(Display display, CMIDlet cMIDlet, byte[] byArray) {
        this.display = display;
        this.midlet = cMIDlet;
        this.jarApp = byArray;
    }

    public boolean load() {
        int n;
        this.sysEvents = new CArrayList();
        this.keyBuffer = new byte[64];
        for (n = 0; n < 64; ++n) {
            this.keyBuffer[n] = 0;
        }
        this.createDisplayCanvas();
        this.file = new CFile(this.jarApp);
        byte[] byArray = new byte[4];
        this.file.read(byArray);
        boolean bl = false;
        if (byArray[0] == 80 && byArray[1] == 65 && byArray[2] == 77 && byArray[3] == 69) {
            bl = true;
            this.bUnicode = false;
        }
        if (byArray[0] == 80 && byArray[1] == 65 && byArray[2] == 77 && byArray[3] == 85) {
            bl = true;
            this.bUnicode = true;
        }
        if (!bl) {
            return false;
        }
        this.file.setUnicode(this.bUnicode);
        short s = this.file.readAShort();
        if (s != 770) {
            return false;
        }
        s = this.file.readAShort();
        int n2 = this.file.readAInt();
        int n3 = this.file.readAInt();
        if (n2 != 3) {
            return false;
        }
        if (n3 < 249) {
            return false;
        }
        this.OIList = new COIList();
        this.imageBank = new CImageBank(this);
        this.fontBank = new CFontBank();
        this.soundPlayer = new CSoundPlayer(this);
        this.soundBank = new CSoundBank(this.soundPlayer);
        this.musicPlayer = new CMusicPlayer(this);
        this.musicBank = new CMusicBank(this.musicPlayer);
        this.eventLoader = new CEventLoader();
        CCnd.initialize();
        CAct.initialize();
        CExp.initialize();
        CChunk cChunk = new CChunk();
        while (cChunk.chID != CChunk.CHUNK_LAST) {
            cChunk.readHeader(this.file);
            if (cChunk.chSize == 0) continue;
            long l = this.file.getFilePointer() + (long)cChunk.chSize;
            switch (cChunk.chID) {
                case 8739: {
                    this.loadAppHeader();
                    this.frameOffsets = new long[this.gaNbFrames];
                    break;
                }
                case 8773: {
                    this.loadAppHeader2();
                    break;
                }
                case 8754: {
                    this.loadGlobalValues();
                    break;
                }
                case 8755: {
                    this.loadGlobalStrings();
                    break;
                }
                case 8745: 
                case 8767: {
                    this.OIList.preLoad(this.file);
                    break;
                }
                case 8747: {
                    this.loadFrameHandles(cChunk.chSize);
                    break;
                }
                case 13107: {
                    this.frameOffsets[this.frameMaxIndex] = this.file.getFilePointer();
                    CChunk cChunk2 = new CChunk();
                    while (cChunk2.chID != 32639) {
                        cChunk2.readHeader(this.file);
                        if (cChunk2.chSize == 0) continue;
                        long l2 = this.file.getFilePointer() + (long)cChunk2.chSize;
                        this.file.seek(l2);
                    }
                    ++this.frameMaxIndex;
                    break;
                }
                case 8756: {
                    this.extLoader = new CExtLoader(this);
                    this.extLoader.loadList(this.file);
                    break;
                }
                case 8760: {
                    int n4 = this.file.readAInt();
                    this.embeddedFiles = new CEmbeddedFile[n4];
                    for (n = 0; n < n4; ++n) {
                        this.embeddedFiles[n] = new CEmbeddedFile(this);
                        this.embeddedFiles[n].preLoad();
                    }
                    break;
                }
                case 26214: {
                    this.imageBank.preLoad(this.file);
                    break;
                }
                case 26215: {
                    this.fontBank.preLoad(this.file);
                    break;
                }
                case 26216: {
                    this.soundBank.preLoad(this.file);
                    break;
                }
                case 26217: {
                    this.musicBank.preLoad(this.file);
                }
            }
            this.file.seek(l);
        }
        this.soundPlayer.setMultipleSounds((this.gaFlags & 0x400) != 0);
        this.rotatePlayerKeys();
        return true;
    }

    public boolean startApplication() {
        this.displayType = -1;
        this.appRunningState = 0;
        this.currentFrame = -2;
        return true;
    }

    public void createDisplayCanvas() {
        String string = "Application.CCanvasCheck";
        this.canvasWidth = this.gaCxWin;
        this.canvasHeight = this.gaCyWin;
        try {
            Class<?> clazz = Class.forName(string);
            CCanvasCheck cCanvasCheck = (CCanvasCheck)((Object)clazz.newInstance());
            if (cCanvasCheck != null) {
                cCanvasCheck.setFullScreenMode(true);
                this.canvasWidth = cCanvasCheck.getCanvasWidth();
                this.canvasHeight = cCanvasCheck.getCanvasHeight();
                this.bGoodCanvas = true;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        this.canvas = new CCanvas(this);
        this.canvas.setFullScreenMode(true);
        this.display.setCurrent((Displayable)this.canvas);
        this.oldOrientation = this.getOrientation();
    }

    public void centerDisplay() {
        if ((this.gaNewFlags & 0x80) != 0) {
            this.xOffset = 0;
            this.yOffset = 0;
        } else if (this.frame != null) {
            if (this.screenRotate == 0) {
                this.xOffset = this.canvasWidth / 2 - this.frame.leEditWinWidth / 2;
                this.yOffset = this.canvasHeight / 2 - this.frame.leEditWinHeight / 2;
            } else {
                this.xOffset = this.canvasWidth / 2 - this.frame.leEditWinHeight / 2;
                this.yOffset = this.canvasHeight / 2 - this.frame.leEditWinWidth / 2;
            }
        }
    }

    public int getRotation() {
        return this.screenRotate;
    }

    public void setRotation(int n) {
        if (n != this.screenRotate && n >= 0 && n <= 2) {
            this.screenRotate = n;
            this.centerDisplay();
            this.rotatePlayerKeys();
            this.winMan.bEraseBackground = true;
        }
    }

    public int getOrientation() {
        if (this.canvasWidth > this.canvasHeight) {
            return 1;
        }
        return 0;
    }

    public void checkOrientation(int n, int n2) {
        this.canvasWidth = n;
        this.canvasHeight = n2;
        this.centerDisplay();
        if (this.getOrientation() != this.oldOrientation) {
            this.oldOrientation = this.getOrientation();
            if (this.winMan != null) {
                this.winMan.bEraseBackground = true;
            }
        }
    }

    public void canvasShownOrHidden(boolean bl) {
        if (this.frame != null && this.run != null) {
            this.run.rhQuit = bl ? (short)0 : (short)102;
        }
    }

    public boolean playApplication() {
        int n = 0;
        boolean bl = true;
        boolean bl2 = true;
        block8: do {
            switch (this.appRunningState) {
                case 0: {
                    this.initGlobal();
                    this.nextFrame = this.startFrame;
                    this.appRunningState = 1;
                    this.killGlobalData();
                    break;
                }
                case 1: {
                    n = this.startTheFrame();
                    break;
                }
                case 2: {
                    if (!this.loopFrameFadeIn()) {
                        this.endFrameFadeIn();
                        if (this.appRunningState != 6 && this.appRunningState != 0) continue block8;
                        this.endFrame();
                        break;
                    }
                    bl = false;
                    break;
                }
                case 3: {
                    if (!this.loopFrame()) {
                        if (this.startFrameFadeOut()) {
                            this.appRunningState = 4;
                            break;
                        }
                        this.endFrame();
                        break;
                    }
                    bl = false;
                    break;
                }
                case 4: {
                    if (!this.loopFrameFadeOut()) {
                        this.endFrameFadeOut();
                        if (this.appRunningState != 6 && this.appRunningState != 0) continue block8;
                        this.endFrame();
                        break;
                    }
                    bl = false;
                    break;
                }
                case 5: {
                    this.endFrame();
                    break;
                }
                default: {
                    bl = false;
                }
            }
        } while (bl && n == 0 && !this.quit);
        if (n != 0) {
            this.appRunningState = 6;
        }
        if (this.appRunningState == 6) {
            bl2 = false;
        }
        return bl2;
    }

    public void endApplication() {
        this.soundPlayer.stopAllSounds();
        this.musicPlayer.stopAllMusics();
        this.soundBank.closeAllSounds();
        this.musicBank.closeAllMusics();
        if (this.file != null) {
            this.file.close();
        }
        this.midlet.notifyDestroyed();
    }

    /*
     * Unable to fully structure code
     */
    public int startTheFrame() {
        var1_1 = 0;
        var2_2 = null;
        if (this.nextFrame == this.currentFrame) ** GOTO lbl9
        this.frame = new CRunFrame(this);
        if (!this.frame.loadFullFrame(this.nextFrame)) {
            var1_1 = -1;
        } else {
            this.currentFrame = this.nextFrame;
lbl9:
            // 2 sources

            this.frame.leY = 0;
            this.frame.leX = 0;
            this.frame.leLastScrlY = 0;
            this.frame.leLastScrlX = 0;
            this.frame.rhOK = false;
            this.frame.levelQuit = 0;
            var3_3 = Math.min(this.gaCxWin, this.frame.leWidth);
            var4_4 = Math.min(this.gaCyWin, this.frame.leHeight);
            this.frame.leEditWinWidth = var3_3;
            this.frame.leEditWinHeight = var4_4;
            if (this.editWin != null && this.frame.fadeIn != null) {
                var2_2 = Image.createImage((int)var3_3, (int)var4_4);
                var5_5 = var2_2.getGraphics();
                var5_5.drawImage(this.editWin, 0, 0, 20);
            }
            if (this.editWin == null || this.editWin != null && (var3_3 != this.editWin.getWidth() || var4_4 != this.editWin.getHeight())) {
                this.editWin = Image.createImage((int)var3_3, (int)var4_4);
                this.g2EditWin = this.editWin.getGraphics();
            }
            if (this.winMan == null) {
                this.winMan = new CWindowManager(this.frame.leEditWinWidth, this.frame.leEditWinHeight);
                this.winMan.setApp(this);
            } else {
                this.winMan.winResetZones();
            }
            if (this.spritesBack == null || this.spritesBack != null && (this.spritesBack.getWidth() != this.frame.leEditWinWidth || this.spritesBack.getHeight() != this.frame.leEditWinHeight)) {
                this.spritesBack = Image.createImage((int)this.frame.leEditWinWidth, (int)this.frame.leEditWinHeight);
            }
            var5_6 = this.frame.maxObjects * 2;
            for (var6_7 = 0; var6_7 < this.frame.LOList.nIndex; var6_7 = (int)((short)(var6_7 + 1))) {
                var7_8 = this.frame.LOList.getLOFromIndex((short)var6_7);
                if (var7_8.loLayer <= 0) continue;
                var8_9 = this.OIList.getOIFromHandle(var7_8.loOiHandle);
                if (var8_9.oiType >= 2) continue;
                ++var5_6;
            }
            var6_7 = this.frame.evtProg.getCollisionFlags();
            this.frame.leFlags |= 32;
            this.frame.colMask = null;
            if ((this.frame.leFlags & 32) != 0 && ((var6_7 |= this.frame.getMaskBits()) & 3) != 0) {
                this.frame.colMask = CColMask.create(-64, -16, this.frame.leWidth + 64, this.frame.leHeight + 16, var6_7);
            }
            this.newResetCptVbl();
            this.appRunningState = 3;
        }
        this.centerDisplay();
        this.flushKeyboard();
        this.run = new CRun(this);
        this.run.initRunLoop(this.frame.fadeIn != null);
        this.frame.rhPtr = this.run;
        if (this.frame.fadeIn != null) {
            if (!this.loopFrame()) {
                this.appRunningState = 5;
            } else if (!this.startFrameFadeIn(var2_2)) {
                this.appRunningState = 3;
            }
        } else {
            this.appRunningState = 3;
        }
        if (var1_1 != 0) {
            this.appRunningState = 6;
        }
        return var1_1;
    }

    public boolean loopFrame() {
        if (this.frame.levelQuit == 0) {
            this.frame.levelQuit = this.run.doRunLoop();
        }
        return this.frame.levelQuit == 0;
    }

    public void endFrame() {
        int n = this.run.killRunLoop(this.frame.levelQuit, false);
        if ((this.gaNewFlags & 4) != 0) {
            this.appRunningState = 6;
        } else {
            switch (CServices.LOWORD(n)) {
                case 1: {
                    this.nextFrame = this.currentFrame + 1;
                    this.appRunningState = 1;
                    break;
                }
                case 2: {
                    this.nextFrame = Math.max(0, this.currentFrame - 1);
                    this.appRunningState = 1;
                    break;
                }
                case 3: {
                    this.appRunningState = 1;
                    if ((CServices.HIWORD(n) & 0x8000) != 0) {
                        this.nextFrame = CServices.HIWORD(n) & Short.MAX_VALUE;
                        if (this.nextFrame >= this.gaNbFrames) {
                            this.nextFrame = this.gaNbFrames - 1;
                        }
                        if (this.nextFrame >= 0) break;
                        this.nextFrame = 0;
                        break;
                    }
                    if (CServices.HIWORD(n) < this.frameMaxHandle) {
                        this.nextFrame = this.frameHandleToIndex[CServices.HIWORD(n)];
                        if (this.nextFrame != -1) break;
                        this.nextFrame = this.currentFrame + 1;
                        break;
                    }
                    this.nextFrame = this.currentFrame + 1;
                    break;
                }
                case 4: {
                    this.appRunningState = 0;
                    this.nextFrame = this.startFrame;
                    break;
                }
                default: {
                    this.appRunningState = 6;
                }
            }
        }
        if (this.appRunningState == 1 && (this.nextFrame < 0 || this.nextFrame >= this.gaNbFrames)) {
            this.appRunningState = 6;
        }
        this.flushKeyboard();
        if (this.appRunningState != 1 || this.nextFrame != this.currentFrame) {
            this.winMan = null;
            this.frame = null;
            this.run = null;
            this.currentFrame = -1;
        }
    }

    public void killGlobalData() {
        this.adGO = null;
    }

    public boolean startFrameFadeIn(Image image) {
        Image image2 = null;
        Image image3 = null;
        CTransitionData cTransitionData = this.frame.fadeIn;
        if (cTransitionData != null) {
            image2 = Image.createImage((int)this.editWin.getWidth(), (int)this.editWin.getHeight());
            image3 = Image.createImage((int)this.editWin.getWidth(), (int)this.editWin.getHeight());
            Graphics graphics = image3.getGraphics();
            graphics.drawImage(this.editWin, 0, 0, 20);
            if ((cTransitionData.transFlags & 1) != 0) {
                graphics = image2.getGraphics();
                graphics.setColor(cTransitionData.transColor);
                graphics.fillRect(0, 0, image2.getWidth(), image3.getHeight());
            } else {
                graphics = image2.getGraphics();
                graphics.setColor(this.gaBorderColour);
                graphics.fillRect(0, 0, image2.getWidth(), image3.getHeight());
                if (image != null) {
                    graphics.drawImage(image, (image2.getWidth() - image.getWidth()) / 2, (image2.getHeight() - image.getHeight()) / 2, 20);
                }
            }
            this.g2EditWin.drawImage(image2, 0, 0, 20);
            this.frame.pTrans = this.getTransitionManager().createTransition(cTransitionData, this.editWin, image2, image3);
            if (this.frame.pTrans != null) {
                this.appRunningState = 2;
                return true;
            }
        }
        this.run.createRemainingFrameObjects();
        this.endFrameFadeIn();
        return false;
    }

    public boolean loopFrameFadeIn() {
        if (this.frame.pTrans != null) {
            if (this.frame.pTrans.isCompleted()) {
                this.endFrameFadeIn();
                return false;
            }
            CRect[] cRectArray = this.frame.pTrans.stepDraw(1);
            if (cRectArray == null) {
                this.winMan.winAddZone(null);
            } else {
                for (int i = 0; i < cRectArray.length; ++i) {
                    this.winMan.winAddZone(cRectArray[i]);
                }
            }
            this.canvas.repaint();
            return true;
        }
        return false;
    }

    public boolean endFrameFadeIn() {
        if (this.frame.pTrans != null) {
            this.frame.pTrans.end();
            this.frame.pTrans = null;
            if (this.appRunningState == 2) {
                this.appRunningState = 3;
            }
            this.run.createRemainingFrameObjects();
        }
        return true;
    }

    public boolean startFrameFadeOut() {
        Image image = null;
        Image image2 = null;
        CTransitionData cTransitionData = this.frame.fadeOut;
        if (cTransitionData != null) {
            image = Image.createImage((int)this.editWin.getWidth(), (int)this.editWin.getHeight());
            image2 = Image.createImage((int)this.editWin.getWidth(), (int)this.editWin.getHeight());
            Graphics graphics = image.getGraphics();
            graphics.drawImage(this.editWin, 0, 0, 20);
            graphics = image2.getGraphics();
            if ((cTransitionData.transFlags & 1) != 0) {
                graphics.setColor(cTransitionData.transColor);
            } else {
                graphics.setColor(0);
            }
            graphics.fillRect(0, 0, image2.getWidth(), image2.getHeight());
            this.frame.pTrans = this.getTransitionManager().createTransition(cTransitionData, this.editWin, image, image2);
            this.appRunningState = 4;
            return true;
        }
        this.endFrameFadeOut();
        return false;
    }

    public boolean loopFrameFadeOut() {
        if (this.frame.pTrans != null) {
            if (this.frame.pTrans.isCompleted()) {
                this.endFrameFadeOut();
                return false;
            }
            CRect[] cRectArray = this.frame.pTrans.stepDraw(2);
            if (cRectArray == null) {
                this.winMan.winAddZone(null);
            } else {
                for (int i = 0; i < cRectArray.length; ++i) {
                    this.winMan.winAddZone(cRectArray[i]);
                }
            }
            this.canvas.repaint();
        }
        return true;
    }

    public boolean endFrameFadeOut() {
        if (this.frame.pTrans != null) {
            this.frame.pTrans.end();
            this.frame.pTrans = null;
            if (this.appRunningState == 4) {
                this.appRunningState = 5;
            }
        }
        return true;
    }

    public void newResetCptVbl() {
        this.refTime = System.currentTimeMillis();
    }

    public int newGetCptVbl() {
        return (int)((double)(System.currentTimeMillis() - this.refTime) * (double)this.gaFrameRate / 1000.0);
    }

    public void initGlobal() {
        int n;
        this.lives = new int[4];
        for (n = 0; n < 4; ++n) {
            this.lives[n] = ~this.gaLivesInit;
        }
        this.scores = new int[4];
        for (n = 0; n < 4; ++n) {
            this.scores[n] = ~this.gaScoreInit;
        }
        this.playerNames = new String[4];
        for (n = 0; n < 4; ++n) {
            this.playerNames[n] = new String("");
        }
        this.gValues = new CArrayList();
        for (n = 0; n < this.nGlobalValuesInit; ++n) {
            this.gValues.add(new CValue(this.globalValuesInit[n]));
        }
        this.tempGValue = new CValue();
        this.gStrings = new CArrayList();
        for (n = 0; n < this.nGlobalStringsInit; ++n) {
            this.gStrings.add(new String(this.globalStringsInit[n]));
        }
    }

    public int[] getLives() {
        return this.lives;
    }

    public int[] getScores() {
        return this.scores;
    }

    public short[] getCtrlType() {
        return this.pcCtrlType;
    }

    public short[][] getCtrlKeys() {
        return this.pcCtrlKeys;
    }

    public CArrayList getGlobalValues() {
        return this.gValues;
    }

    public int getNGlobalValues() {
        if (this.gValues != null) {
            return this.gValues.size();
        }
        return 0;
    }

    public CArrayList getGlobalStrings() {
        return this.gStrings;
    }

    public int getNGlobalStrings() {
        if (this.gStrings != null) {
            return this.gStrings.size();
        }
        return 0;
    }

    public CArrayList checkGlobalValue(int n) {
        CArrayList cArrayList = this.getGlobalValues();
        if (n < 0 || n > 1000) {
            return null;
        }
        int n2 = cArrayList.size();
        if (n >= n2) {
            cArrayList.ensureCapacity(n);
            for (int i = n2; i <= n; ++i) {
                cArrayList.add(new CValue());
            }
        }
        return cArrayList;
    }

    public CValue getGlobalValueAt(int n) {
        CArrayList cArrayList = this.checkGlobalValue(n);
        if (cArrayList != null) {
            return (CValue)cArrayList.get(n);
        }
        return this.tempGValue;
    }

    public void setGlobalValueAt(int n, CValue cValue) {
        CArrayList cArrayList = this.checkGlobalValue(n);
        if (cArrayList != null) {
            ((CValue)cArrayList.get(n)).forceValue(cValue);
        }
    }

    public CArrayList checkGlobalString(int n) {
        CArrayList cArrayList = this.getGlobalStrings();
        if (n < 0 || n > 1000) {
            return null;
        }
        int n2 = cArrayList.size();
        if (n >= n2) {
            cArrayList.ensureCapacity(n);
            for (int i = n2; i <= n; ++i) {
                cArrayList.add(new String(""));
            }
        }
        return cArrayList;
    }

    public String getGlobalStringAt(int n) {
        CArrayList cArrayList = this.checkGlobalString(n);
        if (cArrayList != null) {
            return (String)cArrayList.get(n);
        }
        return "";
    }

    public void setGlobalStringAt(int n, String string) {
        CArrayList cArrayList = this.checkGlobalString(n);
        if (cArrayList != null) {
            cArrayList.set(n, new String(string));
        }
    }

    public void loadAppHeader() {
        int n;
        this.file.skipBytes(4);
        this.gaFlags = this.file.readAShort();
        this.gaNewFlags = this.file.readAShort();
        this.gaMode = this.file.readAShort();
        this.gaOtherFlags = this.file.readAShort();
        this.gaCxWin = this.file.readAShort();
        this.gaCyWin = this.file.readAShort();
        this.gaScoreInit = this.file.readAInt();
        this.gaLivesInit = this.file.readAInt();
        for (n = 0; n < 4; ++n) {
            this.pcCtrlType[n] = this.file.readAShort();
        }
        for (n = 0; n < 4; ++n) {
            for (int i = 0; i < 8; ++i) {
                this.controlKeys[n][i] = CKeyConvert.getJavaKey(this.file.readAShort());
            }
        }
        this.gaBorderColour = this.file.readAColor();
        this.gaNbFrames = this.file.readAInt();
        this.gaFrameRate = this.file.readAInt();
        this.gaMDIWindowMenu = this.file.readByte();
        this.file.skipBytes(3);
    }

    public void rotatePlayerKeys() {
        switch (this.screenRotate) {
            case 0: {
                for (int i = 0; i < 4; ++i) {
                    for (int j = 0; j < 8; ++j) {
                        this.pcCtrlKeys[i][j] = this.controlKeys[i][j];
                    }
                }
                break;
            }
            case 1: {
                for (int i = 0; i < 4; ++i) {
                    this.pcCtrlKeys[i][0] = this.controlKeys[i][3];
                    this.pcCtrlKeys[i][1] = this.controlKeys[i][2];
                    this.pcCtrlKeys[i][2] = this.controlKeys[i][0];
                    this.pcCtrlKeys[i][3] = this.controlKeys[i][1];
                }
                break;
            }
            case 2: {
                for (int i = 0; i < 4; ++i) {
                    this.pcCtrlKeys[i][0] = this.controlKeys[i][2];
                    this.pcCtrlKeys[i][1] = this.controlKeys[i][3];
                    this.pcCtrlKeys[i][2] = this.controlKeys[i][1];
                    this.pcCtrlKeys[i][3] = this.controlKeys[i][0];
                }
                break;
            }
        }
    }

    public void rotateMouse() {
        int n = this.mouseX;
        int n2 = this.mouseY;
        switch (this.screenRotate) {
            case 1: {
                this.mouseX = n2;
                this.mouseY = this.canvasWidth - n;
                break;
            }
            case 2: {
                this.mouseX = this.canvasHeight - n2;
                this.mouseY = n;
            }
        }
    }

    public void loadAppHeader2() {
        this.hdr2Options = this.file.readAInt();
        this.file.readAInt();
        this.file.readAInt();
        this.file.readAShort();
        this.screenRotate = this.file.readAShort();
    }

    public void loadGlobalValues() {
        this.nGlobalValuesInit = this.file.readAShort();
        this.globalValuesInit = new int[this.nGlobalValuesInit];
        this.globalValuesInitTypes = new byte[this.nGlobalValuesInit];
        for (int i = 0; i < this.nGlobalValuesInit; ++i) {
            this.globalValuesInit[i] = this.file.readAInt();
        }
        this.file.read(this.globalValuesInitTypes);
    }

    public void loadGlobalStrings() {
        this.nGlobalStringsInit = (short)this.file.readAInt();
        this.globalStringsInit = new String[this.nGlobalStringsInit];
        for (int i = 0; i < this.nGlobalStringsInit; ++i) {
            this.globalStringsInit[i] = this.file.readAString();
        }
    }

    public void loadFrameHandles(int n) {
        this.frameMaxHandle = (short)(n / 2);
        this.frameHandleToIndex = new short[this.frameMaxHandle];
        for (int i = 0; i < this.frameMaxHandle; ++i) {
            this.frameHandleToIndex[i] = this.file.readAShort();
        }
    }

    public short HCellToNCell(short s) {
        if (this.frameHandleToIndex == null || s == -1 || s >= this.frameMaxHandle) {
            return -1;
        }
        return this.frameHandleToIndex[s];
    }

    CEmbeddedFile getEmbeddedFile(String string) {
        if (this.embeddedFiles != null) {
            for (int i = 0; i < this.embeddedFiles.length; ++i) {
                if (!this.embeddedFiles[i].path.equalsIgnoreCase(string)) continue;
                return this.embeddedFiles[i];
            }
        }
        return null;
    }

    public CFile openHFile(String string) {
        byte[] byArray;
        CEmbeddedFile cEmbeddedFile;
        CFile cFile = null;
        if (string != null && string.length() > 0 && (cEmbeddedFile = this.getEmbeddedFile(string)) != null && (byArray = cEmbeddedFile.openMem()) != null) {
            cFile = new CFile(byArray);
            cFile.setUnicode(this.bUnicode);
            return cFile;
        }
        return null;
    }

    public void closeHFile(CFile cFile) {
        if (cFile != null) {
            cFile.close();
        }
    }

    public void setCursorPos(int n, int n2) {
        this.mouseX = n;
        this.mouseY = n2;
    }

    public CTransitionManager getTransitionManager() {
        if (this.transitionManager == null) {
            this.transitionManager = new CTransitionManager(this);
        }
        return this.transitionManager;
    }

    public void keyPressed(int n, boolean bl) {
        this.specialKeyCode = bl ? n : 0;
        if (n >= 0 && n < 64) {
            if (bl) {
                this.keyBuffer[n] = 1;
                if (this.run != null && this.run.rhEvtProg != null) {
                    CSysEventKeyDown cSysEventKeyDown = new CSysEventKeyDown(n);
                    this.sysEvents.add(cSysEventKeyDown);
                }
            } else {
                this.keyBuffer[n] = 0;
            }
        }
    }

    public void flushKeyboard() {
        for (int i = 0; i < 64; ++i) {
            this.keyBuffer[i] = 0;
        }
    }

    public boolean getKeyState(int n) {
        if (n < 64) {
            return this.keyBuffer[n] != 0;
        }
        return false;
    }

    public void debugOut(String string) {
        if (this.debugList == null) {
            this.debugList = new CArrayList();
        }
        this.debugList.add(new String(string));
        if (this.canvas != null) {
            this.canvas.debugPos = this.debugList.size() - 10;
            if (this.canvas.debugPos < 0) {
                this.canvas.debugPos = 0;
            }
            this.canvas.repaint();
        }
    }
}

