/*
 * Decompiled with CFR 0.152.
 */
import Movements.CRunMvtExtension;
import Services.CBinaryFile;
import Services.CPoint;
import Services.CServices;

public class CRunMvtpinball
extends CRunMvtExtension {
    public static final int EFLAG_MOVEATSTART = 1;
    public static final int MFLAG_STOPPED = 1;
    int m_dwInitialSpeed;
    int m_dwDeceleration;
    int m_dwGravity;
    int m_dwInitialDir;
    int m_dwFlags;
    double m_gravity;
    double m_xVector;
    double m_yVector;
    double m_angle;
    double m_X;
    double m_Y;
    double m_deceleration;
    int m_flags;

    public void initialize(CBinaryFile cBinaryFile) {
        cBinaryFile.skipBytes(1);
        this.m_dwInitialSpeed = cBinaryFile.readInt();
        this.m_dwDeceleration = cBinaryFile.readInt();
        this.m_dwGravity = cBinaryFile.readInt();
        this.m_dwInitialDir = cBinaryFile.readInt();
        this.m_dwFlags = cBinaryFile.readInt();
        this.m_X = this.ho.hoX;
        this.m_Y = this.ho.hoY;
        this.ho.roc.rcSpeed = this.m_dwInitialSpeed;
        this.ho.roc.rcDir = this.dirAtStart(this.m_dwInitialDir);
        double d = (double)(this.ho.roc.rcDir * 2) * Math.PI / 32.0;
        this.m_gravity = this.m_dwGravity;
        this.m_deceleration = this.m_dwDeceleration;
        this.m_xVector = (double)this.ho.roc.rcSpeed * Math.cos(d);
        this.m_yVector = (double)(-this.ho.roc.rcSpeed) * Math.sin(d);
        this.m_flags = 0;
        if ((this.m_dwFlags & 1) == 0) {
            this.m_flags |= 1;
        }
    }

    double getAngle(double d, double d2) {
        double d3 = Math.sqrt(d * d + d2 * d2);
        if (d3 == 0.0) {
            return 0.0;
        }
        double d4 = CServices.acos(d / d3);
        if (d2 > 0.0) {
            d4 = Math.PI * 2 - d4;
        }
        return d4;
    }

    public double getVector(double d, double d2) {
        return Math.sqrt(d * d + d2 * d2);
    }

    public void kill() {
    }

    public boolean move() {
        if ((this.m_flags & 1) != 0) {
            this.animations(0);
            this.collisions();
            return false;
        }
        this.m_yVector += this.m_gravity / 10.0;
        double d = this.getAngle(this.m_xVector, this.m_yVector);
        double d2 = this.getVector(this.m_xVector, this.m_yVector);
        double d3 = this.m_deceleration;
        if ((this.ho.hoAdRunHeader.rhFrame.leFlags & 0x8000) != 0) {
            d3 *= this.ho.hoAdRunHeader.rh4MvtTimerCoef;
        }
        if ((d2 -= d3 / 50.0) < 0.0) {
            d2 = 0.0;
        }
        this.m_xVector = d2 * Math.cos(d);
        this.m_yVector = -d2 * Math.sin(d);
        d3 = this.m_xVector;
        if ((this.ho.hoAdRunHeader.rhFrame.leFlags & 0x8000) != 0) {
            d3 *= this.ho.hoAdRunHeader.rh4MvtTimerCoef;
        }
        this.m_X += d3 / 10.0;
        d3 = this.m_yVector;
        if ((this.ho.hoAdRunHeader.rhFrame.leFlags & 0x8000) != 0) {
            d3 *= this.ho.hoAdRunHeader.rh4MvtTimerCoef;
        }
        this.m_Y += d3 / 10.0;
        this.ho.roc.rcSpeed = (int)d2;
        if (this.ho.roc.rcSpeed > 100) {
            this.ho.roc.rcSpeed = 100;
        }
        this.ho.roc.rcDir = (int)(d * 32.0 / (Math.PI * 2));
        this.animations(1);
        this.ho.hoX = (int)this.m_X;
        this.ho.hoY = (int)this.m_Y;
        this.collisions();
        return true;
    }

    public void setPosition(int n, int n2) {
        this.ho.hoX = n;
        this.ho.hoY = n2;
        this.m_X = n;
        this.m_Y = n2;
    }

    public void setXPosition(int n) {
        this.ho.hoX = n;
        this.m_X = n;
    }

    public void setYPosition(int n) {
        this.ho.hoY = n;
        this.m_Y = n;
    }

    public void stop(boolean bl) {
        this.m_flags |= 1;
    }

    public void bounce(boolean bl) {
        if (!bl) {
            this.m_xVector = -this.m_xVector;
            this.m_yVector = -this.m_yVector;
            return;
        }
        CPoint cPoint = new CPoint();
        this.approachObject(this.ho.hoX, this.ho.hoY, this.ho.roc.rcOldX, this.ho.roc.rcOldY, 0, 1, cPoint);
        this.ho.hoX = cPoint.x;
        this.ho.hoY = cPoint.y;
        this.m_X = cPoint.x;
        this.m_Y = cPoint.y;
        double d = this.getAngle(this.m_xVector, this.m_yVector);
        double d2 = this.getVector(this.m_xVector, this.m_yVector);
        double d3 = -1000.0;
        for (double d4 = 0.0; d4 < Math.PI * 2; d4 += 0.09817477042468103) {
            double d5;
            double d6;
            double d7 = 16.0 * Math.cos(d + d4);
            double d8 = this.m_X + d7;
            if (!this.testPosition((int)d8, (int)(d6 = this.m_Y + (d5 = -16.0 * Math.sin(d + d4))), 0, 1, false)) continue;
            d3 = d4;
            break;
        }
        if (d3 == -1000.0) {
            this.m_xVector = -this.m_xVector;
            this.m_yVector = -this.m_yVector;
        } else {
            if ((d += d3 * 2.0) > Math.PI * 2) {
                d -= Math.PI * 2;
            }
            this.m_xVector = d2 * Math.cos(d);
            this.m_yVector = -d2 * Math.sin(d);
        }
    }

    public void reverse() {
        this.m_xVector = -this.m_xVector;
        this.m_yVector = -this.m_yVector;
    }

    public void start() {
        this.m_flags &= 0xFFFFFFFE;
    }

    public void setSpeed(int n) {
        this.ho.roc.rcSpeed = n;
        double d = this.getAngle(this.m_xVector, this.m_yVector);
        double d2 = this.getVector(this.m_xVector, this.m_yVector);
        this.m_xVector = (double)n * Math.cos(d);
        this.m_yVector = (double)(-n) * Math.sin(d);
    }

    public void setMaxSpeed(int n) {
    }

    public void setDir(int n) {
        this.ho.roc.rcDir = n;
        double d = this.getAngle(this.m_xVector, this.m_yVector);
        double d2 = this.getVector(this.m_xVector, this.m_yVector);
        d = (double)n * 2.0 * Math.PI / 32.0;
        this.m_xVector = d2 * Math.cos(d);
        this.m_yVector = -d2 * Math.sin(d);
    }

    public void setAcc(int n) {
    }

    public void setDec(int n) {
    }

    public void setRotSpeed(int n) {
    }

    public void set8Dirs(int n) {
    }

    public void setGravity(int n) {
        this.m_gravity = n;
    }

    public int extension(int n, int n2) {
        return 0;
    }

    public double actionEntry(int n) {
        switch (n) {
            default: 
        }
        this.m_gravity = this.getParamDouble();
        return 0.0;
    }

    public int getSpeed() {
        return this.ho.roc.rcSpeed;
    }

    public int getAcceleration() {
        return 0;
    }

    public int getDeceleration() {
        return (int)this.m_deceleration;
    }

    public int getGravity() {
        return (int)this.m_gravity;
    }
}

