/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.Image2;
import game.MultiOutPut;
import game.Opponent;
import game.Sound;
import game.game;
import java.util.Random;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.GameCanvas;
import javax.microedition.rms.RecordStore;

class GameScreen
extends GameCanvas
implements Runnable {
    static final byte ADVENTURE = 1;
    static final byte AGRESSIVE = 2;
    static final byte AILERON = 33;
    static final byte AILERON_MENU = 37;
    static final byte AVAILABLE = 0;
    static final short[] BACK_X = new short[]{85, 85, 100, 95, 75, 85};
    static final short BACK_Y = 166;
    static final byte BEACH = 0;
    static final byte BG_1 = 4;
    static final byte BG_2 = 5;
    static final byte BG_3 = 6;
    static final byte CADRE = 29;
    static final byte CAR = 19;
    static final byte CAR_MENU = 26;
    static final byte CIRCUIT = 9;
    static final byte CIRCUIT_MENU = 25;
    static final byte CURSEUR_D = 32;
    static final byte CURSEUR_G = 31;
    static final byte DECOR_1 = 7;
    static final byte DECOR_2 = 8;
    static final byte DEPART1 = 52;
    static final byte DEPART2 = 53;
    static final byte DESERT = 4;
    static final byte DIR_LEFT = 0;
    static final byte DIR_RIGHT = 1;
    static final byte D_AILERON = 0;
    static final byte D_LEVEL = 4;
    static final byte D_MONEY = 3;
    static final byte D_NEON = 2;
    static final byte D_PHARES = 1;
    static final byte ENEMI_1 = 45;
    static final byte ENEMI_2 = 46;
    static final byte ENEMI_3 = 47;
    static final byte FINAL = 3;
    static final byte FINISH = 23;
    static final byte FLAGS = 10;
    static final byte FLAMME = 13;
    static final byte FLASH = 51;
    static final byte FLECHE_D = 28;
    static final byte FLECHE_G = 27;
    static final byte FONT_1 = 2;
    static final byte FREE_RACE = 0;
    static final byte GARAGISTE = 40;
    static final byte GIRL = 30;
    static final byte GIRL_EYES = 43;
    static final byte GIRL_MOUTH = 44;
    static final byte G_END = 4;
    static final byte G_EYES = 41;
    static final byte G_INIT = 0;
    static final byte G_LOOSE = 5;
    static final byte G_MOUTH = 42;
    static final byte G_PAUSE = 3;
    static final byte G_PLAYING = 2;
    static final byte G_START = 1;
    static final byte HOLLYWOOD = 3;
    static final byte INTRO = 0;
    static final byte JAUGE = 12;
    static final byte KEY_DOWN = 3;
    static final byte KEY_LEFT = 4;
    static final byte KEY_NUM0 = 6;
    static final byte KEY_NUM1 = 7;
    static final byte KEY_NUM2 = 8;
    static final byte KEY_NUM3 = 9;
    static final byte KEY_NUM4 = 10;
    static final byte KEY_NUM5 = 11;
    static final byte KEY_NUM6 = 12;
    static final byte KEY_NUM7 = 13;
    static final byte KEY_NUM8 = 14;
    static final byte KEY_NUM9 = 15;
    static final byte KEY_OK = 18;
    static final byte KEY_POUND = 17;
    static final byte KEY_RIGHT = 5;
    static final byte KEY_SOFT1 = 0;
    static final byte KEY_SOFT2 = 1;
    static final byte KEY_STAR = 16;
    static final byte KEY_UP = 2;
    static final byte LA = 1;
    static final byte LAP = 20;
    static final byte LASVEGAS = 5;
    static final short LOAD_Y = 80;
    static final byte LOCKED = 1;
    static final byte LOGO = 11;
    static final byte MAX_OPPONENT = 7;
    static final byte MENU = 1;
    static final byte MUSIC_OFF = 1;
    static final byte MUSIC_ON = 0;
    static final byte M_BRIEFING = 9;
    static final byte M_CHOOSE_KART = 8;
    static final byte M_CHOOSE_LANG = 5;
    static final byte M_CHOOSE_LVL = 7;
    static final byte M_CHOOSE_MODE = 6;
    static final byte M_CREDITS = 4;
    static final byte M_END = 13;
    static final byte M_GARAGE = 11;
    static final byte M_HELP = 1;
    static final byte M_INTRO = 12;
    static final byte M_MAIN = 0;
    static final byte M_OPTIONS = 3;
    static final byte M_RESTART = 10;
    static final byte M_SCORES = 2;
    static final byte NASCAR = 2;
    static final byte NB_DATA = 5;
    static final byte NB_IMG = 54;
    static final byte NB_KEY = 19;
    static final byte NEON1 = 35;
    static final byte NEON2 = 36;
    static final byte NEON_MENU = 39;
    static final byte NICE = 0;
    static final byte NITRO = 24;
    static final byte NONE = -1;
    static final byte NORMAL = 1;
    static final byte NUAGE_1 = 14;
    static final byte NUAGE_2 = 15;
    static final byte NUAGE_3 = 16;
    static final byte NUAGE_4 = 17;
    static final int OPTION = 100;
    static final byte OPTION_MONEY = 0;
    static final byte OPTION_NITRO = 1;
    static final byte OPTION_OIL = 2;
    static final byte O_MONEY = 48;
    static final byte O_NITRO = 49;
    static final byte O_OIL = 50;
    static final short PAUSE_X = 1;
    static final short PAUSE_Y = 166;
    static final byte PHARES = 34;
    static final byte PHARES_MENU = 38;
    static final short RECORD_SIZE = 40;
    static final int ROAD_LEFT = 37;
    static final int ROAD_MAX = 5;
    static final int ROAD_TOP = 128;
    static final int ROAD_WIDTH = 58;
    static final int SCR_H = 176;
    static final int SCR_W = 132;
    static final byte SKY = 3;
    static final byte SND_MENU = 1;
    static final byte SND_RACE1 = 2;
    static final byte SND_RACE2 = 3;
    static final byte SND_TITLE = 0;
    int SPEEDX_MAX = 6;
    static final byte S_EXIT = 6;
    static final byte S_GAME = 5;
    static final byte S_INTRO = 0;
    static final byte S_LOAD_BEGIN = 1;
    static final byte S_LOAD_GAME = 2;
    static final byte S_LOAD_MENU = 3;
    static final byte S_MENU = 4;
    static final short TITLE_Y = 12;
    static final int TURBO_MAX = 80;
    static final int X_INIT = 66;
    static final int X_MAX = 114;
    static final int X_MIN = 18;
    static final int Y1 = 0;
    static final int Y2 = 35;
    static final int Y_INIT = 174;
    static final int ZOOM_MAX = 4;
    int _X;
    int _Y;
    int _acc;
    byte _achat;
    boolean _back;
    long _begin;
    boolean _bend;
    int _bendReduction;
    int _bendX;
    int _bendY;
    int _bordColor1;
    int _bordColor2;
    byte _briefing;
    int _carX;
    int[][] _clouds;
    byte _colOpp;
    boolean _continue;
    int _cptArrowLeft;
    int _cptArrowRight;
    int _cptBend;
    int _cptBoost;
    int _cptCol;
    int _cptCurs;
    int _cptEnd;
    int _cptEscape;
    int _cptFps;
    int _cptLoad;
    int _cptMain;
    int _cptMsg;
    int _cptOffroad;
    int _cptOption;
    int _cptRace;
    int _cptReset;
    int _cptRoad;
    int _cptStart;
    int _cptStripe;
    byte _credit;
    byte _curMusic;
    byte _curs;
    int[] _data;
    byte _debriefing;
    int[] _decalX;
    byte _difficulty;
    long _endTime;
    boolean _enterScore;
    byte _escape;
    byte _finish;
    boolean _finishLine;
    int _finishY;
    int[][] _flashes;
    int _fps;
    int _frame;
    byte _gCurs;
    int _gameState;
    byte _garage;
    int _groundColor1;
    int _groundColor2;
    byte _help;
    int[] _highScores;
    Image2[] _img;
    boolean _inBend;
    byte _intro;
    byte _isMusic;
    byte _isVibro;
    byte _kart;
    boolean _kartMove;
    int _kartX;
    byte[] _keyMap;
    byte _lang;
    byte _lap;
    boolean _leftCol;
    byte _level;
    boolean _loadGarage;
    boolean _loadSoundGame = false;
    byte[] _locked = new byte[]{0, 1, 1, 1, 1, 1};
    boolean _loose;
    int _mainState = 0;
    Image2 _media;
    byte _menuDir;
    int _menuState;
    byte _mode;
    int _moneyRab;
    MultiOutPut _mu0 = null;
    byte _nbLap;
    byte _nbOpponent;
    byte _noControl;
    byte _object;
    byte _objectSize1;
    byte _objectSize2;
    int _objectX1;
    int _objectX2;
    int _objectX3;
    int _objectX4;
    int _objectY1;
    int _objectY2;
    boolean _ok;
    Opponent[] _opp;
    boolean _option;
    boolean _optionCatched;
    int _optionPos;
    byte _optionType;
    int _optionX;
    int _optionY;
    int _optionZoom;
    boolean _paint;
    byte _position;
    static final int[] _prize = new int[]{4000, 2000, 1000};
    byte _produit;
    static final byte[] _races;
    Random _rand = null;
    boolean _reset;
    int _returnState;
    static final int[] _reward;
    static final byte[][] _road;
    int _roadColor1;
    int _roadColor2;
    int _roadX;
    int _score;
    int _scroll1;
    int _scroll2;
    int _scroll3;
    long _sec;
    int _shadowY;
    boolean _showFPS = false;
    Sound _snd;
    int _speed;
    int _speedMax;
    int _speedX;
    long _startTime;
    static final byte[] _stats;
    static final byte[][] _stripes;
    long _t;
    int _time;
    long _tmp;
    static final int[][] _tuning;
    boolean _turbo;
    int _turboSize;
    int _vib;
    int _w0;
    int _w1;
    int _w2;
    int _w3;
    int _xLeft;
    int _xRight;
    boolean _z;
    long last_paint = 0L;
    game midlet;

    static {
        _reward = new int[]{200, 500, 1000, 2000, 3000, 5000, 10000};
        _stats = new byte[]{25, 25, 20, 30, 10, 25, 20, 30, 30};
        _tuning = new int[][]{{-3, 24, 54, 25, 51, -5, 4, 20}, {3, 23, 58, 26, 64, -7, 4, 25}, {3, 29, 55, 30, 58, -4, 3, 20}};
        _races = new byte[]{1, 3, 2, 5, 6, 7, 3, 5, 1, 7, 3, 3};
        _road = new byte[][]{{5, -2, 1, 1, 1, -2, 2, 1, 3, 1, 4, -2, 2, -2, 2, -3, 1, 1, 3, -2, 2, 1, 10, 0}, {5, 2, 3, 2, 2, 2, 8, 3, 2, 3, 3, -2, 6, 3, 2, 0}, {2, -2, 1, -2, 1, -2, 1, -2, 2, -2, 1, -2, 1, -2, 1, -2, 1, 0}, {4, 2, 2, 2, 1, 3, 2, -3, 4, 2, 1, 2, 1, 2, 5, -2, 2, 3, 2, 0}, {12, 3, 6, -3, 4, -3, 6, 3, 12, 2, 20, 0}, {1, -3, 2, 3, 4, 2, 4, -3, 4, -2, 5, 3, 3, -3, 6, -2, 1, -2, 1, -2, 2, 3, 3, 2, 4, -2, 2, -2, 1, -2, 1, 0}};
        _stripes = new byte[][]{{0, 0, 1, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1}, {0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1}, {1, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}};
    }

    public GameScreen(game game2) {
        super(false);
        this._clouds = new int[][]{{65, 77, 0}, {30, 65, 1}, {20, 45, 1}, {90, 55, 2}, {-10, 90, 2}};
        this.setFullScreenMode(true);
        this.midlet = game2;
        this.GameInit();
        new Thread(this).start();
    }

    int Abs(int n) {
        int n2 = n >= 0 ? n : 0 - n;
        return n2;
    }

    void Draw_Arrows(Graphics graphics) {
        if (this._cptArrowLeft == 0) {
            this._img[27].drawFrame(graphics, 0, 35, 0, 16 + 4);
        } else {
            this._img[27].drawFrame(graphics, 0, 35, 1, 16 + 4);
        }
        if (this._cptArrowRight == 0) {
            this._img[28].drawFrame(graphics, 132, 35, 0, 16 + 8);
        } else {
            this._img[28].drawFrame(graphics, 132, 35, 1, 16 + 8);
        }
        if (this._cptArrowLeft > 0) {
            ++this._cptArrowLeft;
            if (this._cptArrowLeft > 10) {
                this._cptArrowLeft = 0;
            }
        }
        if (this._cptArrowRight > 0) {
            ++this._cptArrowRight;
            if (this._cptArrowRight > 10) {
                this._cptArrowRight = 0;
            }
        }
    }

    void Draw_BG(Graphics graphics) {
        if (this._level == 0) {
            int n = 0;
            while (n < 4) {
                this._img[17 - n].draw(graphics, this._clouds[n][0], this._clouds[n][1] + this._vib, 16 + 4);
                int[] nArray = this._clouds[n];
                nArray[0] = nArray[0] + this._clouds[n][2];
                if (this._clouds[n][0] > 132) {
                    this._clouds[n][0] = -75;
                }
                n = (byte)(n + 1);
            }
            this._img[5].draw(graphics, 132, 133 + this._vib, 32 + 8);
            this._img[4].draw(graphics, 132, 133 + this._vib, 32 + 8);
        } else if (this._level == 1) {
            this._img[4].draw(graphics, this._scroll3, 128 + this._vib, 32 + 4);
            this._img[4].draw(graphics, 132 + this._scroll3, 128 + this._vib, 32 + 4);
            this._img[5].draw(graphics, this._scroll2, 128 + this._vib, 32 + 4);
            this._img[5].draw(graphics, 132 + this._scroll2, 128 + this._vib, 32 + 4);
        } else if (this._level == 2) {
            this._img[4].draw(graphics, 132 + this._scroll3, 83 + this._vib, 32 + 4);
            this._img[4].draw(graphics, this._scroll3, 83 + this._vib, 32 + 4);
            this._img[5].draw(graphics, 132 + this._scroll2, 97 + this._vib, 32 + 4);
            this._img[5].draw(graphics, this._scroll2, 97 + this._vib, 32 + 4);
            this._img[6].draw(graphics, 132 + this._scroll1, 128 + this._vib, 32 + 4);
            this._img[6].draw(graphics, this._scroll1, 128 + this._vib, 32 + 4);
            int n = 0;
            while (n < 5) {
                this._flashes[n][0] = this._rand.nextInt() % 132;
                this._flashes[n][1] = this._rand.nextInt() % 35;
                this._flashes[n][2] = this._rand.nextInt() % 3;
                this._img[51].drawFrame(graphics, this._flashes[n][0], 116 - this._flashes[n][1] + this._vib, this._flashes[n][2], 4 + 32);
                n = (byte)(n + 1);
            }
        } else if (this._level == 3 || this._level == 4) {
            this._img[5].draw(graphics, this._scroll3, 118 + this._vib, 32 + 4);
            this._img[5].draw(graphics, 132 + this._scroll3, 118 + this._vib, 32 + 4);
            this._img[4].draw(graphics, this._scroll2, 128 + this._vib, 32 + 4);
            this._img[4].draw(graphics, 132 + this._scroll2, 128 + this._vib, 32 + 4);
        } else if (this._level == 5) {
            this._img[4].draw(graphics, this._scroll2, 128 + this._vib, 32 + 4);
            this._img[4].draw(graphics, 132 + this._scroll2, 128 + this._vib, 32 + 4);
        }
    }

    void Draw_Game(Graphics graphics) {
        graphics.setClip(0, 0, 132, 176);
        this._img[3].draw(graphics, 0, 0 + this._vib, 16 + 4);
        this.Draw_BG(graphics);
        if (this._level != 0) {
            graphics.setClip(0, 0, 132, 176);
            graphics.setColor(this._groundColor1);
            graphics.fillRect(0, 128, 132, 48);
        }
        graphics.setClip(0, 0, 132, 176);
        int n = 0;
        while (n < 48) {
            if (this._bend && this._bendY >= n) {
                int n2 = this._bendY - n;
                this._decalX[n] = this._bendX > 0 ? (this._bendX * 4 - this._bendReduction) * n2 / 16 : (this._bendX * 4 + this._bendReduction) * n2 / 16;
            } else {
                this._decalX[n] = 0;
            }
            if (n % 2 == 0) {
                int n3 = 37 - n - this._roadX * n / 8 + this._decalX[n];
                int n4 = 95 + n - this._roadX * n / 8 + this._decalX[n];
                int n5 = 128 + n;
                if (this._level == 0) {
                    graphics.setColor(this._groundColor1);
                    if (n >= 6) {
                        graphics.fillRect(0, n5, n3 - 2 - n / 3, 2);
                    }
                    graphics.setClip(0, 0, 132, 176);
                    graphics.setColor(this._groundColor2);
                    if (n4 < 0) {
                        n4 = 0;
                    }
                    graphics.fillRect(n4 + 2 + n / 3, n5, 132 - n4, 2);
                    if (n == 8) {
                        this._w0 = n3 - 2 - n / 3 - n / 2;
                    } else if (n == 20) {
                        this._w1 = n3 - 2 - n / 3 - n / 2;
                    } else if (n == 32) {
                        this._w2 = n3 - 2 - n / 3 - n / 2;
                    } else if (n == 46) {
                        this._w3 = n3 - 2 - n / 3 - n / 2;
                    }
                }
                graphics.setClip(0, 0, 132, 176);
                if (this._finishLine && n >= this._finishY && n <= this._finishY * 4 / 3) {
                    graphics.setColor(-1);
                } else if (_stripes[this._cptStripe][n] == 0) {
                    graphics.setColor(this._roadColor1);
                } else {
                    graphics.setColor(this._roadColor2);
                }
                graphics.fillRect(n3, n5, 58 + 2 * n, 2);
                if (_stripes[this._cptStripe][n] == 0) {
                    graphics.setColor(this._bordColor1);
                } else {
                    graphics.setColor(this._bordColor2);
                }
                graphics.fillRect(n3 - 2 - n / 3, n5, 1 + n / 3, 2);
                graphics.fillRect(n4 + 1, n5, 1 + n / 3, 2);
                if (n5 == this._Y - 14) {
                    this._xLeft = n3 - 2 - n / 3;
                    this._xRight = n4 + 2 + n / 3;
                }
            }
            ++n;
        }
        this.Draw_Objects(graphics);
        if (this._option || this._optionCatched) {
            this._img[48 + this._optionType].drawFrame(graphics, this._optionX, this._optionY + 128 + this._vib, 4 - this._optionZoom, 32 + 2);
        }
        if (!this._z) {
            this.Draw_Opponent(graphics);
        }
        if (!this._reset || this._cptReset % 6 >= 3) {
            this._img[19].drawFrame(graphics, this._X, this._Y + this._vib, this._frame, 32 + 2);
        }
        if (this._turbo) {
            this._img[24].drawFrame(graphics, this._X, this._Y + this._vib, this._cptMain % 3, 32 + 2);
        }
        if (this._z) {
            this.Draw_Opponent(graphics);
        }
        graphics.setClip(0, 0, 132, 176);
        this._img[12].draw(graphics, 0, 0, 16 + 4);
        if (this._turboSize > 0) {
            graphics.setClip(30, 8, this._turboSize, 5);
            this._img[13].drawFrameB(graphics, 30, 8, this._cptMain % 3, 16 + 4);
        }
        this._mu0.printValue(graphics, 100, 19, this._position);
        if (this._position == 1) {
            this._mu0.print(graphics, 105, 19, "st");
        } else if (this._position == 2) {
            this._mu0.print(graphics, 107, 19, "nd");
        } else if (this._position == 3) {
            this._mu0.print(graphics, 107, 19, "rd");
        } else {
            this._mu0.print(graphics, 107, 19, "th");
        }
        this._mu0.printValue(graphics, 90, 30, this._lap);
        this._mu0.print(graphics, 95, 30, "/");
        this._mu0.printValue(graphics, 101, 30, this._nbLap);
        this._img[20].draw(graphics, 110, 29, 16 + 4);
        this.Draw_Time(graphics, this._time, 1, 19);
        this._mu0.printValue(graphics, 1, 30, this._speed);
        this._mu0.print(graphics, 25, 30, "km/h");
        if (this._gameState == 2 || this._gameState == 1) {
            this._mu0.print(graphics, 1, 166, 18);
        }
    }

    void Draw_Objects(Graphics graphics) {
        if (this._gameState == 2 || this._gameState == 1) {
            if (this._speed >= 240) {
                this._objectY1 += 4;
                this._objectY2 += 8;
            } else if (this._speed >= 180) {
                this._objectY1 += 3;
                this._objectY2 += 6;
            } else if (this._speed >= 100) {
                this._objectY1 += 2;
                this._objectY2 += 4;
            } else if (this._speed >= 40) {
                ++this._objectY1;
                this._objectY2 += 2;
            } else if (this._speed > 0 && this._cptMain % 2 == 0) {
                ++this._objectY1;
                this._objectY2 += 2;
            }
            if (this._objectY2 >= 85) {
                this._objectY1 = 0;
                this._objectY2 = 35;
                this._object = (byte)(1 - this._object);
                if (this._finishLine && this._finish < 2) {
                    this._finish = (byte)(this._finish + 1);
                }
            }
        }
        this._objectSize1 = (byte)(this._objectY1 / 8);
        this._objectSize2 = (byte)(this._objectY2 / 8);
        if (this._objectSize1 > 4) {
            this._objectSize1 = (byte)4;
        }
        if (this._objectSize2 > 4) {
            this._objectSize2 = (byte)4;
        }
        if (this._level != 0) {
            this._objectX1 = 37 - this._objectY1 - this._roadX * this._objectY1 / 6 - 5 - this._objectY1 / 2 + this._decalX[this._objectY1];
            this._objectX2 = 37 - this._objectY2 - this._roadX * this._objectY2 / 6 - 5 - this._objectY2 / 2 + this._decalX[this._objectY2];
            if (this._finish == 1) {
                this._img[23].drawFrame(graphics, this._objectX1, this._objectY1 + 128 + this._vib, this._objectSize1, 32 + 2);
            } else {
                this._img[7 + this._object].drawFrame(graphics, this._objectX1, this._objectY1 + 128 + this._vib, this._objectSize1, 32 + 2);
            }
            if (this._finish == 2) {
                this._img[23].drawFrame(graphics, this._objectX2, this._objectY2 + 128 + this._vib, this._objectSize2, 32 + 2);
            } else {
                this._img[8 - this._object].drawFrame(graphics, this._objectX2, this._objectY2 + 128 + this._vib, this._objectSize2, 32 + 2);
            }
        }
        this._objectX3 = 95 + this._objectY1 - this._roadX * this._objectY1 / 6 + 5 + this._objectY1 / 2 + this._decalX[this._objectY1];
        this._objectX4 = 95 + this._objectY2 - this._roadX * this._objectY2 / 6 + 5 + this._objectY2 / 2 + this._decalX[this._objectY2];
        if (this._finish == 1) {
            this._img[23].drawFrame(graphics, this._objectX3, this._objectY1 + 128 + this._vib, this._objectSize1, 32 + 2);
        } else {
            this._img[7 + this._object].drawFrame(graphics, this._objectX3, this._objectY1 + 128 + this._vib, this._objectSize1, 32 + 2);
        }
        if (this._finish == 2) {
            this._img[23].drawFrame(graphics, this._objectX4, this._objectY2 + 128 + this._vib, this._objectSize2, 32 + 2);
        } else {
            this._img[8 - this._object].drawFrame(graphics, this._objectX4, this._objectY2 + 128 + this._vib, this._objectSize2, 32 + 2);
        }
        if (this._finishLine) {
            if (this._finish == 1) {
                this._finishY = this._objectY1;
            } else if (this._finish == 2) {
                this._finishY = this._objectY2;
                if (this._finishY + 128 > 173) {
                    this._finishLine = false;
                    this._finish = 0;
                    this._finishY = 0;
                    this._lap = (byte)(this._lap + 1);
                    this._cptRace = 0;
                    if (this._lap > this._nbLap) {
                        this._lap = this._nbLap;
                        this._gameState = 4;
                        this._cptEnd = 0;
                        this._enterScore = false;
                        this._keyMap[11] = -1;
                        this._endTime = System.currentTimeMillis();
                    }
                }
            }
        }
    }

    void Draw_Opponent(Graphics graphics) {
        byte by = 0;
        while (by < this._nbOpponent) {
            if (this._opp[by]._onScreen) {
                this._img[45 + this._opp[by]._sprite].drawFrame(graphics, this._opp[by]._posX, this._opp[by]._posY + 128 + this._vib, this._opp[by]._zoom * 3 + this._opp[by]._anim, 32 + 2);
            }
            by = (byte)(by + 1);
        }
    }

    void Draw_Time(Graphics graphics, int n, int n2, int n3) {
        int n4 = n / 60;
        int n5 = n % 60;
        this._mu0.print(graphics, n2 + 16, n3, "#");
        if (n4 >= 10) {
            this._mu0.printValue(graphics, n2, n3, n4);
        } else {
            this._mu0.printValue(graphics, n2, n3, 0);
            this._mu0.printValue(graphics, n2 + 8, n3, n4);
        }
        if (n5 >= 10) {
            this._mu0.printValue(graphics, n2 + 24, n3, n5);
        } else {
            this._mu0.printValue(graphics, n2 + 24, n3, 0);
            this._mu0.printValue(graphics, n2 + 32, n3, n5);
        }
    }

    void GameExit() {
    }

    void GameInit() {
        this._rand = new Random();
        this._keyMap = new byte[19];
        this._img = new Image2[54];
        this._highScores = new int[6];
        this._data = new int[5];
        this._decalX = new int[176];
        this._flashes = new int[5][3];
        this._opp = new Opponent[7];
        byte by = 0;
        while (by < 7) {
            this._opp[by] = new Opponent(this, by);
            by = (byte)(by + 1);
        }
        this.Load_Records();
        this._begin = System.currentTimeMillis();
    }

    void Init_Adventure() {
        int n = 0;
        while (n < 5) {
            this._data[n] = 0;
            n = (byte)(n + 1);
        }
    }

    void Init_Data() {
        this.Reset_Data();
        this._nbLap = _races[this._level * 2];
        this._nbOpponent = _races[this._level * 2 + 1];
        this._turboSize = 80;
        byte by = 0;
        while (by < this._nbOpponent) {
            this._opp[by].Init();
            by = (byte)(by + 1);
        }
        this._position = (byte)(this._nbOpponent + 1);
        this._cptRoad = 0;
        this._cptRace = 0;
        this._lap = 1;
        this._finishLine = false;
        this._loose = false;
        this._cptStart = 0;
        this._cptBoost = 0;
        this._sec = System.currentTimeMillis();
        this._time = 0;
        this._escape = 0;
        this._cptEscape = 0;
        this._cptOption = 0;
        this._option = false;
        this._optionCatched = false;
        this._moneyRab = 0;
        this._scroll1 = 0;
        this._scroll2 = 0;
        this._scroll3 = 0;
        this._difficulty = this._level < 2 ? (byte)0 : 1;
        this._startTime = System.currentTimeMillis();
    }

    void Load_Car() {
        this._img[26] = null;
        System.gc();
        this._img[26] = this._kart == 0 ? new Image2("/gfx/menucarA.png", 1, 1) : (this._kart == 1 ? new Image2("/gfx/menucarB.png", 1, 1) : new Image2("/gfx/menucarC.png", 1, 1));
    }

    void Load_Circuit() {
        this._img[25] = null;
        System.gc();
        this._img[25] = this._curs == 0 ? new Image2("/gfx/circuitmenu1.png", 1, 1) : (this._curs == 1 ? new Image2("/gfx/circuitmenu2.png", 1, 1) : (this._curs == 2 ? new Image2("/gfx/circuitmenu3.png", 1, 1) : (this._curs == 3 ? new Image2("/gfx/circuitmenu4.png", 1, 1) : (this._curs == 4 ? new Image2("/gfx/circuitmenu5.png", 1, 1) : new Image2("/gfx/circuitmenu6.png", 1, 1)))));
    }

    void Load_Garage() {
        if (this._kart == 0) {
            this._img[35] = new Image2("/gfx/carA_neon1.png", 1, 1);
            this._img[36] = new Image2("/gfx/carA_neon2.png", 1, 1);
            this._img[33] = new Image2("/gfx/carA_aileron.png", 1, 1);
            this._img[34] = new Image2("/gfx/carA_phare.png", 1, 1);
        } else if (this._kart == 1) {
            this._img[35] = new Image2("/gfx/carB_neon1.png", 1, 1);
            this._img[36] = new Image2("/gfx/carB_neon2.png", 1, 1);
            this._img[33] = new Image2("/gfx/carB_aileron.png", 1, 1);
            this._img[34] = new Image2("/gfx/carB_phare.png", 1, 1);
        } else if (this._kart == 2) {
            this._img[35] = new Image2("/gfx/carC_neon1.png", 1, 1);
            this._img[36] = new Image2("/gfx/carC_neon2.png", 1, 1);
            this._img[33] = new Image2("/gfx/carC_aileron.png", 1, 1);
            this._img[34] = new Image2("/gfx/carC_phare.png", 1, 1);
        }
        this._img[39] = new Image2("/gfx/neon_menu.png", 1, 2);
        this._img[37] = new Image2("/gfx/aileron_menu.png", 1, 2);
        this._img[38] = new Image2("/gfx/phare_menu.png", 1, 2);
        this._img[40] = new Image2("/gfx/garagiste.png", 1, 1);
    }

    void Load_Level() {
        if (this._level == 0) {
            this._img[3] = new Image2("/gfx/sky1.png", 1, 1);
            this._img[4] = new Image2("/gfx/bga1.png", 1, 1);
            this._img[5] = new Image2("/gfx/bga2.png", 1, 1);
            this._img[7] = new Image2("/gfx/elementa1.png", 5, 1);
            this._img[8] = new Image2("/gfx/elementa2.png", 5, 1);
            this._img[14] = new Image2("/gfx/cloud1.png", 1, 1);
            this._img[15] = new Image2("/gfx/cloud2.png", 1, 1);
            this._img[16] = new Image2("/gfx/cloud3.png", 1, 1);
            this._img[17] = new Image2("/gfx/cloud4.png", 1, 1);
            this._groundColor1 = -12171052;
            this._groundColor2 = -19370;
            this._roadColor2 = -7238532;
            this._roadColor1 = -5528948;
            this._bordColor1 = -4194304;
            this._bordColor2 = -131093;
        } else if (this._level == 1) {
            this._img[3] = new Image2("/gfx/sky2.png", 1, 1);
            this._img[4] = new Image2("/gfx/bgb1.png", 1, 1);
            this._img[5] = new Image2("/gfx/bgb2.png", 1, 1);
            this._img[7] = new Image2("/gfx/elementa2.png", 5, 1);
            this._img[8] = new Image2("/gfx/elementb2.png", 5, 1);
            this._groundColor1 = -4347528;
            this._roadColor1 = -6908266;
            this._roadColor2 = -5327929;
            this._bordColor1 = -11428;
            this._bordColor2 = -7390405;
        } else if (this._level == 2) {
            this._img[3] = new Image2("/gfx/sky3.png", 1, 1);
            this._img[4] = new Image2("/gfx/bgc1.png", 1, 1);
            this._img[5] = new Image2("/gfx/bgc2.png", 1, 1);
            this._img[6] = new Image2("/gfx/bgc3.png", 1, 1);
            this._img[7] = new Image2("/gfx/elementc1.png", 1, 5);
            this._img[8] = new Image2("/gfx/elementc2.png", 1, 5);
            this._img[51] = new Image2("/gfx/flash_nascar.png", 3, 1);
            this._groundColor1 = -11969509;
            this._roadColor1 = -8229009;
            this._roadColor2 = -6717569;
            this._bordColor1 = -15524;
            this._bordColor2 = -16777216;
        } else if (this._level == 3) {
            this._img[3] = new Image2("/gfx/sky4.png", 1, 1);
            this._img[4] = new Image2("/gfx/bgd1.png", 1, 1);
            this._img[5] = new Image2("/gfx/bgd2.png", 1, 1);
            this._img[7] = new Image2("/gfx/elementd1.png", 5, 1);
            this._img[8] = new Image2("/gfx/elementd2.png", 5, 1);
            this._groundColor1 = -14414048;
            this._roadColor1 = -11322044;
            this._roadColor2 = -9876395;
            this._bordColor1 = -6455418;
            this._bordColor2 = -13817764;
        } else if (this._level == 4) {
            this._img[3] = new Image2("/gfx/sky1.png", 1, 1);
            this._img[4] = new Image2("/gfx/bge2.png", 1, 1);
            this._img[5] = new Image2("/gfx/bge1.png", 1, 1);
            this._img[7] = new Image2("/gfx/elemente1.png", 5, 1);
            this._img[8] = new Image2("/gfx/elemente2.png", 5, 1);
            this._groundColor1 = -4563652;
            this._roadColor1 = -7904145;
            this._roadColor2 = -6915967;
            this._bordColor1 = -1325916;
            this._bordColor2 = -7397072;
        } else if (this._level == 5) {
            this._img[3] = new Image2("/gfx/sky6.png", 1, 1);
            this._img[4] = new Image2("/gfx/bgf1.png", 1, 1);
            this._img[7] = new Image2("/gfx/elementd2.png", 5, 1);
            this._img[8] = new Image2("/gfx/elementd2.png", 5, 1);
            this._groundColor1 = -14742518;
            this._roadColor1 = -10072717;
            this._roadColor2 = -11387300;
            this._bordColor1 = -16754013;
            this._bordColor2 = -15401098;
        }
    }

    void Load_Menu() {
        this._img[2] = new Image2("/gfx/RegularFont1.png", 13, 6);
        this._img[1] = new Image2("/gfx/menuscreen.png", 1, 1);
        this._img[27] = new Image2("/gfx/flechemenu_G.png", 2, 1);
        this._img[28] = new Image2("/gfx/flechemenu_D.png", 2, 1);
        this._img[29] = new Image2("/gfx/cadredialogue.png", 1, 1);
        this._img[30] = new Image2("/gfx/girlz.png", 1, 1);
        this._img[26] = new Image2("/gfx/menucarA.png", 1, 1);
        this._img[25] = new Image2("/gfx/circuitmenu1.png", 1, 1);
    }

    void Load_Records() {
        try {
            byte[] byArray = new byte[40];
            int n = 0;
            while (n < 6) {
                this._highScores[n] = 240;
                n = (byte)(n + 1);
            }
            this._lang = (byte)-1;
            this._isMusic = 0;
            RecordStore recordStore = RecordStore.openRecordStore((String)"VortexRecord", (boolean)true);
            if (recordStore.getNumRecords() > 0) {
                recordStore.getRecord(1, byArray, 0);
                int n2 = 0;
                while (n2 < 6) {
                    this._highScores[n2] = byArray[n2 * 4] * 1000 + byArray[n2 * 4 + 1] * 100 + byArray[n2 * 4 + 2] * 10 + byArray[n2 * 4 + 3];
                    n2 = (byte)(n2 + 1);
                }
                int n3 = 0;
                while (n3 < 6) {
                    this._locked[n3] = byArray[24 + n3];
                    n3 = (byte)(n3 + 1);
                }
                this._isMusic = byArray[30];
                this._lang = byArray[31];
                this._data[0] = byArray[32];
                this._data[1] = byArray[33];
                this._data[2] = byArray[34];
                this._data[3] = byArray[35] * 1000 + byArray[36] * 100 + byArray[37] * 10 + byArray[38];
                this._data[4] = byArray[39];
            } else {
                recordStore.addRecord(byArray, 0, 40);
            }
            recordStore.closeRecordStore();
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.gc();
    }

    void Move() {
        if (this._menuDir == 0) {
            this._kartX -= 40;
            if (this._kartX < -120) {
                this._kartX = 266;
                if (this._menuState == 8) {
                    this._kart = (byte)(this._kart - 1);
                    if (this._kart < 0) {
                        this._kart = (byte)2;
                    }
                    this.Load_Car();
                } else {
                    this._curs = (byte)(this._curs - 1);
                    if (this._curs < 0) {
                        this._curs = (byte)5;
                    }
                    this.Load_Circuit();
                }
            }
            if (this._kartX == 66) {
                this._kartMove = false;
            }
        } else if (this._menuDir == 1) {
            this._kartX += 40;
            if (this._kartX > 252) {
                this._kartX = -134;
                if (this._menuState == 8) {
                    this._kart = (byte)(this._kart + 1);
                    if (this._kart > 2) {
                        this._kart = 0;
                    }
                    this.Load_Car();
                } else {
                    this._curs = (byte)(this._curs + 1);
                    if (this._curs > 5) {
                        this._curs = 0;
                    }
                    this.Load_Circuit();
                }
            }
            if (this._kartX == 66) {
                this._kartMove = false;
            }
        }
    }

    void Reset_Data() {
        this._X = 66;
        this._Y = 174;
        this._frame = 3;
        this._shadowY = 170;
        this._roadX = 0;
        this._speed = 0;
        this._acc = 5;
        this._speedX = 0;
        this._xLeft = -4;
        this._xRight = 136;
        this._leftCol = false;
        this._turbo = false;
        this._object = 0;
        this._objectY1 = 0;
        this._objectY2 = 35;
        this._bend = false;
        this._inBend = false;
        this._cptBend = 0;
        this._bendX = 0;
        this._bendY = 0;
        this._cptCol = 0;
        this._option = false;
        this._optionCatched = false;
        this._cptOption = 0;
        this._cptOffroad = 0;
        this._noControl = 0;
        this._vib = 0;
    }

    void Reset_Direction_Keys() {
        this._keyMap[2] = -1;
        this._keyMap[3] = -1;
        this._keyMap[4] = -1;
        this._keyMap[5] = -1;
        this._keyMap[8] = -1;
        this._keyMap[14] = -1;
        this._keyMap[10] = -1;
        this._keyMap[12] = -1;
    }

    void Save_Records() {
        byte[] byArray = new byte[40];
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)"VortexRecord", (boolean)false);
            if (recordStore.getNumRecords() > 0) {
                int n;
                int n2 = 0;
                while (n2 < 6) {
                    n = (byte)(this._highScores[n2] / 1000);
                    byte by = (byte)((this._highScores[n2] - 1000 * n) / 100);
                    byte by2 = (byte)((this._highScores[n2] - 1000 * n - 100 * by) / 10);
                    byte by3 = (byte)(this._highScores[n2] % 10);
                    byArray[n2 * 4] = n;
                    byArray[n2 * 4 + 1] = by;
                    byArray[n2 * 4 + 2] = by2;
                    byArray[n2 * 4 + 3] = by3;
                    n2 = (byte)(n2 + 1);
                }
                n = 0;
                while (n < 6) {
                    byArray[24 + n] = this._locked[n];
                    n = (byte)(n + 1);
                }
                byArray[30] = this._isMusic;
                byArray[31] = this._lang;
                byArray[32] = (byte)this._data[0];
                byArray[33] = (byte)this._data[1];
                byArray[34] = (byte)this._data[2];
                byArray[35] = (byte)(this._data[3] / 1000);
                byArray[36] = (byte)((this._data[3] - 1000 * byArray[35]) / 100);
                byArray[37] = (byte)((this._data[3] - 1000 * byArray[35] - 100 * byArray[36]) / 10);
                byArray[38] = (byte)(this._data[3] % 10);
                byArray[39] = (byte)this._data[4];
                recordStore.setRecord(1, byArray, 0, 40);
            }
            recordStore.closeRecordStore();
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.gc();
    }

    int Sqrt(int n) {
        int n2 = 0;
        int n3 = 65536;
        while (n3 != 0) {
            int n4 = n2 + n3;
            n2 >>= 1;
            if (n4 <= n) {
                n -= n4;
                n2 += n3;
            }
            n3 >>= 2;
        }
        return n2;
    }

    void Update_Game(Graphics graphics) {
        this.keyUpdate();
        switch (this._gameState) {
            case 0: {
                this._gameState = 1;
                this._curMusic = (byte)(2 + this._level % 2);
                this.Init_Data();
            }
            case 1: {
                if (this._keyMap[0] > 0 || this._keyMap[1] > 0) {
                    this._keyMap[0] = -1;
                    this._keyMap[1] = -1;
                    this._gameState = 3;
                    this._returnState = 1;
                    this._tmp = System.currentTimeMillis();
                    this._curs = 0;
                    return;
                }
                this.Draw_Game(graphics);
                if (System.currentTimeMillis() - this._startTime < 2000L) {
                    graphics.setClip(0, 0, 132, 176);
                    graphics.setColor(-16777216);
                    graphics.fillRect(15, 30, 102, 116);
                    graphics.setColor(-1);
                    graphics.fillRect(20, 35, 92, 106);
                    this._mu0.print(graphics, 5, 50, 42, 2);
                    int n = 0;
                    while (n < 4) {
                        this._mu0.print(graphics, 32, 70 + 12 * n, 43 + n);
                        n = (byte)(n + 1);
                    }
                    break;
                }
                this._img[53].draw(graphics, 27, 60, 16 + 4);
                this._img[52].drawFrame(graphics, 57, 72, this._cptStart, 16 + 4);
                if (System.currentTimeMillis() - this._startTime <= (long)(3000 + 1000 * this._cptStart)) break;
                ++this._cptStart;
                if (this._cptStart != 3) break;
                this._gameState = 2;
                this._keyMap[11] = 0;
                break;
            }
            case 2: {
                if (this._keyMap[0] > 0 || this._keyMap[1] > 0) {
                    this._keyMap[0] = -1;
                    this._keyMap[1] = -1;
                    this._gameState = 3;
                    this._returnState = 2;
                    this._curs = 0;
                    return;
                }
                if (this._turbo) {
                    if (this._kart == 0) {
                        this._speedMax = 290;
                        this._acc = 10;
                    } else if (this._kart == 1) {
                        this._speedMax = 320;
                        this._acc = 5;
                    } else if (this._kart == 2) {
                        this._speedMax = 260;
                        this._acc = 10;
                    }
                    if (this._kart == 0 && this._cptMain % 2 == 0) {
                        --this._turboSize;
                    } else if (this._kart > 0 && this._cptMain % 3 == 0) {
                        --this._turboSize;
                    }
                    if (this._turboSize == 0) {
                        this._turbo = false;
                    }
                    if (this._Y > 172) {
                        --this._Y;
                    }
                } else {
                    this._speedMax = 220;
                    this._acc = 5;
                    if (this._Y < 174) {
                        ++this._Y;
                    }
                }
                this.Update_Option();
                if (!this._reset) {
                    this.Update_Player();
                } else {
                    ++this._cptReset;
                    if (this._cptReset > 18) {
                        this._reset = false;
                    }
                }
                if (this._speed < 0) {
                    this._speed = 0;
                }
                this._z = false;
                this._position = (byte)(this._nbOpponent + 1);
                byte by = 0;
                while (by < this._nbOpponent) {
                    this._opp[by].Update();
                    if (this._opp[by]._posY + 128 >= this._Y) {
                        this._position = (byte)(this._position - 1);
                    }
                    by = (byte)(by + 1);
                }
                if (this._speed > 0) {
                    this.Update_Road();
                }
                if (System.currentTimeMillis() - this._sec >= 1000L) {
                    ++this._time;
                    this._sec = System.currentTimeMillis();
                }
                if (this._scroll1 > 0) {
                    this._scroll1 -= 132;
                } else if (this._scroll1 < -132) {
                    this._scroll1 += 132;
                }
                if (this._scroll2 > 0) {
                    this._scroll2 -= 132;
                } else if (this._scroll2 < -132) {
                    this._scroll2 += 132;
                }
                if (this._scroll3 > 0) {
                    this._scroll3 -= 132;
                } else if (this._scroll3 < -132) {
                    this._scroll3 += 132;
                }
                this.Draw_Game(graphics);
                break;
            }
            case 3: {
                graphics.setColor(-16777216);
                graphics.fillRect(15, 30, 102, 116);
                graphics.setColor(-1);
                graphics.fillRect(20, 35, 92, 106);
                this._mu0.print(graphics, 5, 50, 19, 2);
                this._mu0.print(graphics, 5, 70, 7, 2);
                this._mu0.print(graphics, 0, 82, 9 + this._isMusic, 2);
                this._mu0.print(graphics, 0, 102, 20, 2);
                this._img[31].drawFrame(graphics, 15, 50 + 26 * this._curs, this._cptCurs, 16 + 4);
                this._img[32].drawFrame(graphics, 92, 50 + 26 * this._curs, this._cptCurs, 16 + 4);
                if (this._keyMap[2] > 0 || this._keyMap[8] > 0) {
                    this.Reset_Direction_Keys();
                    this._curs = (byte)(this._curs - 1);
                    if (this._curs < 0) {
                        this._curs = (byte)2;
                    }
                } else if (this._keyMap[3] > 0 || this._keyMap[14] > 0) {
                    this.Reset_Direction_Keys();
                    this._curs = (byte)(this._curs + 1);
                    if (this._curs > 2) {
                        this._curs = 0;
                    }
                }
                if (this._keyMap[11] <= 0 && this._keyMap[18] <= 0 && this._keyMap[0] <= 0) break;
                this._keyMap[11] = -1;
                this._keyMap[18] = -1;
                this._keyMap[0] = -1;
                if (this._curs == 0) {
                    this._gameState = this._returnState;
                    this._startTime += System.currentTimeMillis() - this._tmp;
                    break;
                }
                if (this._curs == 1) {
                    if (this._isMusic == 0) {
                        this._isMusic = 1;
                        this._snd.Stop_Music();
                        break;
                    }
                    this._isMusic = 0;
                    this._curMusic = (byte)(2 + this._level % 2);
                    break;
                }
                this._mainState = 3;
                this._cptLoad = 0;
                this._continue = false;
                break;
            }
            case 4: {
                graphics.setColor(-16777216);
                graphics.fillRect(15, 30, 102, 116);
                graphics.setColor(-1);
                graphics.fillRect(20, 35, 92, 106);
                this._mu0.printValue(graphics, 56, 55, this._position);
                this._mu0.print(graphics, 61, 55, "/");
                this._mu0.printValue(graphics, 67, 55, this._nbOpponent + 1);
                this.Draw_Time(graphics, this._time, 41, 75);
                if (this._mode == 0 && this._time < this._highScores[this._level]) {
                    this._mu0.print(graphics, 0, 95, 23, 16 + 2);
                    this._enterScore = true;
                } else if (this._mode == 1) {
                    int n = this._moneyRab;
                    if (this._position <= 1 && !this._loose) {
                        n += _reward[this._level];
                    }
                    this._mu0.print(graphics, 35, 95, 134, 16 + 4);
                    this._mu0.printValue(graphics, 70, 95, n);
                }
                if (this._keyMap[0] <= 0 && this._keyMap[18] <= 0 && this._keyMap[11] <= 0 && System.currentTimeMillis() - this._endTime <= 3000L) break;
                this._keyMap[18] = -1;
                this._keyMap[11] = -1;
                this._keyMap[0] = -1;
                this._mainState = 3;
                this._cptLoad = 0;
                this._continue = true;
                if (!this._enterScore) break;
                this._highScores[this._level] = this._time;
            }
        }
    }

    void Update_Menu(Graphics graphics) {
        this.keyUpdate();
        this._ok = false;
        this._back = false;
        if (this._keyMap[0] > 0 || this._keyMap[11] > 0 || this._keyMap[18] > 0) {
            this._keyMap[0] = -1;
            this._keyMap[11] = -1;
            this._keyMap[18] = -1;
            this._ok = true;
        } else if (this._keyMap[1] > 0) {
            this._keyMap[1] = -1;
            this._back = true;
        }
        this._img[1].draw(graphics, 0, 0, 16 + 4);
        switch (this._menuState) {
            case 0: {
                if (this._keyMap[2] > 0 || this._keyMap[8] > 0) {
                    this._curs = (byte)(this._curs - 1);
                    if (this._curs < 0) {
                        this._curs = (byte)5;
                    }
                } else if (this._keyMap[3] > 0 || this._keyMap[14] > 0) {
                    this._curs = (byte)(this._curs + 1);
                    if (this._curs > 5) {
                        this._curs = 0;
                    }
                }
                this.Reset_Direction_Keys();
                int n = 0;
                while (n < 6) {
                    this._mu0.print(graphics, 5, 40 + 20 * n, n, 2);
                    n = (byte)(n + 1);
                }
                this._img[31].drawFrame(graphics, 8, 40 + 20 * this._curs, this._cptCurs, 16 + 4);
                this._img[32].drawFrame(graphics, 99, 40 + 20 * this._curs, this._cptCurs, 16 + 4);
                switch (this._curs) {
                    case 0: {
                        if (!this._ok) break;
                        this._menuState = 6;
                        break;
                    }
                    case 1: {
                        if (!this._ok) break;
                        this._menuState = 1;
                        this._help = 0;
                        break;
                    }
                    case 2: {
                        if (!this._ok) break;
                        this._menuState = 3;
                        this._curs = 0;
                        break;
                    }
                    case 3: {
                        if (!this._ok) break;
                        this._menuState = 2;
                        break;
                    }
                    case 4: {
                        if (!this._ok) break;
                        this._menuState = 4;
                        this._credit = 0;
                        break;
                    }
                    case 5: {
                        if (!this._ok) break;
                        this._mainState = 6;
                    }
                }
                break;
            }
            case 6: {
                this._mu0.print(graphics, (int)BACK_X[this._lang], 166, 6);
                if (this._keyMap[2] > 0 || this._keyMap[8] > 0 || this._keyMap[3] > 0 || this._keyMap[14] > 0) {
                    this.Reset_Direction_Keys();
                    this._curs = (byte)(1 - this._curs);
                }
                this._mu0.print(graphics, 5, 60, 25, 2);
                this._mu0.print(graphics, 5, 90, 26, 2);
                this._img[31].drawFrame(graphics, 0, 60 + 30 * this._curs, this._cptCurs, 16 + 4);
                this._img[32].drawFrame(graphics, 107, 60 + 30 * this._curs, this._cptCurs, 16 + 4);
                if (this._ok) {
                    this._mode = this._curs;
                    this._kart = 0;
                    if (this._mode == 0) {
                        this._menuState = 8;
                        this._kartX = 66;
                        this._kartMove = false;
                        this.Load_Car();
                        break;
                    }
                    if (this._mode != 1) break;
                    this._curs = 0;
                    if (this._data[4] > 0) {
                        this._menuState = 10;
                        break;
                    }
                    this._intro = 0;
                    this._menuState = 12;
                    break;
                }
                if (!this._back) break;
                this._menuState = 0;
                this._curs = 0;
                break;
            }
            case 12: {
                int n = 0;
                while (n < 7) {
                    this._mu0.print(graphics, 5, 20 + 11 * n, 51 + n + this._intro * 7, 2);
                    n = (byte)(n + 1);
                }
                this._img[30].draw(graphics, 45, 176, 4 + 32);
                if (this._ok) {
                    if (this._intro == 0) {
                        this._intro = (byte)(this._intro + 1);
                        break;
                    }
                    this.Init_Adventure();
                    this._menuState = 8;
                    this._kartX = 66;
                    this._kartMove = false;
                    this.Load_Car();
                    break;
                }
                if (!this._back) break;
                this._curs = 0;
                this._menuState = 6;
                break;
            }
            case 10: {
                this._mu0.print(graphics, (int)BACK_X[this._lang], 166, 6);
                if (this._keyMap[2] > 0 || this._keyMap[8] > 0 || this._keyMap[3] > 0 || this._keyMap[14] > 0) {
                    this.Reset_Direction_Keys();
                    this._curs = (byte)(1 - this._curs);
                }
                this._mu0.print(graphics, 0, 60, 31, 2);
                this._mu0.print(graphics, 0, 90, 32, 2);
                this._img[31].drawFrame(graphics, 5, 60 + 30 * this._curs, this._cptCurs, 16 + 4);
                this._img[32].drawFrame(graphics, 102, 60 + 30 * this._curs, this._cptCurs, 16 + 4);
                if (this._ok) {
                    if (this._curs == 1) {
                        this._intro = 0;
                        this._menuState = 12;
                        break;
                    }
                    this._menuState = 7;
                    this._curs = (byte)this._data[4];
                    this._kartX = 66;
                    this._kartMove = false;
                    this.Load_Circuit();
                    break;
                }
                if (!this._back) break;
                this._curs = 0;
                this._menuState = 6;
                break;
            }
            case 8: {
                this.Draw_Arrows(graphics);
                this._img[26].draw(graphics, this._kartX, 45, 2);
                this._img[29].draw(graphics, 66, 176, 2 + 32);
                int n = 0;
                while (n < 3) {
                    graphics.setColor(-2673658);
                    graphics.fillRect(65, 125 + 15 * n, 40, 4);
                    graphics.setColor(-11660030);
                    graphics.fillRect(65, 129 + 15 * n, 40, 2);
                    graphics.setColor(-128);
                    graphics.fillRect(65, 125 + 15 * n, (int)_stats[n + this._kart * 3], 4);
                    graphics.setColor(-273858);
                    graphics.fillRect(65, 129 + 15 * n, (int)_stats[n + this._kart * 3], 2);
                    n = (byte)(n + 1);
                }
                this._mu0.print(graphics, 22, 123, 33);
                this._mu0.print(graphics, 22, 138, 34);
                this._mu0.print(graphics, 22, 153, 35);
                if (!(this._kartMove || this._keyMap[4] <= 0 && this._keyMap[10] <= 0)) {
                    this._kartMove = true;
                    this._menuDir = 0;
                    this._cptArrowLeft = 1;
                } else if (!(this._kartMove || this._keyMap[5] <= 0 && this._keyMap[12] <= 0)) {
                    this._kartMove = true;
                    this._menuDir = 1;
                    this._cptArrowRight = 1;
                } else if (!this._kartMove) {
                    this._menuDir = (byte)-1;
                }
                this.Move();
                if (this._back) {
                    this._curs = 0;
                    this._menuState = 6;
                    break;
                }
                if (!this._ok) break;
                this._menuState = 7;
                this._curs = 0;
                this._kartX = 66;
                this._kartMove = false;
                this.Load_Circuit();
                break;
            }
            case 7: {
                if (this._mode == 0) {
                    this.Draw_Arrows(graphics);
                    this._img[25].draw(graphics, this._kartX, 40, 2);
                } else {
                    this._img[25].draw(graphics, this._kartX, 40, 2);
                }
                this._img[29].draw(graphics, 0, 176, 4 + 32);
                this._mu0.print(graphics, 10, 130, 36 + this._curs);
                if (this._mode == 0) {
                    this._mu0.print(graphics, 10, 145, 27 + this._locked[this._curs]);
                }
                this._img[30].draw(graphics, 87, 176, 4 + 32);
                if (this._mode == 0) {
                    if (!(this._kartMove || this._keyMap[4] <= 0 && this._keyMap[10] <= 0)) {
                        this._kartMove = true;
                        this._menuDir = 0;
                        this._cptArrowLeft = 1;
                    } else if (!(this._kartMove || this._keyMap[5] <= 0 && this._keyMap[12] <= 0)) {
                        this._kartMove = true;
                        this._menuDir = 1;
                        this._cptArrowRight = 1;
                    } else if (!this._kartMove) {
                        this._menuDir = (byte)-1;
                    }
                } else {
                    this._menuDir = (byte)-1;
                }
                this.Reset_Direction_Keys();
                this.Move();
                if (this._back) {
                    if (this._mode == 0) {
                        this._menuState = 8;
                        this._kartX = 66;
                        this._kart = 0;
                        this._kartMove = false;
                        this.Load_Car();
                        break;
                    }
                    if (this._mode != 1) break;
                    this._menuState = 6;
                    this._curs = 0;
                    break;
                }
                if (!this._ok) break;
                if (this._mode == 0 && this._locked[this._curs] == 0) {
                    this._mainState = 2;
                    this._cptLoad = 0;
                } else if (this._mode == 1) {
                    this._menuState = 9;
                    this._briefing = 0;
                    this._loadGarage = false;
                }
                this._level = this._curs;
                break;
            }
            case 9: {
                if (!this._loadGarage) {
                    if (this._level == 0) {
                        int n = 0;
                        while (n < 6) {
                            this._mu0.print(graphics, 5, 25 + 12 * n, 65 + n + this._briefing * 6, 2);
                            n = (byte)(n + 1);
                        }
                    } else if (this._level == 1) {
                        int n = 0;
                        while (n < 4) {
                            this._mu0.print(graphics, 5, 30 + 12 * n, 77 + n + this._briefing * 4, 2);
                            n = (byte)(n + 1);
                        }
                    } else if (this._level == 2) {
                        int n = 0;
                        while (n < 5) {
                            this._mu0.print(graphics, 5, 30 + 12 * n, 85 + n + this._briefing * 5, 2);
                            n = (byte)(n + 1);
                        }
                    } else if (this._level == 3) {
                        int n = 0;
                        while (n < 5) {
                            this._mu0.print(graphics, 5, 30 + 12 * n, 95 + n + this._briefing * 5, 2);
                            n = (byte)(n + 1);
                        }
                    } else if (this._level == 4) {
                        int n = 0;
                        while (n < 5) {
                            this._mu0.print(graphics, 5, 30 + 12 * n, 105 + n, 2);
                            n = (byte)(n + 1);
                        }
                    } else if (this._level == 5) {
                        int n = 0;
                        while (n < 4) {
                            this._mu0.print(graphics, 5, 30 + 12 * n, 110 + n + this._briefing * 4, 2);
                            n = (byte)(n + 1);
                        }
                    }
                    this._img[29].draw(graphics, 0, 176, 4 + 32);
                    this._mu0.print(graphics, 10, 130, 36 + this._curs);
                    this._mu0.print(graphics, 10, 145, 27 + this._locked[this._curs]);
                    this._img[30].draw(graphics, 87, 176, 4 + 32);
                    if (this._ok) {
                        if (this._briefing == 0 && this._level != 4) {
                            this._briefing = (byte)(this._briefing + 1);
                            break;
                        }
                        this._loadGarage = true;
                        graphics.setClip(0, 0, 132, 176);
                        graphics.setColor(-16777216);
                        graphics.fillRect(6, 72, 120, 30);
                        this._mu0.print(graphics, 5, 80, 24, 2);
                        break;
                    }
                    if (!this._back) break;
                    this._menuState = 7;
                    this._kartX = 66;
                    this._kartMove = false;
                    this.Load_Circuit();
                    break;
                }
                this._menuState = 11;
                this._garage = 0;
                this._gCurs = 0;
                this.Load_Garage();
                break;
            }
            case 11: {
                this._img[29].draw(graphics, 132, 176, 8 + 32);
                this._img[40].draw(graphics, 0, 176, 4 + 32);
                if (this._garage == 0) {
                    this._mu0.print(graphics, 30, 160, 118, 2);
                    this._mu0.print(graphics, 5, 25, 119, 2);
                    this._mu0.print(graphics, 5, 35, 120, 2);
                    this._mu0.print(graphics, 5, 60, 130, 2);
                    this._mu0.print(graphics, 5, 90, 121, 2);
                    this._img[31].drawFrame(graphics, 0, 30 + 30 * this._gCurs, this._cptCurs, 16 + 4);
                    this._img[32].drawFrame(graphics, 107, 30 + 30 * this._gCurs, this._cptCurs, 16 + 4);
                    if (this._keyMap[2] > 0 || this._keyMap[8] > 0) {
                        this._gCurs = (byte)(this._gCurs - 1);
                        if (this._gCurs < 0) {
                            this._gCurs = (byte)2;
                        }
                    } else if (this._keyMap[3] > 0 || this._keyMap[14] > 0) {
                        this._gCurs = (byte)(this._gCurs + 1);
                        if (this._gCurs > 2) {
                            this._gCurs = 0;
                        }
                    }
                    this.Reset_Direction_Keys();
                    if (this._ok) {
                        if (this._gCurs == 0) {
                            this._garage = 1;
                            this._gCurs = 0;
                        } else if (this._gCurs == 1) {
                            this._garage = (byte)3;
                            this._carX = 20;
                        } else {
                            this._img[35] = null;
                            this._img[33] = null;
                            this._img[36] = null;
                            this._img[34] = null;
                            this._img[39] = null;
                            this._img[38] = null;
                            this._img[37] = null;
                            this._img[41] = null;
                            this._img[42] = null;
                            this._img[40] = null;
                            this._mainState = 2;
                            this._cptLoad = 0;
                        }
                    } else if (this._back) {
                        this._img[35] = null;
                        this._img[33] = null;
                        this._img[36] = null;
                        this._img[34] = null;
                        this._img[39] = null;
                        this._img[38] = null;
                        this._img[37] = null;
                        this._img[40] = null;
                        this._img[41] = null;
                        this._img[42] = null;
                        this._curs = 0;
                        this._menuState = 6;
                    }
                } else if (this._garage == 1) {
                    byte by = 0;
                    while (by < 3) {
                        if (this._gCurs == by) {
                            this._img[37 + by].drawFrame(graphics, 66, 20 + 35 * by, 0, 2);
                        } else {
                            this._img[37 + by].drawFrame(graphics, 66, 20 + 35 * by, 1, 2);
                        }
                        by = (byte)(by + 1);
                    }
                    this._img[31].drawFrame(graphics, 5, 28 + 35 * this._gCurs, this._cptCurs, 16 + 4);
                    this._img[32].drawFrame(graphics, 102, 28 + 35 * this._gCurs, this._cptCurs, 16 + 4);
                    if (this._cptMsg == 0) {
                        this._mu0.print(graphics, 60, 130, 122 + this._gCurs);
                        this._mu0.print(graphics, 60, 145, _prize[this._gCurs] + " $");
                    } else if (this._cptMsg >= 10 && this._cptMsg < 30) {
                        this._mu0.print(graphics, 20, 130, 125, 2);
                        this._mu0.print(graphics, 20, 145, 126, 2);
                    } else if (this._cptMsg >= 30) {
                        this._mu0.print(graphics, 20, 130, 127, 2);
                        this._mu0.print(graphics, 20, 145, 128, 2);
                    }
                    this._mu0.print(graphics, 70, 1, this._data[3] + " $");
                    if (this._keyMap[2] > 0 || this._keyMap[8] > 0) {
                        this._gCurs = (byte)(this._gCurs - 1);
                        if (this._gCurs < 0) {
                            this._gCurs = (byte)2;
                        }
                    } else if (this._keyMap[3] > 0 || this._keyMap[14] > 0) {
                        this._gCurs = (byte)(this._gCurs + 1);
                        if (this._gCurs > 2) {
                            this._gCurs = 0;
                        }
                    } else if (this._ok) {
                        if (this._cptMsg > 0) {
                            this._cptMsg = 0;
                            return;
                        }
                        if (this._gCurs == 0 && this._data[0] == 1 || this._gCurs == 1 && this._data[1] == 1 || this._gCurs == 2 && this._data[2] == 1) {
                            this._cptMsg = 30;
                        } else if (this._data[3] < _prize[this._gCurs]) {
                            this._cptMsg = 10;
                        } else {
                            this._garage = (byte)2;
                            this._produit = this._gCurs;
                            this._carX = 20;
                            this._achat = 0;
                            this._gCurs = 0;
                        }
                    }
                    this.Reset_Direction_Keys();
                    if (this._cptMsg > 0) {
                        ++this._cptMsg;
                        if (this._cptMsg == 29 || this._cptMsg == 49) {
                            this._cptMsg = 0;
                        }
                    }
                } else if (this._garage >= 2) {
                    this._img[26].draw(graphics, this._carX, 45, 16 + 4);
                    if (this._data[2] == 1) {
                        this._img[35].draw(graphics, this._carX + _tuning[this._kart][0], 45 + _tuning[this._kart][1], 16 + 4);
                        this._img[36].draw(graphics, this._carX + _tuning[this._kart][2], 45 + _tuning[this._kart][3], 16 + 4);
                    }
                    if (this._data[0] == 1) {
                        this._img[33].draw(graphics, this._carX + _tuning[this._kart][4], 45 + _tuning[this._kart][5], 16 + 4);
                    }
                    if (this._data[1] == 1) {
                        this._img[34].draw(graphics, this._carX + _tuning[this._kart][6], 45 + _tuning[this._kart][7], 16 + 4);
                    }
                    if (this._garage == 3) {
                        if (this._ok || this._back) {
                            this._garage = 0;
                        }
                        return;
                    }
                    if (this._achat < 50) {
                        this._achat = (byte)(this._achat + 1);
                    }
                    if (this._achat > 15 && this._achat < 25) {
                        this._carX += 25;
                    } else if (this._achat == 25) {
                        this._data[this._produit] = 1;
                    } else if (this._achat > 25 && this._carX > 20) {
                        this._carX -= 25;
                    }
                    if (this._achat > 35) {
                        this._mu0.print(graphics, 25, 130, 129, 2);
                        this._mu0.print(graphics, 25, 145, 9, 2);
                        this._mu0.print(graphics, 25, 160, 10, 2);
                        this._img[31].drawFrame(graphics, 50, 145 + 15 * this._gCurs, this._cptCurs, 16 + 4);
                        if (this._keyMap[2] > 0 || this._keyMap[8] > 0 || this._keyMap[3] > 0 || this._keyMap[14] > 0) {
                            this._gCurs = (byte)(1 - this._gCurs);
                        }
                        this.Reset_Direction_Keys();
                        if (this._ok) {
                            if (this._gCurs == 0) {
                                this._data[3] = this._data[3] - _prize[this._produit];
                            } else {
                                this._data[this._produit] = 0;
                            }
                            this._garage = 1;
                            this._gCurs = 0;
                        }
                        if (this._back) {
                            this._data[this._produit] = 0;
                        }
                    }
                }
                if (this._garage <= 0 || !this._back) break;
                this._garage = 0;
                this._gCurs = 0;
                this._cptMsg = 0;
                break;
            }
            case 13: {
                int n = 0;
                while (n < 3) {
                    this._mu0.print(graphics, 5, 50 + 15 * n, 131 + n, 2);
                    n = (byte)(n + 1);
                }
                this._img[30].draw(graphics, 45, 176, 4 + 32);
                if (!this._ok && !this._back) break;
                this._menuState = 0;
                this._curs = 0;
                this.Init_Adventure();
                break;
            }
            case 1: {
                this._mu0.print(graphics, (int)BACK_X[this._lang], 166, 6);
                this._mu0.print(graphics, 5, 20, 42, 2);
                int n = 0;
                while (n < 4) {
                    this._mu0.print(graphics, 30, 40 + 12 * n, 43 + n);
                    n = (byte)(n + 1);
                }
                int n2 = 0;
                while (n2 < 4) {
                    this._mu0.print(graphics, 5, 100 + 12 * n2, 47 + n2, 2);
                    n2 = (byte)(n2 + 1);
                }
                if (!this._back && !this._ok) break;
                this._menuState = 0;
                this._curs = 0;
                break;
            }
            case 2: {
                this._mu0.print(graphics, (int)BACK_X[this._lang], 166, 6);
                int n = 0;
                while (n < 6) {
                    this._mu0.print(graphics, 2, 40 + 16 * n, 36 + n, 16 + 4);
                    this.Draw_Time(graphics, this._highScores[n], 80, 40 + 16 * n);
                    n = (byte)(n + 1);
                }
                if (!this._ok && !this._back) break;
                this._menuState = 0;
                this._curs = 0;
                break;
            }
            case 3: {
                this._mu0.print(graphics, (int)BACK_X[this._lang], 166, 6);
                if (this._keyMap[2] > 0 || this._keyMap[8] > 0 || this._keyMap[3] > 0 || this._keyMap[14] > 0) {
                    this.Reset_Direction_Keys();
                    this._curs = (byte)(1 - this._curs);
                }
                this._mu0.print(graphics, 5, 55, 7, 2);
                this._mu0.print(graphics, 5, 70, 9 + this._isMusic, 2);
                this._mu0.print(graphics, 5, 110, 11, 2);
                this._img[31].drawFrame(graphics, 0, 70 + 40 * this._curs, this._cptCurs, 16 + 4);
                this._img[32].drawFrame(graphics, 107, 70 + 40 * this._curs, this._cptCurs, 16 + 4);
                if (this._ok) {
                    if (this._curs == 0) {
                        if (this._isMusic == 0) {
                            this._isMusic = 1;
                            this._snd.Stop_Music();
                            break;
                        }
                        this._isMusic = 0;
                        this._curMusic = 1;
                        break;
                    }
                    this._img[10] = new Image2("/gfx/flags.png", 2, 6);
                    this._menuState = 5;
                    break;
                }
                if (!this._back) break;
                this._menuState = 0;
                this._curs = 0;
                break;
            }
            case 4: {
                int n = 0;
                while (n < 3) {
                    this._mu0.print(graphics, 5, 30 + 30 * n, 12 + n * 2, 2);
                    this._mu0.print(graphics, 5, 41 + 30 * n, 13 + n * 2, 2);
                    n = (byte)(n + 1);
                }
                this._mu0.print(graphics, 5, 125, 135, 2);
                int n3 = 0;
                while (n3 < 2) {
                    this._mu0.print(graphics, 5, 140 + 11 * n3, 136 + n3, 2);
                    n3 = (byte)(n3 + 1);
                }
                if (!this._ok && !this._back) break;
                this._menuState = 0;
                this._curs = 0;
                break;
            }
            case 5: {
                if (this._keyMap[2] > 0 || this._keyMap[8] > 0) {
                    this._lang = (byte)(this._lang - 1);
                    if (this._lang < 0) {
                        this._lang = (byte)5;
                    }
                } else if (this._keyMap[3] > 0 || this._keyMap[14] > 0) {
                    this._lang = (byte)(this._lang + 1);
                    if (this._lang > 5) {
                        this._lang = 0;
                    }
                }
                this.Reset_Direction_Keys();
                byte by = 0;
                while (by < 6) {
                    if (this._lang == by) {
                        this._img[10].drawFrame(graphics, 66, 15 + by * 26, by * 2, 2);
                    } else {
                        this._img[10].drawFrame(graphics, 66, 15 + by * 26, 1 + by * 2, 2);
                    }
                    by = (byte)(by + 1);
                }
                if (!this._ok && !this._back) break;
                if (this._mu0 != null) {
                    this._mu0 = null;
                    this._menuState = 3;
                } else {
                    this._menuState = 0;
                }
                this._mu0 = new MultiOutPut(132, 176, 1, -2, this._lang);
                this._img[10] = null;
            }
        }
        if (this._isMusic == 0 && this._snd._sp[0].getState() == 300 && this._snd._sp[1].getState() == 300) {
            this._snd.Start_Music(1);
        }
    }

    void Update_Option() {
        int n;
        if (this._cptOption >= 100) {
            this._option = true;
            this._optionY = 0;
            this._cptOption = 0;
            this._optionPos = this.Abs(this._rand.nextInt() % 3) + 1;
            n = this.Abs(this._rand.nextInt() % 10);
            if (this._mode == 0) {
                this._optionType = n <= 3 ? (byte)2 : (byte)1;
            } else if (this._mode == 1) {
                this._optionType = n <= 3 ? (byte)2 : (n <= 6 ? (byte)1 : 0);
            }
        }
        if (this._option) {
            n = (58 + this._optionY * 2) * this._optionPos / 4;
            this._optionX = 37 - this._optionY - this._roadX * this._optionY / 6 + this._decalX[this._optionY] + n;
            int n2 = 0;
            if (this._speed >= 240) {
                n2 = 5;
            } else if (this._speed >= 160) {
                n2 = 4;
            } else if (this._speed >= 100) {
                n2 = 3;
            } else if (this._speed >= 50) {
                n2 = 2;
            } else if (this._speed > 0) {
                n2 = 1;
            }
            this._optionY = this._optionY < 35 ? (this._optionY += n2) : (this._optionY += n2 * 2);
            if (this._optionY + 128 > 196) {
                this._option = false;
            }
            this._optionZoom = this._optionY / 10;
            if (this._optionZoom > 4) {
                this._optionZoom = 4;
            }
        } else if (this._optionCatched) {
            this._optionY -= 15;
            if (this._optionY + 128 < 0) {
                this._optionCatched = false;
            }
        }
    }

    void Update_Player() {
        if (!this._leftCol) {
            if ((this._keyMap[4] > 0 || this._keyMap[10] > 0) && this._noControl == 0) {
                --this._speedX;
                if (this._speedX < -this.SPEEDX_MAX) {
                    this._speedX = -this.SPEEDX_MAX;
                }
                if (this._inBend && this._bendX < 0) {
                    ++this._bendReduction;
                    this._scroll1 -= this._speedX;
                    this._scroll2 -= this._speedX / 2;
                    this._scroll3 -= this._speedX / 3;
                }
            } else if ((this._keyMap[5] > 0 || this._keyMap[12] > 0) && this._noControl == 0) {
                ++this._speedX;
                if (this._speedX > this.SPEEDX_MAX) {
                    this._speedX = this.SPEEDX_MAX;
                }
                if (this._inBend && this._bendX > 0) {
                    ++this._bendReduction;
                    this._scroll1 -= this._speedX;
                    this._scroll2 -= this._speedX / 2;
                    this._scroll3 -= this._speedX / 3;
                }
            } else if (this._noControl == 0) {
                this._speedX = this._speedX > 1 ? (this._speedX -= 2) : (this._speedX < -1 ? (this._speedX += 2) : 0);
                if (this._bendReduction > 0 && this._bendReduction < 4) {
                    ++this._bendReduction;
                    this._scroll1 -= this._speedX;
                    this._scroll2 -= this._speedX / 2;
                    this._scroll3 -= this._speedX / 3;
                }
            }
            this._turbo = this._keyMap[11] > 0 && this._turboSize > 0;
            if (this._bendReduction == 4) {
                this._bendReduction = 0;
                this._bendX = this._bendX > 0 ? --this._bendX : ++this._bendX;
                if (this._bendX == 0) {
                    this._bend = false;
                    this._inBend = false;
                    this._speedX = 0;
                    this.Reset_Direction_Keys();
                }
            }
            if (!this._inBend) {
                this._X += this._speedX / 2;
                this._roadX += this._speedX / 2;
            }
            this._frame = 3 - this._speedX / 2;
            if (this._level == 0 && this._X - 18 < this._xLeft) {
                this._speedX = 5;
                this._X = 18 + this._xLeft + 2;
                this._speed -= 80;
                if (this._inBend && this._bendX > 0) {
                    ++this._bendReduction;
                }
            } else if (this._X - 18 < this._xLeft || this._X + 18 > this._xRight) {
                ++this._cptOffroad;
                this._speed -= 5;
                this._vib = 1 - this._vib;
                if (this._speed == 0 || this._cptOffroad > 20) {
                    this.Reset_Data();
                    this._cptReset = 0;
                    this._reset = true;
                }
            } else {
                this._cptOffroad = 0;
                if (this._keyMap[3] > 0 || this._keyMap[14] > 0) {
                    this._speed -= 20;
                } else if (this._speed < this._speedMax) {
                    this._speed += this._acc;
                } else if (this._speed > this._speedMax) {
                    this._speed -= 5;
                }
            }
            if (this._level == 0 && this._roadX < -5) {
                this._roadX = -5;
            }
            byte by = 0;
            while (by < this._nbOpponent) {
                if (this._opp[by]._onScreen && this._cptCol == 0) {
                    Opponent cfr_ignored_0 = this._opp[by];
                    if (this._opp[by]._zoom == 4) {
                        if (this._opp[by]._posX - 18 >= this._X && this._opp[by]._posX - 12 <= this._X + 12) {
                            this._opp[by]._decalX = 36;
                            this._speedX = -4;
                            this._cptCol = 1;
                        } else if (this._opp[by]._posX + 18 <= this._X && this._opp[by]._posX + 12 >= this._X - 12) {
                            this._opp[by]._decalX = -36;
                            this._speedX = 4;
                            this._cptCol = 1;
                        }
                    } else {
                        Opponent cfr_ignored_1 = this._opp[by];
                        if (this._opp[by]._zoom == 4 - 1 && (this._opp[by]._posX - 7 >= this._X - 18 && this._opp[by]._posX - 7 <= this._X + 18 || this._opp[by]._posX + 7 >= this._X - 18 && this._opp[by]._posX + 7 <= this._X + 18)) {
                            this._speed -= 60;
                        }
                    }
                }
                by = (byte)(by + 1);
            }
            if (this._option && this._optionY + 128 < this._Y && this._optionY + 128 > this._Y - 20) {
                int n = 0;
                if (this._optionType == 2) {
                    n = 8;
                }
                if (this._optionX > this._X - 12 - n && this._optionX < this._X + 12 + n) {
                    this._option = false;
                    if (this._optionType == 0) {
                        this._optionCatched = true;
                        this._moneyRab += 50;
                    } else if (this._optionType == 1) {
                        this._optionCatched = true;
                        this._turboSize = this._kart <= 1 ? (this._turboSize += 15) : (this._turboSize += 20);
                        if (this._turboSize > 80) {
                            this._turboSize = 80;
                        }
                    } else if (this._optionType == 2) {
                        this._speed -= 40;
                        this._noControl = 1;
                        this._speedX = this._rand.nextInt() % 2 == 0 ? (this._speedX -= 3) : (this._speedX += 3);
                        if (this._speedX < -this.SPEEDX_MAX) {
                            this._speedX = -this.SPEEDX_MAX;
                        }
                        if (this._speedX > this.SPEEDX_MAX) {
                            this._speedX = this.SPEEDX_MAX;
                        }
                    }
                }
            }
        }
        if (this._noControl > 0) {
            this._noControl = (byte)(this._noControl + 1);
            if (this._noControl > 10) {
                this._noControl = 0;
            }
        }
        if (this._speed < 0) {
            this._speed = 0;
        }
        if (this._cptCol > 0) {
            ++this._cptCol;
            if (this._cptCol > 5) {
                this._cptCol = 0;
            }
        }
        if (this._bend && !this._inBend && this._bendY >= this._Y - 25 - 128) {
            this._inBend = true;
            this._bendReduction = 0;
        }
    }

    void Update_Road() {
        if (!this._bend && !this._finishLine) {
            this._cptRoad += this._speed / 10;
            if (this._cptRoad > _road[this._level][this._cptRace * 2] * 800) {
                this._cptRoad = 0;
                if (_road[this._level][this._cptRace * 2 + 1] != 0) {
                    this._bend = true;
                    this._bendX = _road[this._level][this._cptRace * 2 + 1];
                    this._bendY = 10;
                    ++this._cptRace;
                } else {
                    this._finishLine = true;
                    this._finish = 0;
                }
            }
        }
        if (this._speed <= 40) {
            if (this._cptMain % 2 == 0) {
                ++this._cptStripe;
                ++this._cptOption;
            }
            if (this._bend && this._cptMain % 2 == 0) {
                ++this._bendY;
            }
            if (this._inBend) {
                ++this._bendY;
            }
        } else if (this._speed <= 80) {
            ++this._cptStripe;
            ++this._cptOption;
            if (this._bend) {
                ++this._bendY;
            }
            if (this._inBend) {
                this._bendY += 2;
            }
        } else if (this._speed <= 140) {
            ++this._cptStripe;
            ++this._cptOption;
            if (this._bend) {
                this._bendY += 2;
            }
            if (this._inBend) {
                this._bendY += 3;
            }
        } else if (this._speed <= 230) {
            this._cptStripe += 2;
            this._cptOption += 2;
            if (this._bend) {
                this._bendY += 3;
            }
            if (this._inBend) {
                this._bendY += 4;
            }
        } else {
            this._cptStripe += 3;
            this._cptOption += 3;
            if (this._bend) {
                this._bendY += 4;
            }
            if (this._inBend) {
                this._bendY += 5;
            }
        }
        this._cptStripe %= 5;
    }

    protected void hideNotify() {
        this.Save_Records();
        this.GameExit();
        System.gc();
        this.midlet.destroyApp(false);
    }

    protected void keyPressed(int n) {
        if (this._mainState != 4 && this._mainState != 5) {
            return;
        }
        switch (n) {
            case -1: {
                this._keyMap[0] = 1;
                break;
            }
            case -4: {
                this._keyMap[1] = 1;
                break;
            }
            case -26: {
                this._keyMap[18] = 1;
                break;
            }
            case -59: {
                this._keyMap[2] = 1;
                break;
            }
            case -60: {
                this._keyMap[3] = 1;
                break;
            }
            case -61: {
                this._keyMap[4] = 1;
                break;
            }
            case -62: {
                this._keyMap[5] = 1;
                break;
            }
            case 48: {
                this._keyMap[6] = 1;
                break;
            }
            case 49: {
                this._keyMap[7] = 1;
                break;
            }
            case 50: {
                this._keyMap[8] = 1;
                break;
            }
            case 51: {
                this._keyMap[9] = 1;
                break;
            }
            case 52: {
                this._keyMap[10] = 1;
                break;
            }
            case 53: {
                this._keyMap[11] = 1;
                break;
            }
            case 54: {
                this._keyMap[12] = 1;
                break;
            }
            case 55: {
                this._keyMap[13] = 1;
                break;
            }
            case 56: {
                this._keyMap[14] = 1;
                break;
            }
            case 57: {
                this._keyMap[15] = 1;
                break;
            }
            case 42: {
                this._keyMap[16] = 1;
                break;
            }
            case 35: {
                this._keyMap[17] = 1;
            }
        }
    }

    protected void keyReleased(int n) {
        if (this._mainState != 4 && this._mainState != 5) {
            return;
        }
        switch (n) {
            case -1: {
                this._keyMap[0] = -1;
                break;
            }
            case -4: {
                this._keyMap[1] = -1;
                break;
            }
            case -26: {
                this._keyMap[18] = -1;
                break;
            }
            case -59: {
                this._keyMap[2] = -1;
                break;
            }
            case -60: {
                this._keyMap[3] = -1;
                break;
            }
            case -61: {
                this._keyMap[4] = -1;
                break;
            }
            case -62: {
                this._keyMap[5] = -1;
                break;
            }
            case 48: {
                this._keyMap[6] = -1;
                break;
            }
            case 49: {
                this._keyMap[7] = -1;
                break;
            }
            case 50: {
                this._keyMap[8] = -1;
                break;
            }
            case 51: {
                this._keyMap[9] = -1;
                break;
            }
            case 52: {
                this._keyMap[10] = -1;
                break;
            }
            case 53: {
                this._keyMap[11] = -1;
                break;
            }
            case 54: {
                this._keyMap[12] = -1;
                break;
            }
            case 55: {
                this._keyMap[13] = -1;
                break;
            }
            case 56: {
                this._keyMap[14] = -1;
                break;
            }
            case 57: {
                this._keyMap[15] = -1;
                break;
            }
            case 42: {
                this._keyMap[16] = -1;
                break;
            }
            case 35: {
                this._keyMap[17] = -1;
            }
        }
    }

    void keyUpdate() {
        int n = 0;
        n = 0;
        while (n < 19) {
            if (this._keyMap[n] > 0 && this._keyMap[n] < 21) {
                int n2 = n;
                this._keyMap[n2] = (byte)(this._keyMap[n2] + 1);
            } else if (this._keyMap[n] == -1) {
                this._keyMap[n] = -2;
            } else if (this._keyMap[n] == -2) {
                this._keyMap[n] = 0;
            }
            n = (byte)(n + 1);
        }
    }

    public void paint(Graphics graphics) {
        if (this._paint) {
            return;
        }
        this._paint = true;
        this._curMusic = (byte)-1;
        switch (this._mainState) {
            case 0: {
                graphics.setClip(0, 0, 132, 176);
                graphics.setColor(-1);
                graphics.fillRect(0, 0, 132, 176);
                if (this._media == null) {
                    this._media = new Image2("/gfx/mediaplazza.png", 1, 1);
                }
                if (System.currentTimeMillis() - this._begin < 2000L) {
                    this._media.draw(graphics, 66, 88, 1 + 2);
                    break;
                }
                this._mainState = 1;
                this._cptLoad = 0;
                break;
            }
            case 1: {
                if (this._cptLoad == 0) {
                    this._cptLoad = 1;
                    this._media = null;
                    this._img[0] = new Image2("/gfx/introscreen.png", 1, 1);
                    System.gc();
                } else if (this._cptLoad == 1) {
                    this._cptLoad = 2;
                    this._snd = new Sound(this);
                    this._snd.Load("/level/intro.mid", true, false, 0);
                    this._snd.Load("/level/menu.mid", true, true, 1);
                    this._curMusic = 0;
                } else {
                    this.Load_Menu();
                    this._img[31] = new Image2("/gfx/curseur_G.png", 2, 1);
                    this._img[32] = new Image2("/gfx/curseur_D.png", 2, 1);
                    this._mainState = 4;
                    if (this._lang == -1) {
                        this._img[10] = new Image2("/gfx/flags.png", 2, 6);
                        this._lang = 0;
                        this._menuState = 5;
                    } else {
                        this._mu0 = new MultiOutPut(132, 176, 1, -2, this._lang);
                        this._menuState = 0;
                    }
                    System.gc();
                }
                this._img[0].draw(graphics, 0, 0, 16 + 4);
                break;
            }
            case 2: {
                if (this._cptLoad == 0) {
                    this._img[0] = null;
                    this._snd.Stop_Music();
                    System.gc();
                    this._cptLoad = 1;
                } else {
                    this._img[2] = null;
                    this._img[1] = null;
                    this._img[27] = null;
                    this._img[28] = null;
                    this._img[29] = null;
                    this._img[30] = null;
                    this._img[26] = null;
                    this._img[25] = null;
                    System.gc();
                    if (!this._loadSoundGame) {
                        this._snd.Load("/level/run1.mid", true, true, 2);
                        this._snd.Load("/level/run2.mid", true, true, 3);
                        this._loadSoundGame = true;
                    }
                    this.Load_Level();
                    this._img[19] = this._kart == 0 ? new Image2("/gfx/car1.png", 1, 7) : (this._kart == 1 ? new Image2("/gfx/car2.png", 1, 7) : new Image2("/gfx/car3.png", 1, 7));
                    this._img[12] = new Image2("/gfx/jauge.png", 1, 1);
                    this._img[13] = new Image2("/gfx/flame.png", 1, 3);
                    this._img[20] = new Image2("/gfx/flag.png", 1, 1);
                    this._img[24] = new Image2("/gfx/nitroanim.png", 3, 1);
                    this._img[23] = new Image2("/gfx/panofinish.png", 5, 1);
                    this._img[45] = new Image2("/gfx/enemi1.png", 3, 5);
                    this._img[46] = new Image2("/gfx/enemi2.png", 3, 5);
                    this._img[47] = new Image2("/gfx/enemi3.png", 3, 5);
                    this._img[50] = new Image2("/gfx/option_oil.png", 1, 5);
                    this._img[49] = new Image2("/gfx/option_nitro.png", 5, 1);
                    this._img[48] = new Image2("/gfx/option_cash.png", 5, 1);
                    this._img[52] = new Image2("/gfx/depart.png", 3, 1);
                    this._img[53] = new Image2("/gfx/departcadre.png", 1, 1);
                    this._mainState = 5;
                    this._gameState = 0;
                    System.gc();
                }
                graphics.setClip(0, 0, 132, 176);
                graphics.setColor(-16777216);
                graphics.fillRect(0, 0, 132, 176);
                this._mu0.print(graphics, 5, 80, 24, 2);
                break;
            }
            case 3: {
                if (this._cptLoad == 0) {
                    this._snd.Stop_Music();
                    ++this._cptLoad;
                    System.gc();
                } else {
                    this._img[19] = null;
                    this._img[12] = null;
                    this._img[13] = null;
                    this._img[20] = null;
                    this._img[24] = null;
                    this._img[23] = null;
                    this._img[45] = null;
                    this._img[46] = null;
                    this._img[47] = null;
                    this._img[50] = null;
                    this._img[49] = null;
                    this._img[48] = null;
                    this._img[52] = null;
                    this._img[53] = null;
                    this._img[3] = null;
                    this._img[4] = null;
                    this._img[5] = null;
                    this._img[7] = null;
                    this._img[8] = null;
                    this._img[6] = null;
                    System.gc();
                    this.Load_Menu();
                    this._curMusic = 1;
                    this._mainState = 4;
                    if (this._continue) {
                        if (this._mode == 1) {
                            this._data[3] = this._data[3] + this._moneyRab;
                            if (this._position > 1) {
                                this._curs = this._level;
                                this._menuState = 7;
                                this._kartX = 66;
                                this._kartMove = false;
                                this.Load_Circuit();
                            } else {
                                this._data[4] = this._level + 1;
                                this._data[3] = this._data[3] + _reward[this._level];
                                if (this._level < 5) {
                                    this._locked[this._level + 1] = 0;
                                }
                                if (this._level == 5) {
                                    this._menuState = 13;
                                } else {
                                    this._curs = (byte)(this._level + 1);
                                    this._menuState = 7;
                                    this._kartX = 66;
                                    this._kartMove = false;
                                    this.Load_Circuit();
                                }
                            }
                        } else {
                            this._curs = this._position == 1 && this._level < 6 && this._locked[this._level + 1] == 0 ? (byte)(this._level + 1) : this._level;
                            this._menuState = 7;
                            this._kartX = 66;
                            this._kartMove = false;
                            this.Load_Circuit();
                        }
                    } else {
                        this._menuState = 0;
                        this._curs = 0;
                    }
                }
                graphics.setClip(0, 0, 132, 176);
                graphics.setColor(-16777216);
                graphics.fillRect(0, 0, 132, 176);
                this._mu0.print(graphics, 5, 80, 24, 2);
                break;
            }
            case 4: {
                this.Update_Menu(graphics);
                break;
            }
            case 5: {
                this.Update_Game(graphics);
            }
        }
        if (this._curMusic != -1) {
            this._snd.Start_Music(this._curMusic);
        }
        if (this._mu0 != null) {
            ++this._cptFps;
            if (this._showFPS) {
                graphics.setColor(-16777216);
                this._mu0.printValue(graphics, 0, 180, this._fps, 16 + 4);
            }
            if (System.currentTimeMillis() - this._t >= 1000L) {
                this._fps = this._cptFps;
                this._cptFps = 0;
                this._t = System.currentTimeMillis();
            }
        }
        if (System.currentTimeMillis() - this.last_paint < 30L) {
            try {
                Thread.sleep(30L - (System.currentTimeMillis() - this.last_paint));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this._paint = false;
    }

    public void run() {
        while (this._mainState != 6) {
            this.last_paint = System.currentTimeMillis();
            this.repaint();
            this.serviceRepaints();
            ++this._cptMain;
            this._cptCurs = this._cptMain % 4 / 2;
        }
        this.Save_Records();
        this.GameExit();
        System.gc();
        this.midlet.destroyApp(false);
    }
}

