/*
 * Decompiled with CFR 0.152.
 */
package com.kitmaker.games.common.midp20;

import com.kitmaker.games.common.ISoundController;
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;

public class SoundController
implements ISoundController {
    private Player[] aR;

    public void initializeSound(byte by) {
        this.destroy();
        this.aR = new Player[by];
    }

    public byte loadMIDI(InputStream inputStream) {
        int n = -1;
        if (this.aR != null) {
            n = 0;
            boolean bl = false;
            while (n < this.aR.length && !bl) {
                if (this.aR[n] == null) {
                    bl = true;
                    continue;
                }
                n = (byte)(n + 1);
            }
            if (!bl) {
                n = -1;
            } else {
                try {
                    this.aR[n] = Manager.createPlayer((InputStream)inputStream, (String)"audio/midi");
                    this.aR[n].realize();
                }
                catch (Exception exception) {
                    this.aR[n] = null;
                    n = -1;
                }
            }
        }
        return (byte)n;
    }

    public boolean prefetch(byte by) {
        boolean bl = false;
        if (this.aR != null && by > -1 && by < this.aR.length && this.aR[by] != null && this.aR[by].getState() == 200) {
            try {
                this.aR[by].prefetch();
                bl = true;
            }
            catch (Exception exception) {
                bl = false;
            }
        }
        return bl;
    }

    public boolean close(byte by) {
        boolean bl = false;
        if (this.aR != null && by > -1 && by < this.aR.length && this.aR[by] != null) {
            try {
                this.aR[by].close();
                bl = true;
            }
            catch (Exception exception) {
                bl = false;
            }
            finally {
                this.aR[by] = null;
            }
        }
        return bl;
    }

    public boolean deallocate(byte by) {
        boolean bl = false;
        if (this.aR != null && by > -1 && by < this.aR.length && this.aR[by] != null && this.aR[by].getState() == 300) {
            try {
                this.aR[by].deallocate();
                bl = true;
            }
            catch (Exception exception) {
                bl = false;
            }
        }
        return bl;
    }

    public boolean play(byte by) {
        boolean bl = false;
        if (this.aR != null && by > -1 && by < this.aR.length && this.aR[by] != null) {
            try {
                this.aR[by].setLoopCount(1);
                this.aR[by].start();
                bl = true;
            }
            catch (Exception exception) {
                bl = false;
            }
        }
        return bl;
    }

    public byte getPlayerState(byte by) {
        int n = -1;
        if (this.aR != null && by > -1 && by < this.aR.length && this.aR[by] != null) {
            switch (this.aR[by].getState()) {
                case 200: {
                    n = 1;
                    break;
                }
                case 300: {
                    n = 0;
                    break;
                }
                case 400: {
                    n = 2;
                    break;
                }
                default: {
                    n = -1;
                }
            }
        }
        return (byte)n;
    }

    public boolean stop(byte by) {
        boolean bl = false;
        if (this.aR != null && by > -1 && by < this.aR.length && this.aR[by] != null && this.aR[by].getState() == 400) {
            try {
                this.aR[by].stop();
                bl = true;
            }
            catch (Exception exception) {
                bl = false;
            }
        }
        return bl;
    }

    public void destroy() {
        if (this.aR != null) {
            for (int i = 0; i < this.aR.length; ++i) {
                if (this.aR[i] == null) continue;
                this.aR[i].close();
                this.aR[i] = null;
            }
        }
    }

    public byte getFirstPrefetchedPlayer() {
        byte by = -1;
        if (this.aR != null) {
            for (int i = 0; i < this.aR.length; ++i) {
                Player player;
                int n;
                if (this.aR[i] == null || (n = (player = this.aR[i]).getState()) == 300 || n == 400) continue;
                by = (byte)i;
                break;
            }
        }
        return by;
    }

    public boolean isSoundSupported() {
        return true;
    }
}

