/*
 * Decompiled with CFR 0.152.
 */
import java.io.InputStream;
import javax.microedition.lcdui.Image;

public class CSpriteManager {
    private static final int MASK_EXPORT_IMAGES = 1;
    private static final int MASK_EXPORT_MODULES = 2;
    private static final int MASK_EXPORT_FMODULES = 4;
    private static final int MASK_EXPORT_FRAMES = 8;
    private static final int MASK_EXPORT_AFRAMES = 16;
    private static final int MASK_EXPORT_ANIMS = 32;
    private static final int MASK_EXPORT_MODULES_IMAGEIDX = 64;
    private static final int MASK_EXPORT_FMODULES_FLAG = 128;
    private static final int MASK_EXPORT_FRAME_COLLISION = 256;
    private static final int MASK_EXPORT_FRAME_HITPOINTS = 512;
    private static final int MASK_EXPORT_AFRAMES_OFFSETS = 1024;
    private static final int MASK_EXPORT_AFRAMES_FLAGS = 2048;
    private static final int MASK_EXPORT_AFRAMES_TIME = 4096;
    private static final int MASK_MODULE_XYWH_ON_SHORT = 1;
    private static final int MASK_FMODULE_MODULEID_ON_SHORT = 2;
    private static final int MASK_FMODULE_OFFSETS_ON_SHORT = 4;
    private static final int MASK_FRAME_COLLISION_ON_SHORT = 8;
    private static final int MASK_FRAME_HITPOINTS_ON_SHORT = 16;
    private static final int MASK_FRAME_FMODULES_ON_SHORT = 32;
    private static final int MASK_AFRAME_OFFSETS_ON_SHORT = 64;
    private static final int MASK_AFRAME_FRAMEIDS_ON_SHORT = 128;
    private static final int MASK_ANIMS_AFRAMES_ON_SHORT = 256;
    private static final byte IMAGE_NOT_LOADED = 0;
    private static final byte IMAGE_LOADED = 1;
    private static final byte IMAGE_INVALIDATED = 2;
    private static final byte IMAGE_SPECIAL = 3;
    public String rootDir = "/";
    public String loadedFile = "";
    public int flagsA = 0;
    public int flagsB = 0;
    public short imageNo = 0;
    public byte[] imageFlags = null;
    public String[] imageNames = null;
    public byte[] imageStatus = null;
    public Image[] imageBuffer;
    public boolean imageNamesLoaded = false;
    public int moduleNo = 0;
    public byte[] module_imgIdx = null;
    public short[] moduleX = null;
    public short[] moduleY = null;
    public short[] moduleW = null;
    public short[] moduleH = null;
    public int fmoduleNo = 0;
    public short[] fmodule_moduleIdx = null;
    public short[] fmodule_ox = null;
    public short[] fmodule_oy = null;
    public byte[] fmodule_flags = null;
    public int framesNo = 0;
    public short[] frame_collX = null;
    public short[] frame_collY = null;
    public short[] frame_collW = null;
    public short[] frame_collH = null;
    public byte[] frame_hitPtsVal = null;
    public short[][] frame_hitPtsPosXY = null;
    public short[][] frame_fmodulesIdx = null;
    public int aframesNo = 0;
    public short[] aframe_ox = null;
    public short[] aframe_oy = null;
    public byte[] aframe_flags = null;
    public short[] aframe_duration = null;
    public short[] aframe_frameIdx = null;
    public int animationNo = 0;
    public short[][] animation_aframeIdx = null;
    public byte[] animation_flags = null;
    int spr_index = -1;

    public CSpriteManager() {
        this.rootDir = "/";
    }

    public CSpriteManager(String root) {
        this.rootDir = root;
    }

    public void load(int index, boolean loadImageNames, boolean allocateImages) {
        int j;
        int i;
        this.spr_index = index;
        InputStream is = CGlobals.getFile(index);
        CGlobals.closeFile(index);
        byte version = CGlobals.readByte(is);
        if (version != 1) {
            System.err.println("CSpriteManager::load() -> wrong file version\nAccepts version 1 but version is:" + version);
            return;
        }
        this.flagsA = CGlobals.readShort(is);
        this.flagsB = CGlobals.readShort(is);
        if ((this.flagsA & 1) != 0) {
            this.imageNo = CGlobals.readUnsignedByte(is);
            System.err.println("img no=" + this.imageNo);
            this.imageFlags = new byte[this.imageNo];
            this.imageStatus = new byte[this.imageNo];
            this.imageBuffer = new Image[this.imageNo];
            for (i = 0; i < this.imageNo; ++i) {
                this.imageFlags[i] = (byte)CGlobals.readUnsignedByte(is);
                this.imageStatus[i] = 2;
            }
        }
        if ((this.flagsA & 2) != 0) {
            this.moduleNo = CGlobals.readShort(is);
            System.err.println("modules=" + this.moduleNo);
            this.moduleX = new short[this.moduleNo];
            this.moduleY = new short[this.moduleNo];
            this.moduleW = new short[this.moduleNo];
            this.moduleH = new short[this.moduleNo];
            if ((this.flagsA & 0x40) != 0) {
                this.module_imgIdx = new byte[this.moduleNo];
            }
            for (i = 0; i < this.moduleNo; ++i) {
                if ((this.flagsA & 0x40) != 0) {
                    this.module_imgIdx[i] = (byte)CGlobals.readUnsignedByte(is);
                }
                if ((this.flagsB & 1) != 0) {
                    this.moduleX[i] = CGlobals.readShort(is);
                    this.moduleY[i] = CGlobals.readShort(is);
                    this.moduleW[i] = CGlobals.readShort(is);
                    this.moduleH[i] = CGlobals.readShort(is);
                    continue;
                }
                this.moduleX[i] = CGlobals.readUnsignedByte(is);
                this.moduleY[i] = CGlobals.readUnsignedByte(is);
                this.moduleW[i] = CGlobals.readUnsignedByte(is);
                this.moduleH[i] = CGlobals.readUnsignedByte(is);
            }
        }
        CGame.DBG("loading Fmodules");
        if ((this.flagsA & 4) != 0) {
            this.fmoduleNo = CGlobals.readShort(is);
            System.err.println("fmodules=" + this.fmoduleNo);
            this.fmodule_moduleIdx = new short[this.fmoduleNo];
            this.fmodule_ox = new short[this.fmoduleNo];
            this.fmodule_oy = new short[this.fmoduleNo];
            if ((this.flagsA & 0x80) != 0) {
                this.fmodule_flags = new byte[this.fmoduleNo];
            }
            for (i = 0; i < this.fmoduleNo; ++i) {
                this.fmodule_moduleIdx[i] = (this.flagsB & 2) != 0 ? CGlobals.readShort(is) : CGlobals.readUnsignedByte(is);
                if ((this.flagsB & 4) != 0) {
                    this.fmodule_ox[i] = CGlobals.readShort(is);
                    this.fmodule_oy[i] = CGlobals.readShort(is);
                } else {
                    this.fmodule_ox[i] = CGlobals.readByte(is);
                    this.fmodule_oy[i] = CGlobals.readByte(is);
                }
                if ((this.flagsA & 0x80) == 0) continue;
                this.fmodule_flags[i] = CGlobals.readByte(is);
            }
        }
        CGame.DBG("loading frames");
        if ((this.flagsA & 8) != 0) {
            this.framesNo = CGlobals.readShort(is);
            this.frame_fmodulesIdx = new short[this.framesNo][];
            if ((this.flagsA & 0x100) != 0) {
                this.frame_collX = new short[this.framesNo];
                this.frame_collY = new short[this.framesNo];
                this.frame_collW = new short[this.framesNo];
                this.frame_collH = new short[this.framesNo];
            }
            if ((this.flagsA & 0x200) != 0) {
                this.frame_hitPtsVal = new byte[this.framesNo];
                this.frame_hitPtsPosXY = new short[this.framesNo][];
            }
            for (i = 0; i < this.framesNo; ++i) {
                if ((this.flagsA & 0x100) != 0) {
                    if ((this.flagsB & 8) != 0) {
                        this.frame_collX[i] = CGlobals.readShort(is);
                        this.frame_collY[i] = CGlobals.readShort(is);
                        this.frame_collW[i] = CGlobals.readShort(is);
                        this.frame_collH[i] = CGlobals.readShort(is);
                    } else {
                        this.frame_collX[i] = CGlobals.readByte(is);
                        this.frame_collY[i] = CGlobals.readByte(is);
                        this.frame_collW[i] = CGlobals.readUnsignedByte(is);
                        this.frame_collH[i] = CGlobals.readUnsignedByte(is);
                    }
                }
                if ((this.flagsA & 0x200) != 0) {
                    byte frame_hitPtsNo = (byte)CGlobals.readShort(is);
                    this.frame_hitPtsPosXY[i] = new short[frame_hitPtsNo * 2];
                    this.frame_hitPtsVal[i] = CGlobals.readByte(is);
                    for (j = 0; j < frame_hitPtsNo; ++j) {
                        if ((this.flagsB & 0x10) != 0) {
                            this.frame_hitPtsPosXY[i][j * 2] = CGlobals.readShort(is);
                            this.frame_hitPtsPosXY[i][j * 2 + 1] = CGlobals.readShort(is);
                            continue;
                        }
                        this.frame_hitPtsPosXY[i][j * 2] = CGlobals.readByte(is);
                        this.frame_hitPtsPosXY[i][j * 2 + 1] = CGlobals.readByte(is);
                    }
                }
                int frame_fmodulesNo = CGlobals.readUnsignedByte(is);
                this.frame_fmodulesIdx[i] = new short[frame_fmodulesNo];
                for (j = 0; j < frame_fmodulesNo; ++j) {
                    this.frame_fmodulesIdx[i][j] = (this.flagsB & 0x20) != 0 ? CGlobals.readShort(is) : CGlobals.readUnsignedByte(is);
                }
            }
        }
        CGame.DBG("loading aframes");
        if ((this.flagsA & 0x10) != 0) {
            this.aframesNo = CGlobals.readShort(is);
            this.aframe_frameIdx = new short[this.aframesNo];
            if ((this.flagsA & 0x400) != 0) {
                this.aframe_ox = new short[this.aframesNo];
                this.aframe_oy = new short[this.aframesNo];
            }
            if ((this.flagsA & 0x800) != 0) {
                this.aframe_flags = new byte[this.aframesNo];
            }
            if ((this.flagsA & 0x1000) != 0) {
                this.aframe_duration = new short[this.aframesNo];
            }
            for (i = 0; i < this.aframesNo; ++i) {
                if ((this.flagsA & 0x400) != 0) {
                    if ((this.flagsB & 0x40) != 0) {
                        this.aframe_ox[i] = CGlobals.readShort(is);
                        this.aframe_oy[i] = CGlobals.readShort(is);
                    } else {
                        this.aframe_ox[i] = CGlobals.readByte(is);
                        this.aframe_oy[i] = CGlobals.readByte(is);
                    }
                }
                if ((this.flagsA & 0x800) != 0) {
                    this.aframe_flags[i] = CGlobals.readByte(is);
                }
                if ((this.flagsA & 0x1000) != 0) {
                    this.aframe_duration[i] = CGlobals.readUnsignedByte(is);
                }
                this.aframe_frameIdx[i] = (this.flagsB & 0x80) != 0 ? CGlobals.readShort(is) : CGlobals.readUnsignedByte(is);
            }
        }
        CGame.DBG("loading animations");
        if ((this.flagsA & 0x20) != 0) {
            this.animationNo = CGlobals.readShort(is);
            System.err.println("anim count=" + this.animationNo);
            this.animation_aframeIdx = new short[this.animationNo][];
            this.animation_flags = new byte[this.animationNo];
            for (i = 0; i < this.animationNo; ++i) {
                this.animation_flags[i] = CGlobals.readByte(is);
                short animation_aframeCnt = CGlobals.readUnsignedByte(is);
                this.animation_aframeIdx[i] = new short[animation_aframeCnt];
                for (j = 0; j < animation_aframeCnt; ++j) {
                    this.animation_aframeIdx[i][j] = (this.flagsB & 0x100) != 0 ? CGlobals.readShort(is) : CGlobals.readUnsignedByte(is);
                }
            }
        }
        try {
            is.close();
        }
        catch (Exception ex) {
            CGame.DBG("could not close InputStream");
        }
        this.imageNamesLoaded = true;
        if (allocateImages) {
            this.RestoreDeviceObjects(true, true);
        }
    }

    int loadAnimationImages(int animID) {
        for (int ii = 0; ii < this.animation_aframeIdx[animID].length; ++ii) {
            int fmodules = this.frame_fmodulesIdx[this.aframe_frameIdx[this.animation_aframeIdx[animID][ii]]].length;
            for (int jj = 0; jj < fmodules; ++jj) {
                short fmoduleid = this.frame_fmodulesIdx[this.aframe_frameIdx[this.animation_aframeIdx[animID][ii]]][jj];
                byte imgIdx = this.module_imgIdx[this.fmodule_moduleIdx[fmoduleid]];
                System.err.println("img idx=" + imgIdx);
                this.imageStatus[imgIdx] = 3;
            }
        }
        this.RestoreDeviceObjects(false, true);
        return 0;
    }

    int InvalidateDeviceObjects() {
        int count = 0;
        for (int ii = 0; ii < this.imageNo; ++ii) {
            if (this.imageStatus[ii] != 1) continue;
            this.imageBuffer[ii] = null;
            this.imageStatus[ii] = 2;
            ++count;
        }
        System.gc();
        return count;
    }

    int RestoreDeviceObjects(boolean restoreInvalidated, boolean restoreSpecial) {
        int count = 0;
        System.err.println("image number=" + this.imageNo);
        for (int ii = 0; ii < this.imageNo; ++ii) {
            if ((this.imageStatus[ii] != 2 || !restoreInvalidated) && (this.imageStatus[ii] != 3 || !restoreSpecial)) continue;
            try {
                if (this.imageNamesLoaded) {
                    byte imgFlag = (byte)(this.imageFlags[ii] & 3);
                    if (imgFlag == 0) {
                        this.imageBuffer[ii] = Image.createImage((byte[])CGlobals.getBuffer(this.spr_index + 1 + ii), (int)0, (int)CGlobals.getBuffer(this.spr_index + 1 + ii).length);
                        CGlobals.closeFile(this.spr_index + ii);
                    }
                } else {
                    this.imageBuffer[ii] = CGlobals.getImg(this.getClass().getResourceAsStream(this.rootDir + this.loadedFile + ".pak"), ii, 0);
                }
                this.imageStatus[ii] = 1;
                ++count;
                continue;
            }
            catch (Exception ex) {
                CGame.DBG("restore device objects failed!\nCould not load " + this.imageNames[ii] + "\n" + ex.toString());
            }
        }
        System.gc();
        return count;
    }

    static int getHEADER(int header, byte[] pngTemp) {
        for (int i = 0; i < pngTemp.length; ++i) {
            long actualValue = 0L;
            for (int j = i; j < i + 4; ++j) {
                actualValue += (long)((pngTemp[j] & 0xFF) << 8 * (3 - (j - i)));
            }
            if (actualValue != (long)header) continue;
            return i;
        }
        return -1;
    }
}

