/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;

public class CActor {
    public static final byte ANIMATION_FLAG_LOOPED = 1;
    public static final int ANIM_PLAYING = 0;
    public static final int ANIM_PLAYING_FRAME_ADVANCED = 1;
    public static final int ANIM_FRAMELOCK = 2;
    public int animationID;
    public int posX;
    public int posY;
    public int framesPassed;
    public int currentFrame;
    public boolean framelock;

    public CActor() {
        this.posX = 0;
        this.posY = 0;
        this.framelock = false;
    }

    public CActor(int animID, int pX, int pY) {
        this.animationID = animID;
        this.posX = pX;
        this.posY = pY;
        this.framesPassed = 0;
        this.currentFrame = 0;
        this.framelock = false;
    }

    public void initActor(int animID, int pX, int pY) {
        this.animationID = animID;
        this.posX = pX;
        this.posY = pY;
        this.framesPassed = 0;
        this.currentFrame = 0;
        this.framelock = false;
    }

    public void setAnimation(int animID) {
        this.animationID = animID;
        this.framesPassed = 0;
        this.currentFrame = 0;
        this.framelock = false;
    }

    public int update(CSpriteManager sprManager, boolean updatePos) {
        int retval = 0;
        if (this.framelock) {
            return 2;
        }
        short aframeID = sprManager.animation_aframeIdx[this.animationID][this.currentFrame];
        if (this.framesPassed == 0) {
            retval = 1;
            if (updatePos && (sprManager.flagsA & 0x400) != 0) {
                this.posX += sprManager.aframe_ox[aframeID];
                this.posY += sprManager.aframe_oy[aframeID];
            }
        }
        ++this.framesPassed;
        if (this.framesPassed >= sprManager.aframe_duration[aframeID]) {
            this.framesPassed = 0;
            ++this.currentFrame;
            if (this.currentFrame >= sprManager.animation_aframeIdx[this.animationID].length) {
                if ((sprManager.animation_flags[this.animationID] & 1) == 0) {
                    --this.currentFrame;
                    this.framelock = true;
                    retval = 2;
                } else {
                    this.currentFrame = 0;
                    retval = 1;
                }
            }
        }
        return retval;
    }

    public void draw(Graphics g, CSpriteManager sprManager) {
        short frameID = sprManager.aframe_frameIdx[sprManager.animation_aframeIdx[this.animationID][this.currentFrame]];
        int modulesCount = sprManager.frame_fmodulesIdx[frameID].length;
        for (int ii = 0; ii < modulesCount; ++ii) {
            short fmoduleIdx = sprManager.frame_fmodulesIdx[frameID][ii];
            int drawflag = 0;
            if ((sprManager.flagsA & 0x80) != 0) {
                byte flag = sprManager.fmodule_flags[fmoduleIdx];
                if ((flag & 1) != 0) {
                    drawflag = 1;
                }
                if ((flag & 2) != 0) {
                    drawflag |= 2;
                }
            }
            short moduleIdx = sprManager.fmodule_moduleIdx[fmoduleIdx];
            try {
                g.drawRegion(sprManager.imageBuffer[sprManager.module_imgIdx[moduleIdx]], (int)sprManager.moduleX[moduleIdx], (int)sprManager.moduleY[moduleIdx], (int)sprManager.moduleW[moduleIdx], (int)sprManager.moduleH[moduleIdx], drawflag, this.posX + sprManager.fmodule_ox[fmoduleIdx], this.posY + sprManager.fmodule_oy[fmoduleIdx], 0);
                continue;
            }
            catch (Exception ex) {
                CGame.DBG("CActor.paint error:\n" + ex.toString());
            }
        }
    }

    public int getFrameWidth(CSpriteManager sprManager) {
        short frameID = sprManager.aframe_frameIdx[sprManager.animation_aframeIdx[this.animationID][this.currentFrame]];
        int modulesCount = sprManager.frame_fmodulesIdx[frameID].length;
        int width = 0;
        for (int ii = 0; ii < modulesCount; ++ii) {
            short fmoduleIdx = sprManager.frame_fmodulesIdx[frameID][ii];
            short moduleIdx = sprManager.fmodule_moduleIdx[fmoduleIdx];
            if (width >= this.posX + sprManager.fmodule_ox[fmoduleIdx] + sprManager.moduleW[moduleIdx]) continue;
            width = this.posX + sprManager.fmodule_ox[fmoduleIdx] + sprManager.moduleW[moduleIdx];
        }
        return Math.abs(width - this.posX);
    }

    public int getFrameHeight(CSpriteManager sprManager) {
        short frameID = sprManager.aframe_frameIdx[sprManager.animation_aframeIdx[this.animationID][this.currentFrame]];
        int modulesCount = sprManager.frame_fmodulesIdx[frameID].length;
        int height = 0;
        for (int ii = 0; ii < modulesCount; ++ii) {
            short fmoduleIdx = sprManager.frame_fmodulesIdx[frameID][ii];
            short moduleIdx = sprManager.fmodule_moduleIdx[fmoduleIdx];
            if (height >= this.posY + sprManager.fmodule_oy[fmoduleIdx] + sprManager.moduleH[moduleIdx]) continue;
            height = this.posY + sprManager.fmodule_oy[fmoduleIdx] + sprManager.moduleH[moduleIdx];
        }
        return Math.abs(height - this.posY);
    }
}

