/*
 * Decompiled with CFR 0.152.
 */
package AfterDark;

import com.nokia.mid.sound.Sound;

public class InstrumentChannel {
    private Sound soundCH = null;
    private byte[] musicCH = null;
    private int soundFormat = 1;

    public InstrumentChannel(byte[] music, int soundFormat) {
        this.musicCH = music;
        this.soundCH = new Sound(this.musicCH, soundFormat);
        this.soundFormat = soundFormat;
    }

    public void Initial(byte[] music, int soundFormat) {
        this.musicCH = music;
        this.soundCH.init(this.musicCH, soundFormat);
        this.soundFormat = soundFormat;
    }

    public void Play(int loop) {
        this.soundCH.play(loop);
    }

    public void Stop() {
        this.soundCH.stop();
        this.soundCH.init(this.musicCH, this.soundFormat);
    }

    public void Pause() {
        if (this.soundCH != null) {
            this.soundCH.stop();
        }
    }

    public void Resume() {
        if (this.soundCH != null) {
            this.soundCH.resume();
        }
    }

    public void SetVolume(int level) {
        this.soundCH.setGain(level);
    }

    public int GetVolume() {
        return this.soundCH.getGain();
    }
}

