/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDlet;

public final class BPFontReader {
    private static final String RESOURCES_FILE_NAME = "r";
    public static String[][] textAsString;
    public static String[][] langsAsString;
    public static byte[][][] textAsOffset;
    public static byte[][][] langsAsOffset;
    static char[][] alphabetAsChar;
    static char[][] specialsAsChar;
    static byte[][][] specialsAsOffset;
    static byte[][] posX;
    static byte[][] posY;
    public static Image[][] alphabetAsImage;
    public static byte[][] alphabetWidth;
    public static Image[][] specialsAsImage;
    public static byte[][] specialsWidth;
    public static byte[][] specialsHeight;
    static byte[] fontHeight;
    public static short[] specMaxUp;
    public static short[] alphabetIndex;
    public static short[] langsAlphabetIndex;
    public static short[] letterSpacing;
    public static short[] langsLetterSpacing;
    static int[] langSize;
    static int currentLoadLang;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(MIDlet midlet, boolean graphicOnly, boolean loadImages) {
        FilterInputStream buff = null;
        try {
            int a;
            buff = new DataInputStream(midlet.getClass().getResourceAsStream(RESOURCES_FILE_NAME));
            ((DataInputStream)buff).readByte();
            short ilJezykow = ((DataInputStream)buff).readByte();
            langSize = new int[ilJezykow + 1];
            BPFontReader.langSize[0] = ((DataInputStream)buff).readInt();
            for (short l = 0; l < ilJezykow; l = (short)(l + 1)) {
                BPFontReader.langSize[l + 1] = ((DataInputStream)buff).readInt();
            }
            int alphabetCount = ((DataInputStream)buff).readByte();
            alphabetAsImage = new Image[alphabetCount][];
            alphabetWidth = new byte[alphabetCount][];
            specialsAsImage = new Image[alphabetCount][];
            specialsWidth = new byte[alphabetCount][];
            specialsHeight = new byte[alphabetCount][];
            fontHeight = new byte[alphabetCount];
            for (a = 0; a < alphabetCount; ++a) {
                int _alphabetImgLength = ((DataInputStream)buff).readShort();
                BPFontReader.alphabetAsImage[a] = new Image[_alphabetImgLength];
                BPFontReader.alphabetWidth[a] = new byte[_alphabetImgLength];
                BPFontReader.fontHeight[a] = ((DataInputStream)buff).readByte();
                short _paletteSize = ((DataInputStream)buff).readShort();
                for (int i = 0; i < _alphabetImgLength; ++i) {
                    BPFontReader.alphabetWidth[a][i] = ((DataInputStream)buff).readByte();
                }
                byte[] _tempPalette = new byte[_paletteSize];
                ((DataInputStream)buff).read(_tempPalette);
                int[] _paletteData = new int[_paletteSize / 3];
                for (int i = 0; i < _paletteSize / 3; ++i) {
                    int alpha = 255;
                    if (i == 0) {
                        alpha = 0;
                    }
                    _paletteData[i] = alpha << 24 | (_tempPalette[i * 3 + 0] & 0xFF) << 16 | (_tempPalette[i * 3 + 1] & 0xFF) << 8 | _tempPalette[i * 3 + 2] & 0xFF;
                }
                byte[] _imageData = null;
                for (int i = 0; i < _alphabetImgLength; ++i) {
                    _imageData = new byte[fontHeight[a] * (alphabetWidth[a][i] - 1)];
                    ((DataInputStream)buff).read(_imageData);
                    BPFontReader.alphabetAsImage[a][i] = BPGraphics.createFromBGSCreateRGBImageVersion(alphabetWidth[a][i] - 1, fontHeight[a], (byte)0, (byte)0, _imageData, _paletteData, true, false);
                }
                Object imageInBytes = null;
                Object tmpImg = null;
                int len = ((DataInputStream)buff).readShort();
                if (len != 0) {
                    int i;
                    BPFontReader.specialsAsImage[a] = new Image[len];
                    BPFontReader.specialsWidth[a] = new byte[len];
                    BPFontReader.specialsHeight[a] = new byte[len];
                    _paletteSize = ((DataInputStream)buff).readShort();
                    for (i = 0; i < len; ++i) {
                        BPFontReader.specialsWidth[a][i] = ((DataInputStream)buff).readByte();
                        BPFontReader.specialsHeight[a][i] = ((DataInputStream)buff).readByte();
                    }
                    _tempPalette = new byte[_paletteSize];
                    ((DataInputStream)buff).read(_tempPalette);
                    _paletteData = new int[_paletteSize / 3];
                    for (i = 0; i < _paletteSize / 3; ++i) {
                        int alpha = 255;
                        if (i == 0) {
                            alpha = 0;
                        }
                        _paletteData[i] = alpha << 24 | (_tempPalette[i * 3 + 0] & 0xFF) << 16 | (_tempPalette[i * 3 + 1] & 0xFF) << 8 | _tempPalette[i * 3 + 2] & 0xFF;
                    }
                    _imageData = null;
                    for (i = 0; i < len; ++i) {
                        _imageData = new byte[specialsWidth[a][i] * specialsHeight[a][i]];
                        ((DataInputStream)buff).read(_imageData);
                        BPFontReader.specialsAsImage[a][i] = BPGraphics.createFromBGSCreateRGBImageVersion(specialsWidth[a][i], specialsHeight[a][i], (byte)0, (byte)0, _imageData, _paletteData, true, false);
                    }
                    continue;
                }
                BPFontReader.specialsAsImage[a] = null;
            }
            if (graphicOnly) {
                return;
            }
            specMaxUp = new short[alphabetCount];
            alphabetAsChar = new char[alphabetCount][];
            specialsAsChar = new char[alphabetCount][];
            specialsAsOffset = new byte[alphabetCount][][];
            posX = new byte[alphabetCount][];
            posY = new byte[alphabetCount][];
            for (a = 0; a < alphabetCount; a = (int)((short)(a + 1))) {
                int alphabetLength = ((DataInputStream)buff).readInt();
                BPFontReader.alphabetAsChar[a] = new char[alphabetLength];
                for (int c = 0; c < alphabetLength; c = (int)((short)(c + 1))) {
                    BPFontReader.alphabetAsChar[a][c] = (char)(((DataInputStream)buff).readChar() ^ c);
                }
                int specCount = ((DataInputStream)buff).readByte();
                BPFontReader.specialsAsChar[a] = new char[specCount];
                BPFontReader.specialsAsOffset[a] = new byte[specCount][2];
                BPFontReader.posX[a] = new byte[specCount];
                BPFontReader.posY[a] = new byte[specCount];
                for (int s = 0; s < specCount; ++s) {
                    BPFontReader.specialsAsChar[a][s] = (char)(((DataInputStream)buff).readChar() ^ s);
                    BPFontReader.specialsAsOffset[a][s][0] = ((DataInputStream)buff).readByte();
                    BPFontReader.specialsAsOffset[a][s][1] = ((DataInputStream)buff).readByte();
                    BPFontReader.posX[a][s] = ((DataInputStream)buff).readByte();
                    BPFontReader.posY[a][s] = ((DataInputStream)buff).readByte();
                }
            }
            int langCounter = ((DataInputStream)buff).readByte();
            langsAsString = new String[langCounter][];
            langsAlphabetIndex = new short[langCounter];
            langsLetterSpacing = new short[langCounter];
            langsAsOffset = new byte[langCounter][][];
            for (int lt = 0; lt < langCounter; ++lt) {
                String langsID = ((DataInputStream)buff).readUTF();
                byte options = ((DataInputStream)buff).readByte();
                if (options == 0 || options == 1) {
                    int lines = ((DataInputStream)buff).readInt();
                    BPFontReader.langsAsString[lt] = new String[lines];
                    for (int i = 0; i < lines; ++i) {
                        BPFontReader.langsAsString[lt][i] = new String(BPFontReader.decodeText(((DataInputStream)buff).readUTF()));
                    }
                    continue;
                }
                BPFontReader.langsAlphabetIndex[lt] = (short)(options - 2);
                BPFontReader.langsLetterSpacing[lt] = ((DataInputStream)buff).readByte();
                int yLength = ((DataInputStream)buff).readInt();
                BPFontReader.langsAsOffset[lt] = new byte[yLength][];
                for (int ty = 0; ty < yLength; ++ty) {
                    int xLength = ((DataInputStream)buff).readInt();
                    BPFontReader.langsAsOffset[lt][ty] = new byte[xLength];
                    for (int tx = 0; tx < xLength; ++tx) {
                        BPFontReader.langsAsOffset[lt][ty][tx] = ((DataInputStream)buff).readByte();
                    }
                }
            }
        }
        catch (Exception e) {
        }
        finally {
            try {
                if (buff != null) {
                    buff.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public static void loadLanguage(MIDlet midlet, int lang) {
        int j;
        if (lang == currentLoadLang) {
            return;
        }
        currentLoadLang = lang;
        textAsString = null;
        alphabetIndex = null;
        letterSpacing = null;
        textAsOffset = null;
        System.gc();
        DataInputStream buff = null;
        try {
            buff = new DataInputStream(midlet.getClass().getResourceAsStream(RESOURCES_FILE_NAME));
            buff.readByte();
            int il = buff.readByte();
            buff.readInt();
            for (int l = 0; l < il; ++l) {
                buff.readInt();
            }
            if (lang + 1 >= langSize.length) {
                return;
            }
            int bytesSkiped = 0;
            int error = 0;
            while ((bytesSkiped += buff.skipBytes(langSize[lang] - bytesSkiped)) < langSize[lang] && ++error <= langSize[lang]) {
            }
            if (error > langSize[lang]) {
                return;
            }
            String langID = buff.readUTF();
            int textCounter = buff.readInt();
            textAsString = new String[textCounter][];
            alphabetIndex = new short[textCounter];
            letterSpacing = new short[textCounter];
            textAsOffset = new byte[textCounter][][];
            for (int t = 0; t < textCounter; ++t) {
                byte options = buff.readByte();
                if (options < 0) {
                    BPFontReader.letterSpacing[t] = (short)buff.readInt();
                    BPFontReader.alphabetIndex[t] = (short)(-options - 2);
                    options = 1;
                }
                if (options == 0 || options == 1) {
                    int lines = buff.readInt();
                    BPFontReader.textAsString[t] = new String[lines];
                    for (int i = 0; i < lines; ++i) {
                        BPFontReader.textAsString[t][i] = new String(BPFontReader.decodeText(buff.readUTF()));
                    }
                    continue;
                }
                BPFontReader.alphabetIndex[t] = (short)(options - 2);
                BPFontReader.letterSpacing[t] = buff.readByte();
                int yLength = buff.readInt();
                BPFontReader.textAsOffset[t] = new byte[yLength][];
                for (int ty = 0; ty < yLength; ++ty) {
                    int xLength = buff.readInt();
                    BPFontReader.textAsOffset[t][ty] = new byte[xLength];
                    for (int tx = 0; tx < xLength; ++tx) {
                        BPFontReader.textAsOffset[t][ty][tx] = buff.readByte();
                    }
                }
            }
            buff.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        System.gc();
        String gameName = MainCanvas.midlet.getAppProperty("MIDlet-Name");
        int id = gameName.indexOf(":");
        String gameName1 = gameName.substring(++id);
        gameName1 = gameName1.toUpperCase();
        String version = MainCanvas.midlet.getAppProperty("MIDlet-Version");
        version = " : " + version;
        byte[] nameBytes1 = BPFontReader.textToOffsets(gameName1, alphabetIndex[40]);
        byte[] versionBytes = BPFontReader.textToOffsets(version, alphabetIndex[40]);
        byte[][] aboutTxt = new byte[textAsOffset[40].length + 4][];
        aboutTxt[0] = nameBytes1;
        aboutTxt[2] = new byte[0];
        aboutTxt[1] = new byte[textAsOffset[39][0].length + versionBytes.length];
        aboutTxt[3] = new byte[0];
        for (int i = 0; i < textAsOffset[39][0].length; ++i) {
            aboutTxt[1][i] = textAsOffset[39][0][i];
        }
        for (j = 0; j < versionBytes.length; ++j) {
            aboutTxt[1][i + j] = versionBytes[j];
        }
        for (j = 0; j < textAsOffset[40].length; ++j) {
            aboutTxt[j + 4] = textAsOffset[40][j];
        }
        BPFontReader.textAsOffset[40] = aboutTxt;
    }

    public static void freeMemory(boolean releaseText) {
        alphabetAsImage = null;
        if (releaseText) {
            textAsString = null;
            textAsOffset = null;
            langsAsString = null;
            langsAsOffset = null;
            alphabetAsChar = null;
            fontHeight = null;
            specMaxUp = null;
            alphabetIndex = null;
            langsAlphabetIndex = null;
        }
        System.gc();
    }

    public static void drawSystemTextLine(String text, int x, int y, Font font, int RGBColor, Graphics g) {
        g.setFont(font);
        g.setColor(RGBColor);
        g.drawString(text, x, y, 20);
    }

    public static void drawASCIIChar(char c, int x, int y, int alphabetId, Graphics g) {
        int index;
        y += specMaxUp[alphabetId];
        boolean width = false;
        boolean row = false;
        boolean col = false;
        boolean currentOffset = false;
        boolean special = true;
        for (index = 0; index < alphabetAsChar[alphabetId].length; ++index) {
            if (alphabetAsChar[alphabetId][index] != c) continue;
            special = false;
            BPFontReader.drawChar(0, x, y, alphabetId, index, g);
            break;
        }
        if (special) {
            for (index = 0; index < specialsAsChar[alphabetId].length; ++index) {
                if (specialsAsChar[alphabetId][index] != c) continue;
                BPFontReader.drawSpecialChar(0, x, y, alphabetId, index, g);
                break;
            }
        }
    }

    public static void drawGraphicTextLine(int textId, int lineId, int x, int y, Graphics g, int anchor) {
        try {
            short alphabetId;
            byte[] text;
            if (textId >= 1000) {
                text = langsAsOffset[textId -= 1000][lineId];
                alphabetId = langsAlphabetIndex[textId];
                textId += 1000;
            } else {
                text = textAsOffset[textId][lineId];
                alphabetId = alphabetIndex[textId];
            }
            if ((anchor & 8) > 0) {
                x -= BPFontReader.getGraphicTextWidth(textId, lineId);
            } else if ((anchor & 1) > 0) {
                x -= BPFontReader.getGraphicTextWidth(textId, lineId) >> 1;
            }
            BPFontReader.countGraphicTextLine(letterSpacing[textId -= textId >= 1000 ? 1000 : 0], 0, alphabetId, text, g, x, y);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public static void drawGraphicTextLine(byte[] text, int x, int y, Graphics g, int anchor, int alphabetId, int letterSpacing) {
        try {
            if ((anchor & 8) > 0) {
                x -= BPFontReader.getTextAsOffsetWidth(text, alphabetId, letterSpacing);
            } else if ((anchor & 1) > 0) {
                x -= BPFontReader.getTextAsOffsetWidth(text, alphabetId, letterSpacing) >> 1;
            }
            BPFontReader.countGraphicTextLine(letterSpacing, 0, alphabetId, text, g, x, y += specMaxUp[alphabetId]);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public static void drawGraphicTextLine(String text, int x, int y, int alphabetId, int letterSpacing, Graphics g, int anchor) {
        if ((anchor & 8) > 0) {
            x -= BPFontReader.getTextWidth(text, alphabetId, letterSpacing);
        } else if ((anchor & 1) > 0) {
            x -= BPFontReader.getTextWidth(text, alphabetId, letterSpacing) >> 1;
        }
        y += specMaxUp[alphabetId];
        for (int i = 0; i < text.length(); ++i) {
            int index;
            int width = 0;
            boolean row = false;
            boolean col = false;
            boolean currentOffset = false;
            boolean special = true;
            char c = text.charAt(i);
            for (index = 0; index < alphabetAsChar[alphabetId].length; ++index) {
                if (alphabetAsChar[alphabetId][index] != c) continue;
                special = false;
                width = BPFontReader.drawChar(i, x, y, alphabetId, index, g);
                break;
            }
            if (special) {
                for (index = 0; index < specialsAsChar[alphabetId].length; ++index) {
                    if (specialsAsChar[alphabetId][index] != c) continue;
                    width = BPFontReader.drawSpecialChar(i, x, y, alphabetId, index, g);
                    break;
                }
            }
            x += width + letterSpacing;
        }
    }

    public static int drawSpecialChar(int i, int x, int y, int alphabetId, int index, Graphics g) {
        byte width = alphabetWidth[alphabetId][specialsAsOffset[alphabetId][index][0]];
        g.drawImage(alphabetAsImage[alphabetId][specialsAsOffset[alphabetId][index][0]], x - i, y, 20);
        byte specIndex = specialsAsOffset[alphabetId][index][1];
        byte xp = posX[alphabetId][index];
        byte yp = posY[alphabetId][index];
        g.drawImage(specialsAsImage[alphabetId][specIndex], x - i + xp, y + yp, 20);
        return width;
    }

    public static int drawChar(int i, int x, int y, int alphabetId, int index, Graphics g) {
        byte width = alphabetWidth[alphabetId][index];
        g.drawImage(alphabetAsImage[alphabetId][index], x - i, y, 20);
        return width;
    }

    public static void drawGraphicText(int textId, int x, int y, Graphics g, int anchor, int lineSpacing) {
        short _alphabetId;
        int _textHeight;
        if (textId >= 1000) {
            _textHeight = langsAsOffset[textId -= 1000].length;
            _alphabetId = langsAlphabetIndex[textId];
            textId += 1000;
        } else {
            _textHeight = textAsOffset[textId].length;
            _alphabetId = alphabetIndex[textId];
        }
        for (int i = 0; i < _textHeight; ++i) {
            BPFontReader.drawGraphicTextLine(textId, i, x, y, g, anchor);
            y += lineSpacing + fontHeight[_alphabetId];
        }
    }

    public static void drawSystemText(int textId, int x, int y, Font font, int RGBColor, Graphics g, int lineSpacing) {
        for (int i = 0; i < textAsString[textId].length; ++i) {
            BPFontReader.drawSystemTextLine(textAsString[textId][i], x, y, font, RGBColor, g);
            y += lineSpacing + font.getHeight();
        }
    }

    public static int drawGraphicTextInWindow(int textId, int x, int y, int wX, int wY, int wWidth, int wHeight, Graphics g, int anchor, int lineSpacing) {
        short _letterSpacing;
        short _alphabetId;
        byte[][] splittedText = null;
        if (textId >= 1000) {
            splittedText = langsAsOffset[textId -= 1000];
            _alphabetId = langsAlphabetIndex[textId];
            _letterSpacing = letterSpacing[textId];
            textId += 1000;
        } else {
            splittedText = textAsOffset[textId];
            _alphabetId = alphabetIndex[textId];
            _letterSpacing = letterSpacing[textId];
        }
        int xLines = splittedText.length;
        System.out.println("splittedText.length=" + splittedText.length);
        for (int i = 0; i < splittedText.length; ++i) {
            if (y + fontHeight[_alphabetId] > wHeight) {
                return xLines;
            }
            if (y >= 0) {
                BPFontReader.drawGraphicTextLine(splittedText[i], x + wX, y + wY, g, anchor, _alphabetId, (int)_letterSpacing);
            }
            y += lineSpacing + fontHeight[_alphabetId];
        }
        return xLines;
    }

    public static int drawGraphicTextInWindow(String[] splittedText, int yOffset, int wX, int wY, int wWidth, int wHeight, Graphics g, int anchor, int lineSpacing, int alphabetId, int letterSpacing) {
        int x = 0;
        int y = 0;
        int xLines = splittedText.length;
        if ((anchor & 1) > 0) {
            x += wWidth >> 1;
        } else if ((anchor & 8) > 0) {
            x += wWidth;
        }
        if ((anchor & 2) > 0) {
            y += wHeight - xLines * (fontHeight[alphabetId] + lineSpacing) >> 1;
        } else if ((anchor & 0x20) > 0) {
            y += wHeight - xLines * (fontHeight[alphabetId] + lineSpacing);
        }
        for (int i = 0; i < splittedText.length; ++i) {
            if (y + fontHeight[alphabetId] - yOffset > wHeight) {
                return xLines;
            }
            if (y >= yOffset) {
                BPFontReader.drawGraphicTextLine(splittedText[i], x + wX, y + wY - yOffset, alphabetId, letterSpacing, g, anchor);
            }
            y += lineSpacing + fontHeight[alphabetId];
        }
        return xLines;
    }

    public static int drawGraphicTextInWindow(byte[][] splittedText, int yOffset, int wX, int wY, int wWidth, int wHeight, Graphics g, int anchor, int lineSpacing, int alphabetId, int letterSpacing) {
        int x = 0;
        int y = 0;
        int xLines = splittedText.length;
        if ((anchor & 1) > 0) {
            x += wWidth >> 1;
        } else if ((anchor & 8) > 0) {
            x += wWidth;
        }
        if ((anchor & 2) > 0) {
            y += wHeight - xLines * (fontHeight[alphabetId] + lineSpacing) >> 1;
        } else if ((anchor & 0x20) > 0) {
            y += wHeight - xLines * (fontHeight[alphabetId] + lineSpacing);
        }
        for (int i = 0; i < splittedText.length; ++i) {
            if (y + fontHeight[alphabetId] - yOffset > wHeight) {
                return xLines;
            }
            if (y >= yOffset) {
                BPFontReader.drawGraphicTextLine(splittedText[i], x + wX, y + wY - yOffset, g, anchor, alphabetId, letterSpacing);
            }
            y += lineSpacing + fontHeight[alphabetId];
        }
        return xLines;
    }

    public static void drawComposedText(int text1Id, int line1Id, String textIn, int x, int y, int alphabetInId, int letterSpacingIn, Graphics g, int anchor) {
        if ((anchor & 8) > 0) {
            x -= BPFontReader.getGraphicTextWidth(text1Id, line1Id) + BPFontReader.getTextWidth(textIn, alphabetInId, letterSpacingIn);
        } else if ((anchor & 1) > 0) {
            x -= BPFontReader.getGraphicTextWidth(text1Id, line1Id) + BPFontReader.getTextWidth(textIn, alphabetInId, letterSpacingIn) >> 1;
        }
        BPFontReader.drawGraphicTextLine(text1Id, line1Id, x, y, g, 4);
        BPFontReader.drawGraphicTextLine(textIn, x += BPFontReader.getGraphicTextWidth(text1Id, line1Id), y, alphabetInId, letterSpacingIn, g, 4);
    }

    public static void drawComposedText2(int text1Id, int line1Id, String textIn, int text2Id, int line2Id, int x, int y, int alphabetInId, int letterSpacingIn, Graphics g, int anchor) {
        if ((anchor & 8) > 0) {
            x -= BPFontReader.getGraphicTextWidth(text1Id, line1Id) + BPFontReader.getTextWidth(textIn, alphabetInId, letterSpacingIn) + BPFontReader.getGraphicTextWidth(text2Id, line2Id);
        } else if ((anchor & 1) > 0) {
            x -= BPFontReader.getGraphicTextWidth(text1Id, line1Id) + BPFontReader.getTextWidth(textIn, alphabetInId, letterSpacingIn) + BPFontReader.getGraphicTextWidth(text2Id, line2Id) >> 1;
        }
        BPFontReader.drawGraphicTextLine(text1Id, line1Id, x, y, g, 4);
        BPFontReader.drawGraphicTextLine(textIn, x += BPFontReader.getGraphicTextWidth(text1Id, line1Id), y, alphabetInId, letterSpacingIn, g, 4);
        BPFontReader.drawGraphicTextLine(text2Id, line2Id, x += BPFontReader.getTextWidth(textIn, alphabetInId, letterSpacingIn), y, g, 4);
    }

    public static int drawComposedTextInWindow(int textId1, String text, int textId2, int x, int y, int wX, int wY, int wWidth, int wHeight, Graphics g, int anchor, int lineSpacing, int alphabetId) {
        int len;
        byte[][] splittedText1 = textAsOffset[textId1];
        byte[][] splittedText2 = textAsOffset[textId2];
        int xLines = len = splittedText1.length + splittedText2.length + 1;
        for (int i = 0; i < len; ++i) {
            if (i < splittedText1.length) {
                if (y + fontHeight[alphabetIndex[textId1]] > wHeight) {
                    return xLines;
                }
                if (y >= 0) {
                    BPFontReader.drawGraphicTextLine(splittedText1[i], x + wX, y + wY, g, anchor, alphabetIndex[textId1], (int)letterSpacing[textId1]);
                }
                y += lineSpacing + fontHeight[alphabetIndex[textId1]];
                continue;
            }
            if (i == splittedText1.length) {
                if (y + fontHeight[alphabetIndex[textId1]] > wHeight) {
                    return xLines;
                }
                if (y >= 0) {
                    BPFontReader.drawGraphicTextLine(text, x + wX, y + wY, alphabetId, (int)letterSpacing[textId1], g, anchor);
                }
                y += lineSpacing + fontHeight[alphabetIndex[textId1]];
                continue;
            }
            int p = i - splittedText1.length - 1;
            if (y + fontHeight[alphabetIndex[textId2]] > wHeight) {
                return xLines;
            }
            if (y >= 0) {
                BPFontReader.drawGraphicTextLine(splittedText2[p], x + wX, y + wY, g, anchor, alphabetIndex[textId2], (int)letterSpacing[textId2]);
            }
            y += lineSpacing + fontHeight[alphabetIndex[textId2]];
        }
        return xLines;
    }

    public static int drawComposedTextInWindow(String text, int textId, int x, int y, int wX, int wY, int wWidth, int wHeight, Graphics g, int anchor, int lineSpacing, int alphabetId) {
        int len;
        int splitWidth = wWidth - x;
        if (anchor == 8) {
            splitWidth = x;
        } else if (anchor == 1) {
            splitWidth = Math.min(x, wWidth - x) << 1;
        }
        byte[][] splittedText = BPFontReader.splitGraphicText(textId, splitWidth, false);
        int xLines = len = splittedText.length + 1;
        for (int i = 0; i < len; ++i) {
            if (i < 1) {
                if (y >= 0) {
                    BPFontReader.drawGraphicTextLine(text, x + wX, y + wY, alphabetId, (int)letterSpacing[textId], g, anchor);
                }
                y += lineSpacing + fontHeight[alphabetIndex[textId]];
                continue;
            }
            int p = i - 1;
            if (y + fontHeight[alphabetIndex[textId]] > wHeight) {
                return xLines;
            }
            if (y >= 0) {
                BPFontReader.drawGraphicTextLine(splittedText[p], x + wX, y + wY, g, anchor, alphabetIndex[textId], (int)letterSpacing[textId]);
            }
            y += lineSpacing + fontHeight[alphabetIndex[textId]];
        }
        return xLines;
    }

    public static void drawGraphicLang(int langId, int lineId, int x, int y, Graphics g) {
        try {
            byte[] lang = langsAsOffset[langId][lineId];
            short alphabetId = langsAlphabetIndex[langId];
            y += specMaxUp[alphabetId];
            for (int i = 0; i < lang.length; ++i) {
                int width = BPFontReader.drawChar(i, x, y, alphabetId, lang[i], g);
                x += width + langsLetterSpacing[langId];
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public static int getASCIICharWidth(char c, int alphabetId) {
        int index;
        boolean special = true;
        boolean letterWidth = false;
        for (index = 0; index < alphabetAsChar[alphabetId].length; ++index) {
            if (alphabetAsChar[alphabetId][index] != c) continue;
            special = false;
            return alphabetAsImage[alphabetId][index].getWidth();
        }
        if (special) {
            for (index = 0; index < specialsAsChar[alphabetId].length; ++index) {
                if (specialsAsChar[alphabetId][index] != c) continue;
                byte indexspec = specialsAsOffset[alphabetId][index][0];
                return alphabetAsImage[alphabetId][indexspec].getWidth();
            }
        }
        return 0;
    }

    public static int getTextWidth(String text, int alphabetId, int letterSpacing) {
        int letterSpacingLoc = letterSpacing - 1;
        int length = 0;
        for (int i = 0; i < text.length(); ++i) {
            int index;
            boolean special = true;
            char c = text.charAt(i);
            int letterWidth = 0;
            for (index = 0; index < alphabetAsChar[alphabetId].length; ++index) {
                if (alphabetAsChar[alphabetId][index] != c) continue;
                special = false;
                letterWidth = alphabetWidth[alphabetId][index];
                break;
            }
            if (special) {
                for (index = 0; index < specialsAsChar[alphabetId].length; ++index) {
                    if (specialsAsChar[alphabetId][index] != c) continue;
                    byte indexspec = specialsAsOffset[alphabetId][index][0];
                    letterWidth = alphabetWidth[alphabetId][indexspec];
                    break;
                }
            }
            length += letterWidth + letterSpacingLoc;
        }
        return length - letterSpacingLoc;
    }

    private static int getGraphicTextWidth(byte[] text, int alphabetId, int letterSpacing) {
        int length = 0;
        byte letterWidth = 0;
        for (int i = 0; i < text.length; ++i) {
            letterWidth = 0;
            if (text[i] < 0) {
                int specId = -text[i] - 1;
                byte indexspec = specialsAsOffset[alphabetId][specId][0];
                letterWidth = alphabetWidth[alphabetId][indexspec];
            } else {
                letterWidth = alphabetWidth[alphabetId][text[i]];
            }
            length += letterWidth + letterSpacing - 1;
        }
        return length - letterSpacing + 1;
    }

    public static int getGraphicTextWidth(int textId, int lineId) {
        byte[] text;
        short alphabetId;
        int length = 0;
        if (textId >= 1000) {
            alphabetId = langsAlphabetIndex[textId -= 1000];
            text = langsAsOffset[textId][lineId];
        } else {
            alphabetId = alphabetIndex[textId];
            text = textAsOffset[textId][lineId];
        }
        byte letterWidth = 0;
        for (int i = 0; i < text.length; ++i) {
            letterWidth = 0;
            if (text[i] < 0) {
                int specId = -text[i] - 1;
                byte indexspec = specialsAsOffset[alphabetId][specId][0];
                letterWidth = alphabetWidth[alphabetId][indexspec];
            } else {
                letterWidth = alphabetWidth[alphabetId][text[i]];
            }
            length += letterWidth + letterSpacing[textId] - 1;
        }
        return length - letterSpacing[textId] + 1;
    }

    public static int getGraphicTextHeight(int textId, int _lineSpacing) {
        int _height;
        boolean length = false;
        if (textId >= 1000) {
            short alphabetId = langsAlphabetIndex[textId -= 1000];
            _height = langsAsOffset[textId].length * BPFontReader.getFontHeight(textId) + langsAsOffset[textId].length * _lineSpacing;
        } else {
            short alphabetId = alphabetIndex[textId];
            _height = textAsOffset[textId].length * BPFontReader.getFontHeight(textId) + textAsOffset[textId].length * _lineSpacing;
        }
        return _height;
    }

    public static int getLangsNumber() {
        return langsAsOffset.length;
    }

    public static int getLinesNum(int id) {
        return textAsOffset[id].length;
    }

    public static int getAlphabetId(int textId) {
        return alphabetIndex[textId];
    }

    public static int getLetterSpacing(int textId) {
        return letterSpacing[textId];
    }

    public static int getFontHeight(int ID) {
        if (ID >= 1000) {
            return fontHeight[langsAlphabetIndex[ID - 1000]];
        }
        return fontHeight[alphabetIndex[ID]];
    }

    public static int getFontHeightByAlphabetId(int alphabetId) {
        return fontHeight[alphabetId];
    }

    public static String getStringFromOffsets(int textId) {
        String endString = "";
        for (int i = 0; i < textAsOffset[textId].length; ++i) {
            endString = endString + BPFontReader.getStringFromOffsets(textId, i) + " ";
        }
        return endString;
    }

    public static String getStringFromOffsets(int textId, int lineId) {
        String endString = "";
        short alphabetId = alphabetIndex[textId];
        for (int i = 0; i < textAsOffset[textId][lineId].length; ++i) {
            if (textAsOffset[textId][lineId][i] >= 0) {
                endString = endString + alphabetAsChar[alphabetId][textAsOffset[textId][lineId][i]];
                continue;
            }
            int index = -textAsOffset[textId][lineId][i] - 1;
            endString = endString + specialsAsChar[alphabetId][index];
        }
        return endString;
    }

    public static int getTextAsOffsetWidth(byte[] text, int alphabetId, int letterSpacing) {
        int length = 0;
        for (int i = 0; i < text.length; ++i) {
            byte letterWidth = 0;
            if (text[i] < 0) {
                int specId = -text[i] - 1;
                byte indexspec = specialsAsOffset[alphabetId][specId][0];
                letterWidth = alphabetWidth[alphabetId][indexspec];
            } else {
                letterWidth = alphabetWidth[alphabetId][text[i]];
            }
            length += letterWidth + letterSpacing - 1;
        }
        return length - letterSpacing + 1;
    }

    public static int getLinesCntFromWindow(int textId, int x, int y, int wX, int wY, int wWidth, int wHeight, int anchor) {
        int splitWidth = wWidth - x;
        if (anchor == 8) {
            splitWidth = x;
        } else if (anchor == 1) {
            splitWidth = Math.min(x, wWidth - x) << 1;
        }
        return BPFontReader.splitGraphicText(textId, splitWidth, false).length;
    }

    public static byte getSeparatorIndex(char separatorAsChar, int alphabetId) {
        for (int i = 0; i < alphabetAsChar[alphabetId].length; ++i) {
            if (alphabetAsChar[alphabetId][i] != separatorAsChar) continue;
            return (byte)i;
        }
        return -1;
    }

    public static byte[][] splitGraphicText(int textId, int maxWidth, boolean remember) {
        byte[] bothWords;
        short alphabetId = alphabetIndex[textId];
        byte separator = BPFontReader.getSeparatorIndex(' ', alphabetId);
        int linesCnt = textAsOffset[textId].length;
        short letterspace = letterSpacing[textId];
        byte[] tmp = new byte[]{separator};
        int separatorWidth = BPFontReader.getTextAsOffsetWidth(tmp, alphabetId, letterspace);
        tmp = null;
        Vector<byte[]> afterSplit = new Vector<byte[]>();
        for (int i = 0; i < linesCnt; ++i) {
            if (BPFontReader.getTextAsOffsetWidth(textAsOffset[textId][i], alphabetId, letterspace) <= maxWidth) {
                afterSplit.addElement(textAsOffset[textId][i]);
                continue;
            }
            byte[][] words = BPFontReader.splitTextAsOffset(textAsOffset[textId][i], separator);
            if (words.length == 1) {
                afterSplit.addElement(textAsOffset[textId][i]);
                continue;
            }
            byte[] newWord = words[0];
            for (int j = 1; j < words.length; ++j) {
                byte[] word = words[j];
                if (BPFontReader.getTextAsOffsetWidth(newWord, alphabetId, letterspace) + BPFontReader.getTextAsOffsetWidth(word, alphabetId, letterspace) + separatorWidth <= maxWidth) {
                    bothWords = new byte[newWord.length + word.length + 1];
                    System.arraycopy(newWord, 0, bothWords, 0, newWord.length);
                    bothWords[newWord.length] = separator;
                    System.arraycopy(word, 0, bothWords, newWord.length + 1, word.length);
                    newWord = new byte[bothWords.length];
                    System.arraycopy(bothWords, 0, newWord, 0, bothWords.length);
                    continue;
                }
                afterSplit.addElement(newWord);
                newWord = words[j];
            }
            if (newWord.length <= 0) continue;
            afterSplit.addElement(newWord);
        }
        byte[][] textAfterSplit = new byte[afterSplit.size()][];
        for (int i = 0; i < afterSplit.size(); ++i) {
            byte[] newLine = (byte[])afterSplit.elementAt(i);
            textAfterSplit[i] = new byte[newLine.length];
            textAfterSplit[i] = newLine;
        }
        if (remember) {
            BPFontReader.textAsOffset[textId] = textAfterSplit;
        }
        bothWords = null;
        afterSplit = null;
        return textAfterSplit;
    }

    public static String[] splitSystemText(int textId, int maxWidth, int letterWidth, int letterSpacing, boolean remember) {
        int linesCnt = textAsString[textId].length;
        Vector<String> afterSplit = new Vector<String>();
        for (int i = 0; i < linesCnt; ++i) {
            if (textAsString[textId][i].length() * (letterSpacing + letterWidth) <= maxWidth) {
                afterSplit.addElement(textAsString[textId][i]);
                continue;
            }
            String[] wordsOfLine = BPFontReader.splitWord(textAsString[textId][i]);
            if (wordsOfLine.length == 1) {
                afterSplit.addElement(textAsString[textId][i]);
                continue;
            }
            String newWord = wordsOfLine[0];
            for (int w = 1; w < wordsOfLine.length; ++w) {
                if ((newWord.length() + wordsOfLine[w].length() + 1) * (letterSpacing + letterWidth) <= maxWidth) {
                    newWord = newWord + " " + wordsOfLine[w];
                    continue;
                }
                afterSplit.addElement(newWord);
                newWord = wordsOfLine[w];
            }
            if (newWord == null) continue;
            afterSplit.addElement(newWord);
        }
        String[] textAfterSplit = new String[afterSplit.size()];
        for (int i = 0; i < afterSplit.size(); ++i) {
            String newLine;
            textAfterSplit[i] = newLine = (String)afterSplit.elementAt(i);
        }
        if (remember) {
            BPFontReader.textAsString[textId] = textAfterSplit;
        }
        return textAfterSplit;
    }

    public static String[] split(String text, char sep, boolean separatorInclude) {
        Vector<String> vector = new Vector<String>();
        String word = new String();
        for (int i = 0; i < text.length(); ++i) {
            char c0 = text.charAt(i);
            if (c0 != sep) {
                word = word + c0;
                continue;
            }
            if (separatorInclude) {
                word = word + c0;
            }
            vector.addElement(word);
            word = new String();
        }
        if (word.length() != 0) {
            vector.addElement(word);
        }
        String[] result = new String[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            result[i] = (String)vector.elementAt(i);
        }
        return result;
    }

    public static String[] splitText(String text, int maxWidth, int alphabetId, int letterSpacing, char sep, boolean sepIncl) {
        String[] textToSplit = BPFontReader.split(text, sep, sepIncl);
        int separatorWidth = BPFontReader.getTextWidth(" ", alphabetId, letterSpacing);
        Vector<String> afterSplit = new Vector<String>();
        for (int i = 0; i < textToSplit.length; ++i) {
            if (BPFontReader.getTextWidth(textToSplit[i], alphabetId, letterSpacing) <= maxWidth) {
                afterSplit.addElement(textToSplit[i]);
                continue;
            }
            String[] wordsOfLine = BPFontReader.splitWord(textToSplit[i]);
            if (wordsOfLine.length == 1) {
                afterSplit.addElement(textToSplit[i]);
                continue;
            }
            String newWord = wordsOfLine[0];
            for (int w = 1; w < wordsOfLine.length; ++w) {
                if (BPFontReader.getTextWidth(newWord, alphabetId, letterSpacing) + BPFontReader.getTextWidth(wordsOfLine[w], alphabetId, letterSpacing) + separatorWidth <= maxWidth) {
                    newWord = newWord + " " + wordsOfLine[w];
                    continue;
                }
                afterSplit.addElement(newWord);
                newWord = wordsOfLine[w];
            }
            if (newWord == null) continue;
            afterSplit.addElement(newWord);
        }
        String[] textAfterSplit = new String[afterSplit.size()];
        for (int i = 0; i < afterSplit.size(); ++i) {
            String newLine;
            textAfterSplit[i] = newLine = (String)afterSplit.elementAt(i);
        }
        return textAfterSplit;
    }

    private static String[] splitWord(String text) {
        Vector<String> vector = new Vector<String>();
        boolean splitWhenSpace = false;
        String word = new String();
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c != ' ') {
                word = word + c;
                splitWhenSpace = true;
                continue;
            }
            if (splitWhenSpace && c == ' ') {
                vector.addElement(word);
                splitWhenSpace = false;
                word = new String();
                continue;
            }
            word = word + c;
            splitWhenSpace = false;
        }
        if (word.length() != 0) {
            vector.addElement(word);
        }
        String[] result = new String[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            result[i] = (String)vector.elementAt(i);
        }
        return result;
    }

    private static byte[][] splitTextAsOffset(byte[] text, byte separator) {
        Vector<Vector> afterSplit = new Vector<Vector>();
        Vector word = new Vector();
        boolean splitWhenSeparator = false;
        for (int i = 0; i < text.length; ++i) {
            if (text[i] != separator) {
                word.addElement(new Byte(text[i]));
                splitWhenSeparator = true;
                continue;
            }
            if (splitWhenSeparator && text[i] == separator) {
                afterSplit.addElement(word);
                word = new Vector();
                splitWhenSeparator = false;
                continue;
            }
            word.addElement(new Byte(text[i]));
            splitWhenSeparator = false;
        }
        if (word.size() != 0) {
            afterSplit.addElement(word);
        }
        byte[][] splittedText = new byte[afterSplit.size()][];
        for (int i = 0; i < afterSplit.size(); ++i) {
            word = null;
            word = (Vector)afterSplit.elementAt(i);
            splittedText[i] = new byte[word.size()];
            for (int j = 0; j < word.size(); ++j) {
                splittedText[i][j] = (Byte)word.elementAt(j);
            }
        }
        word = null;
        afterSplit = null;
        return splittedText;
    }

    public static void countGraphicTextLine(int letterSpace, int fontWidth, int alphabetId, byte[] text, Graphics g, int x, int y) {
        for (int i = 0; i < text.length; ++i) {
            int width = text[i] < 0 ? BPFontReader.drawSpecialChar(i, x, y, alphabetId, -text[i] - 1, g) : BPFontReader.drawChar(i, x, y, alphabetId, text[i], g);
            x += width + letterSpace;
        }
    }

    private static char[] decodeText(String text) {
        char[] decode = new char[text.length()];
        for (int f = 0; f < text.length(); f = (int)((char)(f + 1))) {
            decode[f] = (char)(text.charAt(f) ^ f);
        }
        return decode;
    }

    public static byte[] textToOffsets(String text, int alphabetId) {
        int textLength = text.length();
        byte[] textInOffsets = new byte[textLength];
        for (int i = 0; i < text.length(); ++i) {
            int index;
            char c = text.charAt(i);
            for (index = 0; index < alphabetAsChar[alphabetId].length && alphabetAsChar[alphabetId][index] != c; ++index) {
            }
            textInOffsets[i] = (byte)index;
        }
        return textInOffsets;
    }

    static {
        currentLoadLang = -100;
    }
}

