/*
 * Decompiled with CFR 0.152.
 */
package gameboy.core;

import gameboy.core.Interrupt;

public class Serial {
    private static final int GAMEBOY_CLOCK = 0x100000;
    private static final int SERIAL_CLOCK = 16;
    private static final int SERIAL_IDLE_CLOCK = 8192;
    public static final int SB = 65281;
    public static final int SC = 65282;
    private int sb;
    private int sc;
    private int cycles;
    private Interrupt interrupt;

    public Serial(Interrupt interrupt) {
        this.interrupt = interrupt;
        this.reset();
    }

    public final void reset() {
        this.cycles = 16;
        this.sb = 0;
        this.sc = 0;
    }

    public final int cycles() {
        return this.cycles;
    }

    public final void emulate(int ticks) {
        if ((this.sc & 0x81) == 129) {
            this.cycles -= ticks;
            if (this.cycles <= 0) {
                this.sb = 255;
                this.sc &= 0x7F;
                this.cycles = 8192;
                this.interrupt.raise(8);
            }
        }
    }

    public final void write(int address, int data) {
        if (address == 65281) {
            this.setSerialData(data);
        } else if (address == 65282) {
            this.setSerialControl(data);
        }
    }

    public final int read(int address) {
        if (address == 65281) {
            return this.getSerialData();
        }
        if (address == 65282) {
            return this.getSerialControl();
        }
        return 255;
    }

    private final void setSerialData(int data) {
        this.sb = data;
    }

    private final void setSerialControl(int data) {
        this.sc = data;
        this.cycles = 8208;
    }

    private final int getSerialData() {
        return this.sb;
    }

    private final int getSerialControl() {
        return this.sc;
    }

    public final String toString() {
        return "SB=" + Integer.toHexString(this.sb) + " SC=" + Integer.toHexString(this.sc);
    }
}

