/*
 * Decompiled with CFR 0.152.
 */
package engine.world;

public class Point {
    public static final byte WALK = 0;
    public static final byte JUMP_LEFT = 1;
    public static final byte JUMP_RIGHT = 2;
    public static final byte FALL = 3;
    public short x;
    public short y;
    public byte passingType;

    public Point() {
        this.y = 0;
        this.x = 0;
        this.passingType = 0;
    }

    public Point(int x, int y) {
        this.x = (short)x;
        this.y = (short)y;
        this.passingType = 0;
    }

    public Point(Point p) {
        this.x = p.x;
        this.y = p.y;
        this.passingType = p.passingType;
    }

    public boolean check(Point p, int radius, int r2) {
        return p.x <= this.x + radius && p.x >= this.x - radius && p.y <= this.y + r2 && p.y >= this.y - r2;
    }

    public boolean check(int xx, int yy) {
        return xx == this.x && yy == this.y;
    }

    public byte checkObszar(Point p, int radius, int r2) {
        if (p.x + r2 - 1 <= this.x && p.x - (r2 - 1) >= this.x) {
            return -1;
        }
        if (p.x <= this.x + radius && p.x >= this.x - radius && p.y <= this.y + r2 && p.y >= this.y - r2) {
            return 0;
        }
        return 1;
    }

    public String toString() {
        return "X " + this.x + " Y " + this.y;
    }
}

