/*
 * Decompiled with CFR 0.152.
 */
package engine.world;

import app.GameAppState;
import engine.world.SimpleAnimation;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;

public class Weapon {
    public int fp_X;
    public int fp_Y;
    public int fp_velX;
    public int fp_velY;
    public int beginHeight;
    public boolean thrownByPlayer;
    public byte state;
    public static final byte WEAPON_STATE_THROWN = 0;
    public static final byte WEAPON_STATE_FALL = 1;
    public static final byte WEAPON_STATE_GROUND = 2;
    public static final byte WEAPON_STATE_IN_HANDS = 3;
    public static final byte WEAPON_STATE_EXPLODING = 4;
    public int timeToExplode;
    public boolean liveGranade;
    public byte weaponType;
    public static final byte WEAPON_TYPE_BULLET = 0;
    public static final byte WEAPON_TYPE_HAND_GRANADE = 1;
    public static final byte WEAPON_TYPE_FLAME_GRANADE = 2;
    public static final byte WEAPON_TYPE_KNIFE = 3;
    public static final byte WEAPON_TYPE_PIPE = 4;
    public static final byte WEAPON_TYPE_BOOMERANG = 5;
    public static final byte WEAPON_TYPE_CHAIN = 6;
    public static final byte WEAPON_TYPE_SHURIKEN = 7;
    public static final byte WEAPON_TYPE_SPIKE = 8;
    public static final byte WEAPON_TYPE_FLAME = 9;
    public static final byte WEAPON_TYPE_NINJA_KNIFE = 10;
    public static final byte WEAPON_TYPE_POWER_BALL = 11;
    public static final byte CHAIN_RANGE = 60;
    public static final byte PIPE_RANGE = 40;
    public static final int BULLET_VELOCITY_X = 34496;
    public static final int GRANADE_VELOCITY_X = 22528;
    public static final int GRANADE_VELOCITY_Y = -22528;
    public static final int VELOCITY_Y_DELTA = 90112;
    public static final int SPIKE_VELOCITY_Y = -84480;
    public static final int SPIKE_VELOCITY_Y_DELTA = 90112;
    public static final int WEAPON_PICKUP_DELTA_X = 2560;
    public static final int WEAPON_PICKUP_DELTA_Y = 1536;
    public static final int SPLASH_DAMAGE_DELTA_X = 3840;
    public static final int SPLASH_DAMAGE_DELTA_Y = 2560;
    public byte granadeBounces;
    public byte id;
    public SimpleAnimation anim;
    public byte damage;
    public int sector;
    public static int boomerangDistance = GameAppState.scaleValue(25600);
    public int[] imageCoords;

    public Weapon(int x, int y, int vx, int vy, byte type) {
        this.fp_X = x;
        this.fp_Y = y;
        this.fp_velX = vx;
        this.fp_velY = vy;
        this.weaponType = type;
        this.state = 0;
        this.granadeBounces = 0;
        this.liveGranade = false;
        this.imageCoords = new int[4];
        if (this.weaponType == 9) {
            this.anim = new SimpleAnimation(10, SimpleAnimation.ALIGN_BOTTOM_CENTER);
            this.anim.setState((byte)2);
        } else {
            this.anim = this.weaponType == 7 ? new SimpleAnimation(16, SimpleAnimation.ALIGN_BOTTOM_CENTER) : new SimpleAnimation(17, SimpleAnimation.ALIGN_CENTER);
        }
    }

    public Weapon(int type) {
        this.fp_X = 0;
        this.fp_Y = 0;
        this.fp_velX = 0;
        this.fp_velY = 0;
        this.weaponType = (byte)type;
        this.state = (byte)3;
        this.granadeBounces = 0;
        this.liveGranade = false;
        this.imageCoords = new int[4];
        try {
            switch (this.weaponType) {
                case 3: {
                    this.anim = new SimpleAnimation(11, SimpleAnimation.ALIGN_CENTER);
                    this.imageCoords[0] = 143;
                    this.imageCoords[1] = 78;
                    this.imageCoords[2] = 8;
                    this.imageCoords[3] = 8;
                    break;
                }
                case 10: {
                    this.anim = new SimpleAnimation(27, SimpleAnimation.ALIGN_CENTER);
                    this.imageCoords[0] = 143;
                    this.imageCoords[1] = 78;
                    this.imageCoords[2] = 8;
                    this.imageCoords[3] = 8;
                    break;
                }
                case 4: {
                    this.anim = new SimpleAnimation(12, SimpleAnimation.ALIGN_CENTER);
                    this.imageCoords[0] = 143;
                    this.imageCoords[1] = 40;
                    this.imageCoords[2] = 11;
                    this.imageCoords[3] = 11;
                    break;
                }
                case 1: {
                    this.anim = new SimpleAnimation(14, SimpleAnimation.ALIGN_CENTER);
                    this.imageCoords[0] = 143;
                    this.imageCoords[1] = 51;
                    this.imageCoords[2] = 8;
                    this.imageCoords[3] = 8;
                    break;
                }
                case 2: {
                    this.anim = new SimpleAnimation(13, SimpleAnimation.ALIGN_CENTER);
                    this.imageCoords[0] = 151;
                    this.imageCoords[1] = 51;
                    this.imageCoords[2] = 3;
                    this.imageCoords[3] = 8;
                    break;
                }
                case 7: {
                    this.anim = new SimpleAnimation(16, SimpleAnimation.ALIGN_CENTER);
                    break;
                }
                case 5: {
                    this.anim = new SimpleAnimation(12, SimpleAnimation.ALIGN_CENTER);
                    this.imageCoords[0] = 143;
                    this.imageCoords[1] = 40;
                    this.imageCoords[2] = 11;
                    this.imageCoords[3] = 11;
                    break;
                }
                case 6: {
                    this.anim = new SimpleAnimation(15, SimpleAnimation.ALIGN_CENTER);
                    this.imageCoords = null;
                    this.imageCoords = new int[8];
                    this.imageCoords[0] = 143;
                    this.imageCoords[1] = 59;
                    this.imageCoords[2] = 10;
                    this.imageCoords[3] = 19;
                    this.imageCoords[4] = 156;
                    this.imageCoords[5] = 93;
                    this.imageCoords[6] = 19;
                    this.imageCoords[7] = 10;
                    break;
                }
                case 11: {
                    this.anim = new SimpleAnimation(23, SimpleAnimation.ALIGN_CENTER);
                    this.weaponType = (byte)11;
                    break;
                }
                case 9: {
                    this.anim = new SimpleAnimation(10, SimpleAnimation.ALIGN_BOTTOM_CENTER);
                    this.anim.setState((byte)2);
                    break;
                }
                default: {
                    this.anim = new SimpleAnimation(17, SimpleAnimation.ALIGN_CENTER);
                }
            }
            this.damage = (byte)4;
            for (int i = 0; i < this.imageCoords.length; ++i) {
                this.imageCoords[i] = GameAppState.scaleValue(this.imageCoords[i]);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.thrownByPlayer = true;
    }

    /*
     * Unable to fully structure code
     */
    public boolean update(int deltaTime) {
        if ((this.weaponType == 2 || this.weaponType == 1) && this.state != 3 && this.state != 4 && this.liveGranade) {
            this.timeToExplode -= deltaTime;
            if (this.timeToExplode <= 0) {
                this.state = (byte)4;
                if (this.weaponType == 2) {
                    this.anim = new SimpleAnimation(1, SimpleAnimation.ALIGN_BOTTOM_CENTER);
                } else if (this.weaponType == 1) {
                    this.anim = new SimpleAnimation(0, SimpleAnimation.ALIGN_CENTER);
                }
            }
        }
        switch (this.state) {
            case 4: {
                for (i = 0; i <= GameAppState.ileWrogow; ++i) {
                    if (GameAppState.heros[i].wasHit() || !this.inSplashDamage(GameAppState.heros[i].fp_heroX, GameAppState.heros[i].fp_heroY)) continue;
                    if (GameAppState.heros[i].orientation == 1) {
                        GameAppState.heros[i].changeState((byte)16, 1);
                    } else {
                        GameAppState.heros[i].changeState((byte)16, -1);
                    }
                    GameAppState.heros[i].life = (short)(GameAppState.heros[i].life - this.damage);
                }
                if (this.anim.update(deltaTime)) break;
                return false;
            }
            case 0: {
                if (this.anim != null) {
                    this.anim.update(deltaTime);
                }
                this.fp_X += this.fp_velX * deltaTime >> 10;
                this.fp_Y += this.fp_velY * deltaTime >> 10;
                if (this.weaponType == 5) {
                    if (this.granadeBounces > 2) {
                        return false;
                    }
                    if (this.fp_X > this.beginHeight + Weapon.boomerangDistance || this.fp_X < this.beginHeight - Weapon.boomerangDistance) {
                        this.fp_velX = -this.fp_velX;
                        this.granadeBounces = (byte)(this.granadeBounces + 1);
                    }
                }
                if ((p = GameAppState.level.checkPoint(this.fp_X >> 8, this.beginHeight >> 8, this.sector)) != null && this.weaponType != 7 && this.weaponType != 0 && this.weaponType != 8 && this.weaponType != 9) {
                    if (this.weaponType != 7 && this.weaponType != 5 && this.weaponType != 10 && this.weaponType != 11) {
                        if (p.passingType != 3) {
                            this.fp_velX = -(this.fp_velX >> 2);
                            this.state = 1;
                            this.anim.setState((byte)0);
                        } else {
                            this.beginHeight = GameAppState.scaleUpValue(GameAppState.level.tiledLayer.layerHeight) << 8;
                        }
                    } else {
                        if (this.weaponType == 10 || this.weaponType == 11) {
                            this.state = (byte)3;
                        }
                        return false;
                    }
                }
                if (!this.thrownByPlayer) ** GOTO lbl65
                for (i = 1; i <= GameAppState.ileWrogow; ++i) {
                    if (GameAppState.heros[i].wasHit() || !GameAppState.heros[i].collision(this.fp_X, this.fp_Y) || this.granadeBounces != 0) continue;
                    GameAppState.heros[i].changeState((byte)16, this.fp_velX);
                    GameAppState.heros[i].life = (short)(GameAppState.heros[i].life - this.damage);
                    GameAppState.hero.score += 100;
                    if (this.weaponType != 1) ** GOTO lbl56
                    this.anim = new SimpleAnimation(0, SimpleAnimation.ALIGN_CENTER);
                    this.state = (byte)4;
                    ** GOTO lbl86
lbl56:
                    // 1 sources

                    if (this.weaponType == 7 || this.weaponType == 5 || this.weaponType == 11) ** GOTO lbl61
                    this.fp_velX = -(this.fp_velX >> 2);
                    this.state = 1;
                    this.anim.setState((byte)0);
                    ** GOTO lbl86
lbl61:
                    // 1 sources

                    if (this.weaponType == 10 || this.weaponType == 11) {
                        this.state = (byte)3;
                    }
                    return false;
                }
                ** GOTO lbl86
lbl65:
                // 1 sources

                if (GameAppState.hero.immortalityTime == 0 && !GameAppState.hero.wasHit() && GameAppState.hero.collision(this.fp_X, this.fp_Y) && this.granadeBounces == 0) {
                    GameAppState.hero.changeState((byte)16, 0);
                    if (GameAppState.level.sectorType[GameAppState.hero.currentSector] == 2) {
                        GameAppState.hero.jumpBeginHeight = GameAppState.level.sectorEdgeBottom[GameAppState.hero.currentSector].yPoint[0] + 3 << 8;
                        GameAppState.hero.currentSector = GameAppState.level.sectorEdgeBottom[GameAppState.hero.currentSector].edgeType[0];
                    }
                    GameAppState.hero.life = (short)(GameAppState.hero.life - this.damage);
                    GameAppState.hero.jumpDirection = this.fp_velX > 0 ? 1 : -1;
                    this.fp_velX = -(this.fp_velX >> 1);
                    this.state = 1;
                    if (this.weaponType == 1) {
                        this.anim = new SimpleAnimation(0, SimpleAnimation.ALIGN_CENTER);
                        this.state = (byte)4;
                        break;
                    }
                    if (this.weaponType != 7 && this.weaponType != 5 && this.weaponType != 10 && this.weaponType != 11 && this.weaponType != 0 && this.weaponType != 8 && this.weaponType != 9) {
                        this.fp_velX = -(this.fp_velX >> 1);
                        this.state = 1;
                        this.anim.setState((byte)0);
                        break;
                    }
                    if (this.weaponType == 10 || this.weaponType == 11) {
                        this.state = (byte)3;
                    }
                    return false;
                }
lbl86:
                // 5 sources

                if (this.weaponType == 1 || this.weaponType == 2) {
                    this.fp_velY += 90112 * deltaTime >> 10;
                    if (this.fp_Y < this.beginHeight) break;
                    this.fp_Y = this.beginHeight;
                    this.fp_velY = -(this.fp_velY >> 1);
                    this.fp_velX >>= 1;
                    this.granadeBounces = (byte)(this.granadeBounces + 1);
                    if (this.granadeBounces != 3) break;
                    this.state = (byte)2;
                    if (this.anim == null) break;
                    this.anim.setToStart();
                    this.anim.setState((byte)2);
                    break;
                }
                if (this.weaponType != 8 && this.weaponType != 9) break;
                this.fp_velY += 90112 * deltaTime >> 10;
                if (this.fp_Y < this.beginHeight) break;
                if (this.weaponType == 8) {
                    return false;
                }
                if (this.weaponType != 9) break;
                this.anim.setState((byte)0);
                this.state = (byte)4;
                this.fp_velY = 0;
                this.fp_Y = this.beginHeight;
                break;
            }
            case 1: {
                if (this.weaponType == 0 || this.weaponType == 8) {
                    return false;
                }
                if (this.anim != null) {
                    this.anim.update(deltaTime);
                }
                this.fp_X += this.fp_velX * deltaTime >> 10;
                this.fp_Y += this.fp_velY * deltaTime >> 10;
                this.fp_velY += 90112 * deltaTime >> 10;
                if (this.fp_Y < this.beginHeight) break;
                this.fp_Y = this.beginHeight;
                this.fp_velY = -(this.fp_velY >> 1);
                this.fp_velX >>= 1;
                this.granadeBounces = (byte)(this.granadeBounces + 1);
                if (this.granadeBounces != 3) break;
                this.state = (byte)2;
                if (this.anim == null) break;
                this.anim.setToStart();
                this.anim.setState((byte)2);
            }
        }
        return true;
    }

    public void paintInHands(Graphics g, int x, int y, int dx, int dy, int f, byte orient) {
        int trans;
        if (this.weaponType == 7 || this.weaponType == 5) {
            return;
        }
        int anchor = 0;
        if (this.weaponType != 6) {
            dy -= this.imageCoords[3 + f * 4];
        }
        if (orient == 0) {
            trans = 0;
            dx -= this.imageCoords[2 + f * 4];
        } else {
            trans = 2;
            dx = -dx;
        }
        if (this.weaponType == 6) {
            SimpleAnimation.paintFrame(g, this.imageCoords[0 + f * 4], this.imageCoords[1 + f * 4], this.imageCoords[2 + f * 4], this.imageCoords[3 + f * 4], trans, GameAppState.scaleValue((x >> 8) - GameAppState.cameraX + dx), GameAppState.scaleValue((y >> 8) - GameAppState.cameraY + dy), anchor);
        } else {
            SimpleAnimation.paintFrame(g, this.imageCoords[0], this.imageCoords[1], this.imageCoords[2], this.imageCoords[3], trans, GameAppState.scaleValue((x >> 8) - GameAppState.cameraX + dx), GameAppState.scaleValue((y >> 8) - GameAppState.cameraY + dy), anchor);
        }
    }

    public void paint(Graphics g) {
        if (this.state != 3) {
            if (this.weaponType == 8) {
                int trans = 0;
                if (this.fp_velY > 0) {
                    trans = 1;
                }
                SimpleAnimation.paintFrame(g, GameAppState.scaleValue(121), GameAppState.scaleValue(72), GameAppState.scaleValue(7), GameAppState.scaleValue(15), trans, GameAppState.scaleValue((this.fp_X >> 8) - GameAppState.cameraX - 3), GameAppState.scaleValue((this.fp_Y >> 8) - GameAppState.cameraY - 7), 0);
            } else {
                int trans = 0;
                if (this.fp_velX <= 0) {
                    trans = 2;
                }
                this.anim.paint(g, this.fp_X >> 8, this.fp_Y >> 8, trans);
            }
        }
    }

    public void throwWeapon(byte direction, int beginX, int beginY, int beginHeight) {
        if (this.state == 3) {
            direction = direction == 1 ? (byte)-1 : (byte)1;
            this.beginHeight = beginHeight;
            if (this.weaponType == 5) {
                beginHeight = beginX;
            }
            this.fp_X = beginX;
            this.fp_Y = beginY;
            switch (this.weaponType) {
                case 5: 
                case 7: {
                    this.fp_velX = direction * 34496;
                    this.fp_velY = 0;
                    this.granadeBounces = 0;
                    this.anim.setState((byte)0);
                    break;
                }
                case 3: 
                case 4: 
                case 10: 
                case 11: {
                    this.fp_velX = direction * 34496;
                    this.fp_velY = 0;
                    this.granadeBounces = 0;
                    this.anim.setState((byte)2);
                    break;
                }
                case 1: 
                case 2: {
                    this.fp_velX = direction * 22528;
                    this.fp_velY = -22528;
                    this.granadeBounces = 0;
                    this.timeToExplode = 2500;
                    this.liveGranade = true;
                    this.anim.setState((byte)0);
                }
            }
            this.state = 0;
            GameAppState.addWeapon(this);
        }
    }

    public boolean canPickUpWeapon(int x, int y) {
        return x > this.fp_X - 2560 && x < this.fp_X + 2560 && y < this.fp_Y + 1536 && y > this.fp_Y - 1536;
    }

    public boolean inSplashDamage(int x, int y) {
        return x > this.fp_X - 3840 && x < this.fp_X + 3840 && y < this.fp_Y + 2560 && y > this.fp_Y - 2560;
    }

    public boolean isThrowable() {
        return this.weaponType == 2 || this.weaponType == 1 || this.weaponType == 3 || this.weaponType == 7 || this.weaponType == 5;
    }

    public void Serialize(DataOutputStream out) {
        try {
            out.writeByte(this.weaponType);
            out.writeInt(this.fp_X);
            out.writeInt(this.fp_Y);
            out.writeInt(this.fp_velX);
            out.writeInt(this.fp_velY);
            out.writeInt(this.beginHeight);
            out.writeBoolean(this.thrownByPlayer);
            out.writeByte(this.state);
            out.writeInt(this.timeToExplode);
            out.writeBoolean(this.liveGranade);
            out.writeByte(this.weaponType);
            out.writeByte(this.granadeBounces);
            out.writeByte(this.id);
            out.writeByte(this.damage);
            out.writeInt(this.sector);
            this.anim.Serialize(out);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void DeSerialize(DataInputStream in) {
        try {
            this.weaponType = in.readByte();
            this.fp_X = in.readInt();
            this.fp_Y = in.readInt();
            this.fp_velX = in.readInt();
            this.fp_velY = in.readInt();
            this.beginHeight = in.readInt();
            this.thrownByPlayer = in.readBoolean();
            this.state = in.readByte();
            this.timeToExplode = in.readInt();
            this.liveGranade = in.readBoolean();
            this.weaponType = in.readByte();
            this.granadeBounces = in.readByte();
            this.id = in.readByte();
            this.damage = in.readByte();
            this.sector = in.readInt();
            this.anim.DeSerialize(in);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }
}

