/*
 * Decompiled with CFR 0.152.
 */
package com.movilenio.debug;

import com.movilenio.debug.Watch;
import com.movilenio.game.Kernel;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class Debug {
    static int linePtr = 0;
    static Object[] lines = new Object[20];
    private static final Font font = Font.getFont((int)0, (int)0, (int)8);

    private static final void _draw_outline_text(Graphics g, String text, int x, int y) {
        g.setColor(0);
        g.drawString(text, x - 1, y, 0);
        g.drawString(text, x + 1, y, 0);
        g.drawString(text, x, y - 1, 0);
        g.drawString(text, x, y + 1, 0);
        g.setColor(0xFFFFFF);
        g.drawString(text, x, y, 0);
    }

    public static final void setObjectLine(int i, Object object) {
        if (i >= lines.length) {
            return;
        }
        Debug.lines[i] = object;
        if (i >= linePtr) {
            linePtr = i + 1;
        }
    }

    public static final void addObjectLine(Object object) {
        if (linePtr == lines.length) {
            --linePtr;
            for (int i = 0; i < linePtr; ++i) {
                Debug.lines[i] = lines[i + 1];
            }
        }
        Debug.lines[Debug.linePtr] = object;
        ++linePtr;
    }

    public static final void setTextLine(int i, String text) {
        Debug.setObjectLine(i, new String(text));
    }

    public static final void addTextLine(String text) {
        Debug.addObjectLine(new String(text));
    }

    public static final void draw(Graphics g) {
        g.setFont(font);
        int cx = g.getClipX();
        int cy = g.getClipY();
        int cw = g.getClipWidth();
        int ch = g.getClipHeight();
        int tx = g.getTranslateX();
        int ty = g.getTranslateY();
        g.translate(-tx, -ty);
        g.setClip(0, 0, Kernel.instance.getWidth(), Kernel.instance.getHeight());
        Font f = g.getFont();
        for (int i = 0; i < lines.length; ++i) {
            if (lines[i] == null) continue;
            if (lines[i] instanceof Watch) {
                Watch w = (Watch)lines[i];
                Debug._draw_outline_text(g, ":" + w.getWatchName() + "=" + w.getWatchValue(), 0, i * font.getHeight());
                continue;
            }
            Debug._draw_outline_text(g, lines[i].toString(), 0, i * font.getHeight());
        }
        g.translate(tx, ty);
        g.setClip(cx, cy, cw, ch);
        g.setFont(f);
    }
}

