/*
 * Decompiled with CFR 0.152.
 */
package com.movilenio.game;

import com.movilenio.debug.Debug;
import com.movilenio.game.GameSection;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.control.VolumeControl;
import javax.microedition.midlet.MIDlet;
import javax.microedition.rms.RecordStore;

public class Kernel
extends Canvas
implements Runnable {
    public static final int VERSION = 768;
    public static Kernel instance;
    public Thread thread;
    private boolean bExitApp;
    private MIDlet midlet;
    private boolean bStop;
    public boolean bPause;
    public boolean bVisible;
    static final int KEYMAP_SIZE = 19;
    public short[] keyMap;
    public short keyStatus;
    public static final byte K_UP = 0;
    public static final byte K_DOWN = 1;
    public static final byte K_LEFT = 2;
    public static final byte K_RIGHT = 3;
    public static final byte K_A = 4;
    public static final byte K_B = 5;
    public static final byte K_C = 6;
    public static final byte K_D = 7;
    public static final byte K_CUP = 8;
    public static final byte K_CDOWN = 9;
    public static final byte K_CLEFT = 10;
    public static final byte K_CRIGHT = 11;
    public static final byte K_CFIRE = 12;
    public static final byte K_SK_LEFT = 13;
    public static final byte K_SK_RIGHT = 14;
    public static final byte K_OK = 13;
    public static final byte K_CANCEL = 14;
    public static final byte K_UP_LEFT = 15;
    public static final byte K_UP_RIGHT = 16;
    public static final byte K_DOWN_LEFT = 17;
    public static final byte K_DOWN_RIGHT = 18;
    public static final int KST_UP = 1;
    public static final int KST_DOWN = 2;
    public static final int KST_LEFT = 4;
    public static final int KST_RIGHT = 8;
    public static final int KST_A = 16;
    public static final int KST_B = 32;
    public static final int KST_C = 64;
    public static final int KST_D = 128;
    public static final int KST_CUP = 256;
    public static final int KST_CDOWN = 512;
    public static final int KST_CLEFT = 1024;
    public static final int KST_CRIGHT = 2048;
    public static final int KST_CFIRE = 4096;
    public static final int KST_SK_LEFT = 8192;
    public static final int KST_SK_RIGHT = 16384;
    public static final int KST_OK = 8192;
    public static final int KST_CANCEL = 16384;
    public static final byte SND_LOOP = 1;
    public static final int SND_INFINITE_LOOP = -1;
    public long frameTicks;
    public GameSection gameSection;
    private GameSection nextGameSection;
    private boolean gsResourcesLoaded;
    private boolean gameSectionOk;
    private boolean bDoubleBuffered;
    private Image backBuffer;
    private Graphics backBuffer_g;
    private static final String IMG_EXT = ".png";

    private Kernel(MIDlet midlet) {
        this.showKernelInfo();
        this.midlet = midlet;
        this.bExitApp = true;
        this.bStop = false;
        this.bPause = false;
        this.bVisible = true;
        this.keyStatus = 0;
        this.frameTicks = 66L;
        this.setFullScreenMode(true);
        this.bDoubleBuffered = this.isDoubleBuffered();
        Kernel.log("Kernel: Cargando keymap.bin... ");
        this.keyMap = new short[19];
        byte[] b = this.loadResource("/keymap.bin");
        switch (b.length) {
            case 19: {
                Kernel.logln("ok (bytes)");
                for (int i = 0; i < 19; ++i) {
                    this.keyMap[i] = b[i];
                }
                break;
            }
            case 38: {
                Kernel.logln("ok (shorts)");
                int i = 0;
                int j = 0;
                while (i < 19) {
                    this.keyMap[i] = (short)(b[j] << 8 | b[j + 1]);
                    ++i;
                    j += 2;
                }
                break;
            }
            default: {
                Kernel.logln("ERROR, tama\u00f1o incorrecto.");
            }
        }
        Object var2_2 = null;
        this.gameSectionOk = false;
    }

    public static void log(String text) {
        System.out.print(text);
    }

    public static void logln() {
        System.out.println();
    }

    public static void logln(String text) {
        System.out.println(text);
    }

    private void showKernelInfo() {
        Kernel.logln();
        Kernel.logln("*** Kernel v3.0 ***");
        Kernel.log("Plataforma: ");
        Kernel.logln("MIDP 2.0");
        Kernel.log("Sonido: ");
        Kernel.logln("MMAPI");
        Kernel.log("MainLoop: ");
        Kernel.logln("Thread");
        Kernel.log("C\u00f3digos del teclado: ");
        Kernel.logln("normales");
        Kernel.log("Softkey aceptar: ");
        Kernel.logln("izquierda");
        Kernel.log("Simular softkeys (Command): ");
        Kernel.logln("NO");
        System.out.print("Simular puntero: ");
        Kernel.logln("NO");
        System.out.print("Forzar doble buffer: ");
        Kernel.logln("NO");
        System.out.print("Forzar ancho: ");
        Kernel.logln("NO");
        System.out.print("Forzar alto: ");
        Kernel.logln("NO");
        Kernel.logln("**************************");
        Kernel.logln();
    }

    private void showError(String msg) {
    }

    public static Kernel createInstance(MIDlet midlet) {
        instance = new Kernel(midlet);
        Display.getDisplay((MIDlet)midlet).setCurrent((Displayable)instance);
        Kernel.instance.thread = new Thread(instance);
        Kernel.instance.thread.start();
        return instance;
    }

    public void setClip(Graphics g, int x, int y, int width, int height) {
        g.setClip(x, y, width, height);
    }

    protected void paint(Graphics g) {
        if (!this.gameSectionOk) {
            return;
        }
        if (this.bVisible && this.gameSection != null) {
            if (this.bDoubleBuffered) {
                this.gameSection.paint(g);
            } else {
                if (this.backBuffer == null) {
                    System.out.println("Kernel: Creando doble buffer");
                    this.backBuffer = Image.createImage((int)this.getWidth(), (int)this.getHeight());
                    this.backBuffer_g = this.backBuffer.getGraphics();
                }
                this.gameSection.paint(this.backBuffer_g);
                g.drawImage(this.backBuffer, 0, 0, 0);
            }
            Debug.draw(g);
        }
    }

    public void run() {
        while (!this.bStop) {
            if (this.bVisible) {
                long tmr = System.currentTimeMillis();
                if (!this.bPause && this.gameSection != null) {
                    try {
                        if (this.gameSectionOk) {
                            this.gameSection.doFrame();
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                this.repaint();
                this.serviceRepaints();
                tmr = System.currentTimeMillis() - tmr;
                if (tmr < this.frameTicks) {
                    try {
                        Thread.sleep(this.frameTicks - tmr);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            } else {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            if (this.gameSection == this.nextGameSection) continue;
            this.gameSectionOk = false;
            if (this.gameSection != null) {
                this.gameSection.endSection();
                if (!this.gsResourcesLoaded) {
                    this.gameSection.freeResources();
                }
            }
            if ((this.gameSection = this.nextGameSection) != null) {
                this.gsResourcesLoaded = this.gameSection.resourcesLoaded;
                if (!this.gsResourcesLoaded) {
                    this.gameSection.loadResources();
                }
                if (this.gameSection.initSection()) {
                    if (!this.bVisible) {
                        this.gameSection.show(false);
                    }
                    this.gameSection = this.gameSection;
                }
            }
            this.gameSectionOk = true;
        }
        if (!this.bStop) {
            return;
        }
        this.bPause = false;
        this.bStop = false;
        if (this.bExitApp) {
            this.midlet.notifyDestroyed();
        }
        instance = null;
    }

    public final synchronized void stop(boolean exitApp) {
        this.setGameSection(null);
        this.bExitApp = exitApp;
        this.bStop = true;
    }

    public final synchronized void stop() {
        this.stop(true);
    }

    public synchronized void setGameSection(GameSection gameSection) {
        this.gameSectionOk = false;
        this.nextGameSection = gameSection;
    }

    protected void keyPressed(int keyCode) {
        boolean kOk = false;
        for (int i = 14; i >= 0; --i) {
            if (keyCode != this.keyMap[i]) continue;
            this.keyStatus = (short)(this.keyStatus | 1 << i);
            kOk = true;
            break;
        }
        if (!kOk) {
            if (keyCode == this.keyMap[15]) {
                this.keyStatus = (short)(this.keyStatus | 5);
            } else if (keyCode == this.keyMap[16]) {
                this.keyStatus = (short)(this.keyStatus | 9);
            } else if (keyCode == this.keyMap[17]) {
                this.keyStatus = (short)(this.keyStatus | 6);
            } else if (keyCode == this.keyMap[18]) {
                this.keyStatus = (short)(this.keyStatus | 0xA);
            }
        }
        if (this.bVisible && this.gameSectionOk && this.gameSection != null) {
            this.gameSection.keyPressed(keyCode);
        }
    }

    protected void keyReleased(int keyCode) {
        boolean kOk = false;
        for (int i = 14; i >= 0; --i) {
            if (keyCode != this.keyMap[i]) continue;
            this.keyStatus = (short)(this.keyStatus & ~(1 << i));
            kOk = true;
            break;
        }
        if (!kOk) {
            if (keyCode == this.keyMap[15]) {
                this.keyStatus = (short)(this.keyStatus & 0xFFFFFFFA);
            } else if (keyCode == this.keyMap[16]) {
                this.keyStatus = (short)(this.keyStatus & 0xFFFFFFF6);
            } else if (keyCode == this.keyMap[17]) {
                this.keyStatus = (short)(this.keyStatus & 0xFFFFFFF9);
            } else if (keyCode == this.keyMap[18]) {
                this.keyStatus = (short)(this.keyStatus & 0xFFFFFFF5);
            }
        }
        if (this.bVisible && this.gameSectionOk && this.gameSection != null) {
            this.gameSection.keyReleased(keyCode);
        }
    }

    protected void keyRepeated(int keyCode) {
    }

    public int getCursorX() {
        return 0;
    }

    public int getCursorY() {
        return 0;
    }

    public int getCursorMovX() {
        return 0;
    }

    public int getCursorMovY() {
        return 0;
    }

    public void setCursorPos(int x, int y) {
    }

    public final boolean getKeyPressedStatus(int keyID) {
        return (this.keyStatus & 1 << keyID) != 0;
    }

    public final void setKeyPressedStatus(int keyID, boolean pressed) {
        this.keyStatus = pressed ? (short)(this.keyStatus | 1 << keyID) : (short)(this.keyStatus & ~(1 << keyID));
    }

    public synchronized void pause(boolean bPause) {
        this.bPause = bPause;
    }

    protected void hideNotify() {
        this.bVisible = false;
        this.bPause = true;
        if (this.gameSectionOk && this.gameSection != null) {
            this.gameSection.show(false);
        }
    }

    protected void showNotify() {
        this.bVisible = true;
        if (this.gameSectionOk && this.gameSection != null) {
            this.gameSection.show(true);
        } else {
            this.bPause = false;
        }
    }

    public void setSoundVolume(Object sound, int volume) {
        VolumeControl vc = (VolumeControl)((Player)sound).getControl("VolumeControl");
        if (vc != null) {
            vc.setLevel(volume);
        }
    }

    public Object openSound(String soundName, String type) {
        Player sound = null;
        try {
            InputStream is = this.getClass().getResourceAsStream(soundName);
            if (is != null) {
                sound = Manager.createPlayer((InputStream)is, (String)type);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sound;
    }

    public void closeSound(Object sound) {
        if (sound != null) {
            this.stopSound(sound);
            ((Player)sound).close();
        }
    }

    public void playSound(Object sound, int flags) {
        this.playSound(sound, (flags & 1) != 0 ? -1 : 1, flags);
    }

    public void playSound(Object sound, int loopCount, int flags) {
        if (sound == null) {
            return;
        }
        Player p = (Player)sound;
        if (p.getState() != 400) {
            try {
                p.setLoopCount(loopCount);
                p.prefetch();
                p.start();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void stopSound(Object sound) {
        if (sound != null) {
            try {
                ((Player)sound).stop();
                ((Player)sound).deallocate();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public Object openMusic(String musicName, String type) {
        return this.openSound(musicName, type);
    }

    public void closeMusic(Object music) {
        this.closeSound(music);
    }

    public void playMusic(Object music, int flags) {
        this.playSound(music, flags);
    }

    public void playMusic(Object music, int loopCount, int flags) {
        this.playSound(music, loopCount, flags);
    }

    public void stopMusic(Object music) {
        this.stopSound(music);
    }

    public void playTone(int note, int duration, int volume) {
        try {
            Manager.playTone((int)note, (int)duration, (int)volume);
        }
        catch (MediaException e) {
            e.printStackTrace();
        }
    }

    public void vibrate(int duration) {
        Display.getDisplay((MIDlet)this.midlet).vibrate(duration);
    }

    public static void writeInt(int value, byte[] b, int offset) {
        b[offset] = (byte)(value >>> 24);
        b[offset + 1] = (byte)(value >>> 16);
        b[offset + 2] = (byte)(value >>> 8);
        b[offset + 3] = (byte)value;
    }

    public static int readInt(byte[] b, int offset) {
        return (b[offset] & 0xFF) << 24 | (b[offset + 1] & 0xFF) << 16 | (b[offset + 2] & 0xFF) << 8 | b[offset + 3] & 0xFF;
    }

    public static byte[][] loadRMS(String name, int offset) {
        return Kernel.loadRMS(name, offset, 0);
    }

    public static byte[][] loadRMS(String name, int offset, int size) {
        Object data = null;
        try {
            RecordStore rs = RecordStore.openRecordStore((String)name, (boolean)false);
            int n = rs.getNumRecords();
            data = new byte[n][];
            for (int i = 0; i < n; ++i) {
                data[i] = rs.getRecord(i + 1);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return data;
    }

    public static void saveRMS(String name, byte[][] data, int offset) {
        try {
            RecordStore rs = RecordStore.openRecordStore((String)name, (boolean)true);
            for (int i = 0; i < data.length; ++i) {
                if (rs.getNumRecords() < i + 1) {
                    rs.addRecord(data[i], 0, data[i].length);
                    continue;
                }
                rs.setRecord(i + 1, data[i], 0, data[i].length);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getResourceIndex(String resourceName) {
        return -1;
    }

    public int getResourcePosition(String resourceName) {
        return -1;
    }

    public int getResourceSize(String resourceName) {
        return -1;
    }

    public DataInputStream getResourceStream(String resourceName) {
        DataInputStream dis = null;
        InputStream is = this.getClass().getResourceAsStream(resourceName);
        if (is != null) {
            dis = new DataInputStream(is);
        }
        return dis;
    }

    public static final void readStreamData(InputStream is, byte[] b, int offset, int length) throws IOException {
        while (length > 0) {
            int read = is.read(b, offset, length);
            offset += read;
            length -= read;
        }
    }

    public byte[] loadResource(String resourceName) {
        byte[] b = null;
        InputStream is = this.getClass().getResourceAsStream(resourceName);
        if (is != null) {
            try {
                int bytesRead;
                byte[] buf = new byte[1024];
                while ((bytesRead = is.read(buf)) != -1) {
                    int bl = b != null ? b.length : 0;
                    byte[] aux = new byte[bl + bytesRead];
                    if (b != null) {
                        System.arraycopy(b, 0, aux, 0, b.length);
                    }
                    System.arraycopy(buf, 0, aux, bl, bytesRead);
                    b = aux;
                    if (bytesRead >= buf.length) continue;
                    break;
                }
                buf = null;
                is.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return b;
    }

    public Image loadImage(String imageName) {
        Image image = null;
        if (imageName.charAt(0) != '/') {
            imageName = '/' + imageName;
        }
        imageName = imageName + IMG_EXT;
        try {
            image = Image.createImage((String)imageName);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return image;
    }

    public Image[] loadImages(String firstImage, int numImages) {
        return null;
    }

    public Image[] loadIndexedImage(String imageName) {
        Object[] image = null;
        int imageSize = 0;
        int paletteOffset = 0;
        short paletteSize = 0;
        byte[] img = null;
        InputStream is = this.getClass().getResourceAsStream(imageName + ".i");
        if (is != null) {
            DataInputStream dis = new DataInputStream(is);
            try {
                imageSize = dis.readInt();
                paletteOffset = dis.readInt();
                paletteSize = dis.readShort();
                img = new byte[imageSize];
                dis.read(img, 0, paletteOffset);
                dis.read(img, paletteOffset + paletteSize, imageSize - (paletteOffset + paletteSize));
                dis.close();
                Vector<Image> v = new Vector<Image>();
                int i = 0;
                while ((is = this.getClass().getResourceAsStream(imageName + ".p" + i)) != null) {
                    is.read(img, paletteOffset, paletteSize);
                    is.close();
                    v.addElement(Image.createImage((byte[])img, (int)0, (int)img.length));
                    ++i;
                }
                if (v.size() > 0) {
                    image = new Image[v.size()];
                    v.copyInto(image);
                    v.removeAllElements();
                }
            }
            catch (IOException e) {
                System.out.println("loadIndexededImage(String) - ERROR:" + e.getMessage());
            }
        }
        return image;
    }

    public Image loadIndexedImage(String imageName, String paletteName) {
        Image image = null;
        int imageSize = 0;
        int paletteOffset = 0;
        short paletteSize = 0;
        byte[] img = null;
        InputStream is = this.getClass().getResourceAsStream(imageName);
        if (is != null) {
            DataInputStream dis = new DataInputStream(is);
            try {
                imageSize = dis.readInt();
                paletteOffset = dis.readInt();
                paletteSize = dis.readShort();
                img = new byte[imageSize];
                dis.read(img, 0, paletteOffset);
                dis.read(img, paletteOffset + paletteSize, imageSize - (paletteOffset + paletteSize));
                dis.close();
                is = this.getClass().getResourceAsStream(paletteName);
                if (is != null) {
                    is.read(img, paletteOffset, paletteSize);
                    is.close();
                    image = Image.createImage((byte[])img, (int)0, (int)img.length);
                }
            }
            catch (Exception e) {
                System.out.println("loadIndexededImage(String,String) - ERROR:" + e.toString());
            }
        }
        return image;
    }
}

