/*
 * Decompiled with CFR 0.152.
 */
package escape;

import com.movilenio.game.GameSection;
import com.movilenio.game.Kernel;
import escape.Escape;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Help
extends GameSection {
    public static final byte MODE_HELP = 0;
    public static final byte MODE_TOP_SCORE = 1;
    public static final byte MODE_END_GAME = 2;
    public static final byte MODE_INTRO = 3;
    public static final byte MODE_ABOUT = 4;
    public byte mode;
    Image bg;
    int txtY;
    int maxY;
    int minY;
    int dy;
    String[] lines;
    short[] lines_x;

    public boolean initSection() {
        Kernel.instance.keyStatus = 0;
        System.gc();
        int KW = Kernel.instance.getWidth();
        int KH = Kernel.instance.getHeight();
        switch (this.mode) {
            case 0: 
            case 3: {
                this.lines = Escape.loadLines("/help.txt", Escape.font, KW - 5);
                break;
            }
            case 1: {
                this.lines = new String[]{Escape.texts[3], String.valueOf(Escape.game.lastLevel), Escape.texts[4], String.valueOf(Escape.game.topScore)};
                break;
            }
            case 2: {
                this.lines = Escape.loadLines("/ending.txt", Escape.font, KW - 5);
                break;
            }
            case 4: {
                this.lines = Escape.loadLines("/about.txt", Escape.font, KW - 5);
            }
        }
        int textHeight = Escape.font.getHeight() * this.lines.length;
        switch (this.mode) {
            case 0: {
                this.txtY = 0;
                this.maxY = 0;
                this.dy = 0;
                this.minY = -Math.max(0, textHeight - KH);
                break;
            }
            case 1: {
                this.txtY = 0;
                this.maxY = this.minY = KH - textHeight >> 1;
                this.dy = 0;
                break;
            }
            case 3: 
            case 4: {
                this.maxY = this.txtY = KH;
                this.minY = textHeight > KH ? -Math.max(0, textHeight - KH) : KH - textHeight >> 1;
                this.dy = -1;
                break;
            }
            case 2: {
                this.maxY = this.txtY = KH;
                this.minY = -textHeight - 30;
                this.dy = -1;
            }
        }
        this.lines_x = new short[this.lines.length];
        for (int i = 0; i < this.lines.length; ++i) {
            this.lines_x[i] = (short)(KW - Escape.font.stringWidth(this.lines[i]) >> 1);
        }
        return true;
    }

    public void endSection() {
        this.lines_x = null;
        for (int i = 0; i < this.lines.length; ++i) {
            this.lines[i] = null;
        }
        this.lines = null;
    }

    public void loadResources() {
        super.loadResources();
        Image aux = Kernel.instance.loadImage("/title");
        this.bg = Image.createImage((int)aux.getWidth(), (int)aux.getHeight());
        int s = this.bg.getHeight();
        Graphics g = this.bg.getGraphics();
        g.setColor(0);
        g.fillRect(0, 0, this.bg.getWidth(), this.bg.getHeight());
        g.drawImage(aux, 0, 0, 0);
        for (int i = -this.bg.getHeight(); i < this.bg.getWidth(); i += 2) {
            g.drawLine(i, 0, i + s, s);
        }
        aux = null;
    }

    public void freeResources() {
        super.freeResources();
        this.bg = null;
        if (this.lines != null) {
            for (int i = this.lines.length - 1; i >= 0; --i) {
                this.lines[i] = null;
            }
        }
        this.lines = null;
    }

    public void show(boolean bShow) {
        Kernel.instance.pause(!bShow);
    }

    public void doFrame() {
        if ((Kernel.instance.keyStatus & 0x7010) != 0) {
            if (this.mode == 3) {
                Kernel.instance.setGameSection(Escape.game);
            } else {
                Kernel.instance.setGameSection(Escape.mainMenu);
            }
            return;
        }
        if (this.mode == 0) {
            if (Kernel.instance.getKeyPressedStatus(8)) {
                if (this.dy < 5) {
                    ++this.dy;
                }
            } else if (Kernel.instance.getKeyPressedStatus(9)) {
                if (this.dy > -5) {
                    --this.dy;
                }
            } else {
                if (this.dy < 0) {
                    ++this.dy;
                }
                if (this.dy > 0) {
                    --this.dy;
                }
            }
        }
        this.txtY += this.dy;
        if (this.txtY > this.maxY) {
            this.txtY = this.maxY;
        }
        if (this.txtY < this.minY) {
            this.txtY = this.minY;
        }
        if (this.mode == 2 && this.txtY <= this.minY) {
            Kernel.instance.setGameSection(Escape.mainMenu);
        }
    }

    public void paint(Graphics g) {
        if (this.bg != null) {
            int l1;
            g.setColor(0);
            g.fillRect(0, 0, Kernel.instance.getWidth(), Kernel.instance.getHeight());
            g.drawImage(this.bg, Kernel.instance.getWidth() >> 1, 0, 17);
            g.setFont(Escape.font);
            int h = Escape.font.getHeight();
            int l0 = -this.txtY / h;
            if (l0 < 0) {
                l0 = 0;
            }
            if ((l1 = l0 + (Kernel.instance.getHeight() - this.txtY) / h) >= this.lines.length) {
                l1 = this.lines.length - 1;
            }
            int x = Kernel.instance.getWidth() >> 1;
            int y = this.txtY + l0 * h;
            for (int i = l0; i <= l1; ++i) {
                g.setColor(0);
                g.drawString(this.lines[i], x + 2, y + 2, 17);
                g.setColor(0xFFFFFF);
                g.drawString(this.lines[i], x, y, 17);
                y += h;
            }
        }
    }
}

