/*
 * Decompiled with CFR 0.152.
 */
package escape;

import com.movilenio.game.GameSection;
import com.movilenio.game.Kernel;
import escape.Escape;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class MainMenu
extends GameSection {
    private final byte ST_OPERADOR = (byte)3;
    private final byte ST_SPLASH;
    private final byte ST_LOGO = (byte)2;
    private final byte ST_MENU;
    private byte status = (byte)3;
    private short tmrSplash = (short)45;
    Image background;
    public static final int PLAY = 0;
    public static final int CONTINUE = 1;
    public static final int TOP_SCORE = 2;
    public static final int SOUND = 3;
    public static final int HELP = 4;
    public static final int ABOUT = 5;
    public static final int EXIT = 6;
    public static final int ON = 7;
    public static final int OFF = 8;
    public static final int LEVEL = 9;
    public byte op = 0;
    String[] options;
    byte desp = (byte)2;
    byte inc = 1;
    public boolean bSound = true;
    Object music;
    Image LOGO_image;
    static final int LOGO_BG_COLOR = 0xFF6600;
    static final int LOGO_TIME = 2;
    int LOGO_timer;
    Image LOGO_point;
    int LOGO_py1;
    int LOGO_pdy1;
    int LOGO_py2;
    int LOGO_pdy2;
    static final int LOGO_px1 = 103;
    static final int LOGO_px2 = 137;
    static final int LOGO_PY = 13;

    public MainMenu() {
        this.ST_SPLASH = 0;
        this.ST_MENU = 1;
    }

    public boolean initSection() {
        Kernel.instance.keyStatus = 0;
        if (this.bSound) {
            Kernel.instance.playMusic(this.music, -1, 0);
        }
        return true;
    }

    public void endSection() {
        Kernel.instance.stopMusic(this.music);
    }

    public void loadResources() {
        super.loadResources();
        System.gc();
        this.background = Kernel.instance.loadImage(this.status == 3 ? "/operador" : "/title");
        Escape.font = Font.getFont((int)0, (int)1, (int)8);
        this.options = Escape.loadLines("/menu.txt", null, 0);
        this.music = Kernel.instance.openMusic("/volcan.mid", "audio/midi");
    }

    public void freeResources() {
        super.freeResources();
        this.background = null;
        for (int i = this.options.length - 1; i >= 0; --i) {
            this.options[i] = null;
        }
        this.options = null;
        Kernel.instance.closeMusic(this.music);
        this.music = null;
    }

    public void show(boolean bShow) {
        if (bShow) {
            if (this.bSound) {
                Kernel.instance.playMusic(this.music, -1, 0);
            }
        } else if (this.bSound) {
            Kernel.instance.stopMusic(this.music);
        }
        Kernel.instance.pause(!bShow);
    }

    public void keyPressed(int keyCode) {
        if (this.status == 1) {
            if (keyCode == Kernel.instance.keyMap[10]) {
                if (this.op == 9) {
                    Escape.game.firstLevel = Escape.game.firstLevel > 1 ? (short)(Escape.game.firstLevel - 1) : Escape.game.lastLevel;
                } else {
                    this.op = (byte)(this.op - 1);
                    if (this.op < 0) {
                        this.op = (byte)6;
                    }
                    if (this.op == 1 && !Escape.game.bExitTemp) {
                        this.op = (byte)(this.op - 1);
                    }
                    if (this.op == 3 && this.music == null) {
                        this.op = (byte)(this.op - 1);
                    }
                }
                return;
            }
            if (keyCode == Kernel.instance.keyMap[11]) {
                if (this.op == 9) {
                    Escape.game.firstLevel = Escape.game.firstLevel < Escape.game.lastLevel ? (short)(Escape.game.firstLevel + 1) : (short)1;
                } else {
                    this.op = (byte)(this.op + 1);
                    if (this.op > 6) {
                        this.op = 0;
                    }
                    if (this.op == 1 && !Escape.game.bExitTemp) {
                        this.op = (byte)(this.op + 1);
                    }
                    if (this.op == 3 && this.music == null) {
                        this.op = (byte)(this.op + 1);
                    }
                }
                return;
            }
            if (this.op == 9 && keyCode == Kernel.instance.keyMap[14]) {
                this.op = 0;
                return;
            }
            if ((Kernel.instance.keyStatus & 0x3010) != 0) {
                switch (this.op) {
                    case 0: {
                        this.op = (byte)9;
                        break;
                    }
                    case 9: {
                        Escape.game.bExitTemp = false;
                        if (Escape.game.firstLevel == 1) {
                            Escape.help.mode = (byte)3;
                            Kernel.instance.setGameSection(Escape.help);
                            break;
                        }
                        Kernel.instance.setGameSection(Escape.game);
                        break;
                    }
                    case 1: {
                        Kernel.instance.setGameSection(Escape.game);
                        break;
                    }
                    case 2: {
                        Escape.help.mode = 1;
                        Kernel.instance.setGameSection(Escape.help);
                        break;
                    }
                    case 3: {
                        boolean bl = this.bSound = !this.bSound;
                        if (this.bSound) {
                            Kernel.instance.playMusic(this.music, -1, 0);
                            break;
                        }
                        Kernel.instance.stopMusic(this.music);
                        break;
                    }
                    case 4: {
                        Escape.help.mode = 0;
                        Kernel.instance.setGameSection(Escape.help);
                        break;
                    }
                    case 5: {
                        Escape.help.mode = (byte)4;
                        Kernel.instance.setGameSection(Escape.help);
                        break;
                    }
                    case 6: {
                        Escape.game.saveGame();
                        Kernel.instance.stop(true);
                    }
                }
            }
        }
    }

    public void drawCenteredImage(Image image, Graphics g) {
        g.drawImage(image, Kernel.instance.getWidth() - image.getWidth() >> 1, Kernel.instance.getHeight() - image.getHeight() >> 1, 0);
    }

    public void paint(Graphics g) {
        switch (this.status) {
            case 0: 
            case 3: {
                g.setColor(0xFFFFFF);
                g.fillRect(0, 0, Kernel.instance.getWidth(), Kernel.instance.getHeight());
                if (this.background == null) break;
                this.drawCenteredImage(this.background, g);
                break;
            }
            case 2: {
                this.LOGO_paint(g);
                break;
            }
            case 1: {
                short menuY = (short)(Kernel.instance.getHeight() - Escape.font.getHeight() - 2);
                g.setColor(0);
                g.fillRect(0, 0, Kernel.instance.getWidth(), Kernel.instance.getHeight());
                if (this.background != null) {
                    g.drawImage(this.background, Kernel.instance.getWidth() >> 1, 0, 17);
                }
                String opt = this.options[this.op];
                switch (this.op) {
                    case 3: {
                        opt = opt + " " + (this.bSound ? this.options[7] : this.options[8]);
                        break;
                    }
                    case 9: {
                        opt = opt + " " + Escape.game.firstLevel;
                    }
                }
                int opWidth = Escape.font.stringWidth(opt);
                int opX = Kernel.instance.getWidth() - opWidth >> 1;
                int aux = Escape.font.charWidth('<');
                int posi = opX - aux - 5 - this.desp;
                int posd = opX + opWidth + 5 + this.desp;
                g.setFont(Escape.font);
                g.setColor(0xFFFF00);
                g.drawString("<", posi, (int)menuY, 0);
                g.drawString(">", posd, (int)menuY, 0);
                g.setColor(255);
                g.drawString(opt, opX, (int)menuY, 0);
            }
        }
    }

    public void doFrame() {
        switch (this.status) {
            case 3: {
                if (this.background == null) {
                    this.tmrSplash = 0;
                }
                short s = this.tmrSplash;
                this.tmrSplash = (short)(s - 1);
                if (s != 0) break;
                this.background = null;
                this.status = 0;
                break;
            }
            case 0: {
                if (this.background == null) {
                    this.background = Kernel.instance.loadImage("/splash");
                    this.tmrSplash = this.background == null ? (short)0 : (short)20;
                }
                short s = this.tmrSplash;
                this.tmrSplash = (short)(s - 1);
                if (s != 0) break;
                this.background = null;
                this.LOGO_init();
                this.status = (byte)2;
                break;
            }
            case 2: {
                if (!this.LOGO_doframe()) break;
                this.background = null;
                this.LOGO_done();
                this.status = 1;
                break;
            }
            case 1: {
                if (this.background == null) {
                    this.background = Kernel.instance.loadImage("/title");
                }
                if (this.desp == 2 || this.desp == -2) {
                    this.inc = -this.inc;
                }
                this.desp = (byte)(this.desp + this.inc);
            }
        }
    }

    public void LOGO_init() {
        try {
            this.LOGO_image = Image.createImage((String)"/m.png");
            this.LOGO_point = Image.createImage((String)"/p.png");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.LOGO_py1 = -100;
        this.LOGO_pdy1 = 0;
        this.LOGO_py2 = -150;
        this.LOGO_pdy2 = 0;
        this.LOGO_timer = (int)(2L * (1000L / Kernel.instance.frameTicks));
    }

    public void LOGO_done() {
        this.LOGO_point = null;
        this.LOGO_image = null;
    }

    public boolean LOGO_doframe() {
        if (++this.LOGO_pdy1 > 9) {
            this.LOGO_pdy1 = 9;
        }
        if ((this.LOGO_py1 += this.LOGO_pdy1) > 13) {
            this.LOGO_py1 = 13;
            this.LOGO_pdy1 = -this.LOGO_pdy1 * 3 / 4;
        }
        if (++this.LOGO_pdy2 > 9) {
            this.LOGO_pdy2 = 9;
        }
        if ((this.LOGO_py2 += this.LOGO_pdy2) > 13) {
            this.LOGO_py2 = 13;
            this.LOGO_pdy2 = -this.LOGO_pdy2 * 3 / 4;
        }
        if (this.LOGO_py1 == 13 && this.LOGO_pdy1 == 0 && this.LOGO_py2 == 13 && this.LOGO_pdy2 == 0) {
            --this.LOGO_timer;
        }
        return this.LOGO_timer == 0 || Kernel.instance.keyStatus != 0;
    }

    public void LOGO_paint(Graphics g) {
        int KW = Kernel.instance.getWidth();
        int KH = Kernel.instance.getHeight();
        int x = KW - this.LOGO_image.getWidth() >> 1;
        int y = KH - this.LOGO_image.getHeight() >> 1;
        g.setColor(0xFF6600);
        g.fillRect(0, 0, KW, KH);
        g.drawImage(this.LOGO_image, x, y, 0);
        g.drawImage(this.LOGO_point, x + 103, y + this.LOGO_py1, 0);
        g.drawImage(this.LOGO_point, x + 137, y + this.LOGO_py2, 0);
    }
}

