/*
 * Decompiled with CFR 0.152.
 */
package escape;

import com.movilenio.game.Kernel;
import escape.BBox;
import escape.Sprite;
import escape.TileMap;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

class Ship {
    private byte frameShip;
    private Sprite sprShip;
    private Sprite[] sprFire;
    private byte[][] fireLxy = new byte[][]{null, null, null, {3, -11, 9}, {4, -10, 6}};
    private byte[][] fireCxy = new byte[][]{{1, 5, 11}, {1, 3, 12}, {0, 0, 11}, {3, -3, 12}, {3, -5, 11}};
    private byte[][] fireRxy = new byte[][]{{2, 10, 6}, {1, 11, 10}, null, null, null};
    private Sprite sprExplo;
    public int x;
    public int y;
    public int dx;
    public int dy;
    BBox bbox;
    public boolean bUp;
    public boolean exit;
    public static final short MAX_FUEL = 128;
    public short fuel;
    public int score;
    public int lives;
    public boolean isDead;
    public int nextLife;
    private TileMap map;
    private final int VH;
    private final int VV;
    private int cnt;

    public Ship(TileMap level) {
        this.VH = 3;
        this.VV = 4;
        this.map = level;
        this.bbox = new BBox(-11, -8, 9, 5);
    }

    public void loadResources() {
        try {
            this.sprShip = new Sprite(Image.createImage((String)"/nave1_t.png"), 16, 13, 5, 0, 0);
            this.sprFire = new Sprite[5];
            this.sprFire[0] = new Sprite(Image.createImage((String)"/fuego1_t.png"), 4, 0, 3, 0, 1);
            this.sprFire[1] = new Sprite(Image.createImage((String)"/fuego2_t.png"), 2, 2, 3, 0, 1);
            this.sprFire[2] = new Sprite(Image.createImage((String)"/fuego3_t.png"), 1, 1, 3, 0, 1);
            this.sprFire[3] = new Sprite(Image.createImage((String)"/fuego4_t.png"), 6, 2, 3, 0, 1);
            this.sprFire[4] = new Sprite(Image.createImage((String)"/fuego5_t.png"), 9, 1, 3, 0, 1);
            this.sprExplo = new Sprite(Image.createImage((String)"/explosion_t.png"), 16, 16, 4, -1, 2);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void freeResources() {
        for (int i = this.sprFire.length - 1; i >= 0; --i) {
            this.sprFire[i].unload();
            this.sprFire[i] = null;
        }
        this.sprShip.unload();
        this.sprExplo.unload();
        this.sprShip = null;
        this.sprFire = null;
        this.sprExplo = null;
    }

    public void init() {
        this.lives = 3;
        this.score = 0;
        this.nextLife = 5000;
    }

    public void done() {
    }

    public void start() {
        this.x = this.map.startX;
        this.y = this.map.startY;
        this.dy = 0;
        this.dx = 0;
        this.isDead = false;
        this.bUp = false;
        this.exit = false;
        this.fuel = (short)128;
        this.frameShip = (byte)2;
        this.map.setViewPoint(this.x, this.y, false);
        this.cnt = 5;
    }

    public void destroy() {
        if (!this.isDead) {
            --this.lives;
            this.sprExplo.setCurrentFrame(0);
            this.isDead = true;
        }
    }

    public void paint(Graphics g) {
        int scrX = this.map.scrX(this.x);
        int scrY = this.map.scrY(this.y);
        if (!this.isDead) {
            if (this.bUp) {
                byte f = this.frameShip;
                byte[] fxy = this.fireLxy[f];
                if (fxy != null) {
                    this.sprFire[fxy[0]].draw(scrX + fxy[1], scrY + fxy[2], g);
                    this.sprFire[fxy[0]].nextFrame();
                }
                if ((fxy = this.fireCxy[f]) != null) {
                    this.sprFire[fxy[0]].draw(scrX + fxy[1], scrY + fxy[2], g);
                    this.sprFire[fxy[0]].nextFrame();
                }
                if ((fxy = this.fireRxy[f]) != null) {
                    this.sprFire[fxy[0]].draw(scrX + fxy[1], scrY + fxy[2], g);
                    this.sprFire[fxy[0]].nextFrame();
                }
            }
            this.sprShip.setCurrentFrame(this.frameShip);
            this.sprShip.draw(scrX, scrY, g);
        } else {
            this.sprExplo.draw(scrX, scrY, g);
            this.sprExplo.nextFrame();
        }
    }

    public void doFrame() {
        if (this.isDead) {
            return;
        }
        --this.cnt;
        if (this.fuel > 0 && (Kernel.instance.keyStatus & 0x111) != 0) {
            if (this.dy > -4) {
                --this.dy;
            }
            if (this.fuel > 0) {
                this.fuel = (short)(this.fuel - 1);
            }
            this.bUp = true;
        } else {
            if (this.cnt == 0 && this.dy < 10) {
                ++this.dy;
            }
            this.bUp = false;
        }
        if ((Kernel.instance.keyStatus & 0x404) != 0) {
            if (this.dx > -3) {
                --this.dx;
            }
            if (this.frameShip > 0) {
                this.frameShip = (byte)(this.frameShip - 1);
            }
        } else {
            if (this.cnt == 0 && this.dx < 0) {
                ++this.dx;
            }
            if (this.frameShip < 2) {
                this.frameShip = (byte)(this.frameShip + 1);
            }
        }
        if ((Kernel.instance.keyStatus & 0x808) != 0) {
            if (this.dx < 3) {
                ++this.dx;
            }
            if (this.frameShip < this.sprShip.numFrames - 1) {
                this.frameShip = (byte)(this.frameShip + 1);
            }
        } else {
            if (this.cnt == 0 && this.dx > 0) {
                --this.dx;
            }
            if (this.frameShip > 2) {
                this.frameShip = (byte)(this.frameShip - 1);
            }
        }
        if (this.cnt == 0) {
            this.cnt = 5;
        }
        this.x += this.dx;
        this.y += this.dy;
        this.map.setViewPoint(this.x, this.y, false);
        if (this.y + this.bbox.y2 > this.map.lavaY) {
            this.destroy();
            return;
        }
        int hitTile = this.map.checkHit((short)this.x, (short)this.y, this.bbox);
        if (hitTile == -2) {
            this.destroy();
        } else if (hitTile != -1) {
            switch (this.map.map[hitTile]) {
                case 3: 
                case 51: 
                case 57: {
                    break;
                }
                case 52: {
                    this.fuel = (short)(this.fuel + 50);
                    if (this.fuel > 128) {
                        this.fuel = (short)128;
                    }
                    this.map.map[hitTile] = 3;
                    break;
                }
                case 53: {
                    this.score += 25;
                    if (this.score >= this.nextLife) {
                        ++this.lives;
                        this.nextLife += 5000;
                    }
                    this.map.map[hitTile] = 3;
                    this.map.numGold = (short)(this.map.numGold + 1);
                    break;
                }
                case 54: {
                    if (this.lives < 9) {
                        ++this.lives;
                    }
                    this.map.map[hitTile] = 3;
                    break;
                }
                default: {
                    this.destroy();
                }
            }
        }
        if (this.y < 16) {
            this.exit = true;
        }
    }
}

