/*
 * Decompiled with CFR 0.152.
 */
package escape;

import com.movilenio.game.Kernel;
import escape.BBox;
import escape.Escape;
import escape.Pinchos;
import escape.Sprite;
import java.io.InputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

class TileMap {
    public static final int TILE_SIZE = 32;
    public static final int SHIFT = 5;
    Image[][] aTiles;
    Image[] tiles;
    public static final int MAX_MAP_SIZE = 1024;
    int mapWidth;
    int mapHeight;
    int mapPixelWidth;
    int mapPixelHeight;
    byte[] map = new byte[1024];
    int wWidth;
    int wHeight;
    int wWidth2;
    int wHeight2;
    int old_x;
    int old_y;
    int x;
    int y;
    private int ox;
    private int oy;
    private Image frontBuffer;
    private Image backBuffer;
    private Graphics frontBuffer_g;
    private Graphics backBuffer_g;
    public static final int EMPTY = 3;
    public static final int ROCK = 0;
    public static final int FUEL = 52;
    public static final int GOLD = 53;
    public static final int LIFE = 54;
    public static final int PINCHO = 55;
    public static final int PINCHO_FIJO = 56;
    public static final int START = 50;
    public static final int ARROW = 51;
    public static final int FINISH = 57;
    private BBox[][] bboxTiles;
    public short levelGold;
    public short numGold;
    private Sprite sprGold;
    private Sprite sprFuel;
    private Sprite sprLife;
    private Image imgLava;
    private Image imgFinish;
    private Image imgArrow;
    private byte t_flecha;
    private Pinchos pinchos = new Pinchos(this);
    public short lavaY;
    private short f_lavaY;
    public byte vel_lava;
    public byte f_lava;
    public byte v_aniLava;
    public short startX;
    public short startY;
    byte pal_n;
    byte pal_t;
    byte[] pal_ani = new byte[]{0, 20, 1, 2, 2, 2, 1, 2};

    TileMap() {
    }

    private BBox[][] loadBBox(String file) {
        BBox[][] bbox = null;
        byte[] aux = Kernel.instance.loadResource(file);
        if (aux != null) {
            int ind = 0;
            int nbbox = aux[ind++];
            bbox = new BBox[nbbox][];
            for (int i = 0; i < nbbox; ++i) {
                int n;
                if ((n = aux[ind++]) == 0) continue;
                bbox[i] = new BBox[n];
                for (int b = 0; b < n; ++b) {
                    bbox[i][b] = new BBox(aux[ind], aux[ind + 1], aux[ind + 2], aux[ind + 3]);
                    ind += 4;
                }
            }
            aux = null;
        }
        return bbox;
    }

    public void loadResources() {
        try {
            Image[] taux = Kernel.instance.loadIndexedImage("/tiles_t");
            Image img = taux[0];
            int n = (img.getWidth() >> 5) * (img.getHeight() >> 5);
            this.aTiles = new Image[taux.length][n];
            for (int t = 0; t < this.aTiles.length; ++t) {
                img = taux[t];
                int i = 0;
                for (int y = 0; y < img.getHeight(); y += 32) {
                    for (int x = 0; x < img.getWidth(); x += 32) {
                        int n2 = i++;
                        Image image = Image.createImage((int)32, (int)32);
                        this.aTiles[t][n2] = image;
                        image.getGraphics().drawImage(img, -x, -y, 0);
                    }
                }
            }
            img = null;
            taux = null;
            this.tiles = this.aTiles[0];
            this.bboxTiles = this.loadBBox("/tiles_t.box");
            this.sprGold = new Sprite(Image.createImage((String)"/gold_t.png"), -8, -8, 4, 0, 2);
            this.sprFuel = new Sprite(Image.createImage((String)"/fuel_t.png"), -1, -1, 3, 0, 2);
            this.sprLife = new Sprite(Image.createImage((String)"/life_t.png"), -6, -4, 3, 0, 2);
            this.imgLava = Image.createImage((String)"/lava_t.png");
            this.imgArrow = Image.createImage((String)"/flecha.png");
            this.imgFinish = Image.createImage((String)"/finish.png");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.old_x = Integer.MAX_VALUE;
        this.old_y = Integer.MAX_VALUE;
    }

    public void freeResources() {
        int j;
        int i;
        if (this.aTiles != null) {
            for (i = 0; i < this.aTiles.length; ++i) {
                if (this.aTiles[i] != null) {
                    for (j = 0; j < this.aTiles[i].length; ++j) {
                        this.aTiles[i][j] = null;
                    }
                }
                this.aTiles[i] = null;
            }
        }
        this.aTiles = null;
        if (this.tiles != null) {
            for (i = 0; i < this.tiles.length; ++i) {
                this.tiles[i] = null;
            }
        }
        this.tiles = null;
        if (this.bboxTiles != null) {
            for (i = 0; i < this.bboxTiles.length; ++i) {
                if (this.bboxTiles[i] != null) {
                    for (j = 0; j < this.bboxTiles[i].length; ++j) {
                        this.bboxTiles[i][j] = null;
                    }
                }
                this.bboxTiles[i] = null;
            }
        }
        this.bboxTiles = null;
        this.sprGold.unload();
        this.sprFuel.unload();
        this.sprLife.unload();
        this.sprLife = null;
        this.sprFuel = null;
        this.sprGold = null;
        this.imgArrow = null;
        this.imgLava = null;
        this.wHeight = 0;
        this.wWidth = 0;
        this.frontBuffer_g = null;
        this.backBuffer_g = null;
        this.frontBuffer = null;
        this.backBuffer = null;
    }

    public void init() {
    }

    public void done() {
    }

    public void setBounds(int width, int height) {
        if (width != this.wWidth || height != this.wHeight) {
            this.wWidth = width;
            this.wWidth2 = this.wWidth >> 1;
            this.wHeight = height;
            this.wHeight2 = this.wHeight >> 1;
            this.frontBuffer = Image.createImage((int)width, (int)height);
            this.frontBuffer_g = this.frontBuffer.getGraphics();
            this.backBuffer = Image.createImage((int)width, (int)height);
            this.backBuffer_g = this.backBuffer.getGraphics();
        }
    }

    public final int scrX(int mapX) {
        return this.ox + mapX;
    }

    public final int scrY(int mapY) {
        return this.oy + mapY;
    }

    public final byte getTile(int x, int y) {
        return this.map[(y >> 5) * this.mapWidth + (x >> 5)];
    }

    public final int getTilePos(int x, int y) {
        return (y >> 5) * this.mapWidth + (x >> 5);
    }

    public final boolean checkHit(short x1, short y1, BBox bbox1, short x2, short y2, BBox bbox2) {
        return x1 + bbox1.x1 <= x2 + bbox2.x2 && y1 + bbox1.y1 <= y2 + bbox2.y2 && x1 + bbox1.x2 >= x2 + bbox2.x1 && y1 + bbox1.y2 >= y2 + bbox2.y1;
    }

    public final boolean checkHit(short x1, short y1, BBox bbox1, short x2, short y2, BBox[] bbox2) {
        for (int i = bbox2.length - 1; i >= 0; --i) {
            if (!this.checkHit(x1, y1, bbox1, x2, y2, bbox2[i])) continue;
            return true;
        }
        return false;
    }

    public int checkHit(short x, short y, BBox bbox) {
        if (this.pinchos.checkHit(x, y, bbox)) {
            return -2;
        }
        int hitTile = this.getTilePos(x + bbox.x1, y + bbox.y1);
        BBox[] bb = this.bboxTiles[this.map[hitTile]];
        if (bb != null && this.checkHit(x, y, bbox, (short)(hitTile % this.mapWidth << 5), (short)(hitTile / this.mapWidth << 5), bb)) {
            return hitTile;
        }
        hitTile = this.getTilePos(x + bbox.x2, y + bbox.y1);
        bb = this.bboxTiles[this.map[hitTile]];
        if (bb != null && this.checkHit(x, y, bbox, (short)(hitTile % this.mapWidth << 5), (short)(hitTile / this.mapWidth << 5), bb)) {
            return hitTile;
        }
        hitTile = this.getTilePos(x + bbox.x1, y + bbox.y2);
        bb = this.bboxTiles[this.map[hitTile]];
        if (bb != null && this.checkHit(x, y, bbox, (short)(hitTile % this.mapWidth << 5), (short)(hitTile / this.mapWidth << 5), bb)) {
            return hitTile;
        }
        hitTile = this.getTilePos(x + bbox.x2, y + bbox.y2);
        bb = this.bboxTiles[this.map[hitTile]];
        if (bb != null && this.checkHit(x, y, bbox, (short)(hitTile % this.mapWidth << 5), (short)(hitTile / this.mapWidth << 5), bb)) {
            return hitTile;
        }
        return -1;
    }

    public boolean load(String tilemap) {
        this.pinchos.num = 0;
        try {
            this.map = null;
            this.map = new byte[1024];
            System.gc();
            InputStream is = this.getClass().getResourceAsStream(tilemap);
            if (is == null) {
                return false;
            }
            this.mapWidth = is.read();
            this.mapPixelWidth = this.mapWidth << 5;
            this.mapHeight = is.read();
            this.mapPixelHeight = this.mapHeight << 5;
            this.vel_lava = (byte)is.read();
            is.read(this.map, 0, this.mapWidth * this.mapHeight);
            is.close();
            is = null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.levelGold = 0;
        this.numGold = 0;
        int i = 0;
        for (int ty = 0; ty < this.mapHeight; ++ty) {
            for (int tx = 0; tx < this.mapWidth; ++tx) {
                switch (this.map[i]) {
                    case 0: 
                    case 3: {
                        int n = i;
                        this.map[n] = (byte)(this.map[n] + (Escape.rand.nextInt() & 0xF) % 3);
                        break;
                    }
                    case 53: {
                        this.levelGold = (short)(this.levelGold + 1);
                        break;
                    }
                    case 50: {
                        this.startX = (short)((tx << 5) + 16);
                        this.startY = (short)((ty << 5) + 16);
                        this.map[i] = 3;
                    }
                }
                ++i;
            }
        }
        this.lavaY = (short)this.mapPixelHeight;
        this.f_lavaY = (short)(this.lavaY * 10);
        this.pal_n = 0;
        this.pal_t = 0;
        this.setViewPoint(this.startX, this.startY, true);
        return true;
    }

    private final void updateRect(Graphics g, int x0, int y0, int w, int h) {
        if (w == 0 || h == 0) {
            return;
        }
        g.setClip(x0, y0, w, h);
        int tx0 = this.x - this.wWidth2 + x0 >> 5;
        int ty0 = this.y - this.wHeight2 + y0 >> 5;
        int tx1 = this.x - this.wWidth2 + x0 + w >> 5;
        int ty1 = this.y - this.wHeight2 + y0 + h >> 5;
        int twidth = tx1 - tx0 + 1;
        int theight = ty1 - ty0 + 1;
        int incmapx = this.mapWidth - twidth;
        int xx0 = this.ox + (tx0 << 5);
        int yy0 = this.oy + (ty0 << 5);
        int i = ty0 * this.mapWidth + tx0;
        int yy = yy0;
        for (int hh = theight; hh != 0; --hh) {
            int xx = xx0;
            for (int ww = twidth; ww != 0; --ww) {
                int tileID;
                if ((tileID = this.map[i++]) >= this.tiles.length) {
                    tileID = 3;
                }
                g.drawImage(this.tiles[tileID], xx, yy, 0);
                xx += 32;
            }
            i += incmapx;
            yy += 32;
        }
    }

    private final void postRender(Graphics g) {
        g.setClip(0, 0, this.wWidth, this.wHeight);
        int tx0 = this.x - this.wWidth2 >> 5;
        int ty0 = this.y - this.wHeight2 >> 5;
        int tx1 = this.x - this.wWidth2 + this.wWidth >> 5;
        int ty1 = this.y - this.wHeight2 + this.wHeight >> 5;
        int twidth = tx1 - tx0 + 1;
        int theight = ty1 - ty0 + 1;
        int incmapx = this.mapWidth - twidth;
        int xx0 = this.ox + (tx0 << 5);
        int yy0 = this.oy + (ty0 << 5);
        int i = ty0 * this.mapWidth + tx0;
        int yy = yy0;
        for (int hh = theight; hh != 0; --hh) {
            int xx = xx0;
            int ww = twidth;
            while (ww != 0) {
                if (this.map[i] > 50) {
                    switch (this.map[i]) {
                        case 51: {
                            g.drawImage(this.imgArrow, xx + 4, yy + 5 - this.t_flecha, 0);
                            break;
                        }
                        case 57: {
                            g.drawImage(this.imgFinish, xx, yy + 8, 0);
                            break;
                        }
                        case 53: {
                            this.sprGold.draw(xx, yy, g);
                            break;
                        }
                        case 52: {
                            this.sprFuel.draw(xx, yy, g);
                            break;
                        }
                        case 54: {
                            this.sprLife.draw(xx, yy, g);
                            break;
                        }
                        case 55: {
                            int px = xx - this.ox;
                            int py = yy - this.oy;
                            if (Escape.game.ship.y > py && Math.abs(py + 16 - Escape.game.ship.y) < 96 && Math.abs(px + 16 - Escape.game.ship.x) < 64) {
                                this.map[i] = 3;
                                this.pinchos.add((short)(px + 11), (short)(py - 4));
                                break;
                            }
                        }
                        case 56: {
                            g.drawImage(this.pinchos.image, xx + 11, yy - 4, 0);
                        }
                    }
                }
                xx += 32;
                --ww;
                ++i;
            }
            i += incmapx;
            yy += 32;
        }
        Escape.game.ship.paint(g);
        this.pinchos.paint(g);
        int lavX = xx0;
        int lavY = this.scrY(this.lavaY - 16);
        if (lavY < Kernel.instance.getHeight()) {
            int f = this.f_lava;
            for (int n = twidth; n >= 0; --n) {
                g.setClip(0, 0, this.wWidth, this.wHeight);
                g.clipRect(lavX, lavY, 32, 32);
                g.drawImage(this.imgLava, lavX, lavY - (f << 5), 0);
                int ly = lavY + 32;
                int f3 = 3 + f << 5;
                for (int lin = Kernel.instance.getHeight() - ly >> 5; lin >= 0; --lin) {
                    g.setClip(0, 0, this.wWidth, this.wHeight);
                    g.clipRect(lavX, ly, 32, 32);
                    g.drawImage(this.imgLava, lavX, ly - f3, 0);
                    ly += 32;
                }
                ++f;
                f %= 3;
                lavX += 32;
            }
        }
    }

    public final void setViewPoint(int x, int y, boolean repaint) {
        this.x = x = Escape.limit(x, this.wWidth2, this.mapPixelWidth - this.wWidth2 - 2);
        this.y = y = Escape.limit(y, this.wHeight2, this.mapPixelHeight - this.wHeight2 - 2);
        this.ox = this.wWidth2 - x;
        this.oy = this.wHeight2 - y;
        int updateH = Math.min(this.scrY(this.lavaY) + 1, this.wHeight);
        if (!repaint) {
            int scroll_w = Math.min(this.wWidth, Math.abs(this.old_x - x));
            int scroll_h = Math.min(updateH, Math.abs(this.old_y - y));
            if (scroll_w == 0 && scroll_h == 0) {
                return;
            }
            int scroll_x = x < this.old_x ? 0 : this.wWidth - scroll_w;
            int scroll_y = y < this.old_y ? 0 : this.wHeight - scroll_h;
            this.backBuffer_g.setClip(0, 0, this.wWidth, updateH);
            this.backBuffer_g.drawImage(this.frontBuffer, this.old_x - x, this.old_y - y, 0);
            this.updateRect(this.backBuffer_g, scroll_x, 0, scroll_w, this.wHeight - scroll_h);
            this.updateRect(this.backBuffer_g, 0, scroll_y, this.wWidth, scroll_h);
        } else {
            this.updateRect(this.backBuffer_g, 0, 0, this.wWidth, updateH);
        }
        Image auxi = this.frontBuffer;
        this.frontBuffer = this.backBuffer;
        this.backBuffer = auxi;
        Graphics auxg = this.frontBuffer_g;
        this.frontBuffer_g = this.backBuffer_g;
        this.backBuffer_g = auxg;
        this.old_x = x;
        this.old_y = y;
    }

    public void repaintBuffer() {
        this.setViewPoint(this.x, this.y, true);
    }

    public final void paint(Graphics g, int x, int y) {
        int updateH = Math.min(this.scrY(this.lavaY) + 1, this.wHeight);
        g.setClip(x, y, this.wWidth, updateH);
        g.drawImage(this.frontBuffer, x, y, 0);
        g.setClip(x, 0, this.wWidth, this.wHeight);
        g.translate(x, y);
        this.postRender(g);
        g.translate(-x, -y);
        this.v_aniLava = (byte)(this.v_aniLava + 1);
        if (this.v_aniLava > 3) {
            this.f_lava = (byte)(this.f_lava + 1);
            this.f_lava = (byte)(this.f_lava % 3);
            this.v_aniLava = 0;
        }
        this.t_flecha = (byte)(this.t_flecha + 1);
        this.t_flecha = (byte)(this.t_flecha % 3);
        this.sprGold.nextFrame();
        this.sprFuel.nextFrame();
        this.sprLife.nextFrame();
        if (this.aTiles.length > 1) {
            byte by = this.pal_t;
            this.pal_t = (byte)(by + 1);
            if (by >= this.pal_ani[this.pal_n + 1]) {
                this.pal_n = (byte)(this.pal_n + 2);
                if (this.pal_n >= this.pal_ani.length) {
                    this.pal_n = 0;
                }
                this.pal_t = 0;
                this.tiles = this.aTiles[this.pal_ani[this.pal_n]];
                this.setViewPoint(this.x, this.y, true);
            }
            this.pal_ani[1] = this.lavaY - Escape.game.ship.y < 128 ? (int)((this.lavaY - Escape.game.ship.y) / 8) : 100;
        }
    }

    public final void doFrame() {
        this.f_lavaY = (short)(this.f_lavaY - this.vel_lava);
        this.lavaY = (short)(this.f_lavaY / 10);
        this.pinchos.doFrame();
    }
}

