/*
 * Decompiled with CFR 0.152.
 */
package com.tqm.fantasydefense.game;

import com.tqm.fantasydefense.GameTemplate;
import com.tqm.fantasydefense.game.Unit;
import javax.microedition.lcdui.Graphics;

public final class Particle
extends Unit {
    public int _life = 0;
    public int _lifeFinal;
    public int _startX;
    public int _startY;
    public int _destX;
    public int _destY;
    public int _delay;
    public boolean _ballistic;

    public Particle(int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        this._startX = n;
        this._startY = n2;
        this._destX = n3;
        this._destY = n4;
        this._type = n6;
        this._ballistic = bl;
        this._lifeFinal = !bl ? n5 : n5 * 3 / 2;
        switch (this._type) {
            case 1: 
            case 2: 
            case 8: 
            case 9: {
                this._width = GameTemplate.arrow.getWidth();
                this._height = GameTemplate.arrow.getHeight();
                return;
            }
            case 3: {
                this._width = GameTemplate.wyvernfx.getWidth();
                this._height = GameTemplate.wyvernfx.getHeight();
                return;
            }
            case 4: {
                this._width = GameTemplate.hydrafx.getWidth();
                this._height = GameTemplate.hydrafx.getHeight();
                return;
            }
            case 5: {
                this._width = GameTemplate.catapultfx.getWidth();
                this._height = GameTemplate.catapultfx.getHeight();
                return;
            }
            case 6: {
                this._width = GameTemplate.ballistafx.getWidth();
                this._height = GameTemplate.ballistafx.getHeight();
                return;
            }
            case 7: {
                this._width = GameTemplate.cannonfx.getWidth();
                this._height = GameTemplate.cannonfx.getHeight();
                return;
            }
            case 14: {
                this._width = GameTemplate.dragonfx1.getWidth();
                this._height = GameTemplate.dragonfx1.getHeight();
            }
        }
    }

    public final void draw(Graphics graphics) {
        if (this._delay > 0) {
            return;
        }
        switch (this._type) {
            case 1: {
                GameTemplate.arrow.setTransform(0);
                GameTemplate.arrow.setPosition(this._x - (this._width >> 1) + GameTemplate.viewX, this._y - (this._height >> 1) + GameTemplate.viewY);
                GameTemplate.arrow.paint(graphics);
                return;
            }
            case 2: {
                GameTemplate.arrow.setTransform(2);
                GameTemplate.arrow.setPosition(this._x - (this._width >> 1) + GameTemplate.viewX, this._y - (this._height >> 1) + GameTemplate.viewY);
                GameTemplate.arrow.paint(graphics);
                return;
            }
            case 8: {
                GameTemplate.arrow.setTransform(3);
                GameTemplate.arrow.setPosition(this._x - (this._width >> 1) + GameTemplate.viewX, this._y - (this._height >> 1) + GameTemplate.viewY);
                GameTemplate.arrow.paint(graphics);
                return;
            }
            case 9: {
                GameTemplate.arrow.setTransform(1);
                GameTemplate.arrow.setPosition(this._x - (this._width >> 1) + GameTemplate.viewX, this._y - (this._height >> 1) + GameTemplate.viewY);
                GameTemplate.arrow.paint(graphics);
                return;
            }
            case 14: {
                if (this._life <= 1) {
                    GameTemplate.dragonfx1.setFrame(0);
                } else {
                    GameTemplate.dragonfx1.setFrame(Math.max((this._life * 6 - 1) / this._lifeFinal - 2, 1));
                }
                GameTemplate.dragonfx1.setPosition(this._x - (this._width >> 1) + GameTemplate.viewX, this._y - (this._height >> 1) + GameTemplate.viewY);
                GameTemplate.dragonfx1.paint(graphics);
                return;
            }
            case 3: {
                GameTemplate.wyvernfx.setFrame((this._life * 3 - 1) / this._lifeFinal);
                GameTemplate.wyvernfx.setPosition(this._x - (this._width >> 1) + GameTemplate.viewX, this._y - (this._height >> 1) + GameTemplate.viewY);
                GameTemplate.wyvernfx.paint(graphics);
                return;
            }
            case 4: {
                GameTemplate.hydrafx.setFrame(Math.max((this._life * 6 - 1) / this._lifeFinal - 4, 0));
                GameTemplate.hydrafx.setPosition(this._x - (this._width >> 1) + GameTemplate.viewX, this._y - (this._height >> 1) + GameTemplate.viewY);
                GameTemplate.hydrafx.paint(graphics);
                return;
            }
            case 5: {
                GameTemplate.catapultfx.setFrame(Math.max((this._life * 12 - 1) / this._lifeFinal - 9, 0));
                GameTemplate.catapultfx.setPosition(this._x - (this._width >> 1) + GameTemplate.viewX, this._y - (this._height >> 1) + GameTemplate.viewY);
                GameTemplate.catapultfx.paint(graphics);
                return;
            }
            case 6: {
                GameTemplate.ballistafx.setFrame(Math.max((this._life * 6 - 1) / this._lifeFinal - 4, 0));
                GameTemplate.ballistafx.setPosition(this._x - (this._width >> 1) + GameTemplate.viewX, this._y - (this._height >> 1) + GameTemplate.viewY);
                GameTemplate.ballistafx.paint(graphics);
                return;
            }
            case 7: {
                GameTemplate.cannonfx.setFrame(Math.max((this._life * 6 - 1) / this._lifeFinal - 4, 0));
                GameTemplate.cannonfx.setPosition(this._x - (this._width >> 1) + GameTemplate.viewX, this._y - (this._height >> 1) + GameTemplate.viewY);
                GameTemplate.cannonfx.paint(graphics);
            }
        }
    }
}

