/*
 * Decompiled with CFR 0.152.
 */
package com.tqm.fantasydefense.game;

import com.tqm.fantasydefense.GameTemplate;

public final class Roads {
    private int[][] roadTileFrames;
    private int[][] tempRoadTileFrames;
    private int[][] roadNodesX;
    private int[][] roadNodesY;
    private int[] roadNodeCount;
    private int roadNum = 1;
    private int maxNodeCount = 100;

    public final int getRoadCount() {
        return this.roadNum;
    }

    private void setTempRoadTile(int i, int j, int value) {
        if (i >= 0 && j >= 0 && i < GameTemplate.levelWidth + 2 && j < GameTemplate.levelHeight + 2) {
            this.tempRoadTileFrames[i][j] = value;
        }
    }

    private void setRawRoadTileAnd(int n, int n2, int n3) {
        if (n >= 0 && n2 >= 0 && n < GameTemplate.levelWidth + 2 && n2 < GameTemplate.levelHeight + 2) {
            if (this.roadTileFrames[n][n2] == -1) {
                this.roadTileFrames[n][n2] = n3;
                return;
            }
            this.roadTileFrames[n][n2] = this.roadTileFrames[n][n2] | n3;
        }
    }

    public final void setRoadTile(int i, int j, int value) {
        if (i >= 0 && j >= 0 && i < GameTemplate.levelWidth + 1 && j < GameTemplate.levelHeight + 1) {
            this.roadTileFrames[i + 1][j + 1] = value;
        }
    }

    public final int getRoadTile(int i, int j) {
        if (i < 0 || j < 0 || i >= GameTemplate.levelWidth || j >= GameTemplate.levelHeight) {
            return -1;
        }
        return this.roadTileFrames[i + 1][j + 1];
    }

    private int getRawRoadTile(int i, int j) {
        if (i < 0 || j < 0 || i >= GameTemplate.levelWidth + 2 || j >= GameTemplate.levelHeight + 2) {
            return -1;
        }
        return this.roadTileFrames[i][j];
    }

    public final void addRoadNode(int n, int n2, int n3) {
        if (n3 > this.roadNum) {
            return;
        }
        int n4 = this.roadNodeCount[n3];
        if (n4 > 0 && n != 0 && n2 != 0) {
            n2 = 0;
        }
        this.roadNodesX[n3][n4] = n;
        this.roadNodesY[n3][n4] = n2;
        if (n4 < this.maxNodeCount - 1) {
            int n5 = n3;
            this.roadNodeCount[n5] = this.roadNodeCount[n5] + 1;
        }
    }

    public final int getRoadNodeCount(int road) {
        return this.roadNodeCount[road];
    }

    public final int getRoadNodeX(int road, int node) {
        return this.roadNodesX[road][node];
    }

    public final int getRoadNodeY(int road, int node) {
        return this.roadNodesY[road][node];
    }

    public final void createRoads() {
        int n;
        int n2;
        int n3;
        for (int i = 0; i < this.roadNum; ++i) {
            n3 = this.getRoadNodeX(i, 0);
            n2 = this.getRoadNodeY(i, 0);
            for (n = 1; n < this.roadNodeCount[i]; ++n) {
                int n4;
                if (this.getRoadNodeX(i, n) != 0) {
                    n4 = n3 + this.getRoadNodeX(i, n);
                    if (n4 > n3) {
                        this.setRawRoadTileAnd(n3, n2, 8);
                        ++n3;
                        while (n3 < n4) {
                            this.setRawRoadTileAnd(n3, n2, 10);
                            ++n3;
                        }
                        continue;
                    }
                    this.setRawRoadTileAnd(n3, n2, 2);
                    --n3;
                    while (n3 > n4) {
                        this.setRawRoadTileAnd(n3, n2, 10);
                        --n3;
                    }
                    continue;
                }
                if (this.getRoadNodeY(i, n) == 0) continue;
                n4 = n2 + this.getRoadNodeY(i, n);
                if (n4 > n2) {
                    this.setRawRoadTileAnd(n3, n2, 1);
                    ++n2;
                    while (n2 < n4) {
                        this.setRawRoadTileAnd(n3, n2, 5);
                        ++n2;
                    }
                    continue;
                }
                this.setRawRoadTileAnd(n3, n2, 4);
                --n2;
                while (n2 > n4) {
                    this.setRawRoadTileAnd(n3, n2, 5);
                    --n2;
                }
            }
        }
        Roads roads = this;
        for (n3 = 1; n3 < GameTemplate.levelWidth + 1; ++n3) {
            for (n2 = 1; n2 < GameTemplate.levelHeight + 1; ++n2) {
                if (roads.getRawRoadTile(n3, n2) < 0) continue;
                n = 0;
                if (roads.getRawRoadTile(n3, n2 + 1) >= 0 && (roads.getRawRoadTile(n3, n2 + 1) & 4) > 0) {
                    n = 1;
                }
                if (roads.getRawRoadTile(n3 - 1, n2) >= 0 && (roads.getRawRoadTile(n3 - 1, n2) & 8) > 0) {
                    n |= 2;
                }
                if (roads.getRawRoadTile(n3, n2 - 1) >= 0 && (roads.getRawRoadTile(n3, n2 - 1) & 1) > 0) {
                    n |= 4;
                }
                if (roads.getRawRoadTile(n3 + 1, n2) >= 0 && (roads.getRawRoadTile(n3 + 1, n2) & 2) > 0) {
                    n |= 8;
                }
                roads.setRawRoadTileAnd(n3, n2, n);
            }
        }
        for (n3 = 1; n3 < GameTemplate.levelWidth + 1; ++n3) {
            block26: for (n2 = 1; n2 < GameTemplate.levelHeight + 1; ++n2) {
                n = roads.getRawRoadTile(n3, n2);
                if (n < 0) continue;
                switch (n) {
                    case 1: {
                        roads.setTempRoadTile(n3, n2, 4);
                        continue block26;
                    }
                    case 2: {
                        roads.setTempRoadTile(n3, n2, 5);
                        continue block26;
                    }
                    case 3: {
                        roads.setTempRoadTile(n3, n2, 0);
                        continue block26;
                    }
                    case 4: {
                        roads.setTempRoadTile(n3, n2, 4);
                        continue block26;
                    }
                    case 5: {
                        roads.setTempRoadTile(n3, n2, 4);
                        continue block26;
                    }
                    case 6: {
                        roads.setTempRoadTile(n3, n2, 2);
                        continue block26;
                    }
                    case 7: {
                        roads.setTempRoadTile(n3, n2, 7);
                        continue block26;
                    }
                    case 9: {
                        roads.setTempRoadTile(n3, n2, 1);
                        continue block26;
                    }
                    case 8: {
                        roads.setTempRoadTile(n3, n2, 5);
                        continue block26;
                    }
                    case 10: {
                        roads.setTempRoadTile(n3, n2, 5);
                        continue block26;
                    }
                    case 11: {
                        roads.setTempRoadTile(n3, n2, 9);
                        continue block26;
                    }
                    case 12: {
                        roads.setTempRoadTile(n3, n2, 3);
                        continue block26;
                    }
                    case 13: {
                        roads.setTempRoadTile(n3, n2, 6);
                        continue block26;
                    }
                    case 14: {
                        roads.setTempRoadTile(n3, n2, 8);
                        continue block26;
                    }
                    case 15: {
                        roads.setTempRoadTile(n3, n2, 10);
                        continue block26;
                    }
                    default: {
                        roads.setTempRoadTile(n3, n2, 10);
                    }
                }
            }
        }
        for (n3 = 0; n3 < GameTemplate.levelWidth + 2; ++n3) {
            for (n2 = 0; n2 < GameTemplate.levelHeight + 2; ++n2) {
                roads.roadTileFrames[n3][n2] = roads.tempRoadTileFrames[n3][n2];
            }
        }
        roads.tempRoadTileFrames = null;
        for (int i = 0; i < this.roadNum; ++i) {
            if (this.getRoadNodeX(i, 0) != GameTemplate.levelWidth + 1 || this.getRoadNodeX(i, 1) >= -1 || this.getRoadNodeY(i, 1) != 0) continue;
            int[] nArray = this.roadNodesX[i];
            nArray[0] = nArray[0] - 1;
            int[] nArray2 = this.roadNodesX[i];
            nArray2[1] = nArray2[1] + 1;
        }
        GameTemplate.portalGroup.initPortals();
    }

    public final void setRoadTables(int n) {
        int n2;
        this.roadNum = n2 = n;
        this.roadTileFrames = null;
        this.roadTileFrames = new int[GameTemplate.levelWidth + 2][GameTemplate.levelHeight + 2];
        for (n = 0; n < GameTemplate.levelWidth + 2; ++n) {
            for (n2 = 0; n2 < GameTemplate.levelHeight + 2; ++n2) {
                this.roadTileFrames[n][n2] = -1;
            }
        }
        this.tempRoadTileFrames = null;
        this.tempRoadTileFrames = new int[GameTemplate.levelWidth + 2][GameTemplate.levelHeight + 2];
        for (n = 0; n < GameTemplate.levelWidth + 2; ++n) {
            for (n2 = 0; n2 < GameTemplate.levelHeight + 2; ++n2) {
                this.tempRoadTileFrames[n][n2] = -1;
            }
        }
        this.roadNodesX = null;
        this.roadNodesY = null;
        this.roadNodeCount = null;
        this.roadNodesX = new int[this.roadNum][this.maxNodeCount];
        this.roadNodesY = new int[this.roadNum][this.maxNodeCount];
        this.roadNodeCount = new int[this.roadNum];
    }
}

