/*
 * Decompiled with CFR 0.152.
 */
package com.tqm.fantasydefense.shop.secret;

import com.tqm.fantasydefense.GameLogic;
import com.tqm.fantasydefense.shop.secret.SecretGems;
import com.tqm.wrapper.WrapperController;

public abstract class AbstractSecretItem {
    private static GameLogic gameLogic;
    private int price;
    private boolean unlocked;
    private boolean active;
    private int statsId;

    public static void setGameLogic(GameLogic gameLogic) {
        AbstractSecretItem.gameLogic = gameLogic;
    }

    public AbstractSecretItem(int price, int statsId) {
        this.price = price;
        this.statsId = statsId;
    }

    protected abstract int getRMSId();

    protected static void saveToRMS(int n, int n2) {
        gameLogic.getGData().save(n2, n);
    }

    protected static int loadFromRMS(int n) {
        return gameLogic.getGData().loadAsInt(n);
    }

    public void saveDefaultToRMS() {
        AbstractSecretItem.saveToRMS(this.getRMSId(), 0);
    }

    protected final void saveUnlockWithActivateToRMS() {
        AbstractSecretItem abstractSecretItem = this;
        AbstractSecretItem.saveToRMS(this.getRMSId(), Integer.parseInt("0" + (abstractSecretItem.active ? 1 : 0) + (abstractSecretItem.unlocked ? 1 : 0), 2));
    }

    public void loadFromRMS() {
        boolean bl;
        AbstractSecretItem abstractSecretItem = this;
        int n = AbstractSecretItem.loadFromRMS(abstractSecretItem.getRMSId());
        abstractSecretItem.active = bl = AbstractSecretItem.isTrueAtIndexByRMSValue(n, 1);
        abstractSecretItem.unlocked = bl = AbstractSecretItem.isTrueAtIndexByRMSValue(n, 0);
    }

    private static boolean isTrueAtIndexByRMSValue(int n, int n2) {
        String string = Integer.toBinaryString(n);
        if (string.length() <= n2) {
            return false;
        }
        return string.charAt(string.length() - 1 - n2) == '1';
    }

    public boolean buy(int n) {
        if (this.unlocked) {
            return true;
        }
        if (SecretGems.isEnoughGems(this.price)) {
            this.reduceGems();
            this.buyWithUnlockAndActivate(n);
            return true;
        }
        WrapperController.logNotEnoughTokens();
        return false;
    }

    protected final void reduceGems() {
        if (!this.unlocked) {
            SecretGems.reduceGems(this.price);
        }
    }

    protected final boolean isEnoughGems() {
        return SecretGems.isEnoughGems(this.price);
    }

    protected final void buyWithUnlockAndActivate(int statsSourceId2) {
        int n = statsSourceId2;
        AbstractSecretItem statsSourceId2 = this;
        WrapperController.logBoughtItem(n, statsSourceId2.statsId);
        this.unlockAndActivateToRMS();
    }

    protected final void unlockAndActivateToRMS() {
        this.active = true;
        this.unlocked = true;
        this.saveUnlockWithActivateToRMS();
    }

    public final int getPrice() {
        return this.price;
    }

    public final void setPrice(int price) {
        this.price = price;
    }

    public final boolean isUnlocked() {
        return this.unlocked;
    }

    protected final void setUnlocked(boolean unlocked) {
        this.unlocked = false;
    }

    public final boolean isActive() {
        return this.active;
    }

    protected final void setActive(boolean active) {
        this.active = false;
    }

    protected final void unlockAndActivate() {
        this.active = true;
        this.unlocked = true;
    }

    public final int getStatsId() {
        return this.statsId;
    }
}

