/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.core;

import baltorogames.graphic2d.CGTexture;
import baltorogames.graphic2d.Graphic2D;
import baltorogames.graphic2d.TextureManager;
import baltorogames.system.FileManager;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

public class CustomFont {
    public static final int STYLE_PLAIN = 0;
    public static final int STYLE_BOLD = 1;
    public static final int STYLE_ITALIC = 2;
    public static final int STYLE_UNDERLINED = 4;
    private int style;
    private int size;
    private int baseline;
    private int height;
    private int width;
    public int alignTopOffset;
    public int alignBottomOffset;
    public int alignVCenterOffset;
    private CGTexture image;
    private int textureSize;
    private int NUM_COLUMNS;
    private int NUM_ROWS;
    private short[] charCodes = null;
    private int[] posXOnBMP = null;
    private int[] posYOnBMP = null;
    private int[] charWidths = null;
    private int fontSpacing = 0;
    char[] characters = new char[8];

    public int getFontHeight() {
        return this.height + this.getFontSpacing();
    }

    public int getFontSpacing() {
        return this.fontSpacing;
    }

    public static CustomFont getFont(String string, String string2) {
        CustomFont customFont = new CustomFont();
        try {
            InputStream inputStream = FileManager.OpenFile(string);
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            customFont.createFontFromStream(dataInputStream, string2);
            dataInputStream.close();
        }
        catch (Exception exception) {
            return null;
        }
        return customFont;
    }

    public static CustomFont getFont(String string, int n) {
        CustomFont customFont = CustomFont.getFont(string, "");
        if (customFont != null) {
            customFont.fontSpacing = n;
        }
        return customFont;
    }

    public static CustomFont getFont(String string, int n, String string2) {
        CustomFont customFont = CustomFont.getFont(string, string2);
        if (customFont != null) {
            customFont.fontSpacing = n;
        }
        return customFont;
    }

    public CustomFont createFontFromStream(DataInputStream dataInputStream, String string) throws IOException {
        String string2 = this.deSerializeString(dataInputStream);
        this.image = string != null && string.length() > 0 ? TextureManager.AddTexture(string) : TextureManager.AddTexture("/" + string2);
        int n = dataInputStream.readInt();
        int n2 = this.image.GetWidth();
        long l = 4096 * n2 / n;
        this.NUM_COLUMNS = this.NUM_ROWS = dataInputStream.readInt();
        this.width = this.height = n2 / this.NUM_ROWS;
        int n3 = this.NUM_COLUMNS * this.NUM_ROWS;
        this.charCodes = new short[n3];
        this.posXOnBMP = new int[n3];
        this.posYOnBMP = new int[n3];
        this.charWidths = new int[n3];
        for (int i = 0; i < n3; ++i) {
            this.charCodes[i] = dataInputStream.readShort();
            this.posXOnBMP[i] = (int)((long)dataInputStream.readInt() * l) / 4096;
            this.posYOnBMP[i] = (int)((long)dataInputStream.readInt() * l) / 4096;
            this.charWidths[i] = (int)((long)dataInputStream.readInt() * l) / 4096;
            if (this.charCodes[i] <= 0) continue;
            System.out.println("Letter,x,y,w: " + this.charCodes[i] + "," + this.posXOnBMP[i] + "," + this.posYOnBMP[i] + "," + this.charWidths[i]);
        }
        return null;
    }

    public int getBaselinePosition() {
        return this.baseline;
    }

    public int getSize() {
        return this.size;
    }

    public int getStyle() {
        return this.style;
    }

    public boolean isBold() {
        return (this.style & 1) != 0;
    }

    public boolean isItalic() {
        return (this.style & 2) != 0;
    }

    public boolean isPlain() {
        return this.style == 0;
    }

    public boolean isUnderlined() {
        return (this.style & 4) != 0;
    }

    public void encodeDynamicStringBuffer(StringBuffer stringBuffer) {
        for (int i = 0; i < stringBuffer.length(); ++i) {
            stringBuffer.setCharAt(i, (char)this.getDecodedCharIndex((short)stringBuffer.charAt(i)));
        }
    }

    public String encodeDynamicString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            stringBuffer.append((char)this.getDecodedCharIndex((short)string.charAt(i)));
        }
        return stringBuffer.toString();
    }

    public String decodeString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            stringBuffer.append((char)this.getCharFromIndex(string.charAt(i)));
        }
        return stringBuffer.toString();
    }

    public int getDecodedCharIndex(short s) {
        for (int i = 0; i < this.charCodes.length; ++i) {
            if (s != this.charCodes[i]) continue;
            return i;
        }
        return -1;
    }

    public short getCharFromIndex(int n) {
        return this.charCodes[n];
    }

    public int getCharOnBMPIndex(char c) {
        return c;
    }

    public int charsWidth(String string, int n, int n2) {
        int n3 = 0;
        for (int i = n; i < n + n2; ++i) {
            char c = (char)this.getCharOnBMPIndex(string.charAt(i));
            n3 += this.charWidth(c);
        }
        return n3;
    }

    public int charsWidth(StringBuffer stringBuffer, int n, int n2) {
        int n3 = 0;
        for (int i = n; i < n + n2; ++i) {
            char c = (char)this.getCharOnBMPIndex(stringBuffer.charAt(i));
            n3 += this.charWidth(c);
        }
        return n3;
    }

    public int charWidth(char c) {
        if (c >= this.charWidths.length) {
            return 0;
        }
        return this.charWidths[c];
    }

    public int stringWidth(String string) {
        return this.charsWidth(string, 0, string.length());
    }

    public void drawChar(char c, int n, int n2, int n3) {
        this.drawCharInternal(c, n, n2, n3);
    }

    public void drawChars(String string, int n, int n2, int n3, int n4, int n5) {
        if ((n5 & 0x10) != 0) {
            n4 += this.alignTopOffset;
        }
        if ((n5 & 0x20) != 0) {
            n4 += this.alignBottomOffset;
        }
        if ((n5 & 2) != 0) {
            n4 += this.alignVCenterOffset;
        }
        if ((n5 & 8) != 0) {
            n3 -= this.charsWidth(string, n, n2);
        } else if ((n5 & 1) != 0) {
            n3 -= this.charsWidth(string, n, n2) / 2;
        }
        for (int i = 0; i < n2; ++i) {
            char c = string.charAt(n + i);
            this.drawCharInternal((char)this.getCharOnBMPIndex(c), n3, n4, 20);
            n3 += this.charWidth((char)this.getCharOnBMPIndex(c));
        }
    }

    public void drawTimeChars(long l, int n, int n2, int n3, int n4) {
        char c;
        int n5 = 0;
        long l2 = l / 1000L;
        long l3 = l2 / 60L;
        long l4 = l2 % 60L;
        long l5 = l % 1000L / 10L;
        this.characters[n5++] = (char)(16L + l3 / 10L);
        this.characters[n5++] = (char)(16L + l3 % 10L);
        this.characters[n5++] = 26;
        this.characters[n5++] = (char)(16L + l4 / 10L);
        this.characters[n5++] = (char)(16L + l4 % 10L);
        this.characters[n5++] = 26;
        this.characters[n5++] = (char)(16L + l5 / 10L);
        this.characters[n5++] = (char)(16L + l5 % 10L);
        int n6 = 0;
        for (c = '\u0000'; c < '\b'; ++c) {
            n6 += this.charWidth((char)this.getCharOnBMPIndex(this.characters[c]));
        }
        if ((n4 & 8) != 0) {
            n2 -= n6;
        } else if ((n4 & 1) != 0) {
            n2 -= n6 / 2;
        }
        for (int i = 0; i < 8; ++i) {
            c = this.characters[i];
            this.drawCharInternal((char)this.getCharOnBMPIndex(c), n2, n3, 20);
            n2 += this.charWidth((char)this.getCharOnBMPIndex(c));
        }
    }

    public void drawSpeedChars(long l, int n, int n2, int n3) {
        if (l < 0L) {
            l = 0L;
        }
        long l2 = l / 100L;
        long l3 = (l - l2 * 100L) / 10L;
        long l4 = l - l2 * 100L - l3 * 10L;
        this.characters[0] = (char)l2;
        this.characters[1] = (char)l3;
        this.characters[2] = (char)l4;
        for (int i = 0; i < 3; ++i) {
            char c = this.characters[i];
            this.drawCharInternal(c, n, n2, 20);
            n += this.charWidth((char)this.getCharOnBMPIndex(c));
        }
    }

    public void drawPointsChars(long l, int n, int n2, int n3) {
        if (l < 0L) {
            l = 0L;
        }
        long l2 = l / 1000L;
        long l3 = (l - l2 * 1000L) / 100L;
        long l4 = (l - l2 * 1000L - l3 * 100L) / 10L;
        long l5 = l - l2 * 1000L - l3 * 100L - l4 * 10L;
        this.characters[0] = (char)l2;
        this.characters[1] = (char)l3;
        this.characters[2] = (char)l4;
        this.characters[3] = (char)l5;
        for (int i = 0; i < 4; ++i) {
            char c = this.characters[i];
            this.drawCharInternal(c, n, n2, 20);
            n += this.charWidth((char)this.getCharOnBMPIndex(c));
        }
    }

    public void drawPosChars(int n, int n2, int n3, int n4) {
        if (n < 0) {
            n = 0;
        }
        int n5 = n / 10;
        int n6 = n - n5 * 10;
        this.characters[0] = (char)n5;
        this.characters[1] = (char)n6;
        if (n5 == 0) {
            char c = this.characters[1];
            this.drawCharInternal(c, n2, n3, 20);
        } else {
            for (int i = 0; i < 2; ++i) {
                char c = this.characters[i];
                this.drawCharInternal(c, n2, n3, 20);
                n2 += this.charWidth((char)this.getCharOnBMPIndex(c));
            }
        }
    }

    public void drawComboChars(long l, int n, int n2, int n3) {
        if (l < 0L) {
            l = 0L;
        }
        long l2 = l / 100L;
        long l3 = (l - l2 * 100L) / 10L;
        long l4 = l - l2 * 100L - l3 * 10L;
        this.characters[0] = (char)l2;
        this.characters[1] = (char)l3;
        this.characters[2] = (char)l4;
        for (int i = 0; i < 3; ++i) {
            char c = this.characters[i];
            if (c <= '\u0000' && i != 2) continue;
            this.drawCharInternal(c, n, n2, 20);
            n += this.charWidth((char)this.getCharOnBMPIndex(c));
        }
    }

    public void drawValue(long l, int n, int n2, int n3) {
        this.drawCharInternal((char)l, n, n2, 20);
    }

    public void drawChars(StringBuffer stringBuffer, int n, int n2, int n3, int n4, int n5) {
        if ((n5 & 8) != 0) {
            n3 -= this.charsWidth(stringBuffer, n, n2);
        } else if ((n5 & 1) != 0) {
            n3 -= this.charsWidth(stringBuffer, n, n2) / 2;
        }
        if ((n5 & 0x20) != 0) {
            n4 -= this.height;
        } else if ((n5 & 2) != 0) {
            n4 -= this.height / 2;
        }
        for (int i = 0; i < n2; ++i) {
            char c = stringBuffer.charAt(n + i);
            this.drawCharInternal((char)this.getCharOnBMPIndex(c), n3, n4, n5);
            n3 += this.charWidth((char)this.getCharOnBMPIndex(c));
        }
    }

    private void drawCharInternal(char c, int n, int n2, int n3) {
        int n4 = Graphic2D.GetClipX();
        int n5 = Graphic2D.GetClipY();
        int n6 = Graphic2D.GetClipWidth();
        int n7 = Graphic2D.GetClipHeight();
        int n8 = c / this.NUM_COLUMNS;
        int n9 = c - n8 * this.NUM_COLUMNS;
        if ((this.style & 2) != 0) {
            Graphic2D.SetClip(n + 1, n2, this.width, this.height / 2);
            Graphic2D.DrawImage(this.image, n - this.width * n9 + 1, n2 - this.height * n8, n3);
            Graphic2D.SetClip(n, n2 + this.height / 2, this.width, this.height / 2);
            Graphic2D.DrawImage(this.image, n - this.width * n9, n2 - this.height * n8, n3);
            if ((this.style & 1) != 0) {
                Graphic2D.SetClip(n, n2, this.width, this.height / 2);
                Graphic2D.DrawImage(this.image, n - this.width * n9 + 2, n2 - this.height * n8, n3);
                Graphic2D.SetClip(n, n2 + this.height / 2, this.width, this.height / 2);
                Graphic2D.DrawImage(this.image, n - this.width * n9 + 1, n2 - this.height * n8, n3);
            }
        } else {
            Graphic2D.SetClip(n, n2, this.width, this.height);
            Graphic2D.ClipRect(n4, n5, n6, n7);
            Graphic2D.DrawImage(this.image, n - this.width * n9, n2 - this.height * n8, n3);
            if ((this.style & 1) != 0) {
                Graphic2D.DrawImage(this.image, n - this.width * c + 1, n2 - this.height * n8, n3);
            }
        }
        if ((this.style & 4) != 0) {
            Graphic2D.DrawLine(n, n2 + this.baseline + 2, n + this.width, n2 + this.baseline + 2);
        }
        Graphic2D.SetClip(n4, n5, n6, n7);
    }

    public void drawString(String string, int n, int n2, int n3) {
        this.drawChars(string, 0, string.length(), n, n2, n3);
    }

    public void drawSpeedString(long l, int n, int n2, int n3) {
        this.drawSpeedChars(l, n, n2, n3);
    }

    public void drawPointsString(long l, int n, int n2, int n3) {
        this.drawPointsChars(l, n, n2, n3);
    }

    public void drawTimeString(long l, int n, int n2, int n3) {
        this.drawTimeChars(l, 0, n, n2, n3);
    }

    public void drawPosString(int n, int n2, int n3, int n4) {
        this.drawPosChars(n, n2, n3, n4);
    }

    public void drawString(StringBuffer stringBuffer, int n, int n2, int n3) {
        this.drawChars(stringBuffer, 0, stringBuffer.length(), n, n2, n3);
    }

    public String deSerializeString(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readInt();
        byte[] byArray = new byte[n];
        dataInputStream.read(byArray, 0, n);
        return new String(byArray);
    }
}

