/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gui;

import baltorogames.core.ApplicationData;
import baltorogames.core_gui.UIScreen;
import baltorogames.project_gameplay.CGEngine;
import baltorogames.project_gameplay.CGUserCareer;
import baltorogames.project_gui.AbortApplicationTB;
import baltorogames.project_gui.AskForGetMoreGames;
import baltorogames.project_gui.EditChampionshipsUserName;
import baltorogames.project_gui.HelpMenu;
import baltorogames.project_gui.MainListAnimated;
import baltorogames.project_gui.NewYesNoDialogScreen;
import baltorogames.project_gui.NotInDemoVersion;
import baltorogames.project_gui.SelectGameMode;
import baltorogames.project_gui.SelectTrack;
import baltorogames.project_gui.ShowTrialExpired;
import baltorogames.project_gui.ShowTrialLimitationsInfo;
import baltorogames.project_gui.UICaptionThick;
import baltorogames.system.ObjectsCache;
import baltorogames.system.Options;

public class MainMenu
extends MainListAnimated {
    boolean isBTAvailable = false;
    private int FREE_TRIAL_ID = -1;
    private int UPSELL_ID = -1;
    private int FREE_RACE_ID = 0;
    private int TOURNAMENT_ID = 1;
    private int OPTIONS_ID = 2;
    private int HELP_ID = 3;
    private int QUIT_ID = 4;
    public final int TUTORIAL_TRACK_INDEX;

    public MainMenu() {
        this.TUTORIAL_TRACK_INDEX = 12;
        if (ApplicationData.demoEnabled) {
            this.append(ApplicationData.lp.getTranslatedString(Options.languageID, "ID_DEMO_VERSION"));
            this.updateIDsForDemo();
        }
        this.append(ApplicationData.lp.getTranslatedString(Options.languageID, ApplicationData.demoEnabled ? "ID_TRIAL_INFO_HEADER" : "TID_FREE_RACE"));
        if (ApplicationData.upSellEnabled) {
            this.append(ApplicationData.lp.getTranslatedString(Options.languageID, "ID_UPSELL_GAME"), true);
            this.updateIDsForUpSell();
        }
        this.append(ApplicationData.lp.getTranslatedString(Options.languageID, "TID_TOURNAMENT"));
        this.append(ApplicationData.lp.getTranslatedString(Options.languageID, "TID_OPTIONS"));
        this.append(ApplicationData.lp.getTranslatedString(Options.languageID, "TID_HELP"));
        this.append(ApplicationData.lp.getTranslatedString(Options.languageID, "TID_QUIT"));
        this.AddArrows();
        this.setSoftButtonImage(ObjectsCache.menuSbOK, ObjectsCache.menuSbOK_a, null, null);
        this.setCaptionThick(new UICaptionThick(ApplicationData.lp.getTranslatedString(Options.languageID, "ID_MAIN_MENU")));
    }

    private void updateIDsForDemo() {
        this.FREE_TRIAL_ID = 0;
        ++this.FREE_RACE_ID;
        ++this.TOURNAMENT_ID;
        ++this.OPTIONS_ID;
        ++this.HELP_ID;
        ++this.QUIT_ID;
    }

    private void updateIDsForUpSell() {
        this.UPSELL_ID = this.FREE_RACE_ID + 1;
        ++this.FREE_RACE_ID;
        ++this.TOURNAMENT_ID;
        ++this.OPTIONS_ID;
        ++this.HELP_ID;
        ++this.QUIT_ID;
    }

    public void currentItemChanged(int n, int n2) {
    }

    public void currentItemSelected(int n) {
        if (n == this.FREE_RACE_ID) {
            CGEngine.selectedGameMode = 1;
            if (!ApplicationData.demoEnabled) {
                CGEngine.selectedTrack = 0;
                UIScreen.SetCurrentScreen(new SelectTrack());
            } else if (!ApplicationData.demoExpired) {
                UIScreen.SetCurrentScreen(new ShowTrialLimitationsInfo());
            } else {
                UIScreen.SetCurrentScreen(new ShowTrialExpired());
            }
        } else if (n == this.TOURNAMENT_ID) {
            if (ApplicationData.demoEnabled) {
                UIScreen.SetCurrentScreen(new NotInDemoVersion(false, 2, false, this));
            } else {
                CGEngine.selectedGameMode = 2;
                if (CGUserCareer.isAnyGameStored()) {
                    UIScreen.SetCurrentScreen(new SelectGameMode());
                } else {
                    EditChampionshipsUserName.playerNick = ApplicationData.lp.getTranslatedString(Options.languageID, "EDIT_PLAYERS_DEFAULT_PLAYER");
                    CGUserCareer.Reset();
                    UIScreen.SetCurrentScreen(new EditChampionshipsUserName());
                }
            }
        } else if (n == this.OPTIONS_ID) {
            UIScreen.SetCurrentScreen(new Options());
        } else if (n == this.HELP_ID) {
            UIScreen.SetCurrentScreen(new HelpMenu());
        } else if (n == this.QUIT_ID) {
            UIScreen.SetCurrentScreen(new AbortApplicationTB());
        } else if (n == this.FREE_TRIAL_ID) {
            UIScreen.SetCurrentScreen(new NewYesNoDialogScreen());
        } else if (n == this.UPSELL_ID) {
            UIScreen.SetCurrentScreen(new AskForGetMoreGames());
        }
    }

    public boolean leftSoftButton() {
        this.currentItemSelected(this.currentItem);
        return true;
    }
}

