/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Image;

class ColumnsJewel
extends NvGridSprite {
    private boolean m_bVanished;
    private boolean m_bDroped;
    public boolean m_bMoving;
    private int m_xStart;
    private int m_yStart;
    private int m_xFinish;
    private int m_yFinish;
    public int m_uiMovingTime;
    private long m_lMovingTick;
    public boolean m_bDead;

    public ColumnsJewel(JewelBlasterCanvas jewelBlasterCanvas, Image image) {
        this.m_pCanvas = jewelBlasterCanvas;
        this.setPosition(0, 0);
        this.setVelocity(0, 0);
        this.setImage(image);
        this.setFrame(0);
        this.setFrameTick(0L);
        this.setFrameDelay(16L);
        this.setVanished(false);
        this.setVisible(false);
        this.setNumCellRows(6);
        this.setNumCellColumns(22);
        this.setCellRow(0);
        this.setCellColumn(0);
        this.setColor(this.m_pCanvas.getRand(this.getNumCellRows()));
        this.setVelocity(this.getWidth(), this.getHeight());
        this.m_bDroped = false;
        this.m_bDead = false;
    }

    public void reset() {
        this.m_lFrameTick = 0L;
        this.setVanished(false);
        this.setVisible(false);
        this.setCellRow(0);
        this.setCellColumn(0);
        this.setColor(this.m_pCanvas.getRand(this.getNumCellRows()));
        this.m_bDroped = false;
        this.m_bMoving = false;
        this.m_uiMovingTime = 1000;
        this.m_bDead = false;
    }

    public boolean isMoving() {
        return this.m_bMoving;
    }

    public void moveTo(int n, int n2) {
        if (this.m_bMoving) {
            return;
        }
        this.m_xStart = this.getX();
        this.m_yStart = this.getY();
        this.m_xFinish = n;
        this.m_yFinish = n2;
        this.m_lFrameTick = 0L;
        this.m_lMovingTick = 0L;
        this.m_bMoving = true;
    }

    public void update(long l) {
        super.update(l);
        if (this.isVanished()) {
            this.m_lFrameTick += l;
            if (this.m_lFrameTick > this.m_lFrameDelay) {
                ++this.m_iCellColumn;
                if (this.m_iCellColumn == this.m_iNumCellColumns) {
                    this.m_iCellColumn = this.m_iNumCellColumns - 1;
                    this.setVisible(false);
                }
                this.m_lFrameTick = 0L;
            }
        } else {
            this.m_lFrameTick += l;
            if (this.m_lFrameTick > 60L) {
                ++this.m_iCellColumn;
                if (this.m_iCellColumn == 15) {
                    this.m_iCellColumn = 0;
                }
                this.m_lFrameTick = 0L;
            }
            if (this.m_bMoving) {
                this.m_lMovingTick += l;
                if (this.m_lMovingTick < (long)this.m_uiMovingTime) {
                    int n = this.m_xFinish - this.m_xStart;
                    int n2 = this.m_yFinish - this.m_yStart;
                    this.setX((int)((long)this.m_xStart + this.m_lMovingTick * (long)n / (long)this.m_uiMovingTime));
                    this.setY((int)((long)this.m_yStart + this.m_lMovingTick * (long)n2 / (long)this.m_uiMovingTime));
                } else {
                    this.setX(this.m_xFinish);
                    this.setY(this.m_yFinish);
                    this.m_iCellColumn = 0;
                    this.m_lMovingTick = 0L;
                    this.m_bMoving = false;
                    return;
                }
            }
        }
    }

    public boolean isVanishedCompleted() {
        return !this.isVisible() && this.isVanished();
    }

    void setVanished(boolean bl) {
        this.m_bVanished = bl;
    }

    public boolean isVanished() {
        return this.m_bVanished;
    }

    void setDroped(boolean bl) {
        this.m_bDroped = bl;
    }

    public boolean isDroped() {
        return this.m_bDroped;
    }

    public void setColor(int n) {
        this.setCellRow(n);
    }

    public int getColor() {
        return this.getCellRow();
    }
}

