/*
 * Decompiled with CFR 0.152.
 */
package com.mobile2win.j2me.sound;

import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.control.VolumeControl;

public class SoundPlayer {
    public boolean soundON = true;
    private Player[] objPlyr;
    public int volumeLevel = 100;

    public SoundPlayer(String[] stringArray, String[] stringArray2) {
        this.initialiseSounds(stringArray, stringArray2);
    }

    private void initialiseSounds(String[] stringArray, String[] stringArray2) {
        this.objPlyr = new Player[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                InputStream inputStream = new Object().getClass().getResourceAsStream(stringArray[i]);
                this.objPlyr[i] = Manager.createPlayer((InputStream)inputStream, (String)stringArray2[i]);
                this.objPlyr[i].realize();
                this.objPlyr[i].prefetch();
                continue;
            }
            catch (Exception exception) {
                System.out.println("Exception:SoundPlayer:SoundPlayer(String[],String[]) : 'index' : " + i + " : " + exception);
            }
        }
        this.setAllVolumes();
    }

    public void setSound(int n, String string, String string2) {
        try {
            InputStream inputStream = new Object().getClass().getResourceAsStream(string);
            this.removeSound(n);
            this.objPlyr[n] = Manager.createPlayer((InputStream)inputStream, (String)string2);
            this.objPlyr[n].realize();
            this.objPlyr[n].prefetch();
        }
        catch (Exception exception) {
            System.out.println("Exception:SoundPlayer:setSound(int,String,String) : 'index' : " + n + " : " + exception);
        }
        this.setVolume(n, this.volumeLevel);
    }

    public void playSound(int n) {
        try {
            if (n >= 0 && n < this.objPlyr.length) {
                if (this.objPlyr[n].getState() != 400 && this.soundON) {
                    this.stopSounds();
                    this.objPlyr[n].start();
                }
            } else {
                System.out.println("Exception:SoundPlayer:playSound(int) : 'index' : " + n + " : " + "Sound Not Found");
            }
        }
        catch (Exception exception) {
            System.out.println("Exception:SoundPlayer:playSound(int) : 'index' : " + n + " : " + exception);
        }
    }

    public void playSound(int n, int n2) {
        try {
            if (n >= 0 && n < this.objPlyr.length) {
                if (this.objPlyr[n].getState() != 400 && this.soundON) {
                    this.objPlyr[n].setLoopCount(n2);
                    this.stopSounds();
                    this.objPlyr[n].start();
                }
            } else {
                System.out.println("Exception:SoundPlayer:playSound(int,int) : 'index' : " + n + " : " + "Sound Not Found");
            }
        }
        catch (Exception exception) {
            System.out.println("Exception:SoundPlayer:playSound(int,int) : 'index' : " + n + " : " + exception);
        }
    }

    public void setAllVolumes() {
        try {
            for (int i = 0; i < this.objPlyr.length; ++i) {
                if (this.objPlyr[i] == null) continue;
                VolumeControl volumeControl = (VolumeControl)this.objPlyr[i].getControl("VolumeControl");
                volumeControl.setLevel(this.volumeLevel);
            }
        }
        catch (Exception exception) {
            System.out.println("Exception:SoundPlayer:setAllVolumes(int) : " + exception);
        }
    }

    public void setVolume(int n, int n2) {
        try {
            if (n >= 0 && n < this.objPlyr.length) {
                VolumeControl volumeControl = (VolumeControl)this.objPlyr[n].getControl("VolumeControl");
                volumeControl.setLevel(n2);
            } else {
                System.out.println("Exception:SoundPlayer:setVolume(int,int) : 'index' : " + n + " : " + "Sound Not Found");
            }
        }
        catch (Exception exception) {
            System.out.println("Exception:SoundPlayer:setVolume(int,int) : " + exception);
        }
    }

    public boolean isPlaying(int n) {
        boolean bl = false;
        try {
            if (n >= 0 && n < this.objPlyr.length) {
                bl = this.objPlyr[n].getState() == 400 && this.soundON;
            } else {
                System.out.println("Exception:SoundPlayer:isPlaying(int) : 'index' : " + n + " : " + "Sound Not Found");
            }
        }
        catch (Exception exception) {
            System.out.println("Exception:SoundPlayer:isPlaying(int) : 'index' : " + n + " : " + exception);
        }
        return bl;
    }

    public void stopSound(int n) {
        try {
            if (n >= 0 && n < this.objPlyr.length) {
                this.objPlyr[n].stop();
            } else {
                System.out.println("Exception:SoundPlayer:stopSound(int) : 'index' : " + n + " : " + "Sound Not Found");
            }
        }
        catch (Exception exception) {
            System.out.println("Exception:SoundPlayer:stopSound(int) : 'index' : " + n + " : " + exception);
        }
    }

    public void stopSounds() {
        try {
            for (int i = 0; i < this.objPlyr.length; ++i) {
                if (this.objPlyr[i] == null) continue;
                this.objPlyr[i].stop();
            }
        }
        catch (Exception exception) {
            System.out.println("Exception:SoundPlayer:stopSounds() : " + exception);
        }
    }

    public void removeSound(int n) {
        try {
            if (n >= 0 && n < this.objPlyr.length) {
                if (this.objPlyr[n] != null) {
                    this.objPlyr[n].stop();
                    this.objPlyr[n].deallocate();
                    this.objPlyr[n].close();
                    this.objPlyr[n] = null;
                }
            } else {
                System.out.println("Exception:SoundPlayer:removeSound(int) : 'index' : " + n + " : " + "Sound Not Found");
            }
        }
        catch (Exception exception) {
            System.out.println("Exception:SoundPlayer:removeSound(int) : 'index' : " + n + " : " + exception);
        }
    }

    public void removeSounds() {
        try {
            for (int i = 0; i < this.objPlyr.length; ++i) {
                if (this.objPlyr[i] == null) continue;
                this.objPlyr[i].stop();
                this.objPlyr[i].deallocate();
                this.objPlyr[i].close();
                this.objPlyr[i] = null;
            }
        }
        catch (Exception exception) {
            System.out.println("Exception:SoundPlayer:removeSounds() : " + exception);
        }
    }
}

