/*
 * Decompiled with CFR 0.152.
 */
package net.sf.zipme;

import net.sf.zipme.DeflaterPending;

class DeflaterHuffman {
    private static final int BUFSIZE = 16384;
    private static final int LITERAL_NUM = 286;
    private static final int DIST_NUM = 30;
    private static final int BITLEN_NUM = 19;
    private static final int REP_3_6 = 16;
    private static final int REP_3_10 = 17;
    private static final int REP_11_138 = 18;
    private static final int EOF_SYMBOL = 256;
    private static final int[] BL_ORDER = new int[]{16, 17, 18, 0, 8, 7, 9, 6, 10, 5, 11, 4, 12, 3, 13, 2, 14, 1, 15};
    private static final String bit4Reverse = "\u0000\b\u0004\f\u0002\n\u0006\u000e\u0001\t\u0005\r\u0003\u000b\u0007\u000f";
    DeflaterPending pending;
    private Tree literalTree;
    private Tree distTree;
    private Tree blTree;
    private short[] d_buf;
    private byte[] l_buf;
    private int last_lit;
    private int extra_bits;
    private static short[] staticLCodes = new short[286];
    private static byte[] staticLLength = new byte[286];
    private static short[] staticDCodes;
    private static byte[] staticDLength;

    static short bitReverse(int value) {
        return (short)(bit4Reverse.charAt(value & 0xF) << 12 | bit4Reverse.charAt(value >> 4 & 0xF) << 8 | bit4Reverse.charAt(value >> 8 & 0xF) << 4 | bit4Reverse.charAt(value >> 12));
    }

    public DeflaterHuffman(DeflaterPending pending) {
        this.pending = pending;
        this.literalTree = new Tree(286, 257, 15);
        this.distTree = new Tree(30, 1, 15);
        this.blTree = new Tree(19, 4, 7);
        this.d_buf = new short[16384];
        this.l_buf = new byte[16384];
    }

    public final void reset() {
        this.last_lit = 0;
        this.extra_bits = 0;
        this.literalTree.reset();
        this.distTree.reset();
        this.blTree.reset();
    }

    private int l_code(int len) {
        if (len == 255) {
            return 285;
        }
        int code = 257;
        while (len >= 8) {
            code += 4;
            len >>= 1;
        }
        return code + len;
    }

    private int d_code(int distance) {
        int code = 0;
        while (distance >= 4) {
            code += 2;
            distance >>= 1;
        }
        return code + distance;
    }

    public void sendAllTrees(int blTreeCodes) {
        this.blTree.buildCodes();
        this.literalTree.buildCodes();
        this.distTree.buildCodes();
        this.pending.writeBits(this.literalTree.numCodes - 257, 5);
        this.pending.writeBits(this.distTree.numCodes - 1, 5);
        this.pending.writeBits(blTreeCodes - 4, 4);
        for (int rank = 0; rank < blTreeCodes; ++rank) {
            this.pending.writeBits(this.blTree.length[BL_ORDER[rank]], 3);
        }
        this.literalTree.writeTree(this.blTree);
        this.distTree.writeTree(this.blTree);
    }

    public void compressBlock() {
        for (int i2 = 0; i2 < this.last_lit; ++i2) {
            int litlen = this.l_buf[i2] & 0xFF;
            int dist = this.d_buf[i2];
            if (dist-- != 0) {
                int lc = this.l_code(litlen);
                this.literalTree.writeSymbol(lc);
                int bits = (lc - 261) / 4;
                if (bits > 0 && bits <= 5) {
                    this.pending.writeBits(litlen & (1 << bits) - 1, bits);
                }
                int dc = this.d_code(dist);
                this.distTree.writeSymbol(dc);
                bits = dc / 2 - 1;
                if (bits <= 0) continue;
                this.pending.writeBits(dist & (1 << bits) - 1, bits);
                continue;
            }
            this.literalTree.writeSymbol(litlen);
        }
        this.literalTree.writeSymbol(256);
    }

    public void flushStoredBlock(byte[] stored, int stored_offset, int stored_len, boolean lastBlock) {
        this.pending.writeBits(0 + (lastBlock ? 1 : 0), 3);
        this.pending.alignToByte();
        this.pending.writeShort(stored_len);
        this.pending.writeShort(~stored_len);
        this.pending.writeBlock(stored, stored_offset, stored_len);
        this.reset();
    }

    public void flushBlock(byte[] stored, int stored_offset, int stored_len, boolean lastBlock) {
        int i2;
        this.literalTree.freqs[256] = (short)(this.literalTree.freqs[256] + 1);
        this.literalTree.buildTree();
        this.distTree.buildTree();
        this.literalTree.calcBLFreq(this.blTree);
        this.distTree.calcBLFreq(this.blTree);
        this.blTree.buildTree();
        int blTreeCodes = 4;
        for (int i3 = 18; i3 > blTreeCodes; --i3) {
            if (this.blTree.length[BL_ORDER[i3]] <= 0) continue;
            blTreeCodes = i3 + 1;
        }
        int opt_len = 14 + blTreeCodes * 3 + this.blTree.getEncodedLength() + this.literalTree.getEncodedLength() + this.distTree.getEncodedLength() + this.extra_bits;
        int static_len = this.extra_bits;
        for (i2 = 0; i2 < 286; ++i2) {
            static_len += this.literalTree.freqs[i2] * staticLLength[i2];
        }
        for (i2 = 0; i2 < 30; ++i2) {
            static_len += this.distTree.freqs[i2] * staticDLength[i2];
        }
        if (opt_len >= static_len) {
            opt_len = static_len;
        }
        if (stored_offset >= 0 && stored_len + 4 < opt_len >> 3) {
            this.flushStoredBlock(stored, stored_offset, stored_len, lastBlock);
        } else if (opt_len == static_len) {
            this.pending.writeBits(2 + (lastBlock ? 1 : 0), 3);
            this.literalTree.setStaticCodes(staticLCodes, staticLLength);
            this.distTree.setStaticCodes(staticDCodes, staticDLength);
            this.compressBlock();
            this.reset();
        } else {
            this.pending.writeBits(4 + (lastBlock ? 1 : 0), 3);
            this.sendAllTrees(blTreeCodes);
            this.compressBlock();
            this.reset();
        }
    }

    public final boolean isFull() {
        return this.last_lit == 16384;
    }

    public final boolean tallyLit(int lit) {
        this.d_buf[this.last_lit] = 0;
        this.l_buf[this.last_lit++] = (byte)lit;
        int n2 = lit;
        this.literalTree.freqs[n2] = (short)(this.literalTree.freqs[n2] + 1);
        return this.last_lit == 16384;
    }

    public final boolean tallyDist(int dist, int len) {
        int dc;
        int lc;
        this.d_buf[this.last_lit] = (short)dist;
        this.l_buf[this.last_lit++] = (byte)(len - 3);
        int n2 = lc = this.l_code(len - 3);
        this.literalTree.freqs[n2] = (short)(this.literalTree.freqs[n2] + 1);
        if (lc >= 265 && lc < 285) {
            this.extra_bits += (lc - 261) / 4;
        }
        int n3 = dc = this.d_code(dist - 1);
        this.distTree.freqs[n3] = (short)(this.distTree.freqs[n3] + 1);
        if (dc >= 4) {
            this.extra_bits += dc / 2 - 1;
        }
        return this.last_lit == 16384;
    }

    static {
        int i2 = 0;
        while (i2 < 144) {
            DeflaterHuffman.staticLCodes[i2] = DeflaterHuffman.bitReverse(48 + i2 << 8);
            DeflaterHuffman.staticLLength[i2++] = 8;
        }
        while (i2 < 256) {
            DeflaterHuffman.staticLCodes[i2] = DeflaterHuffman.bitReverse(256 + i2 << 7);
            DeflaterHuffman.staticLLength[i2++] = 9;
        }
        while (i2 < 280) {
            DeflaterHuffman.staticLCodes[i2] = DeflaterHuffman.bitReverse(-256 + i2 << 9);
            DeflaterHuffman.staticLLength[i2++] = 7;
        }
        while (i2 < 286) {
            DeflaterHuffman.staticLCodes[i2] = DeflaterHuffman.bitReverse(-88 + i2 << 8);
            DeflaterHuffman.staticLLength[i2++] = 8;
        }
        staticDCodes = new short[30];
        staticDLength = new byte[30];
        for (i2 = 0; i2 < 30; ++i2) {
            DeflaterHuffman.staticDCodes[i2] = DeflaterHuffman.bitReverse(i2 << 11);
            DeflaterHuffman.staticDLength[i2] = 5;
        }
    }

    class Tree {
        short[] freqs;
        short[] codes;
        byte[] length;
        int[] bl_counts;
        int minNumCodes;
        int numCodes;
        int maxLength;

        Tree(int elems, int minCodes, int maxLength) {
            this.minNumCodes = minCodes;
            this.maxLength = maxLength;
            this.freqs = new short[elems];
            this.bl_counts = new int[maxLength];
        }

        void reset() {
            for (int i2 = 0; i2 < this.freqs.length; ++i2) {
                this.freqs[i2] = 0;
            }
            this.codes = null;
            this.length = null;
        }

        final void writeSymbol(int code) {
            DeflaterHuffman.this.pending.writeBits(this.codes[code] & 0xFFFF, this.length[code]);
        }

        final void checkEmpty() {
            boolean empty = true;
            for (int i2 = 0; i2 < this.freqs.length; ++i2) {
                if (this.freqs[i2] == 0) continue;
                empty = false;
            }
            if (!empty) {
                throw new Error();
            }
        }

        void setStaticCodes(short[] stCodes, byte[] stLength) {
            this.codes = stCodes;
            this.length = stLength;
        }

        public void buildCodes() {
            int[] nextCode = new int[this.maxLength];
            int code = 0;
            this.codes = new short[this.freqs.length];
            for (int bits = 0; bits < this.maxLength; ++bits) {
                nextCode[bits] = code;
                code += this.bl_counts[bits] << 15 - bits;
            }
            for (int i2 = 0; i2 < this.numCodes; ++i2) {
                byte bits = this.length[i2];
                if (bits <= 0) continue;
                this.codes[i2] = DeflaterHuffman.bitReverse(nextCode[bits - 1]);
                int n2 = bits - 1;
                nextCode[n2] = nextCode[n2] + (1 << 16 - bits);
            }
        }

        private void buildLength(int[] childs) {
            this.length = new byte[this.freqs.length];
            int numNodes = childs.length / 2;
            int numLeafs = (numNodes + 1) / 2;
            int overflow = 0;
            for (int i2 = 0; i2 < this.maxLength; ++i2) {
                this.bl_counts[i2] = 0;
            }
            int[] lengths = new int[numNodes];
            lengths[numNodes - 1] = 0;
            for (int i3 = numNodes - 1; i3 >= 0; --i3) {
                int bitLength;
                if (childs[2 * i3 + 1] != -1) {
                    bitLength = lengths[i3] + 1;
                    if (bitLength > this.maxLength) {
                        bitLength = this.maxLength;
                        ++overflow;
                    }
                    int n2 = bitLength;
                    lengths[childs[2 * i3 + 1]] = n2;
                    lengths[childs[2 * i3]] = n2;
                    continue;
                }
                bitLength = lengths[i3];
                int n3 = bitLength - 1;
                this.bl_counts[n3] = this.bl_counts[n3] + 1;
                this.length[childs[2 * i3]] = (byte)lengths[i3];
            }
            if (overflow == 0) {
                return;
            }
            int incrBitLen = this.maxLength - 1;
            while (true) {
                if (this.bl_counts[--incrBitLen] == 0) {
                    continue;
                }
                do {
                    int n4 = incrBitLen++;
                    this.bl_counts[n4] = this.bl_counts[n4] - 1;
                    int n5 = incrBitLen;
                    this.bl_counts[n5] = this.bl_counts[n5] + 1;
                } while ((overflow -= 1 << this.maxLength - 1 - incrBitLen) > 0 && incrBitLen < this.maxLength - 1);
                if (overflow <= 0) break;
            }
            int n6 = this.maxLength - 1;
            this.bl_counts[n6] = this.bl_counts[n6] + overflow;
            int n7 = this.maxLength - 2;
            this.bl_counts[n7] = this.bl_counts[n7] - overflow;
            int nodePtr = 2 * numLeafs;
            for (int bits = this.maxLength; bits != 0; --bits) {
                int n8 = this.bl_counts[bits - 1];
                while (n8 > 0) {
                    int childPtr;
                    if (childs[(childPtr = 2 * childs[nodePtr++]) + 1] != -1) continue;
                    this.length[childs[childPtr]] = (byte)bits;
                    --n8;
                }
            }
        }

        void buildTree() {
            int numSymbols = this.freqs.length;
            int[] heap = new int[numSymbols];
            int heapLen = 0;
            int maxCode = 0;
            for (int n2 = 0; n2 < numSymbols; ++n2) {
                int ppos;
                short freq = this.freqs[n2];
                if (freq == 0) continue;
                int pos = heapLen++;
                while (pos > 0 && this.freqs[heap[ppos = (pos - 1) / 2]] > freq) {
                    heap[pos] = heap[ppos];
                    pos = ppos;
                }
                heap[pos] = n2;
                maxCode = n2;
            }
            while (heapLen < 2) {
                int node = maxCode < 2 ? ++maxCode : 0;
                heap[heapLen++] = node;
            }
            this.numCodes = Math.max(maxCode + 1, this.minNumCodes);
            int numLeafs = heapLen;
            int[] childs = new int[4 * heapLen - 2];
            int[] values = new int[2 * heapLen - 1];
            int numNodes = numLeafs;
            for (int i2 = 0; i2 < heapLen; ++i2) {
                int node;
                childs[2 * i2] = node = heap[i2];
                childs[2 * i2 + 1] = -1;
                values[i2] = this.freqs[node] << 8;
                heap[i2] = i2;
            }
            do {
                int first = heap[0];
                int last = heap[--heapLen];
                int ppos = 0;
                int path = 1;
                while (path < heapLen) {
                    if (path + 1 < heapLen && values[heap[path]] > values[heap[path + 1]]) {
                        ++path;
                    }
                    heap[ppos] = heap[path];
                    ppos = path;
                    path = path * 2 + 1;
                }
                int lastVal = values[last];
                while ((path = ppos) > 0 && values[heap[ppos = (path - 1) / 2]] > lastVal) {
                    heap[path] = heap[ppos];
                }
                heap[path] = last;
                int second = heap[0];
                last = numNodes++;
                childs[2 * last] = first;
                childs[2 * last + 1] = second;
                int mindepth = Math.min(values[first] & 0xFF, values[second] & 0xFF);
                values[last] = lastVal = values[first] + values[second] - mindepth + 1;
                ppos = 0;
                path = 1;
                while (path < heapLen) {
                    if (path + 1 < heapLen && values[heap[path]] > values[heap[path + 1]]) {
                        ++path;
                    }
                    heap[ppos] = heap[path];
                    ppos = path;
                    path = ppos * 2 + 1;
                }
                while ((path = ppos) > 0 && values[heap[ppos = (path - 1) / 2]] > lastVal) {
                    heap[path] = heap[ppos];
                }
                heap[path] = last;
            } while (heapLen > 1);
            if (heap[0] != childs.length / 2 - 1) {
                throw new RuntimeException("Weird!");
            }
            this.buildLength(childs);
        }

        int getEncodedLength() {
            int len = 0;
            for (int i2 = 0; i2 < this.freqs.length; ++i2) {
                len += this.freqs[i2] * this.length[i2];
            }
            return len;
        }

        void calcBLFreq(Tree blTree) {
            byte curlen = -1;
            int i2 = 0;
            while (i2 < this.numCodes) {
                int min_count;
                int max_count;
                int count = 1;
                byte nextlen = this.length[i2];
                if (nextlen == 0) {
                    max_count = 138;
                    min_count = 3;
                } else {
                    max_count = 6;
                    min_count = 3;
                    if (curlen != nextlen) {
                        byte by = nextlen;
                        blTree.freqs[by] = (short)(blTree.freqs[by] + 1);
                        count = 0;
                    }
                }
                curlen = nextlen;
                ++i2;
                while (i2 < this.numCodes && curlen == this.length[i2]) {
                    ++i2;
                    if (++count < max_count) continue;
                }
                if (count < min_count) {
                    byte by = curlen;
                    blTree.freqs[by] = (short)(blTree.freqs[by] + count);
                    continue;
                }
                if (curlen != 0) {
                    blTree.freqs[16] = (short)(blTree.freqs[16] + 1);
                    continue;
                }
                if (count <= 10) {
                    blTree.freqs[17] = (short)(blTree.freqs[17] + 1);
                    continue;
                }
                blTree.freqs[18] = (short)(blTree.freqs[18] + 1);
            }
        }

        void writeTree(Tree blTree) {
            byte curlen = -1;
            int i2 = 0;
            while (i2 < this.numCodes) {
                int min_count;
                int max_count;
                int count = 1;
                byte nextlen = this.length[i2];
                if (nextlen == 0) {
                    max_count = 138;
                    min_count = 3;
                } else {
                    max_count = 6;
                    min_count = 3;
                    if (curlen != nextlen) {
                        blTree.writeSymbol(nextlen);
                        count = 0;
                    }
                }
                curlen = nextlen;
                ++i2;
                while (i2 < this.numCodes && curlen == this.length[i2]) {
                    ++i2;
                    if (++count < max_count) continue;
                }
                if (count < min_count) {
                    while (count-- > 0) {
                        blTree.writeSymbol(curlen);
                    }
                    continue;
                }
                if (curlen != 0) {
                    blTree.writeSymbol(16);
                    DeflaterHuffman.this.pending.writeBits(count - 3, 2);
                    continue;
                }
                if (count <= 10) {
                    blTree.writeSymbol(17);
                    DeflaterHuffman.this.pending.writeBits(count - 3, 3);
                    continue;
                }
                blTree.writeSymbol(18);
                DeflaterHuffman.this.pending.writeBits(count - 11, 7);
            }
        }
    }
}

