/*
 * Decompiled with CFR 0.152.
 */
package com.anthemgames;

import com.anthemgames.rocky.ui.MainScreen;
import com.anthemgames.sound.SoundPlayer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDlet;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public class Runtime {
    protected static Displayable currentScreen = null;
    public static MIDlet midlet = null;
    protected static SoundPlayer soundPlayer = null;

    public static void setMidlet(MIDlet midlet) {
        Runtime.midlet = midlet;
    }

    public static String getMidletVersion() {
        return midlet.getAppProperty("MIDlet-Version");
    }

    public static void setSoundPlayer(SoundPlayer soundPlayer) {
        Runtime.soundPlayer = soundPlayer;
    }

    public static void playBackgroundSound(String filename, String mimetype) {
        if (soundPlayer != null) {
            soundPlayer.playBackgroundSound(filename, mimetype);
        }
    }

    public static void playSound(String filename, String mimetype) {
        if (soundPlayer != null) {
            soundPlayer.playSound(filename, mimetype);
        }
    }

    public static void stopPlayingSound() {
        if (soundPlayer != null) {
            soundPlayer.stop();
        }
    }

    public static void vibrate() {
    }

    public static Image loadImage(String filename) {
        Image result = null;
        try {
            filename = "/" + filename + (filename.indexOf(".") == -1 ? ".png" : "");
            result = Image.createImage((String)filename);
        }
        catch (IOException error) {
            Runtime.handleError(error);
        }
        return result;
    }

    public static void handleError(Throwable error) {
        System.err.println(error);
        error.printStackTrace();
    }

    public static void exitApp() {
        midlet.notifyDestroyed();
    }

    public static void showScreen(Displayable screen) {
        currentScreen = screen;
        Runtime.showScreen();
    }

    public static void showScreen() {
        if (currentScreen != null) {
            Display.getDisplay((MIDlet)midlet).setCurrent(currentScreen);
        }
    }

    public static String intToPaddedString(int value, int length) {
        StringBuffer buffer = new StringBuffer();
        while (buffer.length() < length) {
            buffer.append("00000");
        }
        buffer.append(String.valueOf(value));
        String result = buffer.toString();
        return result.substring(result.length() - length);
    }

    public static Image extractImage(Image source, int x, int y, int width, int height) {
        Image result = Image.createImage((int)width, (int)height);
        Graphics graphics = result.getGraphics();
        graphics.drawImage(source, 0 - x, 0 - y, 20);
        return result;
    }

    public static Image[] extractFrames(Image source, int framewidth) {
        Image[] result = new Image[source.getWidth() / framewidth];
        for (int index = 0; index < result.length; ++index) {
            result[index] = Runtime.extractFrame(source, framewidth, source.getHeight(), index * framewidth);
        }
        return result;
    }

    public static Image extractFrame(Image source, int width, int height, int offset) {
        Image result = Image.createImage((int)width, (int)height);
        Graphics graphics = result.getGraphics();
        graphics.drawImage(source, 0 - offset, 0, 20);
        return result;
    }

    public static void drawClippedImage(Graphics graphics, Image image, int x, int y, int width, int height, int image_x_offset, int image_y_offset) {
        int cx = graphics.getClipX();
        int cy = graphics.getClipY();
        int cw = graphics.getClipWidth();
        int ch = graphics.getClipHeight();
        graphics.setClip(x, y, width, height);
        graphics.drawImage(image, x - image_x_offset, y - image_y_offset, 20);
        graphics.setClip(cx, cy, cw, ch);
    }

    public static RecordStore openStore(String name, boolean create) {
        RecordStore store = null;
        try {
            store = RecordStore.openRecordStore((String)name, (boolean)create);
        }
        catch (RecordStoreException error) {
            Runtime.handleError(error);
        }
        return store;
    }

    public static void closeStore(RecordStore store) {
        try {
            store.closeRecordStore();
        }
        catch (RecordStoreException error) {
            Runtime.handleError(error);
        }
    }

    public static void deleteStore(String name) {
        try {
            RecordStore.deleteRecordStore((String)name);
        }
        catch (Exception error) {
            Runtime.handleError(error);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void saveData(String storename, byte[] data, boolean recreate) throws IOException {
        if (recreate) {
            Runtime.deleteStore(storename);
        }
        RecordStore store = null;
        try {
            Runtime.checkIfSavable();
            if (!MainScreen.memoryFull) {
                store = Runtime.openStore(storename, true);
                store.addRecord(data, 0, data.length);
            }
            if (MainScreen.memoryFull) return;
        }
        catch (Exception error) {
            try {
                throw new IOException(error.getMessage());
            }
            catch (Throwable throwable) {
                if (MainScreen.memoryFull) throw throwable;
                Runtime.closeStore(store);
                throw throwable;
            }
        }
        Runtime.closeStore(store);
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InputStream loadData(String storename) throws IOException {
        ByteArrayInputStream result = null;
        RecordStore store = Runtime.openStore(storename, false);
        if (store != null) {
            try {
                ByteArrayOutputStream output = new ByteArrayOutputStream();
                RecordEnumeration recordEnumeration = store.enumerateRecords(null, null, false);
                while (recordEnumeration.hasNextElement()) {
                    byte[] record = recordEnumeration.nextRecord();
                    output.write(record, 0, record.length);
                }
                result = new ByteArrayInputStream(output.toByteArray());
            }
            catch (RecordStoreException error) {
                Runtime.handleError(error);
            }
            finally {
                Runtime.closeStore(store);
            }
        }
        return result;
    }

    public static String[] breakUpLines(Font font, String[] lines, int screenwidth, boolean paragraphs) {
        screenwidth -= 10;
        Vector<String> brokenlines = new Vector<String>();
        String current = "";
        String nextword = "";
        for (int index = 0; index < lines.length; ++index) {
            String line = lines[index];
            current = paragraphs ? current : "";
            String string = nextword = paragraphs ? nextword : "";
            if (font.stringWidth(line) < screenwidth && !paragraphs) {
                brokenlines.addElement(line);
            } else {
                while (line.length() > 0) {
                    int offset = line.indexOf(" ");
                    if (offset != -1) {
                        nextword = line.substring(0, offset);
                        line = line.substring(offset + 1);
                    } else {
                        nextword = line;
                        line = "";
                    }
                    if (font.stringWidth(current + " " + nextword) > screenwidth) {
                        brokenlines.addElement(current);
                        current = nextword;
                        nextword = "";
                    } else {
                        current = (current.length() > 0 ? current + " " : "") + nextword;
                    }
                    if (line.length() != 0 || current.length() <= 0 || paragraphs) continue;
                    brokenlines.addElement(current);
                    current = "";
                }
            }
            if (index + 1 != lines.length || current.length() <= 0) continue;
            brokenlines.addElement(current);
        }
        String[] result = new String[brokenlines.size()];
        for (int index = 0; index < result.length; ++index) {
            result[index] = (String)brokenlines.elementAt(index);
        }
        return result;
    }

    public static Image createTextImage(String[] lines, Font font, int bgcolor, int fgcolor) {
        int width = 0;
        int height = 0;
        for (int index = 0; index < lines.length; ++index) {
            height += font.getHeight();
            width = font.stringWidth(lines[index]) > width ? font.stringWidth(lines[index]) : width;
        }
        Image result = Image.createImage((int)width, (int)height);
        Graphics graphics = result.getGraphics();
        int ypos = 0;
        graphics.setColor(bgcolor);
        graphics.fillRect(0, 0, result.getWidth(), result.getHeight());
        graphics.setColor(fgcolor);
        graphics.setFont(font);
        for (int index = 0; index < lines.length; ++index) {
            int xpos = (width - font.stringWidth(lines[index])) / 2;
            graphics.drawString(lines[index], xpos, ypos, 20);
            ypos += font.getHeight();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkIfSavable() {
        String t = "t";
        RecordStore store = null;
        try {
            MainScreen.memoryFull = false;
            store = Runtime.openStore("test", true);
            store.addRecord(t.getBytes(), 0, t.getBytes().length);
        }
        catch (Throwable error) {
            try {
                MainScreen.memoryFull = true;
            }
            catch (Throwable throwable) {
                Runtime.closeStore(store);
                throw throwable;
            }
            Runtime.closeStore(store);
        }
        Runtime.closeStore(store);
    }
}

