/*
 * Decompiled with CFR 0.152.
 */
package com.anthemgames.rocky.ui;

import com.anthemgames.Runtime;
import com.anthemgames.rocky.ui.Arena;
import java.util.Random;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Micky {
    private static final Image UP = Runtime.loadImage("up");
    private static final Image DOWN = Runtime.loadImage("down");
    private Font font = Font.getFont((int)64, (int)0, (int)8);
    private int topline = 0;
    private long lastmsgtime = 0L;
    private boolean showmessage = true;
    private boolean trashtalk = false;
    private String[] quotelines;
    private Arena arena;
    private Image mugshot;
    private int box_top;
    private int text_left;
    private int text_width;
    private boolean firstround;
    private String message = new String("Press Ok");

    public Micky(Arena arena) {
        this(arena, false);
        this.trashtalk = true;
    }

    public Micky(Arena arena, boolean firstround) {
        this.arena = arena;
        this.firstround = firstround;
    }

    public void paint(Graphics graphics) {
        if (this.mugshot == null) {
            this.setupMugshot();
        }
        graphics.setColor(0);
        graphics.fillRect(0, this.box_top, this.arena.getWidth() - 1, this.mugshot.getHeight() + 2);
        graphics.setColor(0xFFFFFF);
        graphics.drawRect(0, this.box_top - 1, this.arena.getWidth() - 1, this.mugshot.getHeight() + 2);
        graphics.drawImage(this.mugshot, 1, this.box_top, 20);
        int y = this.box_top;
        int box_bottom = this.box_top + this.mugshot.getHeight();
        int line = this.topline;
        int boxwidth = this.arena.getWidth() - this.mugshot.getWidth();
        int IncomDLGOffset = 0;
        graphics.setColor(0xFFFFFF);
        graphics.setFont(this.font);
        while (line < this.quotelines.length && y + this.font.getHeight() < box_bottom) {
            graphics.drawString(this.quotelines[line++], this.mugshot.getWidth() + boxwidth / 2, y, 17);
            y += this.font.getHeight();
        }
        if (this.topline > 0) {
            graphics.drawImage(UP, this.arena.getWidth() - 3, this.box_top, 24);
        }
        if (this.font.getHeight() * (this.quotelines.length - this.topline) >= box_bottom - this.box_top) {
            graphics.drawImage(DOWN, this.arena.getWidth() - 3, box_bottom - IncomDLGOffset, 40);
        }
        boxwidth = this.font.stringWidth(this.message) + 10;
        graphics.setColor(0);
        graphics.fillRect((this.arena.getWidth() - boxwidth) / 2, this.arena.getHeight() - this.font.getHeight(), boxwidth, this.font.getHeight());
        if (System.currentTimeMillis() - this.lastmsgtime >= 1000L) {
            this.lastmsgtime = System.currentTimeMillis();
            boolean bl = this.showmessage = !this.showmessage;
        }
        if (this.showmessage) {
            graphics.setColor(0xFFFF00);
            graphics.drawString(this.message, this.arena.getWidth() / 2, this.arena.getHeight() - this.font.getHeight(), 17);
        }
    }

    public void scroll(boolean down) {
        this.topline = down ? (this.font.getHeight() * (this.quotelines.length - this.topline) > this.mugshot.getHeight() ? this.topline + 1 : this.topline) : (this.topline > 0 ? this.topline - 1 : this.topline);
    }

    private void setupMugshot() {
        this.mugshot = Runtime.loadImage("micky");
        this.box_top = (this.arena.getHeight() - this.mugshot.getHeight()) / 2;
        this.text_left = this.mugshot.getWidth();
        this.text_width = this.arena.getWidth() - this.text_left;
        String quote = null;
        if (this.trashtalk) {
            quote = "You coulda been something kid. Better train harder next time.";
        } else if (this.firstround) {
            block0 : switch (this.arena.venue) {
                case 0: {
                    quote = "I ain't got time to teach ya everything, just do what I tell ya and you might learn something!";
                    break;
                }
                case 1: {
                    quote = "Don't think you're going to have an easy go against Melvin here. He's as solid as the Blarney Stone.";
                    break;
                }
                case 2: {
                    switch (this.arena.opponent.getWhich()) {
                        case 0: {
                            quote = "Apollo ain't nothing but fancy footwork and tender touches! Get in there and clobber him!";
                            break block0;
                        }
                        case 1: {
                            quote = "Clubber Lang might look ugly and he might look mean but he's a chump! Go the distance and he'll fold like a napkin!";
                            break block0;
                        }
                        case 2: {
                            quote = "Ivan Drago is a product of the best science in Russia, but the good news is red on the inside too. Make him bleed!";
                        }
                    }
                }
            }
        } else {
            switch (Math.abs(new Random().nextInt() % 10)) {
                case 0: {
                    quote = "You're gonna eat lightning and crap thunder!";
                    break;
                }
                case 1: {
                    quote = "He ain't some bum off the street. Ya gotta fight him!";
                    break;
                }
                case 2: {
                    quote = "You gotta become a very dangerous person!";
                    break;
                }
                case 3: {
                    quote = "What you doing out there? The Waltz?!";
                    break;
                }
                case 4: {
                    quote = "You gotta quit leading with your face!";
                    break;
                }
                case 5: {
                    quote = "He's using your face as a punching bag!";
                    break;
                }
                case 6: {
                    quote = "I thought you were something other than a bum!";
                    break;
                }
                case 7: {
                    quote = "I didn't realize your ma came to fight in your place!";
                    break;
                }
                case 8: {
                    quote = "Fighting's more than a day at the park eating bon bons!";
                    break;
                }
                case 9: {
                    quote = "My aunt Mary's got more fire in her belly than you got, kid!";
                }
            }
        }
        this.quotelines = Runtime.breakUpLines(this.font, new String[]{quote}, this.arena.getWidth() - (this.mugshot.getWidth() + 16), true);
    }
}

