/*
 * Decompiled with CFR 0.152.
 */
package bbs.framework.menu;

import bbs.framework.helper.BBSKeys;
import bbs.framework.models.BBSGame;
import bbs.framework.models.BBSLoader;
import javax.microedition.lcdui.Graphics;

public abstract class BBSGaugeLoader
extends BBSLoader {
    private int cr;
    private int cg;
    private int cb;
    private int timer;
    private int temp1;
    private int temp2;
    private String[] values = new String[]{"100", "80", "60", "40", "20", "0"};
    public static final int temperature = 1;
    public static final int spinner = 2;

    public BBSGaugeLoader(BBSGame game, int effect) {
        super(game, effect);
    }

    public void initialize(BBSGame game) {
        this.cr = 255;
        this.cg = 0;
        this.cb = 0;
    }

    public void setColor(int r, int g, int b) {
        this.cr = r;
        this.cg = g;
        this.cb = b;
    }

    public void doAnimation(BBSGame game, int time) {
    }

    public void drawScreen(BBSGame game, Graphics g, int stage) {
        int perc = 100 - 100 * this.percentage / Math.max(1, this.maxValue);
        this.timer = (int)(game.currentTimeMillis % Integer.MAX_VALUE) / 3;
        g.setColor(0, 0, 0);
        g.fillRect(0, 0, game.w, game.h);
        switch (this.loadEffect) {
            case 1: {
                int cnt;
                int size = game.h / 5;
                for (cnt = 12; cnt >= 2; cnt -= 2) {
                    if (cnt == 12) {
                        g.setColor(200, 200, 200);
                    } else if (cnt == 10) {
                        g.setColor(0, 0, 0);
                    } else if (cnt == 8) {
                        g.setColor(60, 60, 60);
                    } else {
                        g.setColor(255 - 5 * perc / 2, 255 - cnt * 36, 255 - cnt * 36);
                    }
                    g.fillArc(game.w / 2 - cnt * size / 16, 3 * game.h / 4 - cnt * size / 16, cnt * size / 8, cnt * size / 8, 45, 720);
                    if (cnt >= 8) {
                        g.fillRoundRect(game.w / 2 - cnt * size / 32, game.h / 4 - cnt, cnt * size / 16, game.h / 2 + 2 * cnt, cnt * size / 32, cnt * size / 32);
                        continue;
                    }
                    g.fillRoundRect(game.w / 2 - cnt * size / 32, game.h / 4 - cnt + game.h / 2 * perc / 100, cnt * size / 16, game.h / 2 + 2 * cnt - game.h / 2 * perc / 100, cnt * size / 32, cnt * size / 32);
                }
                for (cnt = 0; cnt <= 100; cnt += 20) {
                    game.drawText(g, game.w / 2 + size / 2, game.h / 4 + game.h * cnt / 350, this.values[cnt / 20], null, this.fontNo1, 0);
                }
                if (perc > 0) {
                    game.drawText(g, game.w / 2, game.h - 20, "Now Loading...", null, this.fontNo2, 1);
                    break;
                }
                game.drawText(g, game.w / 2, game.h - 20, "READY", null, this.fontNo1, 1);
                break;
            }
            case 2: {
                this.temp1 = game.w / 2;
                this.temp2 = game.h / 2;
                for (int cnt = 40; cnt >= 10; cnt -= 10) {
                    g.setColor(this.cr * cnt / 40, this.cg * cnt / 40, this.cb * cnt / 40);
                    g.fillArc(this.temp1 - cnt, this.temp2 - cnt, cnt * 2, cnt * 2, (this.timer + cnt * 9) % 360, 270);
                    g.setColor(0, 0, 0);
                    g.fillArc(this.temp1 - cnt + 5, this.temp2 - cnt + 5, cnt * 2 - 10, cnt * 2 - 10, 0, 360);
                }
                if (perc > 0) {
                    game.drawText(g, game.w / 2, game.h / 2 - 15, "Loading", null, this.fontNo1, 1);
                    game.drawText(g, game.w / 2, game.h / 2 + 5, this.percStr, null, this.fontNo1, 1);
                    break;
                }
                game.drawText(g, game.w / 2, game.h / 2 - 15, "READY", null, this.fontNo1, 1);
            }
        }
    }

    public void keyPress(BBSGame game, BBSKeys kcol, int time) {
        if ((kcol.fire || kcol.dblfire) && game.gameState == 4) {
            this.freeResources(game);
        }
    }

    public void loaderClosed(BBSGame game) {
        super.freeResources(game);
    }
}

