/*
 * Decompiled with CFR 0.152.
 */
package bbs.framework.menu;

import bbs.framework.helper.BBSKeys;
import bbs.framework.interfaces.BBSIStory;
import bbs.framework.models.BBSGame;
import bbs.framework.models.BBSStory;
import javax.microedition.lcdui.Graphics;

public abstract class BBSSlideStory
extends BBSStory
implements BBSIStory {
    private String[] photoSet;
    protected int frame = 1;

    public BBSSlideStory(BBSGame game) {
        super(game);
    }

    public void doAnimation(BBSGame game, int time) {
        if (this.photoSet == null) {
            this.photoSet = this.getPhotoSet(game);
        }
    }

    public void drawScreen(BBSGame game, Graphics g) {
        g.setColor(0, 0, 0);
        g.fillRect(0, 0, game.w, game.h);
        g.drawImage(game.loadImage(this.photoSet[this.frame - 1]), game.w / 2, game.h / 2, 3);
    }

    public void keyPress(BBSGame game, BBSKeys kcol, int time) {
        if (kcol.fire || kcol.dblfire) {
            if (this.frame < this.photoSet.length) {
                ++this.frame;
            } else {
                this.freeResources(game);
            }
        }
    }

    protected void freeResources(BBSGame game) {
        game.gameState = 3;
        this.storyClosed(game);
    }

    protected abstract String[] getPhotoSet(BBSGame var1);
}

