/*
 * Decompiled with CFR 0.152.
 */
public class GameObject {
    public static int smIdStack;
    public int mElasticity;
    public byte mCollisionType;
    public int mUniqueId;
    public byte mType;
    public int mPosX;
    public int mPosY;
    public int mOldPosX;
    public int mOldPosY;
    public int mRadius;
    public int mWidth;
    public int mHeight;
    public int mLifeTimer;
    public byte mLinkedMover;
    public byte mLinkedSwitch;
    public int mStartPosX;
    public int mStartPosY;
    public int mTypeData;
    public static int smBoundingBoxX;
    public static int smBoundingBoxY;
    public static int smBoundingBoxW;
    public static int smBoundingBoxH;
    public int mBitmask;

    public GameObject() {
        this.reset();
    }

    public void reset() {
        this.mBitmask = 0;
        this.setBoolean(1, false);
        this.mPosX = 0;
        this.mPosY = 0;
    }

    public void setProperties(byte by, int n, int n2) {
        this.reset();
        this.mUniqueId = smIdStack++;
        this.mBitmask = 0;
        this.mType = by;
        this.mPosX = n << 8;
        this.mPosY = n2 << 8;
        this.mOldPosX = this.mPosX;
        this.mOldPosY = this.mPosY;
        this.mStartPosX = n;
        this.mStartPosY = n2;
        this.mLifeTimer = 0;
        this.mRadius = 5;
        this.mElasticity = 256;
        this.mCollisionType = 0;
        this.mTypeData = 0;
        this.mLinkedMover = 0;
        this.mLinkedSwitch = 0;
        this.setBoolean(1, true);
    }

    public final void update(int n) {
        this.mOldPosX = this.mPosX;
        this.mOldPosY = this.mPosY;
        if (this.mLinkedMover != 0) {
            GameEngine.updateGameObjectLinkedToMover(this);
        }
        switch (this.mType) {
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: {
                if (this.mTypeData != 0 && this.mLifeTimer >= this.mTypeData) {
                    this.setBoolean(8, false);
                    this.mTypeData = 0;
                }
                if (!this.getBoolean(2048) || this.mLifeTimer < 867) break;
                this.setBoolean(2048, false);
                this.setBoolean(8, false);
                break;
            }
            case 66: {
                GameEngine.updateShark(this);
                break;
            }
            case 67: {
                GameEngine.updateHippo(this);
                break;
            }
            case 65: {
                GameEngine.updateGorilla(this);
                break;
            }
            case 1: {
                if (!this.getBoolean(16) || !this.getBoolean(32)) break;
                this.mTypeData += n;
                this.mPosY += 20 * n;
                this.mOldPosY = this.mPosY;
                if (GameEngine.smPlayerState == 1 && GameEngine.smPlayerCirclingCenter.mUniqueId == this.mUniqueId) {
                    this.mTypeData = 1800;
                    break;
                }
                if (this.mTypeData <= 6800) break;
                this.mPosX = this.mStartPosX << 8;
                this.mPosY = this.mStartPosY << 8;
                this.mTypeData = 0;
                this.setBoolean(8, false);
                this.setBoolean(32, false);
                break;
            }
            case 32: 
            case 33: 
            case 34: {
                if (!this.getBoolean(8) || this.mLifeTimer <= 15000) break;
                ParticleSystem.startSwitchFx(this, 0, 0);
                this.setBoolean(8, false);
                break;
            }
            case 69: {
                this.mPosY += 40;
                int n2 = this.mPosX + (this.mPosX - this.mStartPosX);
                int n3 = this.mPosY + (this.mPosY - this.mStartPosY);
                this.mStartPosX = this.mPosX;
                this.mStartPosY = this.mPosY;
                this.mPosX = n2;
                this.mPosY = n3;
                int n4 = this.mPosY - this.mStartPosY;
                if (n4 > 800) {
                    this.mStartPosY = this.mPosY - 800;
                }
                if (this.mPosY <= GameEngine.smLevelHeight + 50 << 8) break;
                this.setBoolean(1, false);
            }
        }
        this.mLifeTimer += n;
    }

    public final void setBoolean(int n, boolean bl) {
        this.mBitmask = bl ? (this.mBitmask |= n) : (this.mBitmask &= ~n);
    }

    public final boolean getBoolean(int n) {
        return (this.mBitmask & n) != 0;
    }

    public void getBoundingBox() {
        if (this.mCollisionType == 1 || this.mCollisionType == 3 || this.mCollisionType == 4) {
            smBoundingBoxX = (this.mPosX >> 8) - this.mRadius;
            smBoundingBoxY = (this.mPosY >> 8) - this.mRadius;
            smBoundingBoxW = this.mRadius << 1;
            smBoundingBoxH = this.mRadius << 1;
        } else if (this.mCollisionType == 2) {
            int n = this.mPosX >> 8;
            int n2 = this.mPosY >> 8;
            int n3 = this.mWidth >> 8;
            int n4 = this.mHeight >> 8;
            smBoundingBoxX = Math.min(n, n3);
            smBoundingBoxY = Math.min(n2, n4);
            smBoundingBoxW = Math.max(n, n3) - smBoundingBoxX;
            smBoundingBoxH = Math.max(n2, n4) - smBoundingBoxY;
        } else {
            smBoundingBoxX = this.mPosX >> 8;
            smBoundingBoxY = this.mPosY >> 8;
            smBoundingBoxW = this.mWidth;
            smBoundingBoxH = this.mHeight;
        }
    }

    public int getRotatingPointX() {
        if (this.getBoolean(64)) {
            SpriteObject spriteObject = VisualEngine.smSwitch;
            if (GameEngine.smPlayerCirclingCenter.getBoolean(512)) {
                spriteObject = VisualEngine.smSwitchToggle;
            }
            int n = this.getBoolean(256) ? 1 : 0;
            return this.mPosX + (Util.getCollisionBoxValue(spriteObject, n, 1) << 8);
        }
        return this.mPosX;
    }

    public int getRotatingPointY() {
        if (this.getBoolean(64)) {
            SpriteObject spriteObject = VisualEngine.smSwitch;
            if (GameEngine.smPlayerCirclingCenter.getBoolean(512)) {
                spriteObject = VisualEngine.smSwitchToggle;
            }
            int n = this.getBoolean(256) ? 1 : 0;
            return this.mPosY + (Util.getCollisionBoxValue(spriteObject, n, 2) << 8);
        }
        return this.mPosY;
    }

    public void switchToggled() {
        this.setBoolean(8, !this.getBoolean(8));
    }
}

