/*
 * Decompiled with CFR 0.152.
 */
package bbs.framework.menu;

import bbs.framework.helper.BBSFunctions;
import bbs.framework.helper.BBSKeys;
import bbs.framework.interfaces.BBSIStory;
import bbs.framework.models.BBSGame;
import bbs.framework.models.BBSStory;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public abstract class BBSSlideStory
extends BBSStory
implements BBSIStory {
    private String[] photoSet;
    protected int frame = 1;
    protected Image temp;

    public BBSSlideStory(BBSGame game) {
        super(game);
    }

    public void doAnimation(BBSGame game, int time) {
        if (this.photoSet == null) {
            this.photoSet = this.getPhotoSet(game);
        }
        if (this.temp == null && this.photoSet.length > 0) {
            this.loadFrame();
        }
    }

    public void drawScreen(BBSGame game, Graphics g) {
        g.setColor(0, 0, 0);
        g.fillRect(0, 0, game.w, game.h);
        if (this.temp != null) {
            g.drawImage(this.temp, game.w / 2, game.h / 2, 3);
        }
    }

    private void loadFrame() {
        this.temp = BBSFunctions.loadImage(this.photoSet[this.frame - 1]);
    }

    public void keyPress(BBSGame game, BBSKeys kcol, int time) {
        if ((kcol.fire || kcol.lfire) && this.photoSet != null) {
            if (this.frame < this.photoSet.length) {
                ++this.frame;
                this.loadFrame();
            } else {
                this.freeResources(game);
            }
        }
    }

    protected void freeResources(BBSGame game) {
        this.temp = null;
        System.gc();
        game.gameState = 3;
        this.storyClosed(game);
    }

    protected abstract String[] getPhotoSet(BBSGame var1);
}

