/*
 * Decompiled with CFR 0.152.
 */
package game.smarts;

import bbs.framework.game.BBSSmartGame;
import bbs.framework.helper.BBSFunctions;
import bbs.framework.helper.BBSKeys;
import bbs.framework.library.BBSSprite;
import bbs.framework.models.BBSGame;
import bbs.framework.models.BBSSmartSprite;
import game.CrazyPiratesGame;
import game.smarts.ThrowCannonBall;
import game.smarts.ThrowSmartPirate;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public class Player
extends BBSSmartSprite {
    private long timeBombSound = 0L;
    public Vector throwCannonBallList;
    public Vector throwSmartPirateList;
    public int[][] havePwrCnt = null;
    public int cannonBallNxt = 0;
    public int smartPirateNxt = 0;
    private byte shipPwr = 0;
    private byte flagPwr = 0;
    private byte purplePiratePwr = 0;
    private byte cannonCarriagePwr = 0;
    private byte cannonPwr = 0;
    private final byte fsStand;
    public final byte fsRunning = (byte)2;
    private final byte fsFillinCannon = (byte)4;
    private final byte fsJump = (byte)2;
    private final byte fsThrow = (byte)2;
    private final byte fsFillRotate = (byte)2;
    public final byte fsEmptyRotate = (byte)3;
    public final byte fsAnimFill = (byte)4;
    public final byte fsThrowTheTarget = (byte)5;
    public final byte fsKaboom;
    public final byte fsPow = (byte)2;
    public final byte fsUgh = (byte)3;
    public final byte fsWow = (byte)4;
    public final byte fsClash = (byte)5;
    public final byte fsBonk = (byte)6;
    public final byte fsCrash = (byte)7;
    public final byte fsKrunch = (byte)8;
    public final byte fsSplash = (byte)9;
    public byte animCounterTextEffect = 0;
    public byte animCounterPurplePirate = 0;
    public byte animCounterCannon = 0;
    private byte animCounterCannonRotate = 0;
    public byte animCannonRotate = 0;
    public byte cannonDirect = 1;
    public boolean fillinBall = false;
    public boolean inTheAir = false;
    public boolean animation = false;
    private boolean animationTileStart = true;
    private boolean cannonBallThrow = false;
    public int vX = 0;
    public int vY = 0;
    public int cannonBallSpeed = 12;
    int angle = 0;
    int posX = 0;
    int posY = 0;
    public int redXBombCount = 3;
    public boolean inTheAirClick = false;
    public int[] cannonDegrees = new int[]{0, 5, 12, 18, 24, 34, 45, 54, 62, 76, 84, 90};
    BBSSmartSprite enemy = null;
    BBSSmartSprite speedBar = null;
    BBSSmartSprite rudder = null;
    private int first = 0;
    private int waveLength = 0;
    private int waves;
    private boolean wavesActive = true;
    private int rx = 0;
    private int ry = 0;
    private boolean throwSS = false;
    public int score = 0;
    private int previousCannonState = 1;
    public int animTextY = 0;
    private long waitTime = 0L;
    private char[] scoreS = new char[6];

    public Player(BBSGame game, BBSSprite[] sprite, int x, int y, int[][] havePowerCnt, BBSSmartSprite enemy, BBSSmartSprite speed, BBSSmartSprite rudder, int sType, int oid) {
        super(sprite, sType, oid);
        this.fsStand = 1;
        this.fsKaboom = 1;
        this.zorder = 1;
        this.x = x;
        this.y = y;
        this.enemy = enemy;
        this.speedBar = speed;
        this.rudder = rudder;
        this.throwCannonBallList = new Vector();
        this.throwSmartPirateList = new Vector();
        this.havePwrCnt = new int[5][5];
        this.havePwrCnt[0][3] = this.shipPwr;
        this.rSprite[0].addFrameSet(new int[]{0, 0, 0, 0, 0}, 270, true);
        this.rSprite[0].doAnimation(1, 0, 0, false);
        this.havePwrCnt[1][3] = this.flagPwr;
        this.rSprite[1].addFrameSet(new int[]{0, 1}, 450, true);
        this.rSprite[1].setFrameSet(1, 0);
        this.havePwrCnt[2][3] = this.purplePiratePwr;
        this.rSprite[2].addFrameSet(new int[]{10}, 0, false);
        this.rSprite[2].addFrameSet(new int[]{0, 1, 2, 3, 4, 5, 0, 1, 2, 3, 4, 5}, 90, false);
        this.rSprite[2].addFrameSet(new int[]{6, 7, 8, 9}, 180, false);
        this.rSprite[2].addFrameSet(new int[]{11, 11, 11, 11, 12, 12, 12, 12, 13, 13, 14, 15, 15, 16, 17, 17}, 180, true);
        this.rSprite[2].doAnimation(4, 0, 0, false);
        this.havePwrCnt[3][3] = this.cannonPwr;
        this.rSprite[3].addFrameSet(new int[]{0}, 180, false);
        this.rSprite[3].addFrameSet(new int[]{2, 1, 2, 3, 3, 0}, 120, false);
        this.rSprite[3].addFrameSet(new int[]{4}, 120, false);
        this.rSprite[3].addFrameSet(new int[]{6, 5, 6, 7, 7, 4}, 120, false);
        this.rSprite[3].addFrameSet(new int[]{8}, 180, false);
        this.rSprite[3].addFrameSet(new int[]{10, 9, 10, 11, 11, 8}, 120, false);
        this.rSprite[3].addFrameSet(new int[]{12}, 180, false);
        this.rSprite[3].addFrameSet(new int[]{14, 13, 14, 15, 15, 12}, 120, false);
        this.rSprite[3].addFrameSet(new int[]{16}, 120, false);
        this.rSprite[3].addFrameSet(new int[]{18, 17, 18, 19, 19, 16}, 120, false);
        this.rSprite[3].addFrameSet(new int[]{20}, 180, false);
        this.rSprite[3].addFrameSet(new int[]{22, 21, 22, 23, 23, 20}, 120, false);
        this.rSprite[3].addFrameSet(new int[]{24}, 180, false);
        this.rSprite[3].addFrameSet(new int[]{26, 25, 26, 27, 27, 24}, 120, false);
        this.rSprite[3].addFrameSet(new int[]{28}, 180, false);
        this.rSprite[3].addFrameSet(new int[]{30, 29, 30, 31, 31, 28}, 120, false);
        this.rSprite[3].addFrameSet(new int[]{32}, 180, false);
        this.rSprite[3].addFrameSet(new int[]{34, 33, 34, 35, 35, 32}, 120, false);
        this.rSprite[3].addFrameSet(new int[]{36}, 180, false);
        this.rSprite[3].addFrameSet(new int[]{38, 37, 38, 39, 39, 36}, 120, false);
        this.rSprite[3].addFrameSet(new int[]{40}, 180, false);
        this.rSprite[3].addFrameSet(new int[]{42, 41, 42, 43, 43, 40}, 120, false);
        this.rSprite[3].addFrameSet(new int[]{44}, 180, false);
        this.rSprite[3].addFrameSet(new int[]{46, 45, 46, 47, 47, 44}, 120, false);
        this.rSprite[3].addFrameSet(new int[]{48}, 180, false);
        this.rSprite[3].addFrameSet(new int[]{49, 50}, 120, false);
        this.rSprite[3].addFrameSet(new int[]{52}, 180, false);
        this.rSprite[3].addFrameSet(new int[]{53, 54}, 120, false);
        this.rSprite[3].addFrameSet(new int[]{56}, 180, false);
        this.rSprite[3].addFrameSet(new int[]{57, 58}, 270, true);
        this.rSprite[3].doAnimation(1, 0, 0, false);
        this.rSprite[3].setFrameSet(29, 1);
        this.havePwrCnt[4][3] = this.cannonCarriagePwr;
        this.rSprite[4].addFrameSet(new int[]{68}, 300, true);
        this.rSprite[4].doAnimation(1, 0, 0, false);
        this.rSprite[5].addFrameSet(new int[]{0, 1, 2, 1, 0}, 90, false);
        this.rSprite[5].addFrameSet(new int[]{3, 3, 3, 3, 3, 3}, 270, false);
        this.rSprite[5].addFrameSet(new int[]{4, 4, 4, 4, 4, 4}, 270, false);
        this.rSprite[5].addFrameSet(new int[]{5, 5, 5, 5, 5, 5}, 270, false);
        this.rSprite[5].addFrameSet(new int[]{6, 6, 6, 6, 6, 6}, 270, false);
        this.rSprite[5].addFrameSet(new int[]{7, 7, 7}, 270, false);
        this.rSprite[5].addFrameSet(new int[]{8, 8, 8, 8, 8, 8, 8}, 270, false);
        this.rSprite[5].addFrameSet(new int[]{9, 9, 9, 9, 9, 9, 9}, 360, false);
        this.rSprite[5].addFrameSet(new int[]{10, 10, 10, 10, 10, 10}, 90, true);
        this.rSprite[5].doAnimation(1, 0, 0, false);
        this.rSprite[5].x = 0;
        this.rSprite[5].y = 0;
        this.rSprite[5].visible = false;
        if (game.stage > 6) {
            this.rSprite[6].addFrameSet(new int[]{0, 1}, 450, true);
            this.rSprite[6].setFrameSet(1, 0);
            this.rSprite[7].addFrameSet(new int[]{1, 0}, 450, true);
            this.rSprite[7].setFrameSet(1, 0);
        } else {
            this.wavesActive = false;
            this.rSprite[6].addFrameSet(new int[]{0}, 450, true);
            this.rSprite[6].setFrameSet(1, 0);
        }
        this.animCounterPurplePirate = Byte.parseByte(String.valueOf(this.rSprite[2].setFrameSet(4, 0)));
    }

    public static BBSSmartSprite create(BBSGame game, int x, int y, BBSSmartSprite enemy, BBSSmartSprite speed, BBSSmartSprite rudder, String waves, int sType, int oid) {
        BBSSprite[] sprites = null;
        sprites = game.stage > 6 ? new BBSSprite[8] : new BBSSprite[7];
        int[][] havePowerCnt = new int[5][5];
        sprites[0] = new BBSSprite(game, "sprites/shipMain.sif", 30, 100, 0, x, y, 0);
        sprites[0].x = x;
        sprites[0].y = game.tileSet.fullH;
        havePowerCnt[0][0] = x;
        havePowerCnt[0][1] = game.tileSet.fullH;
        havePowerCnt[0][2] = 0;
        sprites[1] = new BBSSprite(game, "sprites/flag.sif", -100, 100, 0, x, y, 0);
        sprites[1].x = x;
        sprites[1].y = game.tileSet.fullH - sprites[0].getFrameHeight() * 8 / 10;
        havePowerCnt[1][0] = x + 5;
        havePowerCnt[1][1] = game.tileSet.fullH - sprites[0].getFrameHeight() * 8 / 10;
        havePowerCnt[1][2] = 0;
        sprites[2] = new BBSSprite(game, "sprites/purplePirates.sif", 0, 100, 0, x, y, 0);
        sprites[2].x = -sprites[2].getFrameWidth();
        sprites[2].y = game.tileSet.fullH - sprites[0].getFrameHeight() * 14 / 30;
        havePowerCnt[2][0] = -sprites[2].getFrameWidth() / 2;
        havePowerCnt[2][1] = -(sprites[0].getFrameHeight() * 14 / 30);
        havePowerCnt[2][2] = 0;
        sprites[3] = new BBSSprite(game, "sprites/cannon.sif", 0, 0, 0, x, y, 0);
        sprites[3].x = sprites[0].getFrameWidth() * 3 / 10 - sprites[3].getFrameWidth() / 4;
        sprites[3].y = game.tileSet.fullH - sprites[0].getFrameHeight() * 18 / 30;
        havePowerCnt[3][0] = sprites[0].getFrameWidth() * 3 / 10 - sprites[3].getFrameWidth() / 4;
        havePowerCnt[3][1] = game.tileSet.fullH - sprites[0].getFrameHeight() * 18 / 30;
        havePowerCnt[3][2] = 0;
        sprites[4] = new BBSSprite(game, "sprites/cannon.sif", 0, 100, 0, x, y, 0);
        sprites[4].x = sprites[0].getFrameWidth() * 3 / 10 - sprites[4].getFrameWidth() / 4;
        sprites[4].y = game.tileSet.fullH - sprites[0].getFrameHeight() * 14 / 30;
        havePowerCnt[4][0] = sprites[0].getFrameWidth() - sprites[4].getFrameWidth() / 4;
        havePowerCnt[4][1] = game.tileSet.fullH - sprites[0].getFrameHeight() * 18 / 30;
        havePowerCnt[4][2] = 0;
        sprites[5] = new BBSSprite(game, "sprites/textEffect.sif", 0, 100, 0, x, y, 0);
        if (game.stage > 6) {
            sprites[6] = new BBSSprite(game, waves, 0, 0, 0, 0, 0, 0);
            sprites[6].x = game.tileSet.fullW;
            sprites[6].y = game.tileSet.fullH;
            sprites[7] = new BBSSprite(game, waves, 0, 0, 0, 0, 0, 0);
            sprites[7].x = 0;
            sprites[7].y = game.tileSet.fullH;
        } else {
            sprites[6] = new BBSSprite(game, waves, 20, 0, 0, 0, 0, 0);
            sprites[6].x = x;
            sprites[6].y = game.tileSet.fullH;
        }
        return new Player(game, sprites, x, game.h, havePowerCnt, enemy, speed, rudder, sType, oid);
    }

    public void doAnimation(BBSSmartGame game, int time) {
        this.waves = BBSFunctions.sin((int)(game.currentTimeMillis / 10L % 360L)) / 10;
        this.waves(game, time);
        this.waveLength = BBSFunctions.sin((int)(game.currentTimeMillis / 5L % 360L)) / 40;
        this.rSprite[1].doAnimation(1, 0, time, true);
        if (this.animation) {
            if (((ThrowSmartPirate)this.throwSmartPirateList.elementAt((int)this.smartPirateNxt)).rSprite[this.smartPirateNxt].x != -1) {
                if (this.rSprite[0].x < 0) {
                    this.rSprite[0].x += 2;
                    this.rSprite[1].x += 2;
                    this.rSprite[4].x += 2;
                    this.rSprite[3].x += 2;
                    ((ThrowSmartPirate)this.throwSmartPirateList.elementAt((int)this.smartPirateNxt)).rSprite[this.smartPirateNxt].x += 2;
                } else if (game.tileSet.x + 4 < game.tileSet.fullW - game.w && this.animationTileStart) {
                    game.tileSet.x += 4;
                } else if (game.tileSet.x < game.tileSet.fullW - game.w && this.animationTileStart) {
                    game.tileSet.x = game.tileSet.fullW - game.w;
                    this.animationTileStart = false;
                } else if (game.tileSet.x > 0) {
                    game.tileSet.x -= 4;
                } else {
                    game.tileSet.x = 0;
                    this.animation = false;
                    this.havePwrCnt[2][4] = 4;
                    this.animCounterPurplePirate = Byte.parseByte(String.valueOf(this.rSprite[2].setFrameSet(4, 0)));
                }
            } else if (((ThrowSmartPirate)this.throwSmartPirateList.elementAt((int)this.smartPirateNxt)).animCounterSmartPirate == 0) {
                ((ThrowSmartPirate)this.throwSmartPirateList.elementAt((int)this.smartPirateNxt)).animCounterSmartPirate = Byte.parseByte(String.valueOf(((ThrowSmartPirate)this.throwSmartPirateList.elementAt((int)this.smartPirateNxt)).rSprite[this.smartPirateNxt].setFrameSet(2, 0)));
            }
        }
        if (this.animCounterTextEffect > 0) {
            switch (this.rSprite[5].state) {
                case 1: {
                    if (!this.rSprite[5].doAnimation(this.rSprite[5].state, 0, time, false)) break;
                    this.animCounterTextEffect = (byte)(this.animCounterTextEffect - 1);
                    if (this.animCounterTextEffect == 4) {
                        this.animCounterCannon = Byte.parseByte(String.valueOf(this.rSprite[3].setFrameSet(this.cannonDirect + 1, 0)));
                        this.havePwrCnt[3][4] = 5;
                        if (this.cannonBallNxt < this.throwCannonBallList.size()) {
                            this.angle = this.cannonDegrees[(this.cannonDirect - 1) / 2];
                            this.posX = this.rSprite[3].x + 40 * BBSFunctions.cos(this.angle) / 100;
                            this.posY = this.rSprite[3].y - 40 * BBSFunctions.sin(this.angle) / 100;
                            ((ThrowCannonBall)this.throwCannonBallList.elementAt((int)this.cannonBallNxt)).rSprite[0].x = this.posX;
                            ((ThrowCannonBall)this.throwCannonBallList.elementAt((int)this.cannonBallNxt)).rSprite[0].y = this.posY;
                            ((ThrowCannonBall)this.throwCannonBallList.elementAt((int)this.cannonBallNxt)).cannonBallSpdX = this.cannonBallSpeed * BBSFunctions.cos(this.angle) / 100;
                            ((ThrowCannonBall)this.throwCannonBallList.elementAt((int)this.cannonBallNxt)).cannonBallSpdY = -this.cannonBallSpeed * BBSFunctions.sin(this.angle) / 100;
                            break;
                        }
                        if (this.smartPirateNxt >= this.throwSmartPirateList.size()) break;
                        this.angle = this.cannonDegrees[(this.cannonDirect - 1) / 2];
                        this.posX = this.rSprite[3].x + 4 * BBSFunctions.cos(this.angle) / 10;
                        this.posY = this.rSprite[3].y - 40 * BBSFunctions.sin(this.angle) / 100;
                        this.posX += ((ThrowSmartPirate)this.throwSmartPirateList.elementAt((int)this.smartPirateNxt)).rSprite[0].getFrameWidth() / 2;
                        this.posY += ((ThrowSmartPirate)this.throwSmartPirateList.elementAt((int)this.smartPirateNxt)).rSprite[0].getFrameHeight() / 2;
                        ((ThrowSmartPirate)this.throwSmartPirateList.elementAt((int)this.smartPirateNxt)).rSprite[0].x = this.posX;
                        ((ThrowSmartPirate)this.throwSmartPirateList.elementAt((int)this.smartPirateNxt)).rSprite[0].y = this.posY;
                        ((ThrowSmartPirate)this.throwSmartPirateList.elementAt((int)this.smartPirateNxt)).smartPirateSpdX = this.cannonBallSpeed * BBSFunctions.cos(this.angle) / 100 + 2;
                        ((ThrowSmartPirate)this.throwSmartPirateList.elementAt((int)this.smartPirateNxt)).smartPirateSpdY = -this.cannonBallSpeed * BBSFunctions.sin(this.angle) / 100;
                        break;
                    }
                    if (this.animCounterTextEffect != 0) break;
                    this.rSprite[5].visible = false;
                    break;
                }
                case 2: {
                    if (!this.rSprite[5].doAnimation(this.rSprite[5].state, 0, time, false)) break;
                    this.animCounterTextEffect = (byte)(this.animCounterTextEffect - 1);
                    if (this.animCounterTextEffect != 0) break;
                    this.rSprite[5].visible = false;
                    break;
                }
                case 3: {
                    if (!this.rSprite[5].doAnimation(this.rSprite[5].state, 0, time, false)) break;
                    this.animCounterTextEffect = (byte)(this.animCounterTextEffect - 1);
                    this.rSprite[5].y -= 5;
                    if (this.animCounterTextEffect != 0) break;
                    this.rSprite[5].visible = false;
                    break;
                }
                case 4: {
                    if (!this.rSprite[5].doAnimation(this.rSprite[5].state, 0, time, false)) break;
                    this.animCounterTextEffect = (byte)(this.animCounterTextEffect - 1);
                    if (this.animCounterTextEffect != 0) break;
                    this.rSprite[5].visible = false;
                    break;
                }
                case 5: {
                    if (!this.rSprite[5].doAnimation(this.rSprite[5].state, 0, time, false)) break;
                    this.animCounterTextEffect = (byte)(this.animCounterTextEffect - 1);
                    if (this.animCounterTextEffect != 0) break;
                    this.rSprite[5].visible = false;
                    break;
                }
                case 6: {
                    if (!this.rSprite[5].doAnimation(this.rSprite[5].state, 0, time, false)) break;
                    this.animCounterTextEffect = (byte)(this.animCounterTextEffect - 1);
                    if (this.animCounterTextEffect != 0) break;
                    this.rSprite[5].visible = false;
                    this.animCounterCannon = Byte.parseByte(String.valueOf(this.rSprite[3].setFrameSet(30, 0)));
                    this.havePwrCnt[3][4] = 4;
                    break;
                }
                case 7: {
                    if (!this.rSprite[5].doAnimation(this.rSprite[5].state, 0, time, false)) break;
                    this.animCounterTextEffect = (byte)(this.animCounterTextEffect - 1);
                    if (this.animCounterTextEffect != 0) break;
                    this.rSprite[5].visible = false;
                    break;
                }
                case 8: {
                    if (!this.rSprite[5].doAnimation(this.rSprite[5].state, 0, time, false)) break;
                    this.animCounterTextEffect = (byte)(this.animCounterTextEffect - 1);
                    if (this.animCounterTextEffect != 0) break;
                    this.rSprite[5].visible = false;
                    break;
                }
                case 9: {
                    if (!this.rSprite[5].doAnimation(this.rSprite[5].state, 0, time, false)) break;
                    this.animCounterTextEffect = (byte)(this.animCounterTextEffect - 1);
                    if (this.animCounterTextEffect != 0) break;
                    this.rSprite[5].visible = false;
                    CrazyPiratesGame.animationCrash = true;
                }
            }
        }
        if (this.animCounterPurplePirate > 0) {
            switch (this.rSprite[2].state) {
                case 1: {
                    --this.animCounter;
                    break;
                }
                case 2: {
                    if (!this.rSprite[2].doAnimation(2, -1, time, false)) break;
                    if (this.rSprite[2].x > -this.rSprite[2].getFrameWidth() / 2) {
                        this.rSprite[2].x -= 4;
                        int[] nArray = this.havePwrCnt[2];
                        nArray[0] = nArray[0] - 4;
                        if (this.cannonBallNxt < this.throwCannonBallList.size()) {
                            game.tileSet.x = this.rSprite[2].x;
                        }
                    }
                    this.animCounterPurplePirate = (byte)(this.animCounterPurplePirate - 1);
                    if (this.animCounterPurplePirate == 0 && this.rSprite[2].x > 0) {
                        this.animCounterPurplePirate = Byte.parseByte(String.valueOf(this.rSprite[2].setFrameSet(2, -1)));
                        this.havePwrCnt[2][4] = 2;
                        break;
                    }
                    if (this.rSprite[2].x > -this.rSprite[2].getFrameWidth() / 2 || this.cannonBallNxt >= this.throwCannonBallList.size()) break;
                    game.tileSet.x = 0;
                    this.animCounterPurplePirate = Byte.parseByte(String.valueOf(this.rSprite[2].setFrameSet(4, 0)));
                    this.havePwrCnt[2][4] = 4;
                    break;
                }
                case 4: {
                    if (!this.rSprite[2].doAnimation(4, 1, time, false)) break;
                    this.animCounterPurplePirate = (byte)(this.animCounterPurplePirate - 1);
                    if (this.rSprite[2].x <= ((ThrowSmartPirate)this.throwSmartPirateList.elementAt((int)0)).rSprite[0].x) {
                        this.rSprite[2].x += 4;
                        ((ThrowCannonBall)this.throwCannonBallList.elementAt((int)this.cannonBallNxt)).rSprite[0].x += 4;
                        int[] nArray = this.havePwrCnt[2];
                        nArray[0] = nArray[0] + 4;
                    }
                    if (this.animCounterPurplePirate != 0 || this.rSprite[2].x < 0) break;
                    ((ThrowCannonBall)this.throwCannonBallList.elementAt((int)this.cannonBallNxt)).animCounterCannonBall = Byte.parseByte(String.valueOf(((ThrowCannonBall)this.throwCannonBallList.elementAt((int)this.cannonBallNxt)).rSprite[0].setFrameSet(1, 0)));
                    this.animCounterPurplePirate = Byte.parseByte(String.valueOf(this.rSprite[2].setFrameSet(1, 0)));
                    this.havePwrCnt[2][4] = 1;
                }
            }
        }
        if (this.animCounterCannon > 0) {
            switch (this.havePwrCnt[3][4]) {
                case 3: {
                    if (this.cannonBallNxt < this.throwCannonBallList.size()) {
                        if (this.animCannonRotate < 27) {
                            this.animCannonRotate = (byte)(this.animCannonRotate + 2);
                            this.rSprite[3].setFrameSet(this.animCannonRotate, 0);
                            break;
                        }
                        this.animCannonRotate = (byte)(this.animCannonRotate + 2);
                        this.rSprite[3].setFrameSet(this.animCannonRotate, 0);
                        this.cannonDirect = Byte.parseByte(String.valueOf(this.previousCannonState));
                        this.animCounterCannon = (byte)(this.animCounterCannon - 1);
                        break;
                    }
                    if (this.animCannonRotate < 21) {
                        this.animCannonRotate = (byte)(this.animCannonRotate + 2);
                        this.rSprite[3].setFrameSet(this.animCannonRotate, 0);
                        break;
                    }
                    this.animCannonRotate = (byte)(this.animCannonRotate + 2);
                    this.rSprite[3].setFrameSet(this.animCannonRotate, 0);
                    this.cannonDirect = Byte.parseByte(String.valueOf(this.previousCannonState));
                    this.animCounterCannon = (byte)(this.animCounterCannon - 1);
                    break;
                }
                case 2: {
                    if (this.animCounterCannonRotate > this.previousCannonState + 2) {
                        this.animCounterCannonRotate = (byte)(this.animCounterCannonRotate - 2);
                        this.rSprite[3].setFrameSet(this.animCounterCannonRotate, 0);
                        if (game.tileSet.y >= game.tileSet.fullH - game.h) break;
                        game.tileSet.y += 5;
                        break;
                    }
                    if (this.animCounterCannonRotate != this.previousCannonState + 2) break;
                    this.animCounterCannonRotate = (byte)(this.animCounterCannonRotate - 2);
                    this.rSprite[3].setFrameSet(this.animCounterCannonRotate, 0);
                    this.fillinBall = true;
                    this.speedBar.rSprite[0].visible = true;
                    this.animCounterCannon = 0;
                    this.havePwrCnt[3][4] = 1;
                    game.tileSet.y = game.tileSet.fullH - game.h;
                    break;
                }
                case 4: {
                    if (!this.rSprite[3].doAnimation(this.rSprite[3].state, 0, time, false)) break;
                    this.animCounterCannon = (byte)(this.animCounterCannon - 1);
                    if (this.animCounterCannon == 0 && this.cannonBallNxt < this.throwCannonBallList.size()) {
                        this.havePwrCnt[3][4] = 2;
                        this.animCounterCannonRotate = (byte)29;
                        this.animCounterCannon = Byte.parseByte(String.valueOf(this.rSprite[3].setFrameSet(29, 0)));
                        break;
                    }
                    if (this.animCounterCannon != 2) break;
                    this.havePwrCnt[3][4] = 2;
                    this.animCounterCannonRotate = (byte)23;
                    this.animCounterCannon = Byte.parseByte(String.valueOf(this.rSprite[3].setFrameSet(23, 0)));
                    break;
                }
                case 5: {
                    if (!this.rSprite[3].doAnimation(this.rSprite[3].state, 0, time, false)) break;
                    this.animCounterCannon = (byte)(this.animCounterCannon - 1);
                    if (this.animCounterCannon != 3) break;
                    if (this.cannonBallNxt < this.throwCannonBallList.size()) {
                        this.cannonBallThrow = true;
                        break;
                    }
                    if (this.smartPirateNxt >= this.throwSmartPirateList.size()) break;
                    ThrowSmartPirate throwSmartPirate = (ThrowSmartPirate)this.throwSmartPirateList.elementAt(this.smartPirateNxt);
                    BBSSprite bBSSprite = ((ThrowSmartPirate)this.throwSmartPirateList.elementAt((int)this.smartPirateNxt)).rSprite[0];
                    ((ThrowSmartPirate)this.throwSmartPirateList.elementAt(this.smartPirateNxt)).getClass();
                    throwSmartPirate.animCounterSmartPirate = Byte.parseByte(String.valueOf(bBSSprite.setFrameSet(5, 0)));
                    ((ThrowSmartPirate)this.throwSmartPirateList.elementAt((int)this.smartPirateNxt)).rSprite[0].visible = true;
                }
            }
        }
        if (this.cannonBallThrow) {
            this.cannonBallThrow = false;
            ((ThrowCannonBall)this.throwCannonBallList.elementAt((int)this.cannonBallNxt)).animCounterCannonBall = Byte.parseByte(String.valueOf(((ThrowCannonBall)this.throwCannonBallList.elementAt((int)this.cannonBallNxt)).rSprite[0].setFrameSet(2, 0)));
            ((ThrowCannonBall)this.throwCannonBallList.elementAt((int)this.cannonBallNxt)).rSprite[0].visible = true;
        }
        if (game.gameState == 7) {
            while (this.cannonBallNxt < this.throwCannonBallList.size() - 1 && ((ThrowCannonBall)this.throwCannonBallList.elementAt((int)this.cannonBallNxt)).rSprite[0].state < 2) {
                this.score += ((ThrowCannonBall)this.throwCannonBallList.elementAt((int)this.cannonBallNxt)).energy * 20;
                ++this.cannonBallNxt;
            }
            while (this.smartPirateNxt < this.throwSmartPirateList.size() && ((ThrowSmartPirate)this.throwSmartPirateList.elementAt((int)this.smartPirateNxt)).rSprite[0].state < 4) {
                this.score += ((ThrowSmartPirate)this.throwSmartPirateList.elementAt((int)this.smartPirateNxt)).energy * 20;
                ++this.smartPirateNxt;
            }
        }
        if (this.smartPirateNxt + this.cannonBallNxt >= this.throwCannonBallList.size() + this.throwSmartPirateList.size() && game.gameState != 7 && this.onceInMs(time, 270) && System.currentTimeMillis() - this.waitTime > 3000L) {
            game.gameState = 8;
        }
    }

    public void keyPress(BBSSmartGame game, BBSKeys kcol, int time) {
        super.keyPress(game, kcol, time);
        if (kcol.fire && this.inTheAir && !this.inTheAirClick && game.released) {
            if (this.cannonBallNxt < this.throwCannonBallList.size()) {
                switch (((ThrowCannonBall)this.throwCannonBallList.elementAt((int)this.cannonBallNxt)).cannonBallType) {
                    case 1: {
                        this.inTheAirClick = true;
                        break;
                    }
                    case 2: {
                        this.inTheAirClick = true;
                        break;
                    }
                    case 3: {
                        this.inTheAirClick = true;
                        ((ThrowCannonBall)this.throwCannonBallList.elementAt((int)this.cannonBallNxt)).cannonBallSpdX *= 2;
                        ((ThrowCannonBall)this.throwCannonBallList.elementAt((int)this.cannonBallNxt)).cannonBallSpdY *= 2;
                        break;
                    }
                    case 4: {
                        this.inTheAirClick = true;
                        if (this.enemy.rSprite[0].x == ((ThrowCannonBall)this.throwCannonBallList.elementAt((int)this.cannonBallNxt)).rSprite[0].x || this.enemy.rSprite[0].y == ((ThrowCannonBall)this.throwCannonBallList.elementAt((int)this.cannonBallNxt)).rSprite[0].y) break;
                        ((ThrowCannonBall)this.throwCannonBallList.elementAt((int)this.cannonBallNxt)).cannonBallSpdY -= 4;
                        ++this.cannonBallNxt;
                        ((ThrowCannonBall)this.throwCannonBallList.elementAt((int)this.cannonBallNxt)).rSprite[0].x = ((ThrowCannonBall)this.throwCannonBallList.elementAt((int)(this.cannonBallNxt - 1))).rSprite[0].x;
                        ((ThrowCannonBall)this.throwCannonBallList.elementAt((int)this.cannonBallNxt)).rSprite[0].y = ((ThrowCannonBall)this.throwCannonBallList.elementAt((int)(this.cannonBallNxt - 1))).rSprite[0].y;
                        ((ThrowCannonBall)this.throwCannonBallList.elementAt((int)this.cannonBallNxt)).cannonBallSpdX = ((ThrowCannonBall)this.throwCannonBallList.elementAt((int)(this.cannonBallNxt - 1))).cannonBallSpdX;
                        ((ThrowCannonBall)this.throwCannonBallList.elementAt((int)this.cannonBallNxt)).cannonBallSpdY = ((ThrowCannonBall)this.throwCannonBallList.elementAt((int)(this.cannonBallNxt - 1))).cannonBallSpdY + 4;
                        this.cannonBallThrow = true;
                        this.doAnimation(game, time);
                        ++this.cannonBallNxt;
                        ((ThrowCannonBall)this.throwCannonBallList.elementAt((int)this.cannonBallNxt)).rSprite[0].x = ((ThrowCannonBall)this.throwCannonBallList.elementAt((int)(this.cannonBallNxt - 2))).rSprite[0].x;
                        ((ThrowCannonBall)this.throwCannonBallList.elementAt((int)this.cannonBallNxt)).rSprite[0].y = ((ThrowCannonBall)this.throwCannonBallList.elementAt((int)(this.cannonBallNxt - 2))).rSprite[0].y;
                        ((ThrowCannonBall)this.throwCannonBallList.elementAt((int)this.cannonBallNxt)).cannonBallSpdX = ((ThrowCannonBall)this.throwCannonBallList.elementAt((int)(this.cannonBallNxt - 2))).cannonBallSpdX;
                        ((ThrowCannonBall)this.throwCannonBallList.elementAt((int)this.cannonBallNxt)).cannonBallSpdY = ((ThrowCannonBall)this.throwCannonBallList.elementAt((int)(this.cannonBallNxt - 2))).cannonBallSpdY + 8;
                        this.cannonBallThrow = true;
                        this.doAnimation(game, time);
                    }
                }
            }
            this.inTheAir = false;
        }
        if (this.fillinBall) {
            if (kcol.up && (game.released || this.onceInMs(time, 270))) {
                if (this.cannonDirect + 2 < 25) {
                    this.cannonDirect = (byte)(this.cannonDirect + 2);
                    this.rSprite[3].setFrameSet(this.cannonDirect, 0);
                }
            } else if (kcol.down && (game.released || this.onceInMs(time, 270)) && this.cannonDirect - 2 > 0) {
                this.cannonDirect = (byte)(this.cannonDirect - 2);
                this.rSprite[3].setFrameSet(this.cannonDirect, 0);
            }
            if (kcol.fire && game.released) {
                this.previousCannonState = this.cannonDirect;
                this.timeBombSound = game.currentTimeMillis;
                this.cannonBallSpeed = game.h > 260 ? 3 * this.speedBar.energy / 2 : this.speedBar.energy;
                this.speedBar.rSprite[0].visible = false;
                this.animCounterTextEffect = Byte.parseByte(String.valueOf(this.rSprite[5].setFrameSet(1, 0)));
                this.rSprite[5].visible = true;
                this.rSprite[5].x = this.rSprite[3].x + 20 * BBSFunctions.cos(this.angle) / 100;
                this.rSprite[5].y = this.rSprite[3].y - 40 * BBSFunctions.sin(this.angle) / 100;
                this.inTheAir = true;
                this.fillinBall = false;
            }
        }
    }

    public void trigger(String command, int[] pars) {
    }

    public int interract(BBSSmartGame game, BBSSmartSprite sprite, int action) {
        if (action == 2) {
            if (((ThrowCannonBall)sprite).cannonBallType != 4) {
                if (this.cannonBallNxt < this.throwCannonBallList.size()) {
                    ++this.cannonBallNxt;
                }
                ++this.first;
                this.inTheAirClick = false;
            } else if (((ThrowCannonBall)sprite).cannonBallType == 4 && !this.inTheAirClick) {
                this.cannonBallNxt += this.redXBombCount;
                this.first += 2;
            } else if (((ThrowCannonBall)sprite).cannonBallType == 4 && this.inTheAirClick) {
                --this.redXBombCount;
                if (this.redXBombCount == 0) {
                    this.inTheAirClick = false;
                    this.redXBombCount = 3;
                    ++this.cannonBallNxt;
                    this.first += 2;
                }
            }
            if (!this.inTheAirClick) {
                if (this.cannonBallNxt < this.throwCannonBallList.size() && game.gameState != 7) {
                    ((ThrowCannonBall)this.throwCannonBallList.elementAt((int)this.cannonBallNxt)).rSprite[0].x = -this.rSprite[2].getFrameWidth();
                    ((ThrowCannonBall)this.throwCannonBallList.elementAt((int)this.cannonBallNxt)).rSprite[0].y = game.tileSet.fullH - this.rSprite[0].getFrameHeight() * 15 / 24 - ((ThrowCannonBall)this.throwCannonBallList.elementAt((int)this.cannonBallNxt)).rSprite[0].getFrameHeight() / 3;
                    this.havePwrCnt[2][4] = 2;
                    this.animCounterPurplePirate = Byte.parseByte(String.valueOf(this.rSprite[2].setFrameSet(2, -1)));
                    this.havePwrCnt[3][4] = 3;
                    this.animCannonRotate = this.cannonDirect;
                    this.animCounterCannon = 1;
                    this.havePwrCnt[3][4] = 3;
                    this.rSprite[2].x = -this.rSprite[2].getFrameWidth();
                } else if (game.gameState != 7 && game.gameState != 8 && this.smartPirateNxt < this.throwSmartPirateList.size()) {
                    ((ThrowSmartPirate)this.throwSmartPirateList.elementAt((int)this.smartPirateNxt)).zorder = 2;
                    this.throwSS = true;
                    this.havePwrCnt[3][4] = 3;
                    this.animCannonRotate = this.cannonDirect;
                    this.animCounterCannon = 1;
                    this.animCounterPurplePirate = Byte.parseByte(String.valueOf(this.rSprite[2].setFrameSet(2, -1)));
                    ((ThrowSmartPirate)this.throwSmartPirateList.elementAt((int)this.smartPirateNxt)).animCounterSmartPirate = ((ThrowSmartPirate)this.throwSmartPirateList.elementAt((int)this.smartPirateNxt)).smartPirateType == 3 ? Byte.parseByte(String.valueOf(((ThrowSmartPirate)this.throwSmartPirateList.elementAt((int)this.smartPirateNxt)).rSprite[0].setFrameSet(3, 0))) : Byte.parseByte(String.valueOf(((ThrowSmartPirate)this.throwSmartPirateList.elementAt((int)this.smartPirateNxt)).rSprite[0].setFrameSet(3, 0)));
                }
            }
        }
        if (action == 4) {
            ++this.smartPirateNxt;
            if (!this.inTheAirClick && this.smartPirateNxt < this.throwSmartPirateList.size()) {
                this.havePwrCnt[3][4] = 3;
                this.animCannonRotate = this.cannonDirect;
                this.animCounterCannon = 1;
                ((ThrowSmartPirate)this.throwSmartPirateList.elementAt((int)this.smartPirateNxt)).animCounterSmartPirate = Byte.parseByte(String.valueOf(((ThrowSmartPirate)this.throwSmartPirateList.elementAt((int)this.smartPirateNxt)).rSprite[0].setFrameSet(3, 0)));
            }
            this.waitTime = System.currentTimeMillis();
        }
        if (action == 5) {
            this.inTheAir = false;
            if (this.cannonBallNxt < this.throwCannonBallList.size()) {
                if (((ThrowCannonBall)this.throwCannonBallList.elementAt((int)(this.cannonBallNxt - 1))).cannonBallType == 4) {
                    if (this.redXBombCount == 3 && !this.inTheAirClick) {
                        ((CrazyPiratesGame)game).activePath = !((CrazyPiratesGame)game).activePath;
                    }
                } else {
                    ((CrazyPiratesGame)game).activePath = !((CrazyPiratesGame)game).activePath;
                }
            }
        }
        return 0;
    }

    public boolean draw(BBSSmartGame game, Graphics g, int spriteNo) {
        if (spriteNo < this.rSprite.length) {
            if (spriteNo == 6 && this.wavesActive) {
                for (int cnt = 0; cnt < game.tileSet.fullW / this.rSprite[spriteNo].getFrameWidth(); ++cnt) {
                    this.rSprite[spriteNo].x = this.waves + cnt * this.rSprite[spriteNo].getFrameWidth();
                    super.draw(game, g, spriteNo);
                }
            } else if (spriteNo == 7) {
                for (int cnt = 0; cnt < game.tileSet.fullW / this.rSprite[spriteNo].getFrameWidth(); ++cnt) {
                    this.rSprite[spriteNo].x = -this.waves + cnt * this.rSprite[spriteNo].getFrameWidth();
                    super.draw(game, g, spriteNo);
                }
            } else {
                super.draw(game, g, spriteNo);
            }
            game.drawText(g, game.w / 2, 0, null, this.scoreToChr(this.score), 1, 2);
        }
        return true;
    }

    public void waves(BBSSmartGame game, int time) {
        this.rSprite[0].y = this.ry = game.tileSet.fullH + this.waveLength;
        this.rSprite[1].y = this.ry - this.rSprite[0].getFrameHeight() * 8 / 10;
        this.rSprite[2].y = this.ry - this.rSprite[0].getFrameHeight() * 14 / 30;
        this.rSprite[3].y = this.ry - this.rSprite[0].getFrameHeight() * 18 / 30;
        this.rSprite[4].y = this.ry - this.rSprite[0].getFrameHeight() * 14 / 30;
    }

    protected char[] scoreToChr(int score) {
        int i1 = score / 100000;
        int i2 = score % 100000 / 10000;
        int i3 = score % 10000 / 1000;
        int i4 = score % 1000 / 100;
        int i5 = score % 100 / 10;
        int i6 = score % 10;
        this.scoreS[5] = (char)(48 + i6);
        this.scoreS[4] = score >= 10 ? (char)(48 + i5) : (char)'\u0000';
        this.scoreS[3] = score >= 100 ? (char)(48 + i4) : (char)'\u0000';
        this.scoreS[2] = score >= 1000 ? (char)(48 + i3) : (char)'\u0000';
        this.scoreS[1] = score >= 10000 ? (char)(48 + i2) : (char)'\u0000';
        this.scoreS[0] = score >= 100000 ? (char)(48 + i1) : (char)'\u0000';
        return this.scoreS;
    }
}

