/*
 * Decompiled with CFR 0.152.
 */
package com.movilenio.fs;

import java.io.IOException;
import java.io.InputStream;

public class FSInputStream
extends InputStream {
    InputStream stream;
    int size;
    int cnt;

    public FSInputStream(InputStream stream, int size) {
        this.stream = stream;
        this.size = size;
        this.cnt = 0;
    }

    public int available() throws IOException {
        int n = this.stream.available();
        if (n > this.size - this.cnt) {
            n = this.size - this.cnt;
        }
        return n;
    }

    public void close() throws IOException {
    }

    public void mark(int readlimit) {
        super.mark(readlimit);
    }

    public boolean markSupported() {
        return super.markSupported();
    }

    public int read() throws IOException {
        if (this.cnt < this.size) {
            ++this.cnt;
            return this.stream.read();
        }
        return -1;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int v;
        if (this.cnt >= this.size) {
            return -1;
        }
        int c = 0;
        while (len-- > 0 && (v = this.read()) != -1) {
            b[off++] = (byte)v;
            ++c;
        }
        this.cnt += c;
        return c;
    }

    public void reset() throws IOException {
        super.reset();
    }

    public long skip(long n) throws IOException {
        if (n > (long)(this.size - this.cnt)) {
            n = this.size - this.cnt;
        }
        return this.stream.skip(n);
    }
}

