/*
 * Decompiled with CFR 0.152.
 */
package escape;

import com.movilenio.game.Kernel;
import escape.Game;
import escape.Help;
import escape.MainMenu;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Random;
import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDlet;
import javax.microedition.midlet.MIDletStateChangeException;

public class Escape
extends MIDlet {
    public static MainMenu mainMenu;
    public static Help help;
    public static Game game;
    public static int TEXT_COLOR;
    public static Font font;
    public static Random rand;
    public static String[] texts;

    public static int getRandom(int n) {
        return (rand.nextInt() & Integer.MAX_VALUE) % n;
    }

    public static int getRandom(int min, int max) {
        return min + (rand.nextInt() & Integer.MAX_VALUE) % (max - min + 1);
    }

    public static int sgn(int a) {
        return a < 0 ? -1 : (a > 0 ? 1 : 0);
    }

    public static int limit(int v, int v0, int v1) {
        if (v0 > v1) {
            int aux = v0;
            v0 = v1;
            v1 = aux;
        }
        if (v < v0) {
            v = v0;
        }
        if (v > v1) {
            v = v1;
        }
        return v;
    }

    public void startApp() throws MIDletStateChangeException {
        System.gc();
        if (Kernel.instance == null) {
            Kernel.createInstance(this);
            mainMenu = new MainMenu();
            game = new Game();
            help = new Help();
            font = Font.getFont((int)0, (int)1, (int)8);
            texts = Escape.loadLines("/texts.txt", null, 0);
            Kernel.instance.setGameSection(mainMenu);
        }
    }

    protected void pauseApp() {
    }

    protected void destroyApp(boolean b) throws MIDletStateChangeException {
    }

    public static Image[] loadFrames(String imageName, int frameWidth, int frameHeight) {
        Image[] frames = null;
        try {
            Image img = Image.createImage((String)imageName);
            int n = img.getWidth() / frameWidth * (img.getHeight() / frameHeight);
            frames = new Image[n];
            int i = 0;
            for (int y = 0; y < img.getHeight(); y += frameHeight) {
                for (int x = 0; x < img.getWidth(); x += frameWidth) {
                    int n2 = i++;
                    Image image = Image.createImage((int)frameWidth, (int)frameHeight);
                    frames[n2] = image;
                    image.getGraphics().drawImage(img, -x, -y, 0);
                }
            }
            img = null;
        }
        catch (Exception e) {
            // empty catch block
        }
        return frames;
    }

    public static String[] loadLines(String fileName, Font font, int width) {
        int i = 0;
        char[] line = new char[256];
        Vector<String> v = new Vector<String>();
        Object[] texts = null;
        int lineW = 0;
        int lastSpace = 0;
        boolean bUnicode = false;
        InputStream is = Kernel.instance.getClass().getResourceAsStream(fileName);
        if (is != null) {
            DataInputStream dis = new DataInputStream(is);
            char ch = ' ';
            try {
                int c = dis.readByte() & 0xFF;
                if (c == 254) {
                    dis.readByte();
                    bUnicode = true;
                    ch = dis.readChar();
                } else {
                    ch = (char)c;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                while (true) {
                    int chW;
                    boolean bRead = true;
                    line[i] = ch;
                    if (ch == ' ' || ch == '\n') {
                        lastSpace = i;
                    }
                    int n = chW = width != 0 ? font.charWidth(ch) : 0;
                    if (ch == '\n' || lineW + chW > width) {
                        v.addElement(new String(line, 0, lastSpace));
                        if (width != 0 && lastSpace < i) {
                            lineW = 0;
                            ++lastSpace;
                            int j = 0;
                            while (lastSpace < i) {
                                line[j] = line[lastSpace];
                                lineW += font.charWidth(line[j]);
                                ++j;
                                ++lastSpace;
                            }
                            i = j;
                        } else {
                            i = 0;
                            lineW = 0;
                        }
                        lastSpace = 0;
                        bRead = ch == '\n';
                    } else {
                        ++i;
                        lineW += chW;
                    }
                    if (!bRead) continue;
                    ch = bUnicode ? dis.readChar() : (char)(dis.readByte() & 0xFF);
                }
            }
            catch (EOFException e) {
                v.addElement(new String(line, 0, i));
                texts = new String[v.size()];
                v.copyInto(texts);
            }
            catch (IOException e) {
                // empty catch block
            }
            try {
                dis.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        v.removeAllElements();
        v = null;
        line = null;
        return texts;
    }

    static {
        TEXT_COLOR = 0xFFCC00;
        rand = new Random(System.currentTimeMillis());
    }
}

