/*
 * Decompiled with CFR 0.152.
 */
package escape;

import com.movilenio.game.GameSection;
import com.movilenio.game.Kernel;
import escape.Escape;
import escape.Ship;
import escape.TileMap;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Game
extends GameSection {
    public boolean bExitTemp = false;
    private boolean bRepaint = true;
    private static final byte ST_START_LEVEL = 1;
    private static final byte ST_PLAY = 2;
    private static final byte ST_END_LEVEL = 3;
    private static final byte ST_DIE = 4;
    private static final byte ST_LOAD_LEVEL = 5;
    private static final byte ST_END_GAME = 6;
    private byte status;
    private int statusFrames;
    public short level;
    private boolean bonusLevel;
    private TileMap map = new TileMap();
    public Ship ship = new Ship(this.map);
    private Image panel;
    private Image barraFuel;
    private Image[] imgNum;
    private short lastFuel;
    private int lastScore;
    private Image imgGameOver;
    public short firstLevel = 1;
    public short lastLevel = 1;
    public int topScore = 100;

    public Game() {
        this.loadGame();
    }

    public void loadResources() {
        super.loadResources();
        System.gc();
        try {
            this.panel = Image.createImage((String)"/panel.png");
            this.barraFuel = Image.createImage((String)"/barra_fuel.png");
            this.imgGameOver = Image.createImage((String)"/game_over.png");
            this.imgNum = Escape.loadFrames("/numeros_t.png", 6, 10);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.map.loadResources();
        this.ship.loadResources();
        System.gc();
    }

    public void freeResources() {
        super.freeResources();
        this.ship.freeResources();
        this.map.freeResources();
        this.panel = null;
        this.barraFuel = null;
        this.imgNum = null;
        this.imgGameOver = null;
        System.gc();
    }

    public boolean initSection() {
        Kernel.instance.keyStatus = 0;
        this.map.setBounds(Kernel.instance.getWidth(), Kernel.instance.getHeight() - 31);
        if (!this.bExitTemp) {
            this.level = this.firstLevel;
            this.bonusLevel = false;
            this.status = (byte)5;
            this.map.init();
            this.ship.init();
        } else if (this.status == 2) {
            Kernel.instance.pause(true);
        }
        this.bExitTemp = false;
        this.bRepaint = true;
        if (this.status != 5) {
            this.map.repaintBuffer();
        }
        return true;
    }

    public void endSection() {
        if (this.bExitTemp) {
            Escape.mainMenu.op = 1;
        } else {
            Escape.mainMenu.op = 0;
            this.map.done();
        }
    }

    public void show(boolean bShow) {
        if (bShow) {
            Kernel.instance.keyStatus = 0;
            if (this.status != 2) {
                Kernel.instance.pause(false);
            }
            this.bRepaint = true;
        }
    }

    public void keyPressed(int keyCode) {
        if (Kernel.instance.bPause) {
            Kernel.instance.pause(false);
        }
    }

    public void loadGame() {
        byte[][] rmsData = Kernel.loadRMS("ESCAPE", 0, 0);
        if (rmsData != null) {
            this.topScore = Kernel.readInt(rmsData[0], 0);
            this.firstLevel = this.lastLevel = (short)Kernel.readInt(rmsData[0], 4);
            Escape.mainMenu.bSound = Kernel.readInt(rmsData[0], 8) == 1;
        }
    }

    public void saveGame() {
        if (this.ship.score > this.topScore) {
            this.topScore = this.ship.score;
        }
        if (this.level > this.lastLevel) {
            this.firstLevel = this.lastLevel = this.level;
        }
        byte[][] data = new byte[][]{new byte[12]};
        Kernel.writeInt(this.topScore, data[0], 0);
        Kernel.writeInt(this.lastLevel, data[0], 4);
        Kernel.writeInt(Escape.mainMenu.bSound ? 1 : 0, data[0], 8);
        Kernel.saveRMS("ESCAPE", data, 0);
    }

    public void doFrame() {
        if (this.status != 5 && (Kernel.instance.getKeyPressedStatus(14) || Kernel.instance.getKeyPressedStatus(13))) {
            this.bExitTemp = true;
            Kernel.instance.setGameSection(Escape.mainMenu);
            return;
        }
        switch (this.status) {
            case 1: {
                if (Kernel.instance.keyStatus == 0) break;
                this.status = (byte)2;
                break;
            }
            case 2: {
                this.map.doFrame();
                this.ship.doFrame();
                if (this.ship.isDead) {
                    Kernel.instance.keyStatus = 0;
                    this.statusFrames = 50;
                    this.status = (byte)4;
                    if (this.bonusLevel) {
                        ++this.ship.lives;
                    }
                }
                if (!this.ship.exit) break;
                Kernel.instance.keyStatus = 0;
                this.statusFrames = 50;
                this.status = (byte)3;
                break;
            }
            case 3: {
                if (this.statusFrames-- > 0) break;
                this.bonusLevel = !this.bonusLevel && this.map.numGold == this.map.levelGold && this.level % 5 == 0;
                if (!this.bonusLevel) {
                    this.level = (short)(this.level + 1);
                }
                this.status = (byte)5;
                break;
            }
            case 5: {
                if (this.map.load(this.bonusLevel ? "/bonus" + this.level / 5 + ".map" : "/level" + this.level + ".map")) {
                    if (!this.bonusLevel) {
                        this.saveGame();
                    }
                    this.ship.start();
                    this.status = 1;
                    break;
                }
                if (!this.bonusLevel) {
                    this.level = (short)(this.level - 1);
                }
                this.statusFrames = 100;
                this.status = (byte)6;
                break;
            }
            case 4: {
                if (this.statusFrames-- > 0) break;
                if (this.ship.lives > 0) {
                    if (this.bonusLevel) {
                        this.bonusLevel = false;
                        this.level = (short)(this.level + 1);
                    }
                    this.status = (byte)5;
                    break;
                }
                Escape.mainMenu.op = 0;
                Kernel.instance.setGameSection(Escape.mainMenu);
                this.saveGame();
                break;
            }
            case 6: {
                if (this.statusFrames-- > 0) break;
                Escape.mainMenu.op = 0;
                Escape.help.mode = (byte)2;
                Kernel.instance.setGameSection(Escape.help);
            }
        }
    }

    public void drawNum(int x, int y, int num, int digits, Graphics g) {
        int w = this.imgNum[0].getWidth() + 1;
        x -= w - 1;
        y -= this.imgNum[0].getHeight();
        while (digits-- > 0) {
            int c = num % 10;
            g.drawImage(this.imgNum[c], x, y, 0);
            num /= 10;
            x -= w;
        }
    }

    public void drawCenteredText(String text, String text2, Graphics g) {
        int x = Kernel.instance.getWidth() >> 1;
        int y = Kernel.instance.getHeight() >> 1;
        int w = Escape.font.getHeight();
        g.setFont(Escape.font);
        g.setColor(0);
        g.drawString(text, x + 2, y + 2 - w, 17);
        if (text2 != null) {
            g.drawString(text2, x + 2, y + 2, 17);
        }
        g.setColor(0xFFFFFF);
        g.drawString(text, x, y - w, 17);
        if (text2 != null) {
            g.drawString(text2, x, y, 17);
        }
    }

    public void paint(Graphics g) {
        int txPanel = Kernel.instance.getWidth() - this.panel.getWidth() >> 1;
        if (this.status != 5) {
            this.map.paint(g, 0, 31);
        }
        g.setClip(0, 0, Kernel.instance.getWidth(), Kernel.instance.getHeight());
        if (this.bRepaint) {
            g.setColor(0);
            g.fillRect(0, 0, Kernel.instance.getWidth(), this.panel.getHeight());
            g.drawImage(this.panel, txPanel + 0, 0, 0);
            this.lastFuel = 0;
            this.lastScore = -1;
            this.bRepaint = false;
        }
        switch (this.status) {
            case 1: {
                if (this.bonusLevel) {
                    this.drawCenteredText(Escape.texts[2], null, g);
                    break;
                }
                this.drawCenteredText(Escape.texts[0] + " " + this.level, null, g);
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                if (this.map.numGold == this.map.levelGold) {
                    this.drawCenteredText(Escape.texts[1], Escape.texts[7], g);
                    break;
                }
                this.drawCenteredText(Escape.texts[1], Escape.texts[6] + ": " + this.map.numGold + "/" + this.map.levelGold, g);
                break;
            }
            case 4: {
                if (this.ship.lives > 0) break;
            }
            case 6: {
                g.drawImage(this.imgGameOver, Kernel.instance.getWidth() - this.imgGameOver.getWidth() >> 1, Kernel.instance.getHeight() - this.imgGameOver.getHeight() >> 1, 0);
            }
        }
        if (Kernel.instance.bPause) {
            this.drawCenteredText(Escape.texts[5], null, g);
        }
        if (this.status != 5) {
            if (this.ship.fuel != this.lastFuel) {
                int bfw = this.barraFuel.getWidth();
                int bfh = this.barraFuel.getHeight();
                int wr = this.ship.fuel * bfw / 128;
                g.drawImage(this.barraFuel, txPanel + 90, 19, 0);
                g.setColor(0);
                g.fillRect(txPanel + 90 + wr, 19, bfw - wr, bfh);
            }
            if (this.lastScore != this.ship.score) {
                this.drawNum(txPanel + 128 + 6, 13, this.ship.score, 5, g);
            }
            this.drawNum(txPanel + 163 + 6, 13, this.ship.lives, 1, g);
        }
    }
}

