/*
 * Decompiled with CFR 0.152.
 */
package escape;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Sprite {
    private Image image;
    public short width;
    public short height;
    public byte numFrames;
    public byte currentFrame;
    public byte loopFrame;
    private short currentFrameY;
    private short frameTime;
    private byte _ft;
    public short axisX;
    public short axisY;

    public Sprite(Image image, int axisX, int axisY, int numFrames, int loopFrame, int frameTime) {
        this.image = image;
        this.width = (short)image.getWidth();
        this.height = (short)(image.getHeight() / numFrames);
        this.numFrames = (byte)numFrames;
        this.frameTime = (short)frameTime;
        this._ft = 0;
        this.setCurrentFrame(0);
        this.loopFrame = (byte)loopFrame;
        this.axisX = (short)axisX;
        this.axisY = (short)axisY;
    }

    public void setAxis(short axisX, short axisY) {
        this.axisX = axisX;
        this.axisY = axisY;
    }

    public void nextFrame() {
        byte by = this._ft;
        this._ft = (byte)(by + 1);
        if (by == this.frameTime) {
            if (this.currentFrame < this.numFrames) {
                this.currentFrame = (byte)(this.currentFrame + 1);
            }
            if (this.currentFrame >= this.numFrames && this.loopFrame != -1) {
                this.currentFrame = this.loopFrame;
            }
            this.currentFrameY = (short)(this.height * this.currentFrame);
            this._ft = 0;
        }
    }

    public void setCurrentFrame(int numFrame) {
        this.currentFrame = (byte)numFrame;
        this.currentFrameY = (short)(this.height * this.currentFrame);
    }

    public void draw(int x, int y, Graphics g) {
        if (this.currentFrame >= this.numFrames) {
            return;
        }
        int cx = g.getClipX();
        int cy = g.getClipY();
        int cw = g.getClipWidth();
        int ch = g.getClipHeight();
        g.clipRect(x - this.axisX, y - this.axisY, (int)this.width, (int)this.height);
        g.drawImage(this.image, x - this.axisX, y - this.axisY - this.currentFrameY, 0);
        g.setClip(cx, cy, cw, ch);
    }

    public void unload() {
        this.image = null;
    }
}

