/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.OutputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;

public class LoadGame {
    private static final int MAX_EPISODE = 4;
    private Img img;
    private static final int STARTX = 30;
    private static final int STARTY = 92;
    private static final int GAP = 35;
    int episode;
    int select;
    int complete;
    int pos;
    int[] hiscore = new int[]{0, -1, -1, -1};
    private MyCanvas game;
    private int menuSound;
    private static final int MENUSOUND = 1;

    LoadGame(HelloWord helloWord, MyCanvas myCanvas, Img img) {
        this.img = img;
        this.game = myCanvas;
        this.loadData();
    }

    protected void keyPressed(int n) {
        switch (n) {
            case 1: {
                this.menuSound = 1;
                --this.select;
                if (this.select >= 0) break;
                this.select = this.complete - 1;
                break;
            }
            case 6: {
                this.menuSound = 1;
                ++this.select;
                if (this.select < this.complete) break;
                this.select = 0;
                break;
            }
            case 8: {
                this.menuSound = 1;
                this.game.reStart(this.select);
                MyCanvas.canvas = 0;
                this.game.score.setScore(this.hiscore[this.select]);
                this.game.start();
            }
        }
    }

    public void loadData() {
        try {
            Object object;
            Closeable closeable;
            Object object2;
            RecordStore recordStore = RecordStore.openRecordStore((String)"loadgame", (boolean)true);
            if (recordStore.getNumRecords() == 0) {
                this.hiscore[0] = 0;
                this.hiscore[1] = -1;
                this.hiscore[2] = -1;
                this.hiscore[3] = -1;
                object2 = new ByteArrayOutputStream();
                closeable = new DataOutputStream((OutputStream)object2);
                int n = 0;
                while (n < 4) {
                    ((DataOutputStream)closeable).writeInt(n);
                    ((DataOutputStream)closeable).writeInt(this.hiscore[n]);
                    object = ((ByteArrayOutputStream)object2).toByteArray();
                    recordStore.addRecord((byte[])object, 0, ((RecordEnumeration)object).length);
                    ++n;
                }
            } else {
                object = recordStore.enumerateRecords(null, null, false);
                while (object.hasNextElement()) {
                    object2 = object.nextRecord();
                    closeable = new DataInputStream(new ByteArrayInputStream((byte[])object2));
                    this.episode = ((DataInputStream)closeable).readInt();
                    this.hiscore[this.episode] = ((DataInputStream)closeable).readInt();
                }
            }
            recordStore.closeRecordStore();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.complete = 0;
        int n = 0;
        while (n < 4) {
            if (this.hiscore[n] >= 0) {
                ++this.complete;
            }
            ++n;
        }
        this.select = 0;
    }

    public void paint(Graphics graphics) {
        switch (this.menuSound) {
            case 1: {
                GameSound.menu();
                this.menuSound = -1;
            }
        }
        if (this.img.imgBack == null) {
            try {
                this.img.imgBack = Image.createImage((String)"/img/back.png");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        graphics.drawImage(this.img.imgBack, 0, 0, 20);
        graphics.setColor(0, 0, 0);
        BigString.draw(graphics, 30, 24, "LOAD GAME");
        graphics.fillRect(20, 48, 142, 2);
        int n = 1;
        while (n <= 4) {
            if (this.hiscore[n - 1] >= 0) {
                SmallString.draw(graphics, 28, 32 + 35 * n, " EPISODE " + n);
            }
            ++n;
        }
        graphics.setColor(0, 0, 255);
        graphics.drawRect(24, 26 + 35 * (this.select + 1), 130, 26);
    }
}

