/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gameplay;

import baltorogames.graphic2d.CGTexture;
import baltorogames.graphic2d.TextureManager;
import baltorogames.project_gameplay.CGEngine;
import java.io.DataInputStream;
import java.io.IOException;

public class CGBillboardObject {
    static final int __OBJECT_START_LEFT__ = 0;
    static final int __OBJECT_START_RIGHT__ = 1;
    static final int __OBJECT_FINISH_LEFT__ = 2;
    static final int __OBJECT_FINISH_RIGHT__ = 3;
    static final int __OBJECT_LAMP_LEFT__ = 4;
    static final int __OBJECT_LAMP_RIGHT__ = 5;
    static final int __OBJECT_SIGN1__ = 6;
    static final int __OBJECT_SIGN2__ = 7;
    static final int __OBJECT_BUILDING1_RIGHT__ = 8;
    static final int __OBJECT_BUILDING1_LEFT__ = 9;
    static final int __OBJECT_BUILDING2_RIGHT__ = 10;
    static final int __OBJECT_BUILDING2_LEFT__ = 11;
    static final int __OBJECT_BUILDING3_RIGHT__ = 12;
    static final int __OBJECT_BUILDING3_LEFT__ = 13;
    static final int __OBJECT_RADAR__ = 14;
    static final int __OBJECT_HOUSE_RIGHT__ = 15;
    static final int __OBJECT_HOUSE_LEFT__ = 16;
    static final int __OBJECT_TRYBUNY_RIGHT__ = 17;
    static final int __OBJECT_TRYBUNY_LEFT__ = 18;
    static final int __OBJECT_CONST_RIGHT__ = 19;
    static final int __OBJECT_CONST_LEFT__ = 20;
    static final int __OBJECT_BALT_SIGN_LEFT__ = 21;
    static final int __OBJECT_PALM__ = 22;
    static final int __OBJECT_LIGHTS_RIGHT__ = 23;
    static final int __OBJECT_LIGHTS_LEFT__ = 24;
    static String[] bilboardsFilename = new String[]{"/gameplay/start.png", "/gameplay/start.png", "/gameplay/finish.png", "/gameplay/finish.png", "/gameplay/lamp1.png", "/gameplay/lamp1.png", "/gameplay/sign1.png", "/gameplay/sign2.png", "/gameplay/building_1.png", "/gameplay/building_1.png", "/gameplay/building_2.png", "/gameplay/building_2.png", "/gameplay/building_3.png", "/gameplay/building_3.png", "/gameplay/14_radar.png", "/gameplay/house.png", "/gameplay/house.png", "/gameplay/trybuny.png", "/gameplay/trybuny.png", "/gameplay/baltoro_const.png", "/gameplay/baltoro_const.png", "/gameplay/baltoro_sign.png", "/gameplay/palm.png", "/gameplay/lights.png", "/gameplay/lights.png"};
    static int[] bilboardsWidths = new int[]{206, 206, 24, 24, 85, 85, 173, 173, 160, 160, 107, 107, 147, 147, 68, 176, 176, 198, 198, 331, 331, 187, 74, 34, 34};
    static int[] bilboardsHeights = new int[]{89, 89, 60, 60, 150, 150, 150, 150, 200, 200, 150, 150, 250, 250, 100, 133, 133, 132, 132, 103, 103, 107, 122, 28, 28};
    static int[] bilboardsScale = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    static int[] bilboardsIsMirrored = new int[]{0, 1, 0, 1, 1, 0, 0, 0, 0, 1, 0, 1, 0, 1, 0, 0, 1, 0, 1, 0, 1, 0, 0, 0, 1};
    public long m_fxX;
    public long m_fxY;
    public long m_fxZ;
    public long m_fxH;
    public long m_fxW;
    public long m_fxTrX;
    public long m_fxTrY;
    public long m_fxTrZ;
    public int m_nMirrored = 0;
    public int m_nLinearScale;
    public long m_fxDistanceFromStart;
    public int m_nCarIndex = 0;
    public CGTexture m_Texture;

    public void deSerialize(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readInt();
        char[] cArray = new char[n];
        for (int i = 0; i < n; ++i) {
            char c;
            cArray[i] = c = (char)dataInputStream.readByte();
        }
        String string = new String(cArray);
        String string2 = "/" + string;
        this.m_fxX = dataInputStream.readInt() * 4096;
        this.m_fxZ = dataInputStream.readInt() * 4096;
        this.m_fxW = dataInputStream.readInt() * 4096;
        this.m_fxH = dataInputStream.readInt() * 4096;
        this.m_fxY = dataInputStream.readInt() * 4096;
        this.m_nLinearScale = dataInputStream.readInt();
        this.m_nMirrored = dataInputStream.readInt();
        if (this.m_nMirrored > 0) {
            this.m_nMirrored = 2;
        }
        long l = CGEngine.testApp.GetMaxObjectsDistanceScale();
        long l2 = (4096L - l) / (long)(CGTexture.m_nNrOfMipMaps - 1);
        int[] nArray = new int[CGTexture.m_nNrOfMipMaps];
        int[] nArray2 = new int[CGTexture.m_nNrOfMipMaps];
        for (int i = 0; i < CGTexture.m_nNrOfMipMaps; ++i) {
            nArray[i] = (int)(CGEngine.testApp.m_Camera.m_fxCameraScale * (this.m_fxW / 4096L) * (l + (long)i * l2) / 0x1000000L);
            nArray2[i] = (int)(CGEngine.testApp.m_Camera.m_fxCameraScale * (this.m_fxH / 4096L) * (l + (long)i * l2) / 0x1000000L);
        }
        this.m_Texture = TextureManager.AddTexture(string2, 0, 1, nArray, nArray2);
    }

    public static CGBillboardObject CreateBillboardObject(int n, long l, long l2, long l3) {
        String string = null;
        CGBillboardObject cGBillboardObject = new CGBillboardObject();
        cGBillboardObject.m_fxX = l;
        cGBillboardObject.m_fxY = l2;
        cGBillboardObject.m_fxZ = l3;
        cGBillboardObject.m_fxW = bilboardsWidths[n] << 12;
        cGBillboardObject.m_fxH = bilboardsHeights[n] << 12;
        cGBillboardObject.m_nLinearScale = bilboardsScale[n];
        cGBillboardObject.m_nMirrored = bilboardsIsMirrored[n];
        string = bilboardsFilename[n];
        if (string != null) {
            if (cGBillboardObject.m_nMirrored > 0) {
                cGBillboardObject.m_nMirrored = 2;
            }
            CGTexture.m_nNrOfMipMaps = CGTexture.m_NrOfMipMapsForObjects;
            long l4 = 13L * CGEngine.testApp.GetMaxObjectsDistanceScale() / 10L;
            long l5 = (4096L - l4) / (long)CGTexture.m_nNrOfMipMaps;
            int[] nArray = new int[CGTexture.m_nNrOfMipMaps];
            int[] nArray2 = new int[CGTexture.m_nNrOfMipMaps];
            for (int i = 0; i < CGTexture.m_nNrOfMipMaps; ++i) {
                nArray[i] = (int)(CGEngine.testApp.m_Camera.m_fxCameraScale * (cGBillboardObject.m_fxW / 4096L) * (l4 + (long)i * l5) / 0x1000000L);
                nArray2[i] = (int)(CGEngine.testApp.m_Camera.m_fxCameraScale * (cGBillboardObject.m_fxH / 4096L) * (l4 + (long)i * l5) / 0x1000000L);
            }
            cGBillboardObject.m_Texture = TextureManager.AddTexture(string, 0, 1, nArray, nArray2);
        }
        return cGBillboardObject;
    }
}

