/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gameplay;

import baltorogames.core.ApplicationData;
import baltorogames.project_gameplay.CareerKart;
import baltorogames.project_gui.EditChampionshipsUserName;
import baltorogames.system.BGStore;
import baltorogames.system.Options;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class CGUserCareer {
    public static final int eMaxLevels = 9;
    public static final int NUM_KARTS = 3;
    public static final int eNrOfBolids = 8;
    public static int[] generalClasification = new int[8];
    public static boolean[] tracksUnlocked = new boolean[9];
    public static int[] babeUnlockState = new int[4];
    private static boolean[] availableKarts = new boolean[]{true, false, false, false};
    public static CareerKart[] playerKarts = new CareerKart[3];
    private static int[] raceIDtoCityID = new int[]{1, 1, 1, 2, 2, 2, 3, 3, 3, 4, 4, 4, 5, 5, 5};
    private static int[] eventIDtoCityID = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0};
    protected static String m_szNick;
    protected static String m_szDevicePlatform;
    public static int m_nRaceID;
    public static int currentBabe;
    public static int currentKart;
    public static int m_nFamePoints;
    protected static int m_nPoints;

    public static int FindHumanPosition() {
        int n;
        int n2 = generalClasification[0];
        int n3 = generalClasification[0];
        int n4 = generalClasification[0];
        for (n = 0; n < generalClasification.length; ++n) {
            if (n2 >= generalClasification[n]) continue;
            n2 = generalClasification[n];
        }
        for (n = 0; n < generalClasification.length; ++n) {
            if (n3 >= generalClasification[n] || generalClasification[n] == n2) continue;
            n3 = generalClasification[n];
        }
        for (n = 0; n < generalClasification.length; ++n) {
            if (n4 >= generalClasification[n] || generalClasification[n] == n2 || generalClasification[n] == n3) continue;
            n4 = generalClasification[n];
        }
        if (n2 == generalClasification[0]) {
            return 0;
        }
        if (n3 == generalClasification[0]) {
            return 1;
        }
        if (n4 == generalClasification[0]) {
            return 2;
        }
        return 3;
    }

    public static void unlockCar() {
        for (int i = 0; i < availableKarts.length; ++i) {
            if (availableKarts[i]) continue;
            CGUserCareer.availableKarts[i] = true;
            break;
        }
    }

    public static void Reset() {
        int n;
        m_nPoints = 0;
        m_nFamePoints = 0;
        if (!CGUserCareer.isAnyGameStored()) {
            m_nRaceID = -1;
        }
        if (!CGUserCareer.isAnyGameStored()) {
            for (n = 0; n < 9; ++n) {
                CGUserCareer.tracksUnlocked[n] = false;
            }
            CGUserCareer.tracksUnlocked[0] = true;
            CGUserCareer.babeUnlockState[3] = 0;
            CGUserCareer.babeUnlockState[2] = 0;
            CGUserCareer.babeUnlockState[1] = 0;
            CGUserCareer.babeUnlockState[0] = 0;
            currentBabe = 0;
            CGUserCareer.availableKarts[0] = true;
            CGUserCareer.availableKarts[1] = false;
            CGUserCareer.availableKarts[2] = false;
            CGUserCareer.availableKarts[3] = false;
            currentKart = 0;
            m_szNick = "";
            m_szDevicePlatform = "";
            if (ApplicationData.lp != null) {
                EditChampionshipsUserName.playerNick = ApplicationData.lp.getTranslatedString(Options.languageID, "EDIT_PLAYERS_DEFAULT_PLAYER");
            }
            CGUserCareer.playerKarts[0] = new CareerKart(2048L, 2048L, 0, 0, 1, 2, 3);
            CGUserCareer.playerKarts[1] = new CareerKart(1900L, 1600L, 1, 0, 1, 2, 3);
            CGUserCareer.playerKarts[2] = new CareerKart(2300L, 2048L, 0, 0, 1, 2, 3);
        }
        for (n = 0; n < 8; ++n) {
            CGUserCareer.generalClasification[n] = 0;
        }
    }

    public static void ResetAll() {
        int n;
        m_nPoints = 0;
        m_nFamePoints = 0;
        m_nRaceID = -1;
        for (n = 0; n < 9; ++n) {
            CGUserCareer.tracksUnlocked[n] = false;
        }
        CGUserCareer.tracksUnlocked[0] = true;
        CGUserCareer.babeUnlockState[3] = 0;
        CGUserCareer.babeUnlockState[2] = 0;
        CGUserCareer.babeUnlockState[1] = 0;
        CGUserCareer.babeUnlockState[0] = 0;
        currentBabe = 0;
        CGUserCareer.availableKarts[0] = true;
        CGUserCareer.availableKarts[1] = false;
        CGUserCareer.availableKarts[2] = false;
        CGUserCareer.availableKarts[3] = false;
        currentKart = 0;
        m_szNick = "";
        m_szDevicePlatform = "";
        if (ApplicationData.lp != null) {
            EditChampionshipsUserName.playerNick = ApplicationData.lp.getTranslatedString(Options.languageID, "EDIT_PLAYERS_DEFAULT_PLAYER");
        }
        CGUserCareer.playerKarts[0] = new CareerKart(2048L, 2048L, 0, 0, 1, 2, 3);
        CGUserCareer.playerKarts[1] = new CareerKart(1900L, 1600L, 1, 0, 1, 2, 3);
        CGUserCareer.playerKarts[2] = new CareerKart(2300L, 2048L, 0, 0, 1, 2, 3);
        for (n = 0; n < 8; ++n) {
            CGUserCareer.generalClasification[n] = 0;
        }
    }

    public static void Load() {
        CGUserCareer.Reset();
        BGStore bGStore = BGStore.openStoreToRead("UserCareer");
        if (bGStore == null) {
            return;
        }
        try {
            DataInputStream dataInputStream = bGStore.getInStream();
            if (dataInputStream != null && dataInputStream.available() > 0) {
                int n;
                m_nRaceID = dataInputStream.readInt();
                m_nPoints = dataInputStream.readInt();
                m_nFamePoints = dataInputStream.readInt();
                for (n = 0; n < 9; ++n) {
                    CGUserCareer.tracksUnlocked[n] = dataInputStream.readBoolean();
                }
                CGUserCareer.babeUnlockState[0] = dataInputStream.readInt();
                CGUserCareer.babeUnlockState[1] = dataInputStream.readInt();
                CGUserCareer.babeUnlockState[2] = dataInputStream.readInt();
                CGUserCareer.babeUnlockState[3] = dataInputStream.readInt();
                currentBabe = dataInputStream.readInt();
                CGUserCareer.availableKarts[0] = dataInputStream.readBoolean();
                CGUserCareer.availableKarts[1] = dataInputStream.readBoolean();
                CGUserCareer.availableKarts[2] = dataInputStream.readBoolean();
                CGUserCareer.availableKarts[3] = dataInputStream.readBoolean();
                currentKart = dataInputStream.readInt();
                m_szNick = dataInputStream.readUTF();
                m_szDevicePlatform = dataInputStream.readUTF();
                EditChampionshipsUserName.playerNick = dataInputStream.readUTF();
                for (n = 0; n < 3; ++n) {
                    playerKarts[n].deSerialize(dataInputStream);
                }
                for (n = 0; n < 8; ++n) {
                    CGUserCareer.generalClasification[n] = dataInputStream.readInt();
                }
            }
            bGStore.close();
        }
        catch (Exception exception) {
            CGUserCareer.Reset();
            return;
        }
    }

    public static void Save() {
        BGStore bGStore = BGStore.openStoreToWrite("UserCareer");
        if (bGStore == null) {
            return;
        }
        try {
            int n;
            DataOutputStream dataOutputStream = bGStore.getOutStream();
            dataOutputStream.writeInt(m_nRaceID);
            dataOutputStream.writeInt(m_nPoints);
            dataOutputStream.writeInt(m_nFamePoints);
            for (n = 0; n < 9; ++n) {
                dataOutputStream.writeBoolean(tracksUnlocked[n]);
            }
            dataOutputStream.writeInt(babeUnlockState[0]);
            dataOutputStream.writeInt(babeUnlockState[1]);
            dataOutputStream.writeInt(babeUnlockState[2]);
            dataOutputStream.writeInt(babeUnlockState[3]);
            dataOutputStream.writeInt(currentBabe);
            dataOutputStream.writeBoolean(availableKarts[0]);
            dataOutputStream.writeBoolean(availableKarts[1]);
            dataOutputStream.writeBoolean(availableKarts[2]);
            dataOutputStream.writeBoolean(availableKarts[3]);
            dataOutputStream.writeInt(currentKart);
            dataOutputStream.writeUTF(m_szNick);
            dataOutputStream.writeUTF(m_szDevicePlatform);
            dataOutputStream.writeUTF(EditChampionshipsUserName.playerNick);
            for (n = 0; n < 3; ++n) {
                playerKarts[n].serialize(dataOutputStream);
            }
            for (n = 0; n < 8; ++n) {
                dataOutputStream.writeInt(generalClasification[n]);
            }
            bGStore.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static int getEventFromRaceID(int n) {
        return eventIDtoCityID[n];
    }

    public static int getCityFromRaceID(int n) {
        return raceIDtoCityID[n];
    }

    public static void unlockBabe(int n, int n2) {
        CGUserCareer.babeUnlockState[n] = n2;
    }

    public static boolean isKartAvailable(int n) {
        return availableKarts[n];
    }

    public static void unlockKart(int n) {
        CGUserCareer.availableKarts[n] = true;
    }

    public static boolean isAnyGameStored() {
        return m_nRaceID >= 0;
    }

    public static int GetPoints() {
        return m_nPoints;
    }

    public static void AddPoints(int n) {
        m_nPoints += n;
    }

    public static int GetFamePoints() {
        return m_nFamePoints;
    }

    public static void AddFamePoints(int n) {
        if ((m_nFamePoints += n) < 0) {
            m_nFamePoints = 0;
        }
    }

    public static void SetRaceID(int n) {
        m_nRaceID = n;
    }

    public static int GetRaceID() {
        return m_nRaceID;
    }

    public static void SetNick(String string) {
        m_szNick = string;
    }

    public static String GetNick() {
        return m_szNick;
    }

    public static void SetDevicePlatform(String string) {
        m_szDevicePlatform = string;
    }

    public static String GetDevicePlatform() {
        return m_szDevicePlatform;
    }

    public static void UnlockAll() {
        m_nRaceID = 100;
        for (int i = 0; i < 9; ++i) {
            CGUserCareer.tracksUnlocked[i] = true;
        }
        CGUserCareer.babeUnlockState[3] = 1;
        CGUserCareer.babeUnlockState[2] = 1;
        CGUserCareer.babeUnlockState[1] = 1;
        CGUserCareer.babeUnlockState[0] = 1;
        CGUserCareer.availableKarts[0] = true;
        CGUserCareer.availableKarts[1] = true;
        CGUserCareer.availableKarts[2] = true;
        CGUserCareer.availableKarts[3] = true;
    }

    static {
        m_nRaceID = -1;
        currentBabe = 0;
        currentKart = 0;
        m_nFamePoints = 0;
    }
}

