/*
 * Decompiled with CFR 0.152.
 */
package DWGameEngine;

import java.util.Random;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class GameUtil {
    private static Random rnd = new Random();

    public static Image createImage(String filename) {
        Image tempImage = null;
        try {
            tempImage = Image.createImage((String)("/images/" + filename));
        }
        catch (Exception ex) {}
        return tempImage;
    }

    public static void drawClipImage(Graphics g, Image image, int x, int y, int index, int width, int height) {
        g.setClip(x, y + 6, width, height);
        g.drawImage(image, x - index * width, y + 6, 0);
        g.setClip(0, 0, 176, 220);
    }

    public static void drawClipImage2(Graphics g, Image image, int x, int y, int x1, int y1, int width, int height) {
        g.setClip(x, y + 6, width, height);
        g.drawImage(image, x - x1, y + 6 - y1, 0);
        g.setClip(0, 0, 176, 220);
    }

    public static void drawClipImageHeight(Graphics g, Image image, int x, int y, int index, int width, int height) {
        g.setClip(x, y + 6, width, height);
        g.drawImage(image, x, y + 6 - index * height, 0);
        g.setClip(0, 0, 176, 220);
    }

    public static void drawColorString(Graphics g, String str, int x, int y, int dir) {
        g.drawString(str, x, y + 6, dir);
        g.setColor(255, 255, 255);
        g.drawString(str, x, y + 6, dir);
    }

    public static void drawImage(Graphics g, Image img, int x, int y, int dir) {
        int y1 = 0;
        int x1 = x;
        y1 = y;
        if (x == -1) {
            x1 = (176 - img.getWidth()) / 2;
        }
        if (y == -1) {
            y1 = (208 - img.getHeight()) / 2;
        }
        g.drawImage(img, x1, y1 + 6, dir);
    }

    public static void drawNumber(Graphics g, Image number_img, int score, int x, int y, int space, int num, int start, int w, int h) {
        int number;
        if (num < 0 || score < 0) {
            return;
        }
        String s = "" + score;
        String snum = "";
        int i = number = s.length();
        while (i < num) {
            snum = snum + '0';
            ++i;
        }
        s = snum + score;
        int i2 = 0;
        while (i2 < num) {
            GameUtil.drawClipImage(g, number_img, x + i2 * space, y, start + Integer.parseInt("" + s.charAt(i2)), w, h);
            ++i2;
        }
    }

    public static void drawRect(Graphics g, int x, int y, int width, int height) {
        g.drawRect(x, y + 6, width, height);
    }

    public static void drawString(Graphics g, int startx, int starty, int fontsize, String string) {
        int color = g.getColor();
        int total_len = string.length();
        int width_num = 176 / fontsize;
        int length_num = 220 / fontsize;
        boolean nextline = true;
        if (startx == -1) {
            startx = total_len * fontsize > 176 ? (176 - width_num * fontsize) / 2 : (176 - total_len * fontsize) / 2;
        }
        if (starty == -1) {
            starty = (220 - fontsize) / 2;
        }
        int x = 0;
        int y = 0;
        int count = 0;
        int i = 0;
        while (i < total_len) {
            char test_string = string.charAt(i);
            if (test_string == '\uff5c') {
                x = 0;
                y += fontsize;
                count = 0;
            } else {
                if (count != 0 && count % width_num == 0) {
                    x = 0;
                    count = 0;
                    y += fontsize;
                }
                g.setColor(color);
                GameUtil.drawString(g, String.valueOf(test_string), startx + x, starty + y, 0);
                x += fontsize;
                ++count;
            }
            ++i;
        }
    }

    public static void drawString(Graphics g, String str, int x, int y, int dir) {
        g.drawString(str, x, y + 6, dir);
    }

    public static void fillRect(Graphics g, int x, int y, int width, int height) {
        g.fillRect(x, y + 6, width, height);
    }

    public static int getRand(int start, int end) {
        boolean check = false;
        int number = 0;
        if (start >= end) {
            int temp = end;
            end = start;
            start = temp;
        }
        while (!check) {
            number = Math.abs(rnd.nextInt() % end);
            if (number < start || number >= end) continue;
            check = true;
        }
        return number;
    }

    public static int getRand(int i) {
        return Math.abs(rnd.nextInt() % i);
    }

    public static void randIndex(int[] index, int[] index2) {
        int len = index.length;
        int count = 0;
        boolean[] check = new boolean[len];
        do {
            int rand;
            if (check[rand = GameUtil.getRand(len)]) continue;
            check[rand] = true;
            index[count++] = index2[rand];
        } while (count < len);
    }

    public static void sortIndex(int[] index, int num) {
        if (num == -1) {
            num = index.length;
        }
        boolean ok = true;
        do {
            ok = true;
            int i = 0;
            while (i < num - 1) {
                if (index[i] > index[i + 1]) {
                    int temp = index[i + 1];
                    index[i + 1] = index[i];
                    index[i] = temp;
                    ok = false;
                }
                ++i;
            }
        } while (!ok);
    }
}

